//======================================================================
/**
 *  GAME FREAK inc.
 *
 *  @file   Group.cpp
 *  @brief  V[PXGfB^Ŏw肵O[vKɃANX
 *  @date   2012.05.21
 *  @author ito_isao
 *
 */
//====================================================================== 

#include "Group.h"


GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
Group::Group()
{
  for(int i = 0; i < GROUP_MAX; ++i)
  {
    m_ptr[i] = NULL;
  }
}

Group::~Group()
{
  for(int i = 0; i < GROUP_MAX; ++i)
  {
    GFL_ASSERT(m_ptr[i] == NULL);
  }
}

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void Group::SetModel(int index, gfl::grp::g3d::Model* p)
{
  GFL_ASSERT(m_ptr[index] == NULL);
  m_ptr[index] = p;
  m_type[index] = GROUP_TYPE_MODEL;
}
void Group::SetPokeModel(int index, poke_tool::PokeModel* p)
{
  GFL_ASSERT(m_ptr[index] == NULL);
  m_ptr[index] = p;
  m_type[index] = GROUP_TYPE_POKEMODEL;
}
void Group::SetParticle(int index, gfl::grp::g3d::Particle* p)
{
  GFL_ASSERT(m_ptr[index] == NULL);
  m_ptr[index] = p;
  m_type[index] = GROUP_TYPE_PARTICLE;
}

int Group::GetType(int index)
{
  return m_type[index];
}

void Group::Clear(int index)
{
  m_ptr[index] = NULL;
  m_type[index] = GROUP_TYPE_NULL;
}
gfl::grp::g3d::Model* Group::GetModel(int index)
{
  GFL_ASSERT(m_ptr[index] != NULL);
  GFL_ASSERT(m_type[index] == GROUP_TYPE_MODEL);
  return (gfl::grp::g3d::Model*)(m_ptr[index]);
}

poke_tool::PokeModel* Group::GetPokeModel(int index)
{
  GFL_ASSERT(m_ptr[index] != NULL);
  GFL_ASSERT(m_type[index] == GROUP_TYPE_POKEMODEL);
  return (poke_tool::PokeModel*)(m_ptr[index]);
}

gfl::grp::g3d::Particle* Group::GetParticle(int index)
{
  GFL_ASSERT(m_ptr[index] != NULL);
  GFL_ASSERT(m_type[index] == GROUP_TYPE_PARTICLE);
  return (gfl::grp::g3d::Particle*)(m_ptr[index]);
}

GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)
