//======================================================================
/**
 *  GAME FREAK inc.
 *
 *  @file   CommandFactory.cpp
 *  @brief  V[PXGfB^ō쐬ft@CĐ@\
            ftHg̃R}ht@Ng
 *  @date   2012.05.21
 *  @author ito_isao
 *
 */
//====================================================================== 


#include "CommandFactory.h"
#include "command_define.h"
#include "command_define.cdat"


GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

CommandFactory::CommandFactory(gfl::heap::HeapBase* heap) : 
m_heap(heap)
{
}

CommandFactory::~CommandFactory()
{
}

//------------------------------------------------------------------------------
ICommand* CommandFactory::CreateCommand(int id)
{
  ICommand* ret = NULL;
  switch(id)
  {
  case LABEL_TEST:
    break;
  case MODEL_CREATE:
    ret = GFL_NEW(m_heap) CommandCreateModel();
    break;
  case MODEL_TEX_CHANGE:
    ret = GFL_NEW(m_heap) CommandChangeModelTexture();
    break;
  case MODEL_CMDLA:
  case MODEL_CMATA:
  case MODEL_CSKLA:
    ret = GFL_NEW(m_heap) CommandPlayAnimation();
    break;
  case MODEL_MOVE_ABS:
    ret = GFL_NEW(m_heap) CommandMoveModelAbs();
    break;
  case MODEL_MOVE_REL:
    ret = GFL_NEW(m_heap) CommandMoveModelRel();
    break;
  case MODEL_ROTATE:
    ret = GFL_NEW(m_heap) CommandRotateModel();
    break;
  case MODEL_SCALE:
    ret = GFL_NEW(m_heap) CommandScaleModel();
    break;
  case MODEL_VISIBLE:
    ret = GFL_NEW(m_heap) CommandSetModelVisibility();
    break;
    
    
  case POKE_CREATE:
    ret = GFL_NEW(m_heap) CommandCreatePokeModel();
    break;
  case POKE_MOVE_ABS:
    ret = GFL_NEW(m_heap) CommandMovePokeModelAbs();
    break;
  case POKE_MOVE_REL:
    ret = GFL_NEW(m_heap) CommandMovePokeModelRel();
    break;
  case POKE_ROTATE:
    ret = GFL_NEW(m_heap) CommandRotatePokeModel();
    break;
  case POKE_SCALE:
    ret = GFL_NEW(m_heap) CommandScalePokeModel();
    break;
  case POKE_VISIBLE:
    ret = GFL_NEW(m_heap) CommandSetPokeModelVisibility();
    break;
  case POKE_ANIME:
    ret = GFL_NEW(m_heap) CommandPlayAnimationPoke();
    break;
    
  
  case PARTICLE_CREATE:
    ret = GFL_NEW(m_heap) CommandCreateParticle();
    break;
  case PARTICLE_MOVE_ABS:
    ret = GFL_NEW(m_heap) CommandMoveParticleAbs();
    break;
  case PARTICLE_MOVE_REL:
    ret = GFL_NEW(m_heap) CommandMoveParticleRel();
    break;
  case PARTICLE_ROTATE:
    ret = GFL_NEW(m_heap) CommandRotateParticle();
    break;
  case PARTICLE_SCALE:
    ret = GFL_NEW(m_heap) CommandScaleParticle();
    break;
  case PARTICLE_VISIBLE:
    ret = GFL_NEW(m_heap) CommandSetParticleVisibility();
    break;
  case PARTICLE_FOLLOW:
    ret = GFL_NEW(m_heap) CommandParticleFollowModel();
    break;
    
  case SOUND_SE:
    ret = GFL_NEW(m_heap) CommandPlaySE();
    break;
  }
  return ret;
}

//------------------------------------------------------------------------------
const int* CommandFactory::GetCommandSizeTable()
{
  return command_define_size_table;
}

GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)
