//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_Script.h
 *	@brief  XNvgVXe
 *	@author	Toru=Nagihashi
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_HOLOGRAMMAIL_SCRIPT_H__)
#define __APP_HOLOGRAMMAIL_SCRIPT_H__

#include <gflib.h>
#include <app/util/app_util_heap.h>
#include "app_hologrammail_common_define.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//=========================================================================
//
//  @brief  XNvgR}h
//
//=========================================================================
class ScriptCommand
{
public:
  virtual bool ScriptCommandWait( u32 frame ) = 0;
  virtual bool ScriptCommandEnter( PersonType person1, PersonType person2, PersonType person3, PersonType person4 ) = 0;
  virtual bool ScriptCommandExit( PersonType person1, PersonType person2, PersonType person3, PersonType person4 )  = 0;
  virtual bool ScriptCommandMotion( PersonType person, CommandParam motion )  = 0;
  virtual bool ScriptCommandStartMessage( PersonType person, u32 msg_id, CommandParam talk_dir ) = 0;
  virtual bool ScriptCommandWaitMessage( PersonType person )  = 0;
  virtual bool ScriptCommandEndMessage( PersonType person ) = 0;
  virtual bool ScriptCommandStartSoundSE( u32 se )  = 0;
  virtual bool ScriptCommandWaitSoundSE( void ) = 0;
  virtual bool ScriptCommandStopSoundSE( void ) = 0;
};

//=========================================================================
//
//  @brief  XNvgVXe
//
//=========================================================================
class Script
{
  GFL_FORBID_COPY_AND_ASSIGN(Script);
public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param heap  q[v
   * @param command R}hNX
   */
  Script(app::util::Heap *heap, ScriptCommand *command );
  /**
   * @brief fXgN^
   */
  virtual ~Script();
  
  //-----------------------------------------------------------------------
  // XV
  //-----------------------------------------------------------------------
  /**
   * @brief XV
   */
  void Update(void);

  //-----------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------
  /**
   * @brief XNvgJn
   *
   * @param script_id XNvgID
   */
  void Start( u32 script_id );
  /**
   * @brief XNvgI
   *
   * @return trueŏI falseŌp
   */
  bool IsEnd( void ) const;
private:
  bool RunCommand( u16 cmd_id, u16 param[] );
private:
  app::util::Heap *m_heap;
  ScriptCommand *m_command;
  u16 *m_script_buffer;
  u16 m_script_index;
  u16 m_script_buffer_size;
};

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

#endif		// __APP_HOLOGRAMMAIL_SCRIPT_H__
