//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_Script.cpp
 *	@brief  XNvgVXe
 *	@author	Toru=Nagihashi
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_Script.h"
#include <arc/arc_def.h>
#include <arc/hologram_mail_data.gaix>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param command R}hNX
 */
Script::Script(app::util::Heap *heap, ScriptCommand *command ) :
  m_heap( heap ),
  m_command( command ),
  m_script_buffer( NULL ),
  m_script_index( 0 ),
  m_script_buffer_size( 0 )
{
}

/**
 * @brief fXgN^
 */
Script::~Script()
{
  if( m_script_buffer )
  {
    GflHeapFreeMemory( m_script_buffer );
    m_script_buffer = NULL;
  }
}

//-----------------------------------------------------------------------
// XV
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void Script::Update(void)
{
  if( !this->IsEnd() )
  {
    u16 cmd_id = m_script_buffer[ m_script_index ];
    u16 *param = &m_script_buffer[ m_script_index + 1 ];
    if( this->RunCommand( cmd_id, param ) )
    {
      m_script_index  += 8;
    }
  }
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief XNvgJn
 *
 * @param script_id XNvgID
 */
void Script::Start( u32 script_id )
{
  GFL_ASSERT( script_id != 0 );

  if( m_script_buffer )
  {
    GflHeapFreeMemory( m_script_buffer );
  }

  gfl::fs::ArcFile  *file = GFL_NEW( m_heap->GetSystemHeap()->GetLowerHandle() ) gfl::fs::ArcFile( m_heap->GetSystemHeap()->GetLowerHandle(), ARCID_HOLOGRAM_MAIL_DATA, gfl::fs::ArcFile::OPEN );
  
  u32 idx = GARC_hologram_mail_data_hologram_mail_scr01_DAT + script_id-1;
  GFL_ASSERT( idx < GARC_hologram_mail_data_DATA_NUM );
 
  size_t size = file->GetDataSize( idx ); 
  m_script_buffer  = reinterpret_cast<u16 *>( GflHeapAllocMemory(m_heap->GetSystemHeap(), size ) );
  file->LoadData( idx, m_script_buffer );
  m_script_buffer_size = size / sizeof(u16);
  GFL_SAFE_DELETE( file );

  m_script_index  = 0;
}

/**
 * @brief XNvgI
 *
 * @return trueŏI falseŌp
 */
bool Script::IsEnd( void ) const
{
  return m_script_index >= m_script_buffer_size;
}
//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief R}hs
 *
 * @param cmd_id  R}hID
 * @param param[] R}ḧ
 *
 * @return  trueŃR}hI  falseŌp
 */
bool Script::RunCommand( u16 cmd_id, u16 param[] )
{
  switch( cmd_id )
  {
	case COMMAND_NAME_WAIT:// EFCg
    return m_command->ScriptCommandWait( param[0] );
	case COMMAND_NAME_ENTER:// o
    return m_command->ScriptCommandEnter( static_cast<PersonType>(param[0]), static_cast<PersonType>(param[1]), static_cast<PersonType>(param[2]), static_cast<PersonType>(param[3]) );
	case COMMAND_NAME_EXIT:// ޏo
    return m_command->ScriptCommandExit( static_cast<PersonType>(param[0]), static_cast<PersonType>(param[1]), static_cast<PersonType>(param[2]), static_cast<PersonType>(param[3]) );
	case COMMAND_NAME_MOTION:// [VύX
    return m_command->ScriptCommandMotion( static_cast<PersonType>(param[0]), static_cast<CommandParam>(param[1]) );
	case COMMAND_NAME_MESSAGE_START:// bZ[WJn
    return m_command->ScriptCommandStartMessage( static_cast<PersonType>(param[0]), param[1], static_cast<CommandParam>(param[2]) );
	case COMMAND_NAME_MESSAGE_WAIT:// bZ[W҂
    return m_command->ScriptCommandWaitMessage( static_cast<PersonType>(param[0]) );
	case COMMAND_NAME_MESSAGE_END:// bZ[W
    return m_command->ScriptCommandEndMessage( static_cast<PersonType>(param[0]) );
	case COMMAND_NAME_SE_PLAY:// SEĐ
    return m_command->ScriptCommandStartSoundSE( param[0] );
	case COMMAND_NAME_SE_WAIT:// SEҋ@
    return m_command->ScriptCommandWaitSoundSE();
	case COMMAND_NAME_SE_STOP:// SE~
    return m_command->ScriptCommandStopSoundSE();
  default:
    GFL_ASSERT( 0 );
    return true;
  }
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
