//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_PersonManager.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.06.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_PersonManager.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
//-----------------------------------------------------------------------
// 萔
//-----------------------------------------------------------------------
/**
 * @brief l^CvƂ̃fݒ\
 */
static const trainer::TrModel::Description person_type_description[PERSON_TYPE_MAX] =
{
  //PERSON_TYPE_NONE
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL,
    trainer::TrModel::MOTION_TYPE_OTHER,
    NULL
  },
	//PERSON_TYPE_DOCTOR = 1,//lFm
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL,
    trainer::TrModel::MOTION_TYPE_OTHER,
    NULL
  },
	//PERSON_TYPE_MOTHER = 2,//lF
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL,
    trainer::TrModel::MOTION_TYPE_OTHER,
    NULL
  },
	//PERSON_TYPE_ENEMY = 3,//lFG
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL,
    trainer::TrModel::MOTION_TYPE_OTHER,
    NULL
  },
	//PERSON_TYPE_SUPPORT = 4,//lFT|[g
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL,
    trainer::TrModel::MOTION_TYPE_OTHER,
    NULL
  },
};
//@todo add?

/**
 * @brief lƂ̈ʒu
 */
static const gfl::math::VEC3 person_position[PersonManager::PERSON_MAX] =
{
  gfl::math::VEC3( 160, 0, 200 ),
  gfl::math::VEC3( 200, 0, 240 ),
  gfl::math::VEC3( 240, 0, 280 ),
  gfl::math::VEC3( 280, 0, 320 ),
};

//-----------------------------------------------------------------------
//  RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param file_read_manager [h}l[W
 */
PersonManager::PersonManager(app::util::Heap * heap, gfl::fs::FileReadManager* file_read_manager) :
  m_heap( heap ),
  m_seq( SEQUENCE_IDLE )
{
  // ւf
  xy_system::dress_up::DressUpManagerCreate(
      heap->GetSystemHeap(),
      heap->GetSystemHeap(),
      heap->GetDeviceHeap()
  );
  
  //g[i[f
  m_tr_model_manager = GFL_NEW(heap->GetSystemHeap()) trainer::TrModelManager(
      heap->GetSystemHeap(),
      file_read_manager
      );
}
/**
 * @brief fXgN^
 */
PersonManager::~PersonManager()
{
  this->Delete();
  
  GFL_ASSERT( m_seq == SEQUENCE_IDLE );
  GFL_SAFE_DELETE( m_tr_model_manager );
  // ւf
  xy_system::dress_up::DressUpManagerDestroy();
}

//-----------------------------------------------------------------------
//  VXe
//-----------------------------------------------------------------------
/**
 * @brief V[vZO̍XV
 */
void PersonManager::UpdateCalculateBefore( void )
{
  switch( m_seq )
  {
  case SEQUENCE_LOADING:
    {
      bool is_created = true;
      for( int i=0; i < m_person_max; ++i )
      {
        if(m_tr_model_manager->IsModelCreated( m_person[i]->GetTrModel()) == false )
        {
          is_created = false;
          break;
        }
      }
      if( is_created )
      {
        for( int i=0; i < m_person_max; ++i )
        {
          bool ret = m_person[i]->GetTrModel()->AddModelToScene( m_scene, app::util::G3DUtil::SCENE_CALC_GROUP_MAIN,  app::util::G3DUtil::SCENE_DRAW_GROUP_MODEL );
          GFL_ASSERT( ret );
          m_person[i]->GetTrModel()->SetTranslate( person_position[i] );
        }
        m_seq = SEQUENCE_MAIN;
      }
    }
    break;
  }

  m_tr_model_manager->CalculateBefore();
}

/**
 * @brief V[vZ̍XV
 */
void PersonManager::UpdateCalculateAfter( void )
{
  m_tr_model_manager->CalculateAfter();
}

//-----------------------------------------------------------------------
//  E擾
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ݊JniCɐlǂݍށj
 *
 * @param scene AddV[iǉO[vapp::util::G3DUtil::SCENE_CALC_GROUP_MAIN,  app::util::G3DUtil::SCENE_DRAW_GROUP_MODELj
 * @param desc_tbl  ǂݍݐݒe[uizj
 * @param len Le[u̗vfiO`PERSON_MAXj
 */
void PersonManager::StartLoad( gfl::grp::g3d::Scene *scene, const Description *desc_tbl, u32 len )
{
  GFL_ASSERT( m_seq == SEQUENCE_IDLE );
  GFL_ASSERT( len <= PERSON_MAX );
  m_person_max  = len;
  m_scene = scene;
  

  xy_system::dress_up::HeroineFashion heroine_fashion = xy_system::dress_up::HEROINE_FASHION_DEFAULT;
  xy_system::dress_up::Individual individual;
  individual.model_type = xy_system::dress_up::MODEL_TYPE_HEROINE;
  individual.section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
  individual.fashion = &heroine_fashion;
  
  trainer::TrModel::Description desc =
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL_DRESS,
    trainer::TrModel::MOTION_TYPE_OTHER,
    &individual
  };

  for( int i=0; i < m_person_max; ++i )
  {
    PersonType type = desc_tbl[ i ].type;
    /*  @todo ^Cvʂ̐ݒ󂯎\
    trainer::TrModel::Description desc;
    desc = person_type_description[ type ];
    desc.param  = &individual;  
    */
    

    //@todol͂ȂǁAT|[g邩
    m_person[i] = GFL_NEW( m_heap->GetSystemHeap() ) Person( m_heap, type );
    m_person[i]->Initilize( m_tr_model_manager, desc );
  }
  
  m_seq = SEQUENCE_LOADING;
}

/**
 * @brief Ǎǂ
 *
 * @return trueǍ falseǂݍ݂ĂȂ
 */
bool PersonManager::IsLoading( void ) const
{
  return m_seq == SEQUENCE_LOADING;
}

/**
 * @brief lj(fXgN^łs܂)
 */
void PersonManager::Delete( void )
{
  if( m_seq == SEQUENCE_MAIN )
  {
    GFL_ASSERT( m_tr_model_manager->IsAbleToDestroy() );
    
    for( int i=0; i < m_person_max; ++i )
    {
      m_person[i]->GetTrModel()->RemoveModelFromScene( m_scene );
      
      bool ret = m_person[i]->Finalize( m_tr_model_manager );
      GFL_ASSERT( ret );
      GFL_SAFE_DELETE( m_person[i] );
    }
    m_seq = SEQUENCE_IDLE;
  }
}

/**
 * @brief l擾
 *
 * @param type  l^Cv
 *
 * @return  lNX
 */
Person * PersonManager::GetPerson( PersonType type )
{
  for( int i=0; i < m_person_max; ++ i )
  {
    if( type == m_person[i]->GetPersonType() )
    {
      return m_person[i];
    }
  }
  
  GFL_ASSERT( 0 );
  return NULL;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
