//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_HologramView.cpp
 *	@brief  zO
 *	@author	Toru=Nagihashi
 *	@date		2012.06.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "arc/arc_def.h"
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "app_hologrammail_HologramView.h"
#include "app_hologrammail_BackGround.h"
#include "app_hologrammail_PersonManager.h"
#include "hologram_upper.h"
#include "hologram_upper_pane.h"
#include <sound/sound.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param game_manager  Q[}l[W[
 */
HologramView::HologramView(app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, gamesystem::GameManager *game_manager ) :
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_g3dutil( NULL ),
  m_background( NULL ),
  m_person_manager( NULL ),
  m_script( NULL ),
  m_counter(0),
  m_cmd_seq(0),
  m_played_se( 0)
{
  m_graphicSystem = graphics_system;

  this->CreateLayout( heap, layout_system );
  this->Create3d( heap );
  this->CreateBackGround( heap, game_manager );
  this->CreatePersonManager( heap, game_manager );
  this->CreateTalkWindow( heap, layout_system, game_manager->GetUiDeviceManager() );
  
  m_script = GFL_NEW(heap->GetSystemHeap()) Script(heap, this );
}

/**
 * @brief fXgN^
 */
HologramView::~HologramView()
{
  GFL_SAFE_DELETE( m_script );

  this->DeleteTalkWindow();
  this->DeletePersonManager();
  this->DeleteBackGround();
  this->Delete3d();
  this->DeleteLayout();
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void HologramView::Update(void)
{
#ifdef PM_DEBUG
  m_g3dutil->UpdateDebaguCamera( app::util::G3DUtil::SETUP_CAMERA_UPPER );
#endif
  

  m_script->Update();
  m_talk_win->Update();

  m_person_manager->UpdateCalculateBefore();
  m_g3dutil->CalculateG3dScene();
  m_background->Update();
  m_person_manager->UpdateCalculateAfter();
  m_g3dutil->Update3D(false);
}

/**
 * @brief `
 */
void HologramView::Draw(void)
{
  m_background->Draw();
  m_g3dutil->Draw3D( m_graphicSystem );
  m_g2dUtil->Draw2D( m_graphicSystem, 0);
  
  //TalkWindow̓I[gtOONȂ̂łŕ`悷
  this->GetLayoutSystem()->DrawAll( m_graphicSystem, gfl::grp::DISPLAY_UPPER, m_graphicSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER ), m_graphicSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT ) );
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief XNvgJn
 *
 * @param script_id JnXNvgԍ
 */
void HologramView::StartScript( u32 script_id )
{
}


//-----------------------------------------------------------------------
// ScriptCommand̎
//-----------------------------------------------------------------------
/**
 * @brief XNvgR}h  ҋ@
 *
 * @param frame ҋ@t[
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandWait( u32 frame )
{
  if( m_counter++ < frame )
  {
    return false;
  }
  else
  {
    m_counter = 0;
    return true;
  }
}
/**
 * @brief XNvgR}h  oꉉo
 *
 * @param person_type1 l
 * @param person_type2 l
 * @param person_type3 l
 * @param person_type4 l
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandEnter( PersonType person_type1, PersonType person_type2, PersonType person_type3, PersonType person_type4 )
{
  enum
  {
    SEQ_MOTION_START,
    SEQ_MOTION_WAIT,
    SEQ_END,
  };

  Person *person[PersonManager::PERSON_MAX] = {};
  person[0] = m_person_manager->GetPerson( person_type1 );
  person[1] = m_person_manager->GetPerson( person_type2 );
  person[2] = m_person_manager->GetPerson( person_type3 );
  person[3] = m_person_manager->GetPerson( person_type4 );
  
  switch( m_cmd_seq )
  {
  case SEQ_MOTION_START:
    for( int i=0; i<PersonManager::PERSON_MAX;++i)
    {
      if( person[i] )
      {
        person[i]->ChangeMotion( TRMOT_OTHER_BA50_HOLOON01 );
      }
    }
    m_cmd_seq = SEQ_MOTION_WAIT;
    break;
  case SEQ_MOTION_WAIT:
    {
      bool is_end = true;
      for( int i=0; i<PersonManager::PERSON_MAX;++i)
      {
        if( person[i] != NULL && !person[i]->IsEndMotion())
        {
          is_end = false;
          break;
        }
      }
      if( is_end )
      {
        m_cmd_seq = 0;
        return true;
      }
    }
    break;
  }
  
  return false;
}

/**
 * @brief XNvgR}h  ޏoo
 *
 * @param person_type1 l
 * @param person_type2 l
 * @param person_type3 l
 * @param person_type4 l
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandExit( PersonType person_type1, PersonType person_type2, PersonType person_type3, PersonType person_type4 ) 
{
  enum
  {
    SEQ_MOTION_START,
    SEQ_MOTION_WAIT,
    SEQ_END,
  };

  Person *person[PersonManager::PERSON_MAX] = {};
  person[0] = m_person_manager->GetPerson( person_type1 );
  person[1] = m_person_manager->GetPerson( person_type2 );
  person[2] = m_person_manager->GetPerson( person_type3 );
  person[3] = m_person_manager->GetPerson( person_type4 );
  
  switch( m_cmd_seq )
  {
  case SEQ_MOTION_START:
    for( int i=0; i<PersonManager::PERSON_MAX;++i)
    {
      if( person[i] )
      {
        person[i]->ChangeMotion( TRMOT_OTHER_BA50_HOLOOFF01 );
      }
    }
    m_cmd_seq = SEQ_MOTION_WAIT;
    break;
  case SEQ_MOTION_WAIT:
    {
      bool is_end = true;
      for( int i=0; i<PersonManager::PERSON_MAX;++i)
      {
        if( person[i] != NULL && !person[i]->IsEndMotion())
        {
          is_end = false;
          break;
        }
      }
      if( is_end )
      {
        m_cmd_seq = 0;
        return true;
      }
    }
    break;
  }
  
  return false;
}

/**
 * @brief XNvgR}h  [V؂ւ
 *
 * @param person_type  l
 * @param motion  [V
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandMotion( PersonType person_type, CommandParam motion ) 
{
  Person *person  = m_person_manager->GetPerson( person_type );
  switch( motion )
  { 
	case COMMAND_PARAM_MOTION_ENTER ://[VFo
    person->ChangeMotion( TRMOT_OTHER_BA50_HOLOON01 );
    break;
	case COMMAND_PARAM_MOTION_WAIT ://[VFҋ@
    break;
	case COMMAND_PARAM_MOTION_EXIT ://[VFޏ
    person->ChangeMotion( TRMOT_OTHER_BA50_HOLOOFF01 );
    break;
	case COMMAND_PARAM_MOTION_TALK_START ://[VFbJn
    person->ChangeMotion( TRMOT_OTHER_BA50_HOLOSPEAKA01 );
    break;
	case COMMAND_PARAM_MOTION_TALK_LOOP ://[VFb[v
    person->ChangeMotion( TRMOT_OTHER_BA50_HOLOSPEAKB01 );
    break;
	case COMMAND_PARAM_MOTION_TALK_END ://[VFbI
    person->ChangeMotion( TRMOT_OTHER_BA50_HOLOSPEAKC01 );
    break;
	case COMMAND_PARAM_MOTION_TALK_START_R ://[VFEbJn
    break;
	case COMMAND_PARAM_MOTION_TALK_LOOP_R ://[VFEb[v
    break;
	case COMMAND_PARAM_MOTION_TALK_END_R ://[VFEbI
    break;
	case COMMAND_PARAM_MOTION_TALK_START_L ://[VFbI
    break;
	case COMMAND_PARAM_MOTION_TALK_LOOP_L ://[VFb[v
    break;
	case COMMAND_PARAM_MOTION_TALK_END_L ://[VFbI
    break;
  default:
    GFL_ASSERT(0);
  }
  return true;
}

/**
 * @brief XNvgR}h  bZ[WJn
 *
 * @param person_type  l
 * @param msg_id  bZ[Wԍ
 * @param talk_dir  b
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandStartMessage( PersonType person_type, u32 msg_id, CommandParam talk_dir )
{ 
  m_talk_win->Call( this->GetMessageStrBuf(msg_id), WIN_TYPE_TALK, app::tool::TalkWindowGra::WIN_COLLAR_TYPE_DEFAULT );
  //@todo J[ݒ ۈʒu
  return true;
}

/**
 * @brief XNvgR}h  bZ[Wҋ@
 *
 * @param person_type  l
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandWaitMessage( PersonType person_type ) 
{
  return m_talk_win->GetStatus() != app::tool::TalkWindow::WIN_STATUS_SUSPEND;
}

/**
 * @brief XNvgR}h  bZ[WI
 *
 * @param person_type  l
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandEndMessage( PersonType person_type )
{ 
  enum
  {
    SEQ_START,
    SEQ_WAIT,
  };
  switch( m_cmd_seq )
  {
  case SEQ_START:
    m_talk_win->CloseMsgWin();
    m_cmd_seq = SEQ_WAIT;
    break;
  case SEQ_WAIT:
    if( m_talk_win->GetStatus() == app::tool::TalkWindow::WIN_STATUS_SUSPEND )
    {
      m_cmd_seq = 0;
      return false;
    }
    break;
  default:
    GFL_ASSERT(0);
  }

  return true;
}

/**
 * @brief XNvgR}h  SE炷
 *
 * @param se  SEԍ
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandStartSoundSE( u32 se ) 
{
  xy_snd::PlaySE( se );
  m_played_se = se;
  return true;
}

/**
 * @brief XNvgR}h  SEҋ@
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandWaitSoundSE( void )
{
  if( m_played_se != 0 )
  {
    return !xy_snd::IsSEPlaying(m_played_se);
  }
  else
  {
    return true;
  }
}

/**
 * @brief XNvgR}h  SE~
 *
 * @return  trueŃR}hI  falseŌp
 */
bool HologramView::ScriptCommandStopSoundSE( void )
{
  if( m_played_se != 0 )
  {
    xy_snd::StopSE( m_played_se );
  }
  
  return true;
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief RD쐬
 *
 * @param heap  q[v
 */
void HologramView::Create3d(app::util::Heap * heap)
{
  m_g3dutil = GFL_NEW(heap->GetSystemHeap()) app::util::G3DUtil();
  m_g3dutil->CreateG3dSystem( heap );
  
  //m_g3dutil->CreateG3dScene( ARCID_BATTLE_3D, GARC_battle_3d_SceneEnvironment_BCENV, heap, false, &create_data );
  
  {
    //RootNodes
    gfl::grp::g3d::Scene::Description sceneDesc;
    gfl::grp::g3d::SceneCalculateGroup::Description sceneCalcDesc[2];
    sceneCalcDesc[0].max_scene_nodes = 1024;
    sceneCalcDesc[0].max_models = 1024;
    sceneCalcDesc[0].max_skeletal_models = 1024;
    sceneCalcDesc[0].max_cameras = 64;
    sceneCalcDesc[0].max_lights = 64;
    sceneCalcDesc[0].max_fragment_lights = 64;
    sceneCalcDesc[0].max_vertex_lights = 64;
    sceneCalcDesc[0].max_hemisphere_lights = 64;
    sceneCalcDesc[0].max_ambient_lights = 64;
    sceneCalcDesc[0].max_animatable_nodes = 1024; //@todoƂ
    sceneDesc.scene_draw_group_num = m_g3dutil->GetSceneDrawGroupIndex(BackGround::SCENE_DRAW_GROUP_MAX);
    sceneDesc.scene_calculate_group_description_array = sceneCalcDesc;
    sceneDesc.own_light_num_max = 16; //@todoƂ
    gfl::grp::g3d::Scene *scene = GFL_NEW(heap->GetSystemHeap()) gfl::grp::g3d::Scene( heap->GetDeviceAllocator(), &sceneDesc );
	  m_g3dutil->SetG3dScene( scene );
  }

  static const f32 NEAR_PLANE = 32.0f;
  static const f32 FAR_PLANE  = 6000.0f;
	const app::util::G3DUtil::CAMERA_CREATE_DATA dat =
  {
    gfl::math::VEC3( 238.0f,136.0f,453.0f ), //0.0f,  2.0f, 200.0f ),
    gfl::math::VEC3( -35.0f,100.0f,0.0f ), //0.0f, 50.0f,   0.0f ),
    NEAR_PLANE,//gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT,
    FAR_PLANE,//gfl::grp::g3d::Camera::FAR_CLIP_DEFAULT,
    GFL_MATH_DEG_TO_RAD(30),//gfl::grp::g3d::Camera::FOVY_RADIAN_DEFAULT,
    0.0f,
    gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT,
    1.0f,
    false
  };
  m_g3dutil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat, NULL );

  m_g3dutil->CreateEdgeSystem( m_graphicSystem, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, heap );
	m_g3dutil->SetupG3dScene();
}
/**
 * @brief 3Dj
 */
void HologramView::Delete3d(void)
{
  m_g3dutil->DeleteEdgeSystem();
	m_g3dutil->DeleteG3dCamera();
	m_g3dutil->DeleteG3dScene();
  m_g3dutil->DeleteG3dSystem();
  GFL_SAFE_DELETE( m_g3dutil );
}
/**
 * @brief RDwi쐬
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 */
void HologramView::CreateBackGround( app::util::Heap * heap, gamesystem::GameManager *game_manager )
{
  m_background = GFL_NEW(heap->GetSystemHeap()) BackGround( heap, game_manager, m_graphicSystem, m_g3dutil );
  m_background->StartLoad();
}
/**
 * @brief RDwij
 */
void HologramView::DeleteBackGround(void)
{
  GFL_SAFE_DELETE( m_background );
}

/**
 * @brief l}l[W[쐬
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 */
void HologramView::CreatePersonManager( app::util::Heap * heap, gamesystem::GameManager *game_manager )
{
  m_person_manager  = GFL_NEW( heap->GetSystemHeap() ) PersonManager(heap, game_manager->GetFileReadManager() );
  
  ///@todo
  PersonManager::Description desc[4] = {};
  m_person_manager->StartLoad( m_g3dutil->GetScene(), desc, 4 );
}
/**
 * @brief l}l[W[j
 */
void HologramView::DeletePersonManager(void)
{
  GFL_SAFE_DELETE( m_person_manager );
}

/**
 * @brief CAEg쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void HologramView::CreateLayout( app::util::Heap * heap,gfl::grp::g2d::LytSys* layout_system )
{
  static const app::util::G2DUtil::LYT_RES_DATA LYTRES_TABLE[] =
  {
    {
      ARCID_HOLOGRAM_MAIL_GRA, GARC_hologram_mail_gra_hologram_upper_LYTDAT_LZ, 0
    }
  };
  static const app::util::G2DUtil::LYTWK_DATA LYTWK_DATA_TABLE[]  =
  {
    {
      0,
      LYTRES_HOLOGRAM_UPPER_HOLOGRAM_UPPER_BCLYT,
      NULL,
      0,
      0,
      false,
      app::util::G2DUtil::SETUP_UPPER,
      true,
    }
  };

  this->Create2D( heap, layout_system, GFL_NELEMS(LYTWK_DATA_TABLE), LYTRES_TABLE, GFL_NELEMS(LYTRES_TABLE), LYTWK_DATA_TABLE, GFL_NELEMS(LYTWK_DATA_TABLE), GARC_message_hologram_mail_DAT );
}

/**
 * @brief CAEgj
 */
void HologramView::DeleteLayout( void )
{
  this->Delete2D();
}

/**
 * @brief bEBhE쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 * @param device_manager  foCX}l[W[
 */
void HologramView::CreateTalkWindow(app::util::Heap *heap, gfl::grp::g2d::LytSys* layout_system, gfl::ui::DeviceManager* device_manager )
{
  m_talk_win  = GFL_NEW(heap->GetSystemHeap()) app::tool::TalkWindow();
  m_talk_win->Initialize( heap->GetSystemHeap(), heap->GetDeviceAllocator(), m_graphicSystem, layout_system, device_manager );
  m_talk_win->Setup();
}

/**
 * @brief bEBhEj
 */
void HologramView::DeleteTalkWindow(void)
{
  m_talk_win->End();
  GFL_SAFE_DELETE( m_talk_win );
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
