//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_BackGround.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.06.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_BackGround.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 * @param graphics_system OtBbNXVXe
 * @param g3dutil RDǗ
 */
BackGround::BackGround(app::util::Heap *heap, gamesystem::GameManager *game_manager, gfl::grp::GraphicsSystem* graphics_system, app::util::G3DUtil *g3dutil) :
  m_bg_system( NULL ),
  m_g3dutil( g3dutil ),
  m_seq( SEQUENCE_IDLE )
{
  m_bg_system = GFL_NEW(heap->GetSystemHeap())xy_system::bg::System;
  
  xy_system::bg::InitSystemParam param  = {};

  param.heapAllocator = heap->GetSystemAllocator();
  param.deviceAllocator = heap->GetDeviceAllocator();

  param.grpSys = graphics_system;
  param.g3dSys = g3dutil->GetG3dSystem();
  param.scene  = g3dutil->GetScene();
  param.camera = g3dutil->GetUpperCamera();
  param.readMng= game_manager->GetFileReadManager();
  param.mdlCalcGroup = 0;
  param.mdlDrawGroup = app::util::G3DUtil::SCENE_DRAW_GROUP_MODEL;
  param.useEnv = true;
  param.skyBox = game_manager->GetSkybox();
  param.lightMan = game_manager->GetWeatherLightManager();
  param.weatherMng = game_manager->GetWeatherManager();
  param.skyCalcGroup = 0;
  param.skyDrawGroup = g3dutil->GetSceneDrawGroupIndex(SCENE_DRAW_GROUP_SKY);
  param.wheatherCalcGroup = 0;
  param.wheatherDrawGroup = g3dutil->GetSceneDrawGroupIndex(SCENE_DRAW_GROUP_WEATHER);
  param.isAutoWeather = true;
  param.isAutoTime = true;
  
  m_bg_system->Init(param);
}

/**
 * @brief fXgN^
 */
BackGround::~BackGround()
{
  if( m_seq == SEQUENCE_MAIN )
  {
    m_bg_system->RemoveScene();
  }
  m_bg_system->Delete();
  m_bg_system->Exit();
  GFL_SAFE_DELETE( m_bg_system );
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void BackGround::Update( void )
{
  switch( m_seq )
  {
  case SEQUENCE_START_LOAD:
    {
      xy_system::bg::InitTypeParam param;
      param.groundType = xy_system::bg::BGTYPE_GRASS;
      param.farType = xy_system::bg::BGTYPE_GRASS;
      param.objType = xy_system::bg::OBJTYPE_GRASS;
      param.useSky = true; 
      m_bg_system->StartLoad(param);
      
      m_seq = SEQUENCE_WAIT_LOAD;
    }
    break;
  case SEQUENCE_WAIT_LOAD:
    if( m_bg_system->IsFinishLoad() )
    {
      m_bg_system->Create();
      m_bg_system->AddScene();
      m_seq = SEQUENCE_MAIN;
    }
    break;
  }
  m_bg_system->Update();
  
  
  if( SEQUENCE_MAIN == m_seq )
  {
    gfl::grp::g3d::StereoCamera* camera = m_g3dutil->GetUpperCamera();
    m_g3dutil->GetScene()->SubmitView(camera,true,true,m_g3dutil->GetSceneDrawGroupIndex(SCENE_DRAW_GROUP_SKY));
    m_g3dutil->GetScene()->SubmitView(camera,true,true,m_g3dutil->GetSceneDrawGroupIndex(SCENE_DRAW_GROUP_WEATHER));
  }
}
/**
 * @brief `
 */
void BackGround::Draw( void )
{
  if( m_seq == SEQUENCE_MAIN )
  {
    m_bg_system->Draw();
  }
}
//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ݊Jn
 */
void BackGround::StartLoad( void )
{
  if( m_seq == SEQUENCE_IDLE )
  {
    m_seq = SEQUENCE_START_LOAD;
  }
}
/**
 * @brief ǂݍݒǂ
 *
 * @return trueǂݍݒ falseǂݍłȂ
 */
bool BackGround::IsLoading( void ) const
{
  return m_seq == SEQUENCE_START_LOAD
    || m_seq == SEQUENCE_WAIT_LOAD;
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

