//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		ShaderModel.cpp
 *	@brief  VF[_[fNX
 *	@author	Masayuki Onoue
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system/ShaderModel.h"
namespace xy_system {


//-----------------------------------------------------------------------------
/*
 *  @brief         RXgN^
 *                 Create͌Ă΂܂B
 */
//-----------------------------------------------------------------------------
ShaderModel::ShaderModel(void): Model()
{
  m_MaterialCount = 0;

  for( s32 i = 0; i < MaterialMax; ++i )
  {
    m_pMaterialNames[ i ] = NULL;
  }
}

//-----------------------------------------------------------------------------
/*
 *  @brief         fXgN^
 *                 DestroyĂт܂B
 */
//-----------------------------------------------------------------------------
ShaderModel::~ShaderModel()
{
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void ShaderModel::Create(
    gfl::heap::NwAllocator*           allocator,
    gfl::heap::NwAllocator*           device_allocator,
    gfl::grp::g3d::Resource*          resource,
    s32                               index_in_resource,
    Description*                      description
)
{
  Model::Create( allocator, device_allocator, resource, index_in_resource, description );
  CreateParam();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Ɏ擾Kvȃp[^W߂
 */
/* -------------------------------------------------------------------------*/
void ShaderModel::CreateParam( void )
{
  m_MaterialCount = this->GetNwModel()->GetMaterialCount();
  for( s32 i = 0; i < m_MaterialCount; ++i )
  {
        
    nw::gfx::Material   *material = this->GetNwModel()->GetMaterial( i );
    m_pMaterialNames[ i ] = material->GetName();
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief \[Xf[^ݒ֐
 * @param pData
 * @note Ń|C^QƂ܂BSAgr[g̃nh擾ɍŝŏd͂
 */
//-----------------------------------------------------------------------------
void ShaderModel::SetShaderAttributeAnimData( const gfl::grp::g3d::ResAnim *pData )
{
  resetHandle();
  m_pResAnim = pData;
  
  if ( m_pResAnim == NULL )    return;
  
  for( s32 matNo = 0; matNo < MaterialMax; ++matNo )
  {
    if ( m_pMaterialNames[ matNo ] == NULL )
      continue;
    
    const char*   pMatName = m_pMaterialNames[ matNo ];
    char          attrName[ ShaderAttributeNameMaxLen ];//̃obt@z镶͂ȂBGNX|[^[Ń`FbNĂB
    char          tempName[ ShaderAttributeNameMaxLen ];//̃obt@z镶͂ȂBGNX|[^[Ń`FbNĂB
    
    for( s32 type = 0; type < VecAnimDataType::NumberOf; ++type )
    {
      IntVec     &rHadle = m_VectorAnimHadles[matNo][type];
      
      if ( type >= VecAnimDataType::Constant0 && type <= VecAnimDataType::Constant5 )
      {
        static const char* attrTypeName[] = {
          "Constant0", "Constant1", "Constant2", "Constant3", "Constant4", "Constant5"
        };
        
        s32   index = type - VecAnimDataType::Constant0;
        
        sprintf( tempName, "%s.%s", pMatName, attrTypeName[index] );
      }
      
      for( s32 i = 0; i < 4; ++i )
      {
        static const char* elementName[] = {
          "x", "y", "z", "w"
        };
        
        sprintf( attrName, "%s.%s", tempName, elementName[i] );
        rHadle[i] = m_pResAnim->GetMemberAnimSetIndex( attrName );
        //ISHIGURO_PRs32( "attrName = %s : %d\n", attrName, rHadle[i] );
      }
    }
    
    for( s32 type = 0; type < FloatAnimDataType::NumberOf; ++type )
    {     
      if ( type == FloatAnimDataType::AlphaRef )
      {
        sprintf( attrName, "%s.AlphaRef", pMatName );
        m_AlphaRefHandle[matNo] = m_pResAnim->GetMemberAnimSetIndex( attrName );
      }
      else if ( type >= FloatAnimDataType::TextureCombinerRgb0_MathFormula && type <= FloatAnimDataType::TextureCombinerAlpha5_OutPutBuffer )
      {
        if ( m_CombinerKeyCnt[matNo] < CombinerKeyMax )
        {
          static const char*	ElementName[] = { "MathFormula", "Scale", "InputSourceA", "InputSourceB", "InputSourceC", "OperandA", "OperandB", "OperandC", "OutPutBuffer" };
          static const char*	ColorName[CombinerColorType::NumberOf] = { "RGB", "Alpha" };
          s32                 colorType = ( type < FloatAnimDataType::TextureCombinerAlpha0_MathFormula ) ? CombinerColorType::RGB : CombinerColorType::A;
          s32                 convNo;
          s32                 elementType;
          float               value;

          convNo = type - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
          convNo %= CombinerStageNum;

          elementType = type - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
          elementType /= CombinerStageNum;
          elementType = ( colorType == CombinerColorType::RGB ) ? elementType : elementType - CombinerElementNum;

          sprintf( attrName, "%s.Combiner%01d.%s.%s", pMatName, convNo, ColorName[colorType], ElementName[elementType] );

          s32     handle = m_pResAnim->GetMemberAnimSetIndex( attrName );
          
          if ( handle != -1 )
          {
            m_CombinerHandle[matNo][m_CombinerKeyCnt[matNo]] = handle;
            m_CombinerHandleType[matNo][m_CombinerKeyCnt[matNo]] = type;
            ++m_CombinerKeyCnt[matNo];
          }
        }
      }
    }
  }

}

//-----------------------------------------------------------------------------
/**
 * @brief VF[_[Agr[gAj[Vt[ݒ
 * @param frame t[
 */
//-----------------------------------------------------------------------------
void ShaderModel::SetShaderAttributeAnimFrame( s32 frame )
{
  m_AnimFrame = frame;
  
  if ( m_pResAnim == NULL )    return;
  
  for( s32 materialNo = 0; materialNo < m_MaterialCount; ++materialNo )
  {
    nw::gfx::Material               *material = this->GetNwModel()->GetMaterial( materialNo );
    const char*                     pMaterialName = material->GetName();
    s32                             materialIndex = getMaterialIndex( pMaterialName );
    
    if ( materialIndex == -1 )
      continue;
    
    nw::gfx::ResMaterial            res_material = material->GetTextureMapperResMaterial();
    nw::gfx::res::ResFragmentShader res_shader = res_material.GetFragmentShader();
    s32                             dataHandle = -1;
    
    {  
      nw::gfx::ResMaterialColor       res_color = res_material.GetMaterialColor();
      bool      fUpdate = setConstantAnim( materialIndex, m_AnimFrame, res_color );
      
      if ( fUpdate )
      {
        res_material.SetMaterialColorHash(0x0);
      }
    }
    
    dataHandle = m_AlphaRefHandle[materialIndex];
    if ( dataHandle != -1 )
    {
      nw::gfx::res::ResAlphaTest            res_alpha_test = res_shader.GetAlphaTest();
      f32                                   value = m_pResAnim->GetFloatValue( dataHandle, m_AnimFrame );
      res_alpha_test.SetTestReference( value );
      
      res_material.SetAlphaTestHash(0x0);
    }
    
    { 
      for ( s32 keyCnt = 0; keyCnt < m_CombinerKeyCnt[materialIndex]; ++keyCnt )
      {
        s32                 attrType = m_CombinerHandleType[materialIndex][keyCnt];
        dataHandle = m_CombinerHandle[materialIndex][keyCnt];
        
        s32                 colorType = ( attrType < FloatAnimDataType::TextureCombinerAlpha0_MathFormula ) ? CombinerColorType::RGB : CombinerColorType::A;
        s32                 convNo;
        s32                 elementType;
        float               value;

        convNo = attrType - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
        convNo %= CombinerStageNum;

        elementType = attrType - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
        elementType /= CombinerStageNum;
        elementType = ( colorType == CombinerColorType::RGB ) ? elementType : elementType - CombinerElementNum;

        nw::gfx::ResTextureCombiner res_combiner = res_shader.GetTextureCombiners(convNo);
        
        switch( elementType ){
        case CombinerElementType::MathFormula:
          {         
            if ( colorType == CombinerColorType::RGB )
              res_combiner.SetCombineRgb( getCombinerCombineData( dataHandle, m_AnimFrame ) );
            else
              res_combiner.SetCombineAlpha( getCombinerCombineData( dataHandle, m_AnimFrame ) );
          }
          break;
        case CombinerElementType::Scale:
          {         
            if ( colorType == CombinerColorType::RGB )
              res_combiner.SetScaleRgb( getCombinerScaleData( dataHandle, m_AnimFrame ) );
            else
              res_combiner.SetScaleAlpha( getCombinerScaleData( dataHandle, m_AnimFrame ) );
          }
          break;
        case CombinerElementType::InputSourceA:
        case CombinerElementType::InputSourceB:
        case CombinerElementType::InputSourceC:
          {
            s32     index = elementType - CombinerElementType::InputSourceA;

            if ( colorType == CombinerColorType::RGB )
              res_combiner.SetSourceRgb( index, getCombinerSrcData( dataHandle, m_AnimFrame ) );
            else
              res_combiner.SetSourceAlpha( index, getCombinerSrcData( dataHandle, m_AnimFrame ) );
          }
          break;
        case CombinerElementType::OperandA:
        case CombinerElementType::OperandB:
        case CombinerElementType::OperandC:
          {
            s32     index = elementType - CombinerElementType::OperandA;

            if ( colorType == CombinerColorType::RGB )
              res_combiner.SetOperandRgb( index, getCombinerOperandRgbData( dataHandle, m_AnimFrame ) );
            else
              res_combiner.SetOperandAlpha( index, getCombinerOperandAlphaData( dataHandle, m_AnimFrame ) );
          }
          break;
        case CombinerElementType::OutPutBuffer:
          {//̒iւ̏o͐ݒł͂ȂAO̒i̓͐ݒȂ̂ŒӂKvBiconvNo + 1j
            if ( colorType == CombinerColorType::RGB )
              res_shader.SetBufferInputRgb(convNo + 1, getCombinerBufferInputData( dataHandle, m_AnimFrame ));
            else
              res_shader.SetBufferInputAlpha(convNo + 1, getCombinerBufferInputData( dataHandle, m_AnimFrame ));
          }
          break;
        }
      }

      if ( m_CombinerKeyCnt[materialIndex] )
        res_material.SetShaderParametersHash(0x0);
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
bool ShaderModel::setConstantAnim( s32 materialNo, s32 frame, nw::gfx::ResMaterialColor &res_color )
{
  bool      fUpdate = false;
  
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant0) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant0();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant0, frame );
    res_color.SetConstant0( color );
    fUpdate = true;
  }
  
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant1) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant1();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant1, frame );
    res_color.SetConstant1( color );
    fUpdate = true;
  }
  
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant2) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant2();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant2, frame );
    res_color.SetConstant2( color );
    fUpdate = true;
  }
  
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant3) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant3();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant3, frame );
    res_color.SetConstant3( color );
    fUpdate = true;
  }
  
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant4) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant4();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant4, frame );
    res_color.SetConstant4( color );
    fUpdate = true;
  }
  if ( isVecHandleEnable(materialNo, VecAnimDataType::Constant5) )
  {
    nw::ut::FloatColor      color = res_color.GetConstant5();
    color = overWriteColorData( color, materialNo, VecAnimDataType::Constant5, frame );
    res_color.SetConstant5( color );
    fUpdate = true;
  }
  
  return fUpdate;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
s32 ShaderModel::getMaterialIndex( const char* pMaterialName )
{
  for( s32 i = 0; i < MaterialMax; ++i )
  {
    if ( pMaterialName == m_pMaterialNames[i] )
      return i;//Ԃ|C^rłBʖڂȂ當r
  }
  
  return -1;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void ShaderModel::resetHandle()
{
  for( s32 i = 0; i < MaterialMax; ++i )
  {
    m_AlphaRefHandle[ i ] = -1;
    m_CombinerKeyCnt[ i ] = 0;
    
    for( s32 i2 = 0; i2 < VecAnimDataType::NumberOf; ++i2 )
    {
      for( s32 i3 = 0; i3 < 4; ++i3 )
      {
        m_VectorAnimHadles[ i ][ i2 ][i3] = -1;
      }
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResTextureCombiner::Combine ShaderModel::getCombinerCombineData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResTextureCombiner::Combine      sampleTable[] = {
    nw::gfx::res::ResTextureCombiner::COMBINE_REPLACE,    //!< A ł
    nw::gfx::res::ResTextureCombiner::COMBINE_MODULATE,       //!< A * B łB
    nw::gfx::res::ResTextureCombiner::COMBINE_ADD,            //!< A + B łB
    nw::gfx::res::ResTextureCombiner::COMBINE_ADDSIGNED,      //!< A + B - 0.5 łB
    nw::gfx::res::ResTextureCombiner::COMBINE_INTERPOLATE,    //!< A * C + B * ( 1 - C ) łB
    nw::gfx::res::ResTextureCombiner::COMBINE_SUBTRACT,       //!< A - B łB
    nw::gfx::res::ResTextureCombiner::COMBINE_DOT3_RGB,       //!< RGB  Dot ( A , B ) łB
    nw::gfx::res::ResTextureCombiner::COMBINE_DOT3_RGBA,      //!< RGBA  Dot ( A , B ) łB
    nw::gfx::res::ResTextureCombiner::COMBINE_MULT_ADD,       //!< ( A * B ) + C łB
    nw::gfx::res::ResTextureCombiner::COMBINE_ADD_MULT        //!< ( A + B ) * C łB
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResTextureCombiner::Scale ShaderModel::getCombinerScaleData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResTextureCombiner::Scale      sampleTable[] = {
    nw::gfx::res::ResTextureCombiner::SCALE_ONE, //!< 1.0 {B
    nw::gfx::res::ResTextureCombiner::SCALE_TWO,     //!< 2.0 {B
    nw::gfx::res::ResTextureCombiner::SCALE_FOUR     //!< 4.0 {B
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResTextureCombiner::OperandAlpha ShaderModel::getCombinerOperandAlphaData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResTextureCombiner::OperandAlpha      sampleTable[] = {
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_SRC_ALPHA,             //!< At@łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_SRC_ONE_MINUS_ALPHA, //!< 1 - At@łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_RED,                 //!< R łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_ONE_MINUS_RED,       //!< 1 - R łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_GREEN,               //!< G łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_ONE_MINUS_GREEN,     //!< 1 - G łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_BLUE,                //!< B łB
    nw::gfx::res::ResTextureCombiner::OPERANDALPHA_ONE_MINUS_BLUE       //!< 1 - B łB
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::ColorF32 ShaderModel::overWriteColorData( gfl::grp::ColorF32 src, s32 materialNo, VecAnimDataType::Enum type, s32 frame )
{
  s32     dataHandle;
  
  dataHandle = m_VectorAnimHadles[materialNo][type].x;
  if( dataHandle != -1 )
  {
    src.r = m_pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = m_VectorAnimHadles[materialNo][type].y;
  if( dataHandle != -1 )
  {
    src.g = m_pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = m_VectorAnimHadles[materialNo][type].z;
  if( dataHandle != -1 )
  {
    src.b = m_pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = m_VectorAnimHadles[materialNo][type].w;
  if( dataHandle != -1 )
  {
    src.a = m_pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  return src;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResTextureCombiner::Source ShaderModel::getCombinerSrcData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResTextureCombiner::Source      sampleTable[] = {
    nw::gfx::res::ResTextureCombiner::SOURCE_TEXTURE0,                    //!< eNX` 0 łB
    nw::gfx::res::ResTextureCombiner::SOURCE_TEXTURE1,                    //!< eNX` 1 łB
    nw::gfx::res::ResTextureCombiner::SOURCE_TEXTURE2,                    //!< eNX` 2 łB
    nw::gfx::res::ResTextureCombiner::SOURCE_TEXTURE3,                    //!< eNX` 3 łB
    nw::gfx::res::ResTextureCombiner::SOURCE_CONSTANT,                    //!< RX^gJ[łB
    nw::gfx::res::ResTextureCombiner::SOURCE_PRIMARY_COLOR,               //!< _VF[_[̏o͌ʂłB
    nw::gfx::res::ResTextureCombiner::SOURCE_FRAGMENT_PRIMARY_COLOR,      //!< vC}J[łB
    nw::gfx::res::ResTextureCombiner::SOURCE_FRAGMENT_SECONDARY_COLOR,    //!< ZJ_J[łB
    nw::gfx::res::ResTextureCombiner::SOURCE_PREVIOUS,                    //!< Oȉo͌ʂłB
    nw::gfx::res::ResTextureCombiner::SOURCE_PREVIOUS_BUFFER              //!< Oĩobt@łB
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResTextureCombiner::OperandRgb ShaderModel::getCombinerOperandRgbData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResTextureCombiner::OperandRgb      sampleTable[] = {
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_SRC_COLOR,               //!< RGB łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_ONE_MINUS_SRC_COLOR,   //!< 1 - RGB łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_SRC_ALPHA,             //!< At@łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_ONE_MINUS_SRC_ALPHA,   //!< 1 - At@łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_RED,                   //!< R łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_ONE_MINUS_RED,       //!< 1 - R łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_GREEN,                 //!< G łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_ONE_MINUS_GREEN,       //!< 1 - G łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_BLUE,                  //!< B łB
    nw::gfx::res::ResTextureCombiner::OPERANDRGB_ONE_MINUS_BLUE        //!< 1 - B łB
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
nw::gfx::res::ResFragmentShader::BufferInput ShaderModel::getCombinerBufferInputData( s32 dataHandle, s32 frame )
{
  nw::gfx::res::ResFragmentShader::BufferInput      sampleTable[] = {
    nw::gfx::res::ResFragmentShader::BUFFERINPUT_PREVIOUS,          //Oȉo͌ʂłB
    nw::gfx::res::ResFragmentShader::BUFFERINPUT_PREVIOUS_BUFFER, 	//Oĩobt@łB
  };
  
  s32 value = static_cast<s32>( m_pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
inline bool ShaderModel::isVecHandleEnable( int materialNo, VecAnimDataType::Enum type )
{
  IntVec          &rHandle = m_VectorAnimHadles[materialNo][type];

  for( int i = 0; i < 4; ++i )
  {
    if ( rHandle[i] != -1 )
      return true;
  }

  return false;
}

}  // namespace xy_system

