//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		ShaderModel.h
 *	@brief  VF[_[fNX
 *	@author	Masayuki Onoue
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#if !defined( __SHADERMODEL_H__ )
#define __SHADERMODEL_H__

#include <gflib.h>

// NW4C
#include <nw/gfx.h>
#include <nw/gfx/gfx_Model.h>

#define DECLARE_ENUM_BEGIN( CLASSNAME )	\
	class CLASSNAME {											\
	public:																\
		enum Enum {
#define DECLARE_ENUM_END( CLASSNAME )		\
		};                                  \
	};

namespace xy_system {
  
//-------------------------------------------------------------------------------------------------------------------------------------------------
//!  Aj[Vf[^^Cv
DECLARE_ENUM_BEGIN( VecAnimDataType )
  Constant0 = 0,
  Constant1,
  Constant2,
  Constant3,
  Constant4,
  Constant5,
  NumberOf,
  
  ConstantNum = (Constant5 - Constant0) + 1
DECLARE_ENUM_END( VecAnimDataType )    

class ShaderModel : public gfl::grp::g3d::Model
{
  
protected:
  struct IntVec{
    union
    {
      struct
      {
        int		x;
        int		y;
        int		z;
        int		w;
      };

      struct
      {
        int		i[4];
      };

    };
    
    int& operator []( int index ){ return this->i[index]; }
    const int& operator []( int index ) const { return this->i[index]; }
  };

protected:
  static const s32      MaterialMax = 16 + 1;              ///< p[eBN}eAPǉ
  static const s32      ColorTextureMax = MaterialMax * 3;///<ő24܂ł̃J[}bvBieʓIɂ256x256x3͈̔́j
  static const s32      ShaderAttributeNameMaxLen = 256;  ///< lςƂ̓Ro[^[ς
  static const s32      CombinerKeyMax = 8;               ///< lςƂ̓Ro[^[ς
  static const s32      MAX_PATH = 4;
  static const int      CombinerStageNum = 6;
  static const int      ConstantMax = 6;
  static const int      CombinerElementNum = 9;
  
  s32                   m_AnimFrame;
  s32                   m_MaterialCount;
  
  IntVec                m_VectorAnimHadles[MaterialMax][VecAnimDataType::NumberOf];
  s32                   m_AlphaRefHandle[MaterialMax];
  
  //\̂ɂ܂Ƃ߂
  s32                   m_CombinerHandle[MaterialMax][CombinerKeyMax];
  s32                   m_CombinerHandleType[MaterialMax][CombinerKeyMax];
  s32                   m_CombinerKeyCnt[MaterialMax];
  
  const char*           m_pMaterialNames[MaterialMax];

  const gfl::grp::g3d::ResAnim  *m_pResAnim;
 
public:
   
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  ShaderModel(void);

  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~ShaderModel();
 
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *
   *  @param[in]     allocator          AP[^
   *  @param[in]     device_allocator   foCX̃AP[^
   *  @param[in]     resource           \[X
   *  @param[in]     index_in_resource  \[XɂCfbNX
   *  @param[in]     description        ݒe
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*           allocator,
      gfl::heap::NwAllocator*           device_allocator,
      gfl::grp::g3d::Resource*          resource,
      s32                               index_in_resource,
      Description*                      description  = NULL
  );

  //-----------------------------------------------------------------------------
  /**
   * @brief \[Xf[^ݒ֐
   * @param pData
   * @note Ń|C^QƂ܂BSAgr[g̃nh擾ɍŝŏd͂
   */
  //-----------------------------------------------------------------------------
  void SetShaderAttributeAnimData( const gfl::grp::g3d::ResAnim *pData );

  //-----------------------------------------------------------------------------
  /**
   * @brief VF[_[Agr[gAj[Vt[ݒ
   * @param frame t[
   */
  //-----------------------------------------------------------------------------
  void SetShaderAttributeAnimFrame( s32 frame );

protected:
  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  void resetHandle();

private:
  /* -------------------------------------------------------------------------*/
  /**
   * @brief Ɏ擾Kvȃp[^W߂
   */
  /* -------------------------------------------------------------------------*/
  void CreateParam( void );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  bool setConstantAnim( s32 materialNo, s32 frame, nw::gfx::ResMaterialColor &res_color );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  s32 getMaterialIndex( const char* pMaterialName );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  inline bool isVecHandleEnable( int materialNo, VecAnimDataType::Enum type );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResTextureCombiner::Combine getCombinerCombineData( s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResTextureCombiner::Scale getCombinerScaleData( s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResTextureCombiner::OperandAlpha getCombinerOperandAlphaData( s32 dataHandle, s32 frame );

   //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::ColorF32 overWriteColorData( gfl::grp::ColorF32 src, int materialNo, VecAnimDataType::Enum type, int frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResTextureCombiner::Source getCombinerSrcData( int dataHandle, int frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResTextureCombiner::OperandRgb getCombinerOperandRgbData( s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  nw::gfx::res::ResFragmentShader::BufferInput getCombinerBufferInputData( s32 dataHandle, s32 frame );
  

};

}  // namespace xy_system

#endif		// __SHADERMODEL_H__
