//============================================================================
/**
 *
 *	@file		ScriptFuncSetGimmick.cpp
 *	@brief  XNvg߃ZbgFM~bN֘A
 *
 */
//============================================================================
#include "ScriptFuncSetGimmick.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

//=============================================================================
/**
 *					萔錾
*/
//=============================================================================

//-----------------------------------------------------------------------------
/**
 *	@brief  ߃e[uZbg擾
 */
//-----------------------------------------------------------------------------
const GFL_PAWN_FUNC_TABLE* FuncSetGimmick::GetTable( void )
{
  static const GFL_PAWN_FUNC_TABLE s_FuncTable[] = 
  {
    GFL_PAWN_FUNC( GymInsectEnterEvent )
    GFL_PAWN_FUNC( WarpNextPos )
    GFL_PAWN_FUNC( GymRockClimbEvent )
    GFL_PAWN_FUNC( GymGrassHangMoveEvent )
    GFL_PAWN_FUNC( GymGrassRopeUpDownEvent )
    GFL_PAWN_FUNC( GymGrassSlideEvent )
    GFL_PAWN_FUNC( CallFireEntranceEvent )
  };

  return s_FuncTable;
}

//=============================================================================
/**
 *					W
*/

//----------------------------------------------------------------------------
/**
 *	@brief  ioĐ
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::GymInsectEnterEvent( AMX * amx, const cell * ptr )
{
  ONOUE_PRINT("XNvgR}hďo\n");
  
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymInsect* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymInsect>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  event->SetParameter( p_fieldmap );

  return NULL;
}

//=============================================================================
/**
 *					dW
*/

/* -------------------------------------------------------------------------*/
/**
 * @brief [vs
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetGimmick::WarpNextPos( AMX * amx, const cell * ptr )
{
  // p[^󂯎
  f32 gx    = ptr[1];
  f32 gy    = ptr[2];
  f32 gz    = ptr[3]; 

  // f[^擾
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  
  // CxgĂяo
  EventGymFairy* event = GAMESYSTEM_EVENT_CHANGE<gamesystem::GameEventManager, EventGymFairy>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  event->SetParameter( p_fieldmap ,gx, gy, gz);

  return NULL;
}

//=============================================================================
/**
 *					W
*/

//----------------------------------------------------------------------------
/**
 *	@brief  bNNCJnƏI
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::GymRockClimbEvent( AMX * amx, const cell * ptr )
{
  NOZOMU_PRINT("W@XNvgR}hďo\n");

  int wall_idx;
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymRock* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymRock>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  wall_idx = ptr[1];
  event->SetParameter( p_fieldmap, wall_idx );

  return NULL;
}

//=============================================================================
/**
 *					W
*/

//----------------------------------------------------------------------------
/**
 *	@brief  ^[Uړ
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::GymGrassHangMoveEvent( AMX * amx, const cell * ptr )
{
  NOZOMU_PRINT("Wړ@XNvgR}hďo\n");
  
  int data_idx;
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymGrassHangMove* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymGrassHangMove>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  data_idx = ptr[1];
  event->SetParameter( p_fieldmap, data_idx );
  NOZOMU_PRINT("p[^: data=%d\n",data_idx);

  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  [v㉺ړ
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::GymGrassRopeUpDownEvent( AMX * amx, const cell * ptr )
{
  NOZOMU_PRINT("Wcړ@XNvgR}hďo\n");
 
  int data_idx;
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymGrassRopeUpDown* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymGrassRopeUpDown>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  data_idx = ptr[1];
  event->SetParameter( p_fieldmap, data_idx );
  NOZOMU_PRINT("p[^: data=%d\n",data_idx);

  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ~
 *
 *	@param	*amx
 *	@param	*ptr 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetGimmick::GymGrassSlideEvent( AMX * amx, const cell * ptr )
{
  NOZOMU_PRINT("W~ړ@XNvgR}hďo\n");
  
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventGymGrassSlide* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventGymGrassSlide>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  event->SetParameter( p_fieldmap );

  return NULL;
}

//=============================================================================
/**
 *					lV
*/

/* -------------------------------------------------------------------------*/
/**
 * @brief GgXCxg
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetGimmick::CallFireEntranceEvent( AMX * amx, const cell * ptr )
{
  System* p_sys  = System::GetInstance();
  gamesystem::GameManager* p_gman = p_sys->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  EventBigFourFire* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventBigFourFire>( p_fieldmap->GetGameManager()->GetGameEventManager() );
  event->SetParameter( p_fieldmap );

  return NULL;
}


GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

