//============================================================================================
/**
 * @file		app_tool_TalkWindowGra.cpp
 * @brief		bEBhẼCAEg\[X
 * @author	Hiroyuki Nakamura -> Onoue Masayuki
 * @date		12.04.17
 * 
 * @note  TalkWindow\[X݂̂̂ŖOTalkWindowGraɕύXnagihashi
 *
 * namespace	app::tool::
 */
//============================================================================================

namespace app {
namespace tool {

/* -------------------------------------------------------------------------*/
/**
 * @brief yC
 */
/* -------------------------------------------------------------------------*/
typedef struct {
	gfl::grp::g2d::LytPaneIndex top_pane;   ///< gbvyC
	gfl::grp::g2d::LytPaneIndex sub_pane;   ///< TuyC
	gfl::grp::g2d::LytPaneIndex tail_pane;  ///< KyC
	gfl::grp::g2d::LytPaneIndex arrow_pane; ///< yC
}WINDOW_PANE_DATA;

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhE^Cv
 */
/* -------------------------------------------------------------------------*/
typedef struct {
  const WINDOW_PANE_DATA  *p_pane_data;         ///< yC
  bool                    use_frame_inout_anm;  ///< AjL肩ǂ
  f32                     frame_size_x;           ///< t[TCY
  f32                     frame_size_y;           ///< t[TCY
  f32                     default_w;            ///< ftHgEBhE
  f32                     default_h;            ///< ftHgEBhE
  bool                    is_variable;          ///< σEBhE
  u8                      line_num;             ///< C
}WINDOW_DATA;

/// yCl
static const u32 PANE_NONE = LYTRES_PANENAME_MSG_WINDOW_RES_PANE_END;

/// EBhE`
#include "app/tool/app_tool_TalkWindow_type.h" // EBhE^Cv
#include "app_tool_TalkWindow.cdat" // for WindowDataTable

static const u16 WIN_TABLE_NUM = GFL_NELEMS(WindowDataTable);   ///< EBhEe[uTCY
static const u16 WIN_ANM_TABLE_NUM = GFL_NELEMS(AnimeIndexTbl); ///< Aj[Ve[uTCY


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
TalkWindowGra::TalkWindowGra(void) :
	mp_lyt_sys( NULL ),
	mp_lyt_wk( NULL ),
	m_lyt_res_id( 0 ),
	m_str_win_ofs( gfl::math::VEC3(0,0,0) ),
	m_win_type( 0 ),
  m_collar_id( 0 ),
  m_anm_end_frm( 0 ),
  m_is_play_anime( false )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
TalkWindowGra::~TalkWindowGra()
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[Xǂݍ
 *
 * @param		lytsys				CAEgVXe
 * @param		heap					q[v
 * @param		devAllocator	foCXq[vAP[^
 * @param		trans					eNX`]tO true = ]@ftHg = true
 *
 * @return	CAEg\[XID
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID TalkWindowGra::LoadLayoutResource(
													gfl::grp::g2d::LytSys * lytsys, gfl::heap::HeapBase * heap, gfl::heap::NwAllocator * devAllocator, bool trans )
{
	gfl::fs::ArcFile * af = GFL_NEW_LOW( heap ) gfl::fs::ArcFile( heap, ARCID_COMMON_MSGWINDOW, gfl::fs::ArcFile::OPEN );
	gfl::grp::g2d::LytResID id = lytsys->LoadLytResComp( devAllocator, af, 0 );
	GFL_DELETE af;

	if( trans == true ){
		lytsys->TransferAllTexture( id, gfl::grp::MEMORY_AREA_FCRAM );
	}

	return id;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		lytsys				CAEgVXe
 * @param		setup					CAEg[ÑZbgAbvf[^
 * @param		res_id				CAEg\[XID
 * @param		type					EBhE^Cv@TYPE_TALK_**
 *
 * @return	CAEg[N
 *
 * @li	type = TYPE_NORMALŁAeʂ̃CAEgɃEBhE܂܂ĂȂsv
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytWk * TalkWindowGra::CreateLayoutWork(
												gfl::grp::g2d::LytSys * lytsys,
												const gfl::grp::g2d::LytWkSetUp * setup,
												gfl::grp::g2d::LytResID res_id, u32 type,
                        gfl::heap::NwAllocator* device_allocator )
{
	mp_lyt_sys = lytsys;

	const WINDOW_DATA * win = &WindowDataTable[type];

  //---------------------------
  /// CAEg[N𐶐
  if( device_allocator )
  {
    mp_lyt_wk = mp_lyt_sys->CreateLytWk( device_allocator, device_allocator, res_id, LYTRES_MSG_WINDOW_RES_MESSAGE_WIN_BCLYT, AnimeIndexTbl, WIN_ANM_TABLE_NUM, WIN_ANM_TABLE_NUM , setup, false );
  }
  else 
  {
	  mp_lyt_wk = mp_lyt_sys->CreateLytWk( res_id, LYTRES_MSG_WINDOW_RES_MESSAGE_WIN_BCLYT,  AnimeIndexTbl, WIN_ANM_TABLE_NUM,WIN_ANM_TABLE_NUM , setup, false );
  }

  // Aj[V͏1
  mp_lyt_wk->BindAnime( BIND_ANM_ID );
  mp_lyt_wk->SetAutoAnime( BIND_ANM_ID, false );

  // EBhȄ
  ResetWindowStatus( type );
  
	return mp_lyt_wk;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhE^Cv
 *
 * @param win_type  EBhE^Cv
 * 
 * @note ŃZbgs܂
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetWindowType( u16 win_type )
{
  // EBhE^Cvݒ肷
  ResetWindowStatus( win_type );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Fݒ肷
 *
 * @param collar  ZbgF
 * 
 * @note  Aj[V͒~ԂɂȂ
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetColor( app::tool::TalkWindowGra::WIN_COLLAR_TYPE collar )
{
  // J[ID̕ۑ
  m_collar_id = static_cast<u16>(collar);

  // J[ɉJnt[vZ
  u32 set_frame;
  u32 current_frame = (FRAME_IN_FRAME+FRAME_OUT_FRAME)*m_collar_id;
  
  // t[Aj[VĐɐݒ
  set_frame     = current_frame + FRAME_IN_FRAME;
  m_anm_end_frm = set_frame + FRAME_OUT_FRAME;

  // Aj[V𔽉f(Aj[V͒~)
  SetAnime( set_frame ,false );

}
  
/* -------------------------------------------------------------------------*/
/**
 * @brief EBhE
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::ResetWindowStatus( u16 win_type )
{
  //---------------------------
  /// SyC̕\Ԃ
  gfl::grp::g2d::LytPane * pane = mp_lyt_wk->GetPane( PANENAME_MESSAGE_WIN_PANE_NULL_00 );
  nw::lyt::PaneList & list = pane->GetChildList();
  nw::lyt::PaneList::Iterator iter = list.GetBeginIter();
  nw::lyt::PaneList::Iterator end  = list.GetEndIter();

  // SẴm[h̏邪A[vh~̂ߍő吔߂Ă
  for(int i = 0; i < PANE_INIT_NUM ; i++ )
  {
    if( iter == end ){
      break;
    }
    // Sm[h\ɂ
    gfl::grp::g2d::LytPane * child = nw::ut::DynamicCast<gfl::grp::g2d::LytPane *>( &(*iter) );
    child->SetVisible( true );
    iter++;
  }

  // SpkyC͏ɕ\
  SetVisible( PANENAME_MESSAGE_WIN_PANE_NULL_00, true );
  // pkyC͏ɕ\
  SetVisible( PANENAME_MESSAGE_WIN_PANE_NULL_01, true );

  // SẴEBhE\ɂ
  for(int i = 0; i < WIN_TABLE_NUM ; i++ )
  {
    const WINDOW_PANE_DATA * base = WindowDataTable[i].p_pane_data;
    SetVisible( base->top_pane, false );
  }

  // ItZbg
  m_str_win_ofs = gfl::math::VEC3(0,0,0);

  // EBhE^Cv
  m_win_type = win_type;

  // J[^Cv
  m_collar_id = 0;

  // Aj[VIt[
  m_anm_end_frm = 0;

  // eLXg{bNXyC̐eq֌W𒅑ւ
  SetStrWinParent();

  // eLXg{bNXyC̃ItZbgʒuݒ肷
  SetStrWinPosOffset();

  // C
  m_line_num = 2;

  // ʒu͏ɒSA͍폜
  gfl::grp::g2d::LytTextBox* p_str_pane;
  // 1s 
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  p_str_pane->SetTextPositionV( nw::lyt::VERTICALPOSITION_CENTER );
  p_str_pane->SetString( L"" );
  // 2s
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  p_str_pane->SetTextPositionV( nw::lyt::VERTICALPOSITION_CENTER );
  p_str_pane->SetString( L"" );

  SetFontScale( 1.0f );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ʒũZ^OJn
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::StartTextPosCenter( void )
{
  gfl::grp::g2d::LytTextBox* p_str_pane;
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  p_str_pane->SetTextPositionH( nw::lyt::HORIZONTALPOSITION_CENTER );
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  p_str_pane->SetTextPositionH( nw::lyt::HORIZONTALPOSITION_CENTER );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ʒu␳̃Zbg
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::ResetTextPos( void )
{
  gfl::grp::g2d::LytTextBox* p_str_pane;
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  p_str_pane->SetTextPositionH( nw::lyt::HORIZONTALPOSITION_LEFT );
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  p_str_pane->SetTextPositionH( nw::lyt::HORIZONTALPOSITION_LEFT );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TalkWindowGra::DeleteLayoutWork(void)
{
	mp_lyt_sys->RemoveLytWk( mp_lyt_wk );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief W𒼐ڎw肷
 *
 * @param pos W
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetWindowPos( const gfl::math::VEC3 &pos )
{
	const WINDOW_PANE_DATA * base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane * pane = mp_lyt_wk->GetPane( base->top_pane );
  pane->SetTranslate( pos );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Ww肷iʊOɃEBhEʊOɍsꍇ͈ʒu␳)
 *
 * @param pos W
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetWindowPosFix( gfl::math::VEC3 pos )
{
	const WINDOW_PANE_DATA * p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane * p_pane = mp_lyt_wk->GetPane( p_base->top_pane );
  nw::ut::Rect rect = p_pane->GetPaneRect();

  f32 w = gfl::math::Abs(rect.GetWidth());
  f32 h = gfl::math::Abs(rect.GetHeight());

  // [
  if( pos.x < 0 )
  {
    pos.x = 0;
  }
  // E[
  if( pos.x + w > UP_WIN_SIZE_X )
  {
    pos.x = UP_WIN_SIZE_X - w;
  }
  // [
  if( pos.y > 0 )
  {
    pos.y = 0;
  }
  // [
  if( (pos.y - h) < -UP_WIN_SIZE_Y )
  {
    pos.y = -(UP_WIN_SIZE_Y-h);
  }

  // ʒuݒ
  p_pane->SetTranslate( pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ŒʒuɃEBhEzu
 *
 * @param		pos		ʒu@WIN_PUT_UPPER_** or WIN_PUT_LOWER_**
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TalkWindowGra::SetWindowPosEz( u32 pos )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J[\̔zuʒu擾
 *
 * @return	zuʒu
 */
//--------------------------------------------------------------------------------------------
gfl::math::VEC3 TalkWindowGra::GetCursorPos(void)
{
  const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane* p_pane_top = mp_lyt_wk->GetPane( p_base->top_pane );
  gfl::math::VEC3 pos   = p_pane_top->GetTranslate();
  nw::ut::Rect rect     = p_pane_top->GetPaneRect();

  f32 w = gfl::math::Abs(rect.GetWidth());
  f32 h = gfl::math::Abs(rect.GetHeight());

  pos.x += w;
  pos.y -= h;

  pos.x += OKURI_X_OFS;
  pos.y += OKURI_Y_OFS;

  // J[\͉ʒSʒuɐݒ肳Ă̂
  // W~Kv
  pos.x-=UP_WIN_SIZE_X/2;
  pos.y+=UP_WIN_SIZE_Y/2;


  return pos;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhE\؂ւ
 *
 * @param		flg		true = \, false = \
 * @li	    CreateLayuotWork()gpꍇ̂
 */
//--------------------------------------------------------------------------------------------
void TalkWindowGra::SetVisible( bool flg )
{
	const WINDOW_PANE_DATA * base = WindowDataTable[m_win_type].p_pane_data;
	SetVisible( base->top_pane, flg );

  // yC̓gbvyCgɕ\\؂ւ
  gfl::grp::g2d::LytPaneIndex up_pane_id    = GetTextBoxPaneIdx( true );
  gfl::grp::g2d::LytPaneIndex down_pane_id  = GetTextBoxPaneIdx( false );
	SetVisible( up_pane_id,   flg );
	SetVisible( down_pane_id, flg );

}

/* -------------------------------------------------------------------------*/
/**
 * @brief gbvyCg̕\Ԃ擾
 *
 * @return truêƂ\
 */
/* -------------------------------------------------------------------------*/
bool TalkWindowGra::GetVisible( void )
{
  if( mp_lyt_wk )
  {
    const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;
    gfl::grp::g2d::LytPane* p_pane_tail = mp_lyt_wk->GetPane( p_base->top_pane );
    return p_pane_tail->IsVisible();
  }

  GFL_ASSERT( mp_lyt_wk != NULL );
  return false;
}

//----------------------------------------------------------------------------
/**
 *	@brief  wID̃rWreB[𑀍삷
 *
 *	@param	id  yCID
 *	@param	flg true = \@false = \
 */
//-----------------------------------------------------------------------------
void TalkWindowGra::SetVisible( u32 id, bool flg )
{
	GFL_ASSERT( mp_lyt_wk != NULL );

  gfl::grp::g2d::LytPane * pane = mp_lyt_wk->GetPane( id );
	pane->SetVisible( flg );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief KOFFɂ
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetTailOff(void)
{
  const WINDOW_PANE_DATA * base = WindowDataTable[m_win_type].p_pane_data;

  if( base->tail_pane != PANE_NONE)
  {
    SetVisible( base->tail_pane ,false );
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief KONɂ
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetTailOn(void)
{
  const WINDOW_PANE_DATA * base = WindowDataTable[m_win_type].p_pane_data;

  if( base->tail_pane != PANE_NONE)
  {
    SetVisible( base->tail_pane ,true );
  }
}

void TalkWindowGra::SetTailPut( u32 put_type, u32 pos )
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   eLXg{bNXyCCfbNX擾
 *
 * @return yCCfbNX
 */
/* -------------------------------------------------------------------------*/
gfl::grp::g2d::LytTextBox * TalkWindowGra::GetTextBoxPane(void)
{
	return mp_lyt_wk->GetTextBoxPane( PANENAME_MESSAGE_WIN_PANE_TEXTBOX_00 );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   eLXg{bNXyCINDEX擾
 *
 * @param   is_line_up  true = 1s,false = 2s
 *
 * @return  yCCfbNX
 */
/* -------------------------------------------------------------------------*/
gfl::grp::g2d::LytPaneIndex TalkWindowGra::GetTextBoxPaneIdx( bool is_line_up )
{
  if( is_line_up )
  {
	  return PANENAME_MESSAGE_WIN_PANE_TEXTBOX_00;
  }
  
	return PANENAME_MESSAGE_WIN_PANE_TEXTBOX_01;
}



//----------------------------------------------------------------------------
/**
 *	@brief  Aj[Vt[ݒ肷
 *
 *	@param	set_frm Zbgt[
 *	@param	is_auto_anm true̎Aj[V
 */
//-----------------------------------------------------------------------------
void TalkWindowGra::SetAnime( u32 set_frm ,bool is_auto_anm )
{
  mp_lyt_wk->SetAnimeFrame( BIND_ANM_ID, set_frm );
  mp_lyt_wk->SetAutoAnime( BIND_ANM_ID, is_auto_anm );
  m_is_play_anime = is_auto_anm;
}

//----------------------------------------------------------------------------
/**
 *	@brief  t[INAOUTAjĐiJ[̔fsj
 *
 *	@param	is_in true̎INAj,false̎OUTAj
 *
 *	@retval false̎t[Aj[V݂Ȃ
 */
//-----------------------------------------------------------------------------
bool TalkWindowGra::SetFrameInOutAnm( bool is_in )
{
	bool is_anm = WindowDataTable[m_win_type].use_frame_inout_anm;

  // J[ɉJnt[vZ
  u32 set_frame;
  u32 current_frame = (FRAME_IN_FRAME+FRAME_OUT_FRAME)*m_collar_id;
  
  // IN,OUT𔻒fāAJnt[ƏIt[vZ
  if( is_in ){
    set_frame     = current_frame;
    m_anm_end_frm = set_frame + FRAME_IN_FRAME;
  }else{
    set_frame     = current_frame + FRAME_IN_FRAME;
    m_anm_end_frm = set_frame + FRAME_OUT_FRAME;
  }

  // Aj[V𔽉f
  SetAnime( set_frame ,is_anm );

  return is_anm;
}

//----------------------------------------------------------------------------
/**
 *	@brief  XVs(Aj[V̍Đs܂)
 */
//-----------------------------------------------------------------------------
void TalkWindowGra::Update( void )
{
  // CAEg[N쐬ĂKv
  if( mp_lyt_wk )
  {

#if defined(DEBUG_ONLY_FOR_onoue_masayuki)
#if PM_DEBUG
    nn::hid::DebugPadReader pad;
    nn::hid::CTR::DebugPadStatus		pad_state;
    s32		readLen;
    pad.Read( &pad_state, &readLen, 1 );

    gfl::math::VEC3 pos;
    const WINDOW_PANE_DATA * p_base = WindowDataTable[m_win_type].p_pane_data;
    gfl::grp::g2d::LytPane * p_pane = mp_lyt_wk->GetPane( p_base->top_pane );

    // ݒ肷͉̂ĂƂ
    if( gfl::math::Abs(pad_state.leftStickX) > 0.3f ||
        gfl::math::Abs(pad_state.leftStickY) > 0.3f )
    {
      // yC̈ړl
      pos = p_pane->GetTranslate();
      pos.x += pad_state.leftStickX*3;
      pos.y += pad_state.leftStickY*3;

      ONOUE_PRINT("pos:%f %f %f\n",pos.x,pos.y,pos.z);
      SetWindowPosFix( pos );
    }

    // ݒ肷͉̂ĂƂ
    if( gfl::math::Abs(pad_state.rightStickX) > 0.3f ||
        gfl::math::Abs(pad_state.rightStickY) > 0.3f )
    {
      // yC̈ړl
      pos = p_pane->GetTranslate();
      pos.x += pad_state.rightStickX*3;
      pos.y += pad_state.rightStickY*3;

      ONOUE_PRINT("pos:%f %f %f\n",pos.x,pos.y,pos.z);
      SetWindowPos( pos );
    }

#endif // PM_DEBUG
#endif


    // oChċȂƂ̓Abvf[gKv
    if( mp_lyt_wk->IsBindAnime( BIND_ANM_ID ) && m_is_play_anime )
    {
      // It[ɒBĂꍇ̓Aj[V~
      if( mp_lyt_wk->GetAnimeFrame( BIND_ANM_ID ) == m_anm_end_frm )
      {
        // Aj[V~
        m_is_play_anime = false;
        mp_lyt_wk->SetAutoAnime( BIND_ANM_ID, m_is_play_anime );
      }
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[V̏I҂ԂmF
 *
 * @return true̎Aj[VI
 */
/* -------------------------------------------------------------------------*/
bool TalkWindowGra::IsPlayAnime( void )
{
  return m_is_play_anime;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief eLXg{bNXyC̃ItZbgݒ肷
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetStrWinPosOffset( void )
{
  // eLXgʒupyCňʒu
  gfl::grp::g2d::LytPane* p_str_pane;
  p_str_pane = mp_lyt_wk->GetPane( PANENAME_MESSAGE_WIN_PANE_NULL_01 );
  p_str_pane->SetTranslate( m_str_win_ofs );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief yC̐eq֌W݂̌̃EBhE^Cvɍ킹čĐݒ肷
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetStrWinParent( void )
{
  gfl::grp::g2d::LytPane* p_str_pane;
  gfl::grp::g2d::LytPane* p_parent;
  p_str_pane = mp_lyt_wk->GetPane( PANENAME_MESSAGE_WIN_PANE_NULL_01 );

  // eyC甲
  p_parent = p_str_pane->GetParent();
  p_parent->RemoveChild( p_str_pane );
  
  // ݂̃gbvyC̉Ɉړ
	const WINDOW_PANE_DATA * base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane *p_top_pane = mp_lyt_wk->GetPane( base->top_pane );
  p_top_pane->AppendChild( p_str_pane );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhETCYύXiσEBhÊ݂ɑΉj
 *
 * @param size  EBhETCY
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetWindowSize( const nw::lyt::Size& size )
{
	const WINDOW_PANE_DATA *p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytWindow* p_win_pane = mp_lyt_wk->GetWindowPane( p_base->top_pane );
  gfl::grp::g2d::LytWindow* p_win_sub;
  
  // yC̑݃`FbN
  if( p_win_pane )
  {
    // gbvEBhẼTCYύX
    p_win_pane->SetSize( size );
    
    // TuyCɃTCYύX
    if( p_base->sub_pane != PANE_NONE )
    {
      p_win_sub = mp_lyt_wk->GetWindowPane( p_base->sub_pane );
      GFL_ASSERT(p_win_sub);
      
      // Ȃ͐ݒ肵Ȃ
      if( p_win_sub )
      {
        // gbvEBhẼTCYύX
        p_win_sub->SetSize( size );
      }
    }
  }else{
    GFL_ASSERT_MSG( 0, "EBhEyCȊÕTCYύX悤ƂB\n");
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ɍ킹ăEBhETCYgk
 *
 * @param str_width   
 * @param str_height  
 * @param line_num    C
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetWinsizeFitStrWidth( int str_width ,int str_height ,int line_num )
{
	f32 frame_size_x = WindowDataTable[m_win_type].frame_size_x;
	f32 frame_size_y = WindowDataTable[m_win_type].frame_size_y;
  nw::lyt::Size size;
  
  // Cۑ
  m_line_num = line_num;
  
  // TCYƃCɂăEBhETCYݒ
  size.width  = str_width + (frame_size_x*2);
  size.height = (str_height*m_line_num) + (frame_size_y*2);

  gfl::grp::g2d::LytTextBox* p_str_pane;
  gfl::math::VEC3 pos;
  
  // 1ڂ̈ʒu
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  pos.x = frame_size_x;
  pos.y = -(frame_size_y);
  pos.z = 0;
  p_str_pane->SetTranslate( pos );
  
  // 2ڂ̈ʒu
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  pos.x = frame_size_x;
  pos.y = -(frame_size_y+str_height);
  pos.z = 0;
  p_str_pane->SetTranslate( pos );

  // EBhETCYύX
  SetWindowSize( size );
  
  // EBhEtBbg
  FitTextWinSize();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ftHg̃EBhETCYݒ肷
 *
 * @param line_num  C
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetDefaultWindowSize( int line_num )
{
  f32 default_w = WindowDataTable[m_win_type].default_w;
  f32 default_h = WindowDataTable[m_win_type].default_h;
  f32   frame_size_x = WindowDataTable[m_win_type].frame_size_x;
  f32   frame_size_y = WindowDataTable[m_win_type].frame_size_y;
  bool  is_variable = WindowDataTable[m_win_type].is_variable;
  
  // Cۑ
  m_line_num = line_num;
  
  gfl::grp::g2d::LytTextBox* p_str_pane;
  gfl::math::VEC3 pos;
  
  // 1ڂ̈ʒu
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  pos.x = frame_size_x;
  pos.y = -(frame_size_y);
  pos.z = 0;
  p_str_pane->SetTranslate( pos );
  
  // 2ڂ̈ʒu
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  pos.x = frame_size_x;
  pos.y = -(default_h/2);
  pos.z = 0;
  p_str_pane->SetTranslate( pos );

  // σEBhȄꍇ̓ftHgTCYݒ肵ăTCY𒲐
  if( is_variable )
  {
    nw::lyt::Size size;
    size.width  = default_w;
    size.height = default_h;
    SetWindowSize( size );
  }

  // EBhEtBbg
  FitTextWinSize();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief eLXg{bNXEBhEɍ킹Ċgk
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::FitTextWinSize( void )
{
	const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane* p_pane = mp_lyt_wk->GetPane( p_base->top_pane );
  gfl::grp::g2d::LytTextBox* p_str_pane;
	
  // t[TCY
  f32 frame_size_x = WindowDataTable[m_win_type].frame_size_x;
  f32 frame_size_y = WindowDataTable[m_win_type].frame_size_y;
  nw::ut::Rect rect = p_pane->GetPaneRect();
  
  // TCYvZ
  nw::lyt::Size size;
  f32 w = gfl::math::Abs(rect.GetWidth());
  f32 h = gfl::math::Abs(rect.GetHeight());
  size.width  = gfl::math::FCeil(w-(frame_size_x*2));
  size.height = gfl::math::FCeil(h-(frame_size_y*2));
 
  // ̓Cl
  size.height /= m_line_num;
  size.height = gfl::math::FCeil(size.height);
  
  // TCY𔽉f
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
  p_str_pane->SetSize( size );
  p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
  p_str_pane->SetSize( size );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhẼZ^[ʒu擾
 *
 * @param center_pos  擾W̊i[
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::GetWinCenterPos( gfl::math::VEC3& center_pos )
{
	const WINDOW_PANE_DATA * p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane * p_pane = mp_lyt_wk->GetPane( p_base->top_pane );
  
  // yC̈ړl
  center_pos = p_pane->GetTranslate();
  
  // ƍ擾
  nw::ut::Rect rect   = p_pane->GetPaneRect();
  f32 w = gfl::math::Abs(rect.GetWidth());
  f32 h = gfl::math::Abs(rect.GetHeight());

  // Sʒu߂
  center_pos.x += w/2;
  center_pos.y -= h/2;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhẼNg
 *
 * @param rect  擾Ng̊i[
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::GetWinRect( nw::ut::Rect &rect )
{
  	const WINDOW_PANE_DATA * p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane * p_pane = mp_lyt_wk->GetPane( p_base->top_pane );
  
  // gbvpl̃Ng擾
  rect   = p_pane->GetPaneRect();

}

/* -------------------------------------------------------------------------*/
/**
 * @brief KړpNg̎擾
 *
 * @param rect  擾Ng̊i[
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::GetTailRect( nw::ut::Rect &rect )
{
  const WINDOW_PANE_DATA * p_base = WindowDataTable[m_win_type].p_pane_data;
  gfl::grp::g2d::LytPane * p_pane = mp_lyt_wk->GetPane( p_base->top_pane );
  
  // gbvpl̃Ng擾
  rect   = p_pane->GetPaneRect();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief K̈ʒuݒ肷
 *
 * @param pos ݒ肷K̈ʒui[JWj
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetTailPos( gfl::math::VEC3 pos )
{
  const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;

  if( p_base->tail_pane != PANE_NONE)
  {
    gfl::grp::g2d::LytPane* p_pane = mp_lyt_wk->GetPane( p_base->tail_pane );
    p_pane->SetTranslate( pos );
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief K̈ʒu擾
 *
 * @param pos K̈ʒui[JWł͂܂j
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::GetTailPos( gfl::math::VEC3& pos )
{
  const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;
  if( p_base->tail_pane != PANE_NONE)
  {
    gfl::grp::g2d::LytPane* p_pane_top = mp_lyt_wk->GetPane( p_base->top_pane );
    gfl::grp::g2d::LytPane* p_pane_tail = mp_lyt_wk->GetPane( p_base->tail_pane );
    gfl::math::VEC3 top_pos   = p_pane_top->GetTranslate();
    gfl::math::VEC3 tail_pos  = p_pane_tail->GetTranslate();

    // Zbg
    pos = top_pos + tail_pos;
  }
  else
  {
    // @todo mȋmF
    // WZbg
    gfl::grp::g2d::LytPane* p_pane_top = mp_lyt_wk->GetPane( p_base->top_pane );
    pos   = p_pane_top->GetTranslate();
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief K̉]ݒ肷iZɉ]j
 *
 * @param z_rotate  ]pxidegj
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetTailRotate( f32 z_rotate )
{
  gfl::math::VEC3 rot_vec = gfl::math::VEC3(0,0,0);
  const WINDOW_PANE_DATA* p_base = WindowDataTable[m_win_type].p_pane_data;

  if( p_base->tail_pane != PANE_NONE)
  {
    gfl::grp::g2d::LytPane* p_pane_tail = mp_lyt_wk->GetPane( p_base->tail_pane );

    // Z𒆐Sɉ]
    rot_vec.z = z_rotate;
    p_pane_tail->SetRotate( rot_vec );
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief vCIeB[ݒ肷
 *
 * @param priority  ݒ肷vCIeB[
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetPriority( u16 priority )
{
  if( mp_lyt_wk )
  {
    mp_lyt_wk->SetPriority( priority );
  }
  GFL_ASSERT( mp_lyt_wk );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief tHg̔{ݒ肷
 *
 * @param scale ݒ肷XP[
 */
/* -------------------------------------------------------------------------*/
void TalkWindowGra::SetFontScale( f32 scale )
{
  if( mp_lyt_wk )
  {
    // ʒu͏ɒSA͍폜
    nw::lyt::Size size;
    gfl::grp::g2d::LytTextBox* p_str_pane;
    
    // tHgTCYݒ肷
    size.width  = FONT_DEFAULT_SIZE_X * scale;
    size.height = FONT_DEFAULT_SIZE_Y * scale;
    
    // P
    p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(true) );
    p_str_pane->SetFontSize( size );

    // Q
    p_str_pane = mp_lyt_wk->GetTextBoxPane( GetTextBoxPaneIdx(false) );
    p_str_pane->SetFontSize( size );

  }
  GFL_ASSERT( mp_lyt_wk );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhE^CvƂ̃C擾
 *
 * @param win_type EBhE^Cv
 *
 * @return C
 */
/* -------------------------------------------------------------------------*/
u8 TalkWindowGra::GetLineNum( u16 win_type )
{
  return WindowDataTable[win_type].line_num;
}

}		// tool
}		// app
