#if !defined( __APP_TOOL_TALKWINDOWGRA_H__ )
#define __APP_TOOL_TALKWINDOWGRA_H__
//============================================================================================
/**
 * @file		app_tool_TalkWindowGra.h
 * @brief		bEBhẼCAEg\[X
 * @author	Hiroyuki Nakamura -> Onoue Masayuki
 * @date		12.04.17
 *
 * namespace	app::tool::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include <app/tool/app_tool_TalkWindow_type.h>

namespace app {
namespace tool {

class TalkWindowGra {
public:
     
  //---------------------------
  /// J[萔
  typedef enum {
    WIN_COLLAR_TYPE_DEFAULT = 0,
    WIN_COLLAR_TYPE_HERO,
    WIN_COLLAR_TYPE_FRIEND1,
    WIN_COLLAR_TYPE_FRIEND2,
    WIN_COLLAR_TYPE_FRIEND3,
    WIN_COLLAR_TYPE_HAKASE,
    WIN_COLLAR_TYPE_CHAMPION,
    WIN_COLLAR_TYPE_MYSTERYM,
    WIN_COLLAR_TYPE_FLARE_BOSS,
    WIN_COLLAR_TYPE_MAX,
  }WIN_COLLAR_TYPE;

private:
  
  //---------------------------
  /// NX萔
  enum {
    PANE_INIT_NUM   = 1000,   ///< Sm[hƂ́Aő吔
    FRAME_IN_FRAME  = 10,     ///< t[INAj[Ṽt[
    FRAME_OUT_FRAME = 10,     ///< t[OUTAj[Ṽt[
    BIND_ANM_ID     = 0,      ///< oChAj[VID(TalkWindowGrał͏ɌŒ)
    OKURI_X_OFS     = -15,    ///< J[\̃ItZbgX
    OKURI_Y_OFS     = 15,     ///< J[\̃ItZbgY
    UP_WIN_SIZE_X   = 400,    ///< ʂ̕
    UP_WIN_SIZE_Y   = 240,    ///< ʂ̍
    FONT_DEFAULT_SIZE_X   = 16,   ///< tHgTCYX
    FONT_DEFAULT_SIZE_Y   = 19,   ///< tHgTCYX
	};

public:

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 */
	//--------------------------------------------------------------------------------------------
	TalkWindowGra(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	virtual ~TalkWindowGra();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[Xǂݍ
	 *
	 * @param		lytsys				CAEgVXe
	 * @param		heap					q[v
	 * @param		devAllocator	foCXq[vAP[^
	 * @param		trans					eNX`]tO true = ]@ftHg = true
	 *
	 * @return	CAEg\[XID
	 *
	 * @li	σEBhEƓ̂[hĂ̂ŁA[hĂꍇ͕sv
	 */
	//--------------------------------------------------------------------------------------------
	static gfl::grp::g2d::LytResID LoadLayoutResource(
																	gfl::grp::g2d::LytSys * lytsys,
																	gfl::heap::HeapBase * heap,
																	gfl::heap::NwAllocator * devAllocator,
																	bool trans = true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		lytsys				CAEgVXe
	 * @param		setup					CAEg[ÑZbgAbvf[^
	 * @param		res_id				CAEg\[XID
	 * @param		type					EBhE^Cv@TYPE_TALK_**
   * @param   device_allocator Õgpꍇ͎w肷
	 *
	 * @return	CAEg[N
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytWk * CreateLayoutWork(
													gfl::grp::g2d::LytSys * lytsys,
													const gfl::grp::g2d::LytWkSetUp * setup,
													gfl::grp::g2d::LytResID res_id, u32 type,
                          gfl::heap::NwAllocator* device_allocator = NULL );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutWork(void);

  //----------------------------------------------------------------------------
  /**
   *	@brief  XVs(Aj[V̍Đs܂)
   */
  //-----------------------------------------------------------------------------
  void Update( void );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Wݒ
	 *
	 * @param		pos		      W
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
  void SetWindowPos( const gfl::math::VEC3 &pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ŒʒuɃEBhEzu
	 *
	 * @param		pos		ʒu@WIN_PUT_UPPER_** or WIN_PUT_LOWER_**
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetWindowPosEz( u32 pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J[\̔zuʒu擾
	 *
	 * @param		none
	 *
	 * @return	zuʒu
	 */
	//--------------------------------------------------------------------------------------------
	gfl::math::VEC3 GetCursorPos(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhE\؂ւ
	 *
	 * @param		flg		true = \, false = \
	 *
	 * @return	none
	 *
	 * @li	K͕\Ȃ
	 */
	//--------------------------------------------------------------------------------------------
	void SetVisible( bool flg );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief KOFFɂ
   */
  /* -------------------------------------------------------------------------*/
  void SetTailOff(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief KONɂ
   */
  /* -------------------------------------------------------------------------*/
  void SetTailOn(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		K\
	 *
	 * @param		put_type	\^Cv@TAIL_PUT_UPPER_** or TAIL_PUT_LOWER_**
	 * @param		pos				\ʒu@0()`199(Ej
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetTailPut( u32 put_type, u32 pos );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief   eLXg{bNXyCCfbNX擾
   *
   * @return yCCfbNX
   */
  /* -------------------------------------------------------------------------*/
	gfl::grp::g2d::LytTextBox * GetTextBoxPane(void);
  
  /* -------------------------------------------------------------------------*/
  /**
   * @brief   eLXg{bNXyCINDEX擾
   *
   * @param   is_line_up  true = 1s,false = 2s
   *
   * @return  yCCfbNX
   */
  /* -------------------------------------------------------------------------*/
  gfl::grp::g2d::LytPaneIndex GetTextBoxPaneIdx( bool is_line_up );

  //----------------------------------------------------------------------------
  /**
   *	@brief  t[INAOUTAjĐiJ[̔fsj
   *
   *	@param	is_in true̎INAj,false̎OUTAj
   *
   *	@retval false̎t[Aj[V݂Ȃ
   */
  //-----------------------------------------------------------------------------
  bool SetFrameInOutAnm( bool is_in );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief Aj[V̏I҂ԂmF
   *
   * @return true̎Aj[VI
   */
  /* -------------------------------------------------------------------------*/
  bool IsPlayAnime( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief EBhETCYύXiσEBhÊ݂ɑΉj
   *
   * @param size  EBhETCY
   */
  /* -------------------------------------------------------------------------*/
  void SetWindowSize( const nw::lyt::Size& size );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief ɍ킹ăEBhETCYgk
   *
   * @param str_width   
   * @param str_height  
   * @param line_num    C
   */
  /* -------------------------------------------------------------------------*/
  void SetWinsizeFitStrWidth( int str_width ,int str_height ,int line_num );
 
  /* -------------------------------------------------------------------------*/
  /**
   * @brief ʒũZ^OJn
   */
  /* -------------------------------------------------------------------------*/
  void StartTextPosCenter( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief ʒu␳̃Zbg
   */
  /* -------------------------------------------------------------------------*/
  void ResetTextPos( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief EBhE^Cv
   *
   * @param win_type  EBhE^Cv
   */
  /* -------------------------------------------------------------------------*/
  void SetWindowType( u16 win_type );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief Fݒ肷
   *
   * @param collar  ZbgF
   */
  /* -------------------------------------------------------------------------*/
  void SetColor( app::tool::TalkWindowGra::WIN_COLLAR_TYPE collar );
 
  /* -------------------------------------------------------------------------*/
  /**
   * @brief EBhẼZ^[ʒu擾
   *
   * @param center_pos  擾W̊i[
   */
  /* -------------------------------------------------------------------------*/
  void GetWinCenterPos( gfl::math::VEC3& center_pos );
 
  /* -------------------------------------------------------------------------*/
  /**
   * @brief EBhẼNg
   *
   * @param rect  擾Ng̊i[
   */
  /* -------------------------------------------------------------------------*/
  void GetWinRect( nw::ut::Rect &rect );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief KړpNg̎擾
   *
   * @param rect  擾Ng̊i[
   */
  /* -------------------------------------------------------------------------*/
  void GetTailRect( nw::ut::Rect &rect );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief K̈ʒuݒ肷
   *
   * @param pos ݒ肷K̈ʒu
   */
  /* -------------------------------------------------------------------------*/
  void SetTailPos( gfl::math::VEC3 pos );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief K̈ʒu擾
   *
   * @param pos K̈ʒui[JWł͂܂j
   */
  /* -------------------------------------------------------------------------*/
  void GetTailPos( gfl::math::VEC3& pos );
  
  /* -------------------------------------------------------------------------*/
  /**
   * @brief K̉]ݒ肷iZɉ]j
   *
   * @param z_rotate
   */
  /* -------------------------------------------------------------------------*/
  void SetTailRotate( f32 z_rotate );

   /* -------------------------------------------------------------------------*/
   /**
    * @brief gbvyCg̕\Ԃ擾
    *
    * @return truêƂ\
    */
   /* -------------------------------------------------------------------------*/
   bool GetVisible( void );
   
   /* -------------------------------------------------------------------------*/
   /**
    * @brief vCIeB[ݒ肷
    *
    * @param priority  ݒ肷vCIeB[
    */
   /* -------------------------------------------------------------------------*/
   void SetPriority( u16 priority );

   /* -------------------------------------------------------------------------*/
   /**
    * @brief Ww肷iʊOɃEBhEʊOɍsꍇ͈ʒu␳)
    *
    * @param pos W
    */
   /* -------------------------------------------------------------------------*/
   void SetWindowPosFix( gfl::math::VEC3 pos );

   /* -------------------------------------------------------------------------*/
   /**
    * @brief tHg̔{ݒ肷
    *
    * @param scale ݒ肷XP[
    */
   /* -------------------------------------------------------------------------*/
   void SetFontScale( f32 scale );

   /* -------------------------------------------------------------------------*/
   /**
    * @brief ftHg̃EBhETCYݒ肷
    *
    * @param line_num  C
    */
   /* -------------------------------------------------------------------------*/
   void SetDefaultWindowSize( int line_num );

   /* -------------------------------------------------------------------------*/
   /**
    * @brief EBhE^CvƂ̃C擾
    *
    * @param win_type EBhE^Cv
    *
    * @return C
    */
   /* -------------------------------------------------------------------------*/
   u8 GetLineNum( u16 win_type );

private:

  //----------------------------------------------------------------------------
  /**
   *	@brief  wID̃rWreB[𑀍삷
   *
   *	@param	id  yCID
   *	@param	flg true = \@false = \
   */
  //-----------------------------------------------------------------------------
  void SetVisible( u32 id, bool flg );

  //----------------------------------------------------------------------------
  /**
   *	@brief  Aj[Vt[ݒ肷
   *
   *	@param	set_frm Zbgt[
   *	@param	is_auto_anm true̎Aj[V
   */
  //-----------------------------------------------------------------------------
  void SetAnime( u32 set_frm ,bool is_auto_anm );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief eLXg{bNXyC̃ItZbgݒ肷
   */
  /* -------------------------------------------------------------------------*/
  void SetStrWinPosOffset( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief yC̐eq֌W݂̌̃EBhE^Cvɍ킹čĐݒ肷
   */
  /* -------------------------------------------------------------------------*/
  void SetStrWinParent( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief eLXg{bNXEBhEɍ킹Ċgk
   *
   * @param line      C
   */
  /* -------------------------------------------------------------------------*/
  void FitTextWinSize( void );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief EBhE
   */
  /* -------------------------------------------------------------------------*/
  void ResetWindowStatus( u16 win_type );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief K̕vZ
   */
  /* -------------------------------------------------------------------------*/
  void RefreshTailDir( void );

private:
	gfl::grp::g2d::LytSys     *mp_lyt_sys;    ///< CAEgVXe
	gfl::grp::g2d::LytWk      *mp_lyt_wk;     ///< CAEgVXe[N
	gfl::grp::g2d::LytResID	  m_lyt_res_id;   ///< \[XID
  gfl::math::VEC3           m_str_win_ofs;  ///< EBhẼItZbg

	u16	m_win_type;       ///< EBhE^Cv
  u16 m_collar_id;      ///< J[ID
  u16 m_anm_end_frm;    ///< Aj[VIt[
  bool m_is_play_anime; ///< Aj[VĐĂ邩
	int  m_line_num;      ///< 

};


}		// tool
}		// app
#endif // __APP_TOOL_TALKWINDOWGRA_H__
