#if PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PlayerIconTexTest.cpp
 *	@brief  PlayerIconTexManager̃eXg
 *	@author	Koji Kawada
 *	@date		2012.06.14
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "system/main.h"           // HEAP_DEFINE
#include "gamesystem/GameProc.h"
#include "common_res/PlayerIconTexManager.h"  // ꂾǂݍ߂PlayerIconTexg܂

// dress_up
#include "system/dress_up/DressUpInclude.h"  // ꂾǂݍ߂ΑSĂ̌JւIuWFNgɃANZXł܂

// test/kawada
#include "PlayerIconTexTest.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/hero_icon_test.gaix"


namespace test {
namespace kawada {
namespace hero_icon_test {


// lyt
#include "hero_icon_test_header/hero_icon_test_lyt.h"
#include "hero_icon_test_header/hero_icon_test_lyt_pane.h"



//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result PlayerIconTexTestProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  // Y`FbN
  DumpMemory("[Start]");

  // JEg
  m_wait_count = 0;

  // 
  {
    gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
    gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

    GFL_PRINT("heap_memory   GetTotalAllocatableSize=%d\n", heap_memory->GetTotalAllocatableSize());
    GFL_PRINT("device_memory GetTotalAllocatableSize=%d\n", device_memory->GetTotalAllocatableSize());
   
    // 
    m_heap_memory   = GFL_CREATE_HEAP(
        heap_memory,   HEAPID_TEST_KAWADA_HEAP,   heap_memory->GetTotalAllocatableSize(),   gfl::heap::HEAP_TYPE_EXP, false );
    m_device_memory = GFL_CREATE_HEAP(
        device_memory, HEAPID_TEST_KAWADA_DEVICE, device_memory->GetTotalAllocatableSize(), gfl::heap::HEAP_TYPE_EXP, false );

    // AP[^
    m_heap_allocator   = GFL_NEW(m_heap_memory)   gfl::heap::NwAllocator(m_heap_memory);
    m_device_allocator = GFL_NEW(m_device_memory) gfl::heap::NwAllocator(m_device_memory);
  }

  // ui
  m_device_manager = GFL_NEW(m_heap_memory) gfl::ui::CTR_DeviceManager(m_heap_memory);

  // OtBbNXVXe
  gfl::grp::GraphicsSystemSetUp setup = gfl::grp::GraphicsSystemSetupDefault;
  setup.buffer_mode = gfl::grp::MODE_SINGLE_BUFFER;  // obt@O[h
  setup.stereoOn = true;  // ̎On
  m_graphics_system = GFL_NEW(m_heap_memory) gfl::grp::GraphicsSystem( m_heap_allocator, m_device_allocator, &setup );

  // DrawUtil 
  gfl::grp::util::DrawUtil::Initialize( m_graphics_system, m_heap_allocator, m_device_allocator );

  // grp::util
  {
    nn::fs::FileReader	file;
  	nn::fs::FileWriter	wfile;
  	size_t				fileSize;
  	
    file.Initialize( L"rom:/ishiguro/ShaderTest/HgpPop.bcfnt" );
    
    fileSize = file.GetSize();
    m_bcFontBuffer = m_device_allocator->Alloc(fileSize, 128);
    file.Read( m_bcFontBuffer, fileSize );
    file.Finalize();

    //ʏōs܂̂GraphcsSystemʉĂAriizumi11/06/02
    gfl::grp::util::DrawUtil::SetFontResource( m_bcFontBuffer );
  }

  // lyt
  {
    // VXe
    static const gfl::grp::g2d::LytSysSetUp lyt_sys_setup =
    {
      1,  // Ǘ\[Xő吔
      1   // ǗLytWkő吔
    };
    m_lyt_sys = GFL_NEW(m_heap_memory) gfl::grp::g2d::LytSys(
      &lyt_sys_setup,
      m_heap_allocator,
      m_device_allocator
    );

    // t@C
    m_lyt_file = GFL_NEW(m_heap_memory) gfl::fs::ArcFile( m_heap_memory, ARCID_HERO_ICON_TEST, gfl::fs::ArcFile::OPEN );
    
    // \[X
    m_lyt_res_id = m_lyt_sys->LoadLytRes( m_device_allocator, m_lyt_file, GARC_hero_icon_test_hero_icon_test_lyt_LYTDAT );
    m_lyt_sys->TransferAllTexture( m_lyt_res_id, gfl::grp::MEMORY_AREA_FCRAM );

    // [N
    static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup =
    {
      gfl::math::VEC3(0,0,0),     // pos 
      gfl::math::VEC2(1,1),       // scale
      gfl::math::VEC3(0,0,0),     // rotate
      0,                          // priority
    };
    m_lyt_wk = m_lyt_sys->CreateLytWk(
      m_lyt_res_id,                                    // CAEg\[XID
      LYTRES_HERO_ICON_TEST_LYT_HERO_ICON_TEST_BCLYT,  // resID̃CAEgf[^ID
      NULL,                                            // Aj[Vf[^IDe[u      AĵȂꍇNULL
      0,                                               // Aj[Vf[^IDe[u    AĵȂꍇ0
      0,                                               // o^Aj[Vő吔ij  // ijanmMax = o^Aj[Vő吔ɂ
      &lyt_wk_setup,                                   // CAEg[N{
      false                                            // Aj[ṼoChsB
    );
  }

  // t@C[h}l[W
  {
    m_file_read_manager = GFL_NEW(m_heap_memory) gfl::fs::FileReadManager(
      m_heap_memory,
      ARCID_TABLE_MAX,
      ARCID_TABLE_MAX,
      5,
      gfl::base::Thread::DefaultPriority + 1
    );
  }

  // PlayerIconTexManager
  {
    m_destroy_flag = false;
    m_PlayerIconTex = NULL;

    m_PlayerIconTexManager = GFL_NEW(m_heap_memory) common::resource::PlayerIconTexManager(
        m_file_read_manager, m_heap_memory, 7*3*3, 0  // 7ACR*3*3, Xi[Ȃ
    );
  }

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result PlayerIconTexTestProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  // t@C[h}l[W
  m_file_read_manager->UpdateFileRead();

  // PlayerIconTexManager
  m_PlayerIconTexManager->Update();

  do
  {
    gfl::ui::Button*       button    = m_device_manager->GetButton(0);
    gfl::ui::VectorDevice* cross_key = m_device_manager->GetCrossKey(0);
    gfl::ui::VectorDevice* stick     = m_device_manager->GetStick(0);
    
    // ui
    m_device_manager->Main();

    // JEg
    ++m_wait_count;

    if( !m_destroy_flag )
    {
      if( button->IsTrigger( gfl::ui::BUTTON_Y ) )
      {
        if( !m_PlayerIconTex )
        {
          // PlayerIconTex
          common::resource::PlayerIconTexManager::IconParam param;
              param.fix_id = xy_system::player_icon::TR_ICON_ID_0001,
              param.fashion_buffer = &(GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetGameData()->GetPlayerStatus()->GetDressUpData());
          
          common::resource::PlayerIconTexManager::IconDesc desc;
              desc.replace_info_num_max = 1;
         
          // ACRNGXg
          m_PlayerIconTex = m_PlayerIconTexManager->RequestCreatePlayerIconTex(
              m_heap_memory,
              m_device_memory,
              m_heap_memory->GetLowerHandle(),  // ꎞ
              m_device_memory->GetLowerHandle(),  // ꎞ
              param,
              desc
          );

          common::resource::PlayerIconTex::ReplaceInfo info;
              info.replace_mode = common::resource::PlayerIconTex::REPLACE_MODE_SOON;
              info.pane         = m_lyt_wk->GetPicturePane(PANENAME_HERO_ICON_TEST_PANE_PLAYER_ICON_00);
              info.material     = 0;
              info.texture      = 0;
          if( button->IsHold( gfl::ui::BUTTON_R ) ) info.replace_mode = common::resource::PlayerIconTex::REPLACE_MODE_VISIBLE;
          
          // CAEg̃yC̃eNX`u
          m_PlayerIconTex->AddReplaceInfo(
              info
          );
        }
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_X ) )
      {
        if( m_PlayerIconTex )
        {
          // PlayerIconTexĵP
          if( m_PlayerIconTexManager->IsAbleToDestroyIcon(m_PlayerIconTex) )  // jł邩ǂmF
          {
            // _uobt@ŕ`𑱂̂ŁAACR̕`~߂
            m_lyt_wk->GetPicturePane(PANENAME_HERO_ICON_TEST_PANE_PLAYER_ICON_00)->SetVisible(false);
            m_destroy_flag = true;  // j
          }
        }
      }
    }
    else
    {
      // PlayerIconTexĵQ
      {
        // ACRj
        m_PlayerIconTexManager->DestroyIcon(m_PlayerIconTex, true, 0);  // `𑱂̂ŁAtrueŌɖ߂B
        m_PlayerIconTex = NULL;
        // ACR̕`߂
        m_lyt_wk->GetPicturePane(PANENAME_HERO_ICON_TEST_PANE_PLAYER_ICON_00)->SetVisible(true);
        m_destroy_flag = false;  // jI
      }
    }

    // lyt
    m_lyt_sys->UpdateAll();

    // `
    m_graphics_system->StartRendering();

    gfl::grp::RenderTarget* lower_render_target       = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_LOWER ) );
    gfl::grp::RenderTarget* upper_render_target       = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    gfl::grp::RenderTarget* upper_right_render_target = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER_RIGHT ) );

    // ̊ȈՕ`
    {
      m_graphics_system->BindCurrentCommandList( lower_render_target );

      gfl::grp::util::DrawUtil::BeginRender( lower_render_target );

      gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
      gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );   // オ(0, 0)
 
      //s32 text_x_pos = 4;
      s32 text_y_pos = 4;
      const s32 text_y_pos_add = 12;
 
      const s32 text_x_pos_page = 16;

      {
        gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_page, text_y_pos, L"[vC[ACR]" );
        text_y_pos += text_y_pos_add;
      }

      gfl::grp::util::DrawUtil::EndRender();
    } 

    // lyt
    {
      m_lyt_sys->DrawAll( m_graphics_system, gfl::grp::DISPLAY_UPPER, upper_render_target, upper_right_render_target );
      m_lyt_sys->DrawAll( m_graphics_system, gfl::grp::DISPLAY_LOWER, lower_render_target );
    } 

    m_graphics_system->EndRendering();

    // `XV
    m_graphics_system->SwapBuffer();

    gfl::grp::GraphicsSystem::WaitVSync(gfl::grp::DISPLAY_BOTH_MAX);
   
    // obt@Xbv
    m_graphics_system->VSyncAfter();

    // ui
    if( button->IsTrigger( gfl::ui::BUTTON_B ) )
    {
      break;
    }
  
    return gfl::proc::RES_CONTINUE;
  }
  while(0);

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result PlayerIconTexTestProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  // PlayerIconTexManager
  if( m_PlayerIconTexManager->IsAbleToDestroy() )  // jł邩ǂmF
  {
    if( m_PlayerIconTex )
    {
      if( m_PlayerIconTexManager->IsAbleToDestroyIcon(m_PlayerIconTex) )  // jł邩ǂmF
      {
        m_PlayerIconTexManager->DestroyIcon(m_PlayerIconTex, false, 0);  // `𑱂Ȃ̂ŁAfalseŌɖ߂ȂB
      }
      else
      {
        GFL_ASSERT(0);
      }
    }
    GFL_DELETE m_PlayerIconTexManager;
  }
  else
  {
    GFL_ASSERT(0);
  }

  // t@C[h}l[W
  GFL_DELETE m_file_read_manager;

  // lyt
  {
    if( m_lyt_wk )
    {
      // [N
      m_lyt_sys->RemoveLytWk( m_lyt_wk );
      m_lyt_wk = NULL;
    }

    // \[X
    m_lyt_sys->ReleaseLytRes( m_lyt_res_id );
    m_lyt_res_id = 0;  // 0ł낤

    if( m_lyt_file )
    {
      // t@C
      GFL_DELETE m_lyt_file;
      m_lyt_file = NULL;
    }

    // VXe
    if( m_lyt_sys )
    {
      GFL_DELETE m_lyt_sys;
      m_lyt_sys = NULL;
    }
  }

  // grp::util
  {
    m_device_allocator->Free(m_bcFontBuffer);
  }

  // DrawUtil 
  gfl::grp::util::DrawUtil::Terminate();

  // OtBbNXVXe
  GFL_DELETE m_graphics_system;

  // ui
  GFL_DELETE m_device_manager;

  // 
  {
    // AP[^
    GFL_DELETE  m_device_allocator;
    GFL_DELETE  m_heap_allocator;
    // 
    gfl::heap::Manager::DeleteHeap(m_device_memory);
    gfl::heap::Manager::DeleteHeap(m_heap_memory);
  }

  // Y`FbN
  DumpMemory("[End]");

  return gfl::proc::RES_FINISH;
}

// Y`FbN
void PlayerIconTexTestProc::DumpMemory(const char* message)  // s͂Ȃł
{
  // 
  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  // Y`FbN
  GFL_PRINT("%s\n", message);
  GFL_PRINT("heap_memory\n");
  heap_memory->Dump();
  GFL_PRINT("\n");
  GFL_PRINT("device_memory\n");
  device_memory->Dump();
  GFL_PRINT("\n");
}


}  // namespace hero_icon_test
}  // namespace kawada
}  // namespace test

#endif // PM_DEBUG

