//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PlayerIconTexManager.cpp
 *	@brief  CAEg̃eNX`vC[ACR}l[W
 *	@author	Koji Kawada
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// kujira
#include "system/player_icon/PlayerFixIconID.h"
#include "system/player_icon/PlayerIconManager.h"
#include "common_res/PlayerIconTexManager.h"
#include "common_res/PlayerIconTex.h"


namespace common {
namespace resource {


  //-----------------------------------------------------------------------------
  /*
   *  @brief      RXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerIconTexManager::PlayerIconTexManager(
      gfl::fs::FileReadManager* file_read_manager,
      gfl::heap::HeapBase* heap_memory,
      s32 req_num_max,
      s32 listener_num_max
  )
    : m_manager(NULL),
      m_elem_head(NULL),
      m_elem_tail(NULL)
  {
    m_manager = GFL_NEW(heap_memory) xy_system::player_icon::PlayerIconManager;
    b32 ret = m_manager->Create(file_read_manager, heap_memory, req_num_max, listener_num_max);
    if( !ret )
    {
      GFL_ASSERT_MSG(0, "xy_system::player_icon::PlayerIconManagerł܂łB\n");
      GFL_DELETE m_manager;
      m_manager = NULL;
    }
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      fXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerIconTexManager::~PlayerIconTexManager()
  {
    if( IsAbleToDestroy() )
    {
      Element* elem = m_elem_head;
      while(elem)
      {
        Element* next_elem = elem->next;
        GFL_DELETE elem;
        elem = next_elem;
      }

      if( m_manager )
      {
        GFL_DELETE m_manager;
      }
    }
    else
    {
      GFL_ASSERT_MSG(0, "jł܂Bjł悤ɂȂ܂ő҂ĉB\n");
    }
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      jł邩ǂmF
   */
  //-----------------------------------------------------------------------------
  b32 PlayerIconTexManager::IsAbleToDestroy(void)
  {
    if( m_manager )
    {
      return m_manager->IsAbleToDestroy();
    }
    return true;
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      XV
   */
  //-----------------------------------------------------------------------------
  void PlayerIconTexManager::Update(void)
  {
    if( m_manager )
    {
      m_manager->Update();

      // ACRXV
      Element* elem = m_elem_head;
      while(elem)
      {
        Element* next_elem = elem->next;
        b32 ret = updateCreatePlayerIconTex(elem->icon);
        if( ret )
        {
          // ǗKvȂ̂ŁAXg͂ĂB
          Element* prev_elem = elem->prev;
          GFL_DELETE elem;

          if(prev_elem) prev_elem->next = next_elem;
          else          m_elem_head = next_elem;
          
          if(next_elem) next_elem->prev = prev_elem;
          else          m_elem_tail = prev_elem;
        }
        elem = next_elem;
      }
    }
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      ACRNGXg
   */
  //-----------------------------------------------------------------------------
  PlayerIconTex* PlayerIconTexManager::RequestCreatePlayerIconTex(
    gfl::heap::HeapBase* tex_heap_memory,
    gfl::heap::HeapBase* tex_device_memory,
    gfl::heap::HeapBase* heap_memory,
    gfl::heap::HeapBase* device_memory,
    const IconParam& icon_param,
    const IconDesc&  icon_desc
  )
  {
    PlayerIconTex* icon = NULL;
    if( m_manager )
    {
      icon = GFL_NEW(tex_heap_memory) PlayerIconTex(
          tex_heap_memory,
          tex_device_memory,
          icon_desc.replace_info_num_max
      );
     
      s32 req_id = requestCreatePlayerIcon(
        heap_memory,
        device_memory,
        icon->GetImageAddress(),
        icon_param
      );

      if( req_id != xy_system::player_icon::PlayerIconManager::REQ_ID_NONE )
      {
        icon->SetReqId(req_id);
      }
      else
      {
        GFL_ASSERT_MSG(0, "NGXgsB\n");
        GFL_DELETE icon;
        icon = NULL;
      }
    }

    if( icon )
    {
      b32 ret_add = addPlayerIconTex(heap_memory, icon);
      GFL_ASSERT_MSG(ret_add, "\ʃG[łB\n");
      // NGXg̍XV
      Update();
    }
    return icon;
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      ς݂̃obt@gpACRNGXg
   */
  //-----------------------------------------------------------------------------
  PlayerIconTex* PlayerIconTexManager::RequestRecreatePlayerIconTex(
    PlayerIconTex* icon,
    b32            clear_flag,
    b32            original_flag,
    gfl::heap::HeapBase* heap_memory,
    gfl::heap::HeapBase* device_memory,
    const IconParam& icon_param
  )
  {
    PlayerIconTex* ret_icon = NULL;
    if( m_manager )
    {
      if( icon->IsCreated() )
      {
        if(clear_flag)
        {
          if( original_flag )
          {
            icon->ResetOriginal();
          }
          icon->ClearInfo();
        }
        icon->ClearImage();
     
        s32 req_id = requestCreatePlayerIcon(
          heap_memory,
          device_memory,
          icon->GetImageAddress(),
          icon_param
        );
     
        if( req_id != xy_system::player_icon::PlayerIconManager::REQ_ID_NONE )
        {
          icon->SetReqId(req_id);
          ret_icon = icon;
        }
        else
        {
          GFL_ASSERT_MSG(0, "NGXgsB\n");
        }
      }
      else
      {
        GFL_ASSERT_MSG(0, "icon܂rȂ̂ŃNGXgɎs܂B\n");
      }
    }

    if( ret_icon )
    {
      b32 ret_add = addPlayerIconTex(heap_memory, ret_icon);
      GFL_ASSERT_MSG(ret_add, "\ʃG[łB\n");
      // NGXg̍XV
      Update();
    } 
    return ret_icon;
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      ACRLZNGXg
   */
  //-----------------------------------------------------------------------------
  void PlayerIconTexManager::RequestCancelCreateIcon(
    PlayerIconTex* icon
  )
  {
    if( m_manager )
    {
      m_manager->RequestCancelCreateIcon(
        icon->GetReqId()
      );
      icon->FinishCancelCreate();
      // NGXg̍XV
      Update();
    }
  }

  //-----------------------------------------------------------------------------
  /*
   *  @brief      ACR
   */
  //-----------------------------------------------------------------------------
  b32 PlayerIconTexManager::IsIconCreated(
    PlayerIconTex* icon
  )
  {
    return icon->IsCreated();
  }

  //-----------------------------------------------------------------------------
  /**
   *   @brief  ACRjł邩
   */
  //-----------------------------------------------------------------------------
  b32 PlayerIconTexManager::IsAbleToDestroyIcon(PlayerIconTex* icon)
  {
    return icon->IsAbleToDestroy();
  }
 
  //-----------------------------------------------------------------------------
  /**
   *   @brief  ACR̔j
   */
  //-----------------------------------------------------------------------------
  b32 PlayerIconTexManager::DestroyIcon(
      PlayerIconTex* icon,
      b32            original_flag,
      s32            wait
  )
  {
    GFL_ASSERT_MSG(wait==0,"waitΉłB\n");wait=0;//ΉꍇUpdate֐O猩̂ƒ猩̂ɋ@\悤I

    b32 ret = false;
    if( IsAbleToDestroyIcon(icon) )
    {
      if(original_flag)
      {
        icon->ResetOriginal();
      }
      GFL_DELETE icon;
      ret = true;
    }
    else
    {
      GFL_ASSERT_MSG(0, "jł܂Bjł悤ɂȂ܂ő҂ĉB\n");
    }
    return ret;
  }


  // @brief  ACRNGXg
  s32 PlayerIconTexManager::requestCreatePlayerIcon(
    gfl::heap::HeapBase* heap_memory,
    gfl::heap::HeapBase* device_memory,
    void* image_address,
    const IconParam& icon_param
  )
  {
    s32 req_id = xy_system::player_icon::PlayerIconManager::REQ_ID_NONE;
    switch(icon_param.fix_id)
    {
    case xy_system::player_icon::TR_ICON_ID_0001:
    case xy_system::player_icon::TR_ICON_ID_0002:
      {
        // lAl
        req_id = m_manager->RequestCreateHeroIcon(heap_memory, device_memory, image_address, *(icon_param.fashion_buffer));
        break;
      }
    case xy_system::player_icon::FIX_ICON_PIC_ID:
      {
        // ʐ^ACR
        break;
      }
    defalut:
      {
        // NPCg[i[ACRACxgACR
        req_id = m_manager->RequestCreateFixIcon(heap_memory, device_memory, image_address, icon_param.fix_id);
        break;
      }
    }
    return req_id;
  }

  // @brief  ACRXV
  b32 PlayerIconTexManager::updateCreatePlayerIconTex(
    PlayerIconTex* icon
  )
  {
    b32 ret = false;

    do
    {
      //if( IsIconCreated(icon) )  // IsAbleToDestroyIconł܂Ȃ̂ŃRgAEgB
      //{
      //  ret = true;
      //  break;
      //}

      if( IsAbleToDestroyIcon(icon) )  // IsAbleToDestroyIcontrueȂIsIconCreatedtrueȂ̂ŁA炾̔ōςށB
      {
        ret = true;
        break;
      }

      if( m_manager )
      {
        if( m_manager->IsIconCreated(icon->GetReqId()) )
        {
          icon->FinishCreate();
          ret = true;
          break;
        }
      }
    }
    while(0);

    return ret;
  }

  // @brief  ACRXg̖ɒǉ
  b32 PlayerIconTexManager::addPlayerIconTex(
    gfl::heap::HeapBase* heap_memory,
    PlayerIconTex* icon
  )
  {
    Element* elem = GFL_NEW(heap_memory) Element;
    elem->icon = icon;
    
    if( m_elem_tail )
    {
      // vf1͂
      m_elem_tail->next = elem;
      elem->prev = m_elem_tail;
      m_elem_tail = elem;
    }
    else
    {
      // vf1Ȃ
      m_elem_head = elem;
      m_elem_tail = elem;
    }

    return true;
  }


} // namespace resource
} // namespace common

