//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PlayerIconTex.h
 *	@brief  CAEg̃eNX`vC[ACR
 *	@author	Koji Kawada
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// kujira
#include "system/player_icon/PlayerFixIconID.h"
#include "system/player_icon/PlayerIconManager.h"
#include "common_res/PlayerIconTexManager.h"
#include "common_res/PlayerIconTex.h"


namespace common {
namespace resource {

  //-----------------------------------------------------------------------------
  // @brief  uݒ肷yC̏ǉ
  //-----------------------------------------------------------------------------
  b32 PlayerIconTex::AddReplaceInfo(
    const ReplaceInfo& replace_info
  )
  {
    b32 ret = false;

    if( 
           replace_info.material<=TYPE_MAX_OF_MATERIAL
        && replace_info.texture<=TYPE_MAX_OF_TEXTURE
    )
    {
      if( m_total_info_num < m_replace_info_num_max )
      {
        u8 i = 0;
        for(i=0; i<m_replace_info_num_max; ++i)
        {
          if( m_total_info[i].replace_info.replace_mode == REPLACE_MODE_NONE )  // 󂫔
          {
            {
              m_total_info[i].replace_info.pane         = replace_info.pane;
              m_total_info[i].replace_info.material     = replace_info.material;
              m_total_info[i].replace_info.texture      = replace_info.texture;
              m_total_info[i].replace_info.replace_mode = replace_info.replace_mode;
            
              m_total_info[i].original_info.state            = ORIGINAL_STATE_NONE;
              m_total_info[i].original_info.physical_address = NULL;
            }

            ret = true;
            ++m_total_info_num;
           
            // ɐɂȂĂȂ
            if( m_state == STATE_CREATING )
            {
              startReplace( &(m_total_info[i]) );
            }
            break;
          }
        }
      }
      else
      {
        GFL_ASSERT_MSG(0, "ǉł܂łBm_replace_info_num_max=%d\n", m_replace_info_num_max);
      }
    }
    else
    {
      GFL_ASSERT(0);
    }

    return ret;
  }

  //-----------------------------------------------------------------------------
  // @brief  uݒ肷yC̏菜
  //-----------------------------------------------------------------------------
  void PlayerIconTex::RemoveReplaceInfo(
    const ReplaceInfo& replace_info,
    b32                original_flag
  )
  {
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      {
        if(
               m_total_info[i].replace_info.pane     == replace_info.pane
            && m_total_info[i].replace_info.material == replace_info.material
            && m_total_info[i].replace_info.texture  == replace_info.texture
        )
        {
          // 菜Ώۂt
          if( original_flag )
          {
            // uݒ肳ĂyCɖ߂
            resetOriginal( &(m_total_info[i]) );
          }
          m_total_info[i].replace_info.replace_mode = REPLACE_MODE_NONE;  // 󂫂ɂĂ
          --m_total_info_num;
          break;
        }
      }
    }
  }

  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //
  // Jo(friendNXɂJ)
  //
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  PlayerIconTex::PlayerIconTex(
      gfl::heap::HeapBase* tex_heap_memory,
      gfl::heap::HeapBase* tex_device_memory,
      u32 replace_info_num_max
  )
    : m_req_id(0),
      m_replace_info_num_max(0),
      m_total_info_num(0),
      m_state(STATE_NONE),
      m_image_address(NULL),
      m_total_info(NULL)
  {
    STATIC_ASSERT(xy_system::player_icon::PlayerIconManager::REQ_NUM_MAX<=TYPE_MAX_OF_M_REQ_ID);  // oϐ̌^̍őlI[o[ĂȂmF

    if( replace_info_num_max<=TYPE_MAX_OF_M_REPLACE_INFO_NUM_MAX )
    {
      m_replace_info_num_max = replace_info_num_max;
    }
    else
    {
      GFL_ASSERT(0);
      m_replace_info_num_max = TYPE_MAX_OF_M_REPLACE_INFO_NUM_MAX;
    }

    // RGBA555164x64̃C[W̃obt@mۂ
    m_image_address = reinterpret_cast<uptr>( GflHeapAllocMemoryAlign( tex_device_memory, 2*64*64, 128 ) );  // eNX`Ȃ̂128oCgACgɂĂ
    gfl::std::MemClear(reinterpret_cast<void*>(m_image_address), 2*64*64);
    // LĂz
    if( m_replace_info_num_max > 0 )
    {
      m_total_info = GFL_NEW_ARRAY(tex_heap_memory) TotalInfo[m_replace_info_num_max];
    }
  }
  PlayerIconTex::~PlayerIconTex()
  {
    // ResetOriginal͌Ăяo̊֐̑OɌĂłĂ
    if( m_total_info )
    {
      GFL_DELETE_ARRAY m_total_info;
    }
    if( m_image_address )
    {
      GflHeapFreeMemory(reinterpret_cast<void*>(m_image_address));
    }
  }

  void* PlayerIconTex::GetImageAddress(void) const
  {
    return reinterpret_cast<void*>(m_image_address);
  }

  void PlayerIconTex::ResetOriginal(void)
  {
    // uݒ肳ĂyCɖ߂
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      { 
        resetOriginal( &(m_total_info[i]) );
      }
    }
  }
  void PlayerIconTex::ClearInfo(void)
  {
    // ResetOriginal͌Ăяo̊֐̑OɌĂłĂ
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      {
        m_total_info[i].replace_info.replace_mode = REPLACE_MODE_NONE;  // 󂫂ɂĂ
        --m_total_info_num;
      }
    }
  }
  void PlayerIconTex::ClearImage(void)
  {
    gfl::std::MemClear(reinterpret_cast<void*>(m_image_address), 2*64*64);
  }

  void PlayerIconTex::SetReqId(s32 req_id)
  {
    m_req_id = req_id;
    // Jn
    m_state = STATE_CREATING;
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      {
        startReplace( &(m_total_info[i]) );
      }
    }
  }
  s32 PlayerIconTex::GetReqId(void) const
  {
    return m_req_id;
  }

  void PlayerIconTex::FinishCreate(void)
  {
    // 
    m_state = STATE_CREATED;
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      {
        endReplace( &(m_total_info[i]) );
      }
    }
  }
  void PlayerIconTex::FinishCancelCreate(void)
  {
    // LZ
    m_state = STATE_CANCELED;
    for(u8 i=0; i<m_replace_info_num_max; ++i)
    {
      if( m_total_info[i].replace_info.replace_mode != REPLACE_MODE_NONE )  // 󂫂Ȃ
      {
        resetOriginal( &(m_total_info[i]) );
      }
    }
  }
  
  b32 PlayerIconTex::IsCreated(void) const
  {
    return (m_state == STATE_CREATED);
  }
  b32 PlayerIconTex::IsAbleToDestroy(void) const
  {
    return (m_state != STATE_CREATING);
  }

  // @brief Jn̒uݒs
  void PlayerIconTex::startReplace(TotalInfo* total_info)
  {
    // (1) ̃yC̏ԂAApɊoĂ
    {
      const nw::lyt::TexMap& tex_map = getTexMap( *total_info );
      total_info->original_info.physical_address = tex_map.GetPhysicalAddress();

      switch(total_info->replace_info.replace_mode)
      {
      case REPLACE_MODE_NONE:
        {
          // Ȃ
          break;
        }
      case REPLACE_MODE_SOON:
        {
          total_info->original_info.state = ORIGINAL_STATE_NONE;
          break;
        }
      case REPLACE_MODE_WAIT:
        {
          total_info->original_info.state = ORIGINAL_STATE_NONE;
          break;
        }
      case REPLACE_MODE_VISIBLE:
        {
          if( total_info->replace_info.pane->IsVisible() )
          {
            total_info->original_info.state = ORIGINAL_STATE_VISIBLE;
          }
          else
          {
            total_info->original_info.state = ORIGINAL_STATE_INVISIBLE;
          }
          break;
        }
      }
    }

    // (2) Jn̒uݒs
    {
      switch(total_info->replace_info.replace_mode)
      {
      case REPLACE_MODE_NONE:
        {
          // Ȃ
          break;
        }
      case REPLACE_MODE_SOON:
        {
          changeImage(total_info, nngxGetPhysicalAddr(m_image_address));
          break;
        }
      case REPLACE_MODE_WAIT:
        {
          // ̎_ł͉Ȃ
          break;
        }
      case REPLACE_MODE_VISIBLE:
        {
          total_info->replace_info.pane->SetVisible(false);
          break;
        }
      }
    }
  }

  // @brief I̒uݒs
  void PlayerIconTex::endReplace(TotalInfo* total_info)
  {
    switch(total_info->replace_info.replace_mode)
    {
    case REPLACE_MODE_NONE:
      {
        // Ȃ
        break;
      }
    case REPLACE_MODE_SOON:
      {
        // ̎_ł͉Ȃ
        break;
      }
    case REPLACE_MODE_WAIT:
      {
        changeImage(total_info, nngxGetPhysicalAddr(m_image_address));
        break;
      }
    case REPLACE_MODE_VISIBLE:
      {
        changeImage(total_info, nngxGetPhysicalAddr(m_image_address));
        total_info->replace_info.pane->SetVisible(true);
        break;
      }
    }
  }

  // @brief sꂽuݒ𕜋A
  void PlayerIconTex::resetOriginal(TotalInfo* total_info)
  {
    changeImage(total_info, total_info->original_info.physical_address);
    switch(total_info->original_info.state)
    {
    case ORIGINAL_STATE_NONE:
      {
        // Ȃ
        break;
      }
    case ORIGINAL_STATE_VISIBLE:
      {
        total_info->replace_info.pane->SetVisible(true);
        break;
      }
    case ORIGINAL_STATE_INVISIBLE:
      {
        total_info->replace_info.pane->SetVisible(false);
        break;
      }
    }
  }

  const nw::lyt::TexMap& PlayerIconTex::getTexMap(const TotalInfo& total_info) const
  {
    if( total_info.replace_info.pane->GetMaterialNum() > total_info.replace_info.material )
    {
      nw::lyt::Material* material = total_info.replace_info.pane->GetMaterial( total_info.replace_info.material );
      if( material->GetTexMapNum() > total_info.replace_info.texture )
      {
        return material->GetTexMap( total_info.replace_info.texture );
      }
    }
    GFL_ASSERT_STOP(0);
    nw::lyt::TexMap tex_map;
    const nw::lyt::TexMap& ref_tex_map = tex_map;  // warning΍̂܂
    return ref_tex_map;
  }
  void PlayerIconTex::setTexMap(TotalInfo* total_info, const nw::lyt::TexMap& tex_map)
  {
    if( total_info->replace_info.pane->GetMaterialNum() > total_info->replace_info.material )
    {
      nw::lyt::Material* material = total_info->replace_info.pane->GetMaterial( total_info->replace_info.material );
      if( material->GetTexMapNum() > total_info->replace_info.texture )
      {
        material->SetTexMap( total_info->replace_info.texture, tex_map );
      }
    }
  }
  void PlayerIconTex::changeImage(TotalInfo* total_info, uptr physical_address)
  {
    nw::lyt::TexMap tex_map = getTexMap( *total_info );
    tex_map.SetPhysicalAddress(physical_address);
    setTexMap(total_info, tex_map);
  }


} // namespace resource
} // namespace common

