#pragma once
#if !defined( __PLAYERICONTEX_H__ )
#define __PLAYERICONTEX_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		PlayerIconTex.h
 *	@brief  CAEg̃eNX`vC[ACR
 *	@author	Koji Kawada
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// kujira
#include "system/player_icon/PlayerFixIconID.h"
#include "system/player_icon/PlayerIconManager.h"


namespace common {
namespace resource {


//-----------------------------------------------------------------------------
/**
 *          NX錾
 */
//-----------------------------------------------------------------------------
// @brief  CAEg̃eNX`vC[ACR
class PlayerIconTex
{
  GFL_FORBID_COPY_AND_ASSIGN(PlayerIconTex);


  friend class PlayerIconTexManager;


  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //
  // Jo
  //
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
public:
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // 萔
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /*
   *  @brief    uݒ肷yĆAݒ蒆̃[h
   */
  //-----------------------------------------------------------------------------
  enum ReplaceMode
  {
    REPLACE_MODE_NONE,     // Ȃ(ւȂBRemoveReplaceInfop)
    REPLACE_MODE_SOON,     // ɍւ(ACR̉ߒ)
    REPLACE_MODE_WAIT,     // ACRĂ獷ւ
    REPLACE_MODE_VISIBLE,  // ACR܂ł͔\ɂA\
  };


  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // \
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  /*
   *  @brief      uݒ肷yC̏
   */
  //-----------------------------------------------------------------------------
  struct ReplaceInfo
  {
    ReplaceMode                replace_mode;
    gfl::grp::g2d::LytPicture* pane;  // nw::lyt::Picture*
    u32                        material;
    u32                        texture;

    // @brief  RXgN^
    ReplaceInfo(void)
      : replace_mode(REPLACE_MODE_NONE),
        pane(NULL),
        material(0),
        texture(0)
    {}
  };


  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // ֐
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////

  //-----------------------------------------------------------------------------
  // @brief  uݒ肷yC̏ǉ
  //         ACRłǉł܂
  // @param[in]  replace_info  uݒ肷yC̏B̊֐߂Ăяo͂jĂvłB
  // @retval  ǉłƂtrueԂ
  //-----------------------------------------------------------------------------
  b32 AddReplaceInfo(
    const ReplaceInfo& replace_info
  );

  //-----------------------------------------------------------------------------
  // @brief  uݒ肷yC̏菜
  //         ACRł菜܂
  // @param[in]  replace_info  uݒ肳ĂyC̏B̊֐߂Ăяo͂jĂvłBreplace_mode͉łłB
  // @param[in]  original_flag  truêƂuݒ肳ĂyCɖ߂B
  //-----------------------------------------------------------------------------
  void RemoveReplaceInfo(
    const ReplaceInfo& replace_info,
    b32                original_flag
  );


  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //
  // Jo(friendNXɂJ)
  //
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
private:
  PlayerIconTex(
      gfl::heap::HeapBase* tex_heap_memory,
      gfl::heap::HeapBase* tex_device_memory,
      u32 replace_info_num_max
  );
  virtual ~PlayerIconTex();

  void* GetImageAddress(void) const;

  void ResetOriginal(void);
  void ClearInfo(void);
  void ClearImage(void);

  void SetReqId(s32 req_id);
  s32 GetReqId(void) const;

  void FinishCreate(void);
  void FinishCancelCreate(void);
  
  b32 IsCreated(void) const;
  b32 IsAbleToDestroy(void) const;


  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //
  // Jo
  //
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
  //#########################################################################################
private:
  // AƂɂǂԂɖ߂
  enum OriginalState
  {
    ORIGINAL_STATE_NONE,      // Ȃ
    ORIGINAL_STATE_VISIBLE,   // \ɖ߂
    ORIGINAL_STATE_INVISIBLE  // \ɖ߂
  };
  // ÂɕKvȏ
  struct OriginalInfo
  {
    u32           state;  // OriginalState
    uptr          physical_address;

    OriginalInfo(void)
      : state(ORIGINAL_STATE_NONE),
        physical_address(NULL)
    {}
  };

  // uݒ肷yC̏()
  struct InternalReplaceInfo
  {
    gfl::grp::g2d::LytPicture* pane;
    u16                        material;
    u8                         texture;
    u8                         replace_mode;  // ReplaceMode

    InternalReplaceInfo(void)
      : pane(NULL),
        material(0),
        texture(0),
        replace_mode(REPLACE_MODE_NONE)
    {}
  }; 

  // uݒ肷yC̏{ÂɕKvȏ
  struct TotalInfo
  {
    // replace_inforeplace_modeREPLACE_MODE_NONÊƂA󂫂Ƃ݂ȂB
    InternalReplaceInfo  replace_info;
    OriginalInfo         original_info;

    TotalInfo(void)
      : replace_info(),
        original_info()
    {}
  };

  // 
  enum State
  {
    STATE_NONE,      // ܂gp
    STATE_CREATING,  // 
    STATE_CREATED,   // Ă
    STATE_CANCELED   // LZĂ
  };

private:
  // @brief Jn̒uݒs
  void startReplace(TotalInfo* total_info);
  // @brief I̒uݒs
  void endReplace(TotalInfo* total_info);
  // @brief sꂽuݒ𕜋A
  void resetOriginal(TotalInfo* total_info);

  const nw::lyt::TexMap& getTexMap(const TotalInfo& total_info) const;
  void setTexMap(TotalInfo* total_info, const nw::lyt::TexMap& tex_map);
  void changeImage(TotalInfo* total_info, uptr physical_address);

private:
  // oϐ̌^̍ől
  enum
  {
    TYPE_MAX_OF_M_REQ_ID                = 250,
    TYPE_MAX_OF_M_REPLACE_INFO_NUM_MAX  = 250,
    TYPE_MAX_OF_MATERIAL                = 32000,
    TYPE_MAX_OF_TEXTURE                 = 250
  };

private:
  u8     m_req_id;  // m_stateSTATE_CREATINĜƂgpȂ
  u8     m_replace_info_num_max;
  u8     m_total_info_num;
  u8     m_state;  // State
  uptr   m_image_address;  // _AhX
  TotalInfo* m_total_info;

};


} // namespace resource
} // namespace common


#endif // __PLAYERICONTEX_H__

