//============================================================================================
/**
 * @file		sv_union_pokemon.h
 * @brief		Z[uf[^F̃|P̑ޔ̈
 * @author	Hiroyuki Nakamura
 * @date		12.06.13
 *
 * namespace	savedata::
 */
//============================================================================================
#if !defined( __SV_UNION_POKEMON_H__ )
#define __SV_UNION_POKEMON_H__

#include <gflib.h>
#include <savedata/SaveDataInterface.h>

GFL_NAMESPACE_BEGIN(savedata)

class UnionPokemon : public SaveDataInterface
{
	GFL_FORBID_COPY_AND_ASSIGN(UnionPokemon); //Rs[RXgN^{֎~

public:
	//------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 */
	//------------------------------------------------------------------------------------------
	UnionPokemon(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//------------------------------------------------------------------------------------------
	~UnionPokemon();

private:
	struct Data {
		u8	pokemonParam[ pml::pokepara::PokemonParam::DATASIZE ];
	};

	Data poke;

public:
  //-----------------------------------------------------------------------------
  /**
   *  @brief    ǂݍ񂾃f[^Zbg֐
    * @param    pData   擪̃|C^
   */
  //-----------------------------------------------------------------------------
	virtual void SetData(void * pData){ gfl::std::MemCopy( pData, reinterpret_cast<void*>(&poke), sizeof(Data) ); };

  //-----------------------------------------------------------------------------
  /**
   *  @brief    f[^̐擪|C^𓾂֐
    * @return   擪̃|C^
   */
  //-----------------------------------------------------------------------------
	virtual void * GetData(void){ return reinterpret_cast<void*>(&poke); };

  //-----------------------------------------------------------------------------
  /**
   *  @brief    f[^TCY
   *  @retval   oCg
   */
  //-----------------------------------------------------------------------------
	virtual size_t GetDataSize(void){ return sizeof(Data); };

  //-----------------------------------------------------------------------------
  /**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
   */
  //-----------------------------------------------------------------------------
	virtual void Clear( gfl::heap::HeapBase * heap ){ this->InitPokemonData(heap); };

public:
	//------------------------------------------------------------------------------------------
	/**
	 * @brief		
	 *
	 * @param		heap	q[v
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void InitPokemonData( gfl::heap::HeapBase * heap );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		PokemonParamZbg
	 *
	 * @param		pp	ZbgPokemonParam
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void SetPokemon( const pml::pokepara::PokemonParam * pp );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		PokemonParam擾
	 *
	 * @param		pp	擾ꏊ
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void GetPokemon( pml::pokepara::PokemonParam * pp );
};

GFL_NAMESPACE_END(savedata)


#endif	// __SV_UNION_POKEMON_H__
