//==============================================================================
/**
 * @file	pss_assist_power_view.h
 * @brief	PSS AVXgp[ʁ@OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 18:44
 */
// =============================================================================

#if !defined( __PSS_ASSIST_POWER_VIEW_H__ )
#define	__PSS_ASSIST_POWER_VIEW_H__


#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

#include "PssAssistPowerUIListener.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power)


class ViewWork : public app::ui::UIView, public app::ui::UIInputListener
{
private:
	typedef enum{
		PSS_ASSIST_POWER_LAYOUT_ID_UPPER,
		PSS_ASSIST_POWER_LAYOUT_ID_LOWER,
		PSS_ASSIST_POWER_LAYOUT_ID_MAX,
	}LAYOUT_ID;

	
public:
  // RXgN^
  ViewWork( app::util::Heap * heap,
						 gfl::grp::g2d::LytSys *layout,
             app::tool::LytTexReplaceSystem* textureSystem );
  // fXgN^
  virtual ~ViewWork( void );

public:
	void SetPssAssistPowerUIListener( PssAssistPowerUIListener *listener );

public:
	virtual void Update( void );
	virtual void Draw( void );


public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);


private:
	void StartAnime( u32 animeId );
	void Initialize2D( app::util::Heap *heap, gfl::grp::g2d::LytSys *layout );
	void UpdateBottomMenuBar( void );

private:
	static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[5];	///< Aj[Ve[u
	static const u32												ButtonPaneList[3];	///< {^j[pyC

	PssAssistPowerUIListener*		m_uiListener;		///< UICxgXi

};

GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)

#endif	/* __PSS_ASSIST_POWER_VIEW_H__ */

