//==============================================================================
/**
 * @file	pss_assist_power_view.cpp
 * @brief	PSS AVXgp[ʁ@OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 19:21
 */
// =============================================================================

#include "pss_assist_power_main.h"
#include "layout.h"
#include "layout_pane.h"

#include <arc/arc_def.h>
#include <arc/assist_power_res.gaix>
#include <message/message.gaix>
#include <message/msg_assist_power.h>


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power)


//{^j[pyC
const u32 ViewWork::ButtonPaneList[3] =
{
  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW01_BOUND,
  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW02_BOUND,
  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW03_BOUND,
};
				
// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex ViewWork::LowerAnmIndex[5] = {
	LYTRES_LAYOUT_ASSIST_POWER_LOWER_ACTIVE_BCLAN,
  LYTRES_LAYOUT_ASSIST_POWER_LOWER_CANSEL_BCLAN,
  LYTRES_LAYOUT_ASSIST_POWER_LOWER_PASSIVE_BCLAN,
  LYTRES_LAYOUT_ASSIST_POWER_LOWER_RELEASE_BCLAN,
  LYTRES_LAYOUT_ASSIST_POWER_LOWER_TOUCH_BCLAN,
};

// RXgN^
ViewWork::ViewWork( app::util::Heap * heap,
										gfl::grp::g2d::LytSys *layout,
										app::tool::LytTexReplaceSystem* textureSystem ) :
										app::ui::UIView( heap, heap->pDevHeapAllocator, heap->pDevHeapAllocator )
{
	m_uiListener = NULL;

	CreateGraphicsSystem( heap );
	Initialize2D( heap, layout );
	if( textureSystem != NULL ){ ReUseTextureSystem( textureSystem ); }

	// {^}l[W
	u32 paneNum = sizeof(ButtonPaneList) / sizeof(ButtonPaneList[0]);
	CreateButtonManager( heap, GetLayoutWork(PSS_ASSIST_POWER_LAYOUT_ID_LOWER),
										 ButtonPaneList, paneNum );

	// p[BOUNDL
	// @todo

	// @todo
  // afeNX`̍ւ
  //ReplacePaneTexture( PSS_PROFILE_LAYOUT_ID_UPPER, PANENAME_PROFILE_UPPER_PANE_PROFILE_BG, GARC_fieldmenu_pss_tex_pss_bg_BCLIM );
  //ReplacePaneTexture( PSS_PROFILE_LAYOUT_ID_LOWER, PANENAME_PROFILE_LOWER_PANE_PROFILE_00, GARC_fieldmenu_pss_tex_pss_bg_BCLIM );

	UpdateBottomMenuBar();

	SetInputListener( this );
}

// fXgN^
ViewWork::~ViewWork( void )
{
	Delete2D();
	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------
/**
 * @brief		UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void ViewWork::SetPssAssistPowerUIListener( PssAssistPowerUIListener *listener )
{
	m_uiListener = listener;
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 */
//--------------------------------------------------------------------------
void ViewWork::Update(void)
{
  app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 * @brief		`
 */
//--------------------------------------------------------------------------
void ViewWork::Draw(void)
{
  m_g2dUtil->Draw2D( m_graphicSystem, PSS_ASSIST_POWER_LAYOUT_ID_UPPER );
  m_g2dUtil->Draw2D( m_graphicSystem, PSS_ASSIST_POWER_LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		ʉ̃j[o[XV
 */
//--------------------------------------------------------------------------
void ViewWork::UpdateBottomMenuBar( void )
{

	// s{^\
	// @todo

}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Aj[V̊Jn
 *
 * @param animeId Aj[VID
 */
//--------------------------------------------------------------------------------------------
void ViewWork::StartAnime( u32 animeId )
{
  m_g2dUtil->StopAnime( PSS_ASSIST_POWER_LAYOUT_ID_LOWER, animeId, false);
  m_g2dUtil->StartAnime( PSS_ASSIST_POWER_LAYOUT_ID_LOWER, animeId );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ViewWork::Initialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout )
{
	// A[JCuIDe[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[] = 
  {
		{ ARCID_ASSIST_POWER_GRA, 0, 0 }
  };

	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
		{	// 
			0,
			LYTRES_LAYOUT_ASSIST_POWER_UPPER_BCLYT,			// resID̃CAEgf[^ID
			NULL,																				// Aj[Vf[^IDe[u	AĵȂꍇNULL
			0,																					// Aj[Vf[^IDe[u AĵȂꍇ0
			0,																					// o^Aj[Vő吔
			false,																			// \yCɍsvZs
			app::util::G2DUtil::SETUP_UPPER,						// fBXvC
			true,																				// \ݒ
		},
		{	// 
			0,
			LYTRES_LAYOUT_ASSIST_POWER_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
			false,
			app::util::G2DUtil::SETUP_LOWER,
			true,
		},
	};

	Create2D( heap, layout, PSS_ASSIST_POWER_LAYOUT_ID_MAX,
						resTbl, GFL_NELEMS(resTbl),
						layoutData, GFL_NELEMS(layoutData),
						GARC_message_assist_power_DAT );
}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnLayoutPaneEvent( const u32 painId )
{
#if 0
  switch( painId )
  {
    case  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW01_BOUND:
      if( m_uiListener != NULL ){
        m_uiListener->OnMenuCloseAction();
        return false;
      }
      break;

    case  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW02_BOUND:
      if( m_uiListener != NULL ){
        m_uiListener->OnSelectedIconAction();
        return false;
      }
      break;

    case  PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW03_BOUND:
      {
        UpdateBottomMenuBar();

        if( m_uiListener != NULL ){
          m_uiListener->OnSelectedFavoriteAction( m_isFavorite );
        }
      }
      return false;
  }
#endif

  return true;
}


//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( m_uiListener != NULL )
  {
    if( pKey->IsTrigger( gfl::ui::BUTTON_B ) ){
      m_uiListener->OnReturnAction();
      return false;
    }
  }
  return true;
}

GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)
