//==============================================================================
/**
 * @file	pss_assist_power_main.h
 * @brief	PSS AVXgp[ʁ@C
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 17:08
 */
// =============================================================================

#if !defined( __PSS_ASSIST_POWER_MAIN_H__ )
#define	__PSS_ASSIST_POWER_MAIN_H__

#include <app/pss/pss_assist_power/pss_assist_power.h>

#include "pss_assist_power_view.h"
#include "PssAssistPowerUIListener.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power)

class MainSystem : public PssAssistPowerUIListener
{
private:
	//-------------------------------------
	/// CV[PX`
  //=====================================
	typedef enum {
		MAINSEQ_INIT = 0,
		MAINSEQ_MAIN,
		MAINSEQ_FADE_OUT,
		MAINSEQ_RELEASE,
		MAINSEQ_END,
	}ENUM_MAIN_SEQ;

public:
  // RXgN^
  MainSystem( APP_PARAM *prm );
  // fXgN^
  virtual ~MainSystem( void );

public:
	bool Update( void );
	void Draw( void );

	//--------------------------------------------------------------
	// UIXi[
	virtual void OnReturnAction( void );
	virtual void OnSelectPowerAction( void );

private:
	void CreateSubWork( void );
	void DeleteSubWork( void );

	void SetFadeIn( void );
	void SetFadeOut( void );
	void SetFinish( ENUM_END_MODE retCode );	// Iݒ
	void SetMainSeq( ENUM_MAIN_SEQ seq );
	
	bool DoSeqProcess( void );

private:
	// CV[PX
	void MainSeq_Init( void );
	bool MainSeq_Release( void );
	void MainSeq_Fade( ENUM_MAIN_SEQ seq );
	void MainSeq_Main( void );

private:
	static const u32 APP_HEAP_SIZE    = 0x100000;  ///< Avp[Jq[vTCY
	static const u32 DEVICE_HEAP_SIZE = 0x300000;  ///< Avp[JfoCXq[vTCY

private:
	ViewWork*								m_view;						///< `Ǘ
  app::util::Heap         m_heap;           ///< q[vǗ
  APP_PARAM*              m_appParam;       ///< Np[^
  ENUM_MAIN_SEQ 					m_seq;						///< JgV[PX
  bool                    m_isFinish;       ///< fItO
};

GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)

#endif	/* __PSS_ASSIST_POWER_MAIN_H__ */

