//==============================================================================
/**
 * @file	pss_assist_power_main.cpp
 * @brief	PSS AVXgp[ʁ@C
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 17:47
 */
// =============================================================================

#include "pss_assist_power_main.h"
#include <gamesystem/ForcedReturnManager.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power )

// RXgN^
MainSystem::MainSystem( APP_PARAM *prm )
{
	m_view			= NULL;
	m_isFinish	= false;

	m_appParam						= prm;
	m_appParam->m_endMode = END_MODE_CONTINUE;

	SetMainSeq( MAINSEQ_INIT );
}

// fXgN^
MainSystem::~MainSystem( void )
{
	DeleteSubWork();
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::Update( void )
{
	bool isRunning = DoSeqProcess();

	if( m_view != NULL ) 
	{
		m_view->Update();
	}

	return isRunning;
}

//--------------------------------------------------------------------------
/**
 * @brief		`揈
 */
//--------------------------------------------------------------------------
void MainSystem::Draw( void )
{
	if( m_view != NULL )
	{
		m_view->Draw();
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void MainSystem::OnReturnAction( void )
{
	SetFinish( END_MODE_RETURN );
}

//--------------------------------------------------------------------------
/**
 * @brief		p[Iʒm
 */
//--------------------------------------------------------------------------
void MainSystem::OnSelectPowerAction( void )
{
}

//--------------------------------------------------------------------------
/**
 * @brief		V[PXʃvZX
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::DoSeqProcess( void )
{
	switch( m_seq ){
	case MAINSEQ_INIT:			MainSeq_Init();											break;
	case MAINSEQ_MAIN:			MainSeq_Main();											break;
	case MAINSEQ_FADE_OUT:	MainSeq_Fade( MAINSEQ_RELEASE );		break;
	case MAINSEQ_RELEASE:
		if( !MainSeq_Release()	){
			break;
		}
		/* break through */
	case MAINSEQ_END:
		return false;
	}
	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 */
//--------------------------------------------------------------------------
void MainSystem::CreateSubWork( void )
{
	gfl::heap::HEAPID parent_heapID;
	gfl::heap::HEAPID parent_heapDevID;

#ifdef PM_DEBUG
	if( m_appParam->m_isDebug == true )
	{
		// fobOsAPP擾
		parent_heapID			= HEAPID_APP;
		parent_heapDevID	= HEAPID_APP_DEVICE;
		GFL_PRINT("fobOs!\n");
	}
	else
#endif // PM_DEBUG
	{
		// ʏs
		parent_heapID			= HEAPID_FIELDMENU;
		parent_heapDevID	= HEAPID_FIELDMENU_DEV;
	}

  m_heap.Create( gfl::heap::Manager::GetHeapByHeapId( parent_heapID ),
	               gfl::heap::Manager::GetHeapByHeapId( parent_heapDevID ),
	               HEAPID_PSS_ASSIST_POWER_APP, APP_HEAP_SIZE, HEAPID_PSS_ASSIST_POWER_DEVICE, DEVICE_HEAP_SIZE );

	m_view = GFL_NEW( m_heap.pHeap ) ViewWork( &m_heap,
																							m_appParam->m_layout,
																							m_appParam->m_textureSystem );

	m_view->SetPssAssistPowerUIListener( this );
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 */
//--------------------------------------------------------------------------
void MainSystem::DeleteSubWork( void )
{
	if( m_view )
	{
		GFL_SAFE_DELETE( m_view );
	}
	m_heap.Delete();
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeIn( void )
{
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeOut( void )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_LOWER, gfl::grp::Fade::OUTTYPE_CAPTURE, 1, false );
}

//==========================================================================
/**
 *					CV[PX
 */
//==========================================================================
//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Init( void )
{
	m_isFinish	= false;

	// Tu[N쐬
	CreateSubWork();
	m_view->Update();

	// tF[hC
	SetFadeIn();
	SetMainSeq( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @retval	true:
 * @retval	true:쒆
 */
//--------------------------------------------------------------------------
bool MainSystem::MainSeq_Release( void )
{
	// Tu[N폜
	DeleteSubWork();
	SetMainSeq( MAINSEQ_END );

	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Fade( ENUM_MAIN_SEQ seq )
{
	if( gfl::grp::Fade_IsEnd() ){
	  SetMainSeq( seq );
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Main( void )
{
  if( m_isFinish ||
      GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
  {
    if( m_appParam->m_endMode != END_MODE_RETURN ){
      SetFadeOut();
    }
    SetMainSeq( MAINSEQ_FADE_OUT );
  }
}

//------------------------------------------------------------------
/**
 * @brief CV[PXݒ
 *
 * @param  seq   ؂ւΏۂƂȂV[PX
 */
//------------------------------------------------------------------
void MainSystem::SetMainSeq( ENUM_MAIN_SEQ seq )
{
  m_seq = seq;
}

//------------------------------------------------------------------
/**
 * @brief  j[̏Iݒ
 * @param		retCode IR[h
 */
//------------------------------------------------------------------
void MainSystem::SetFinish( ENUM_END_MODE retCode )
{
  m_isFinish = true;
  m_appParam->m_endMode = retCode;

  // ȍ~̃L[֎~
  m_view->SetInputEnabled( false );
}





GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)
