//==============================================================================
/**
 * @file	pss_assist_power.cpp
 * @brief	PSS	AVXgp[
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 16:08
 */
// =============================================================================

#include "app/pss/pss_assist_power/pss_assist_power.h"
#include "pss_assist_power_main.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power )

// RXgN^
Proc::Proc( APP_PARAM *prm )
{
	m_appParam  = prm;
  CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

// fXgN^

Proc::~Proc( void )
{
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	GFL_DELETE	pMain;
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	if( pMain->Update() )
	{
	  return gfl::proc::RES_CONTINUE;
	}
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	gfl::heap::HEAPID parent_heapID;


#ifdef PM_DEBUG
	// fobOsAPP擾
	if( m_appParam->m_isDebug == true )
	{
		parent_heapID = HEAPID_APP;
	}
	else
#endif // PM_DEBUG
	{
		parent_heapID = HEAPID_FIELDMENU;
	}

	pHeap = GFL_CREATE_HEAP( gfl::heap::Manager::GetHeapByHeapId( parent_heapID ),
                           HEAPID_PSS_ASSIST_POWER_SYS, SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}				
				
GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)
