//==============================================================================
/**
 * @file	pss_assist_power.h
 * @brief	PSS	AVXgp[
 * @author	ichiraku_katsuhiko
 * @data	2012/06/12, 16:06
 */
// =============================================================================

#if !defined( __PSS_ASSIST_POWER_H__ )
#define	__PSS_ASSIST_POWER_H__

#include <gflib.h>
#include <gfl_Device.h>
#include "gamesystem/GameProc.h"

#include <app/tool/app_tool_LytTexReplaceSystem.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(assist_power)


class MainSystem;

//-------------------------------------
///	I[h
//=====================================
typedef enum {
	END_MODE_CONTINUE = 0,		///< 쒆
	END_MODE_RETURN,					///< PSSgbvʂ
} ENUM_END_MODE;


//-------------------------------------
///	Oݒp[^
//=====================================
typedef struct {
  gfl::grp::g2d::LytSys*                     m_layout;           ///< [in]pCAEgVXeBNULLȂVK쐬
  app::tool::LytTexReplaceSystem*            m_textureSystem;    ///< [in]peNX`VXeB
  gfl::str::MsgData*                         m_pssMessageData;   ///< [in]pPSSbZ[Wf[^B
  WordSet*                                   m_pssWordset;       ///< [in]pPSS[hZbgB
  u32                                        m_endMode;          ///< [out]I[h(ENUM_END_MODE)

#ifdef PM_DEBUG
	bool		m_isDebug;		// fobOsp
#endif // PM_DEBUG

}APP_PARAM;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class Proc : public gamesystem::GameProc
{
public:
  // RXgN^
  Proc( APP_PARAM *prm );
  // fXgN^
  virtual ~Proc( void );

public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcI
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcAbvf[g
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc`揈
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void DrawFunc( gfl::proc::Manager * proc_manager );


private:

	private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateHeap(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteHeap(void);

private:
  gfl::heap::HeapBase*                 pHeap;        // VXeq[v
  MainSystem*                          pMain;        // fNX
  APP_PARAM*                           m_appParam;   // Np[^

  static const u32      SYS_HEAP_SIZE = 0x800;      // VXeq[vTCY
};

GFL_NAMESPACE_END(assist_power)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(app)

#endif	/* __PSS_ASSIST_POWER_H__ */

