//=============================================================================
/**
 * @file   SubscriptionUpdateThread.h
 * @brief  SubscriptionXVpXbh
 * @author h.suzuki
 */
//=============================================================================

#ifndef __SUBSCRIPTION_UPDATE_THREAD_H__
#define __SUBSCRIPTION_UPDATE_THREAD_H__


#include <gflib.h>
#include <gflnet.h>
#include <netapp/subscription/SubscriptionManager.h>


namespace netapp {
namespace subscription {


class SubscriptionUpdateThread : public gfl::base::Thread
{
  GFL_FORBID_COPY_AND_ASSIGN(SubscriptionUpdateThread); //Rs[RXgN^{֎~

private:
  SubscriptionManager*  m_subscriptMgr;

public:
  //--------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   * @param sys            SubscriptionUpdateThreadւ̃|C^
   * @param heap           Xbh̃X^bN̈Ɏgpq[v
   * @param stack_size     Xbh̃X^bN̈̃TCY
   */
  //--------------------------------------------------------------------------------
  SubscriptionUpdateThread( SubscriptionManager* subMgr, gfl::heap::HeapBase* heap, u32 stack_size );

  //--------------------------------------------------------------------------------
  /**
   * @brief fXgN^
   */
  //--------------------------------------------------------------------------------
  virtual ~SubscriptionUpdateThread();

private:

  virtual void Initialize( void );
  virtual void Finalize( void );
  virtual void OnKill( void );
  virtual void Main( void );
};




} // subscription
} // netapp


#endif  // __SUBSCRIPTION_UPDATE_THREAD_H__

