//============================================================================================
/**
 * @file		gts_main.h
 * @brief		C
 * @author	suzuki_hisanao
 * @date		11.11.09
 *
 * namespace	app::gts::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#if !defined( __GTS_MAIN_H__ )
#define __GTS_MAIN_H__

#include <gflnet.h>
#include "app/util/app_util_heap.h"

#include "app/tool/app_tool_BoxUpper.h"   // ʃ|Pʕ`

#include <netapp/gts/gts.h>
#include "gts_graphic.h"

namespace netapp {
namespace gts {


/// C[N
typedef struct {
  APP_PARAM * prm;  ///< AvĂяop[^(gts.hŒ`)

  int	mainSeq;      ///< ݂̃V[PX
  int	nextSeq;      ///< ̃V[PX
  int	subSeq;       ///< V[PXTu[N
  int	fadeNextSeq;  ///< tF[hAEg̐iݐ
}MAIN_WORK;

/// gts_mainNX
class MainSystem : public GtsUIListener
{
public:

  // CV[PX`
  typedef enum {
    MAINSEQ_INIT = 0, // 
    MAINSEQ_RELEASE,  // [N
    MAINSEQ_FADE,     // tF[h҂
    MAINSEQ_MAIN,     // C
    MAINSEQ_SENDRECVWAIT, // f[^M҂
    MAINSEQ_SAVEWAIT,     // Z[u҂
    MAINSEQ_WINDOWOPEN,   // ʐMXgʃI[v҂
    MAINSEQ_SEARCH,       // ʏ
    MAINSEQ_END
  }MAIN_SEQUENCE;

public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @retval	"true = "
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);


private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hCZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeIn( int next );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hAEgZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeOut( int next );

  /// O
  void PreSearchMyBox_Temochi( void );



	// XP[ύXʒmCxg
  virtual void OnScaleChange( float newScale );
  // ^E}bvj[̃N[Yʒm
  virtual void OnMenuCloseAction( void );
  // ^E}bvj[̃^[ʒm
  virtual void OnMenuReturnAction( void );
  // J[\Ă][IDύXꂽʒm
  virtual void OnChangeSelectedZone( s32 newPaneNo );
  // ̃][Iꂽۂ̒ʒm
  virtual void OnDecideZone( s32 selectedPainID );



// CV[PX
public:
  int MainSeq_Init(void);
  int MainSeq_Release(void);
  int MainSeq_Fade(void);
  int MainSeq_Main(void);
  int MainSeq_SendRecvWait(void);
  int MainSeq_SaveWait(void);
  int MainSeq_WindowOpen(void);
  int MainSeq_Search(void);


private:

  MAIN_WORK             mainWork;     ///< C[N
  GraphicWork           *m_view;      ///< OtBbN`NX
  app::util::Heap       m_heap;       ///< q[v
  gflnet::p2p::NetGame  *m_netHandle; ///< ʐMnh
  bool                  m_isFinish;   ///< IʒmtO
  int                   wait;         ///< ҂p[N

  gfl::str::StrBuf      *strBuf;      ///< e|obt@

private:
  static const u32 GTS_APP_HEAP_SIZE    = 0x300000;   ///< Avp[Jq[vTCY
  static const u32 GTS_DEVICE_HEAP_SIZE = 0x1000000;   ///< Avp[JfoCXq[vTCY
  static const u32 GTS_FADE_SYNC = 8;   ///< tF[hx
};

}		// gts
}		// netapp
#endif // __GTS_MAIN_H__
