//============================================================================================
/**
 * @file		gts_main.cpp
 * @brief		ʐMXgʃC
 * @author	Akitoi Mori
 * @date		12.04.20
 *
 * namespace	netapp::gts::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================


#include <gflib.h>
#include <pmlib.h>
#include <sound/sound.h>
#include <base/gfl_Singleton.h>

#include "gamesystem/ForcedReturnManager.h"

#include "gts_main.h"

#include "res_gts_layout.gaix"
#include "res_gts_layout.h"
#include "res_gts_layout_pane.h"

namespace netapp {
  namespace gts {

// ʐMȂȂԂō쐬邽߂̒`
#define NO_NET_BUILD

//============================================================================================
//	萔`
//============================================================================================

typedef int (MainSystem::*pSeqFunc)(void);

// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&MainSystem::MainSeq_Init,
	&MainSystem::MainSeq_Release,
	&MainSystem::MainSeq_Fade,
	&MainSystem::MainSeq_Main,
	&MainSystem::MainSeq_SendRecvWait,
	&MainSystem::MainSeq_SaveWait,
	&MainSystem::MainSeq_WindowOpen,
	&MainSystem::MainSeq_Search,
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm )
{
  m_view           = NULL;
	mainWork.prm     = prm;
	m_isFinish       = false;

  mainWork.mainSeq = MainSeq_Init();

	// ʐMݒ
	gflnet::p2p::GameInitialize initialize;
	initialize.max          = 2;            // ڑMAX  4ł̂?
	initialize.pHeapSystem  = m_heap.pHeap; // ʐMŎgq[v

#ifndef NO_NET_BUILD
	// NetGameNX쐬
	m_netHandle = GFL_NEW( m_heap.pHeap ) gflnet::p2p::NetGame( &initialize, NULL );
	m_netHandle->Initialize();

  GFL_PRINT("NetGame Start\n");
#else
  GFL_PRINT("ʐMȂ HEAPID=%d\n", HEAPID_GTS_SYS);
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem(void)
{
#ifndef NO_NET_BUILD
  // ʐMnhN[Y
	m_netHandle->Finalize( );
	GFL_SAFE_DELETE( m_netHandle );
	GFL_PRINT("NetGame end\n");
#else
  GFL_PRINT("ʐMȂŏI\n");
#endif

  // [N
  DeleteSubWork();

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::Update(void)
{
  MAIN_WORK * mwk = &mainWork;

  mwk->mainSeq = (this->*MainSeq[mwk->mainSeq])();

  if( mwk->mainSeq == MAINSEQ_END ){
    return false;
  }

	// Kɍs
  if( m_view != NULL )
  {
    m_view->Update();
  }

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
	if( m_view != NULL )
	{
    m_view->Draw();
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
  m_heap.Create( HEAPID_GTS_APP, GTS_APP_HEAP_SIZE, HEAPID_GTS_DEVICE, GTS_DEVICE_HEAP_SIZE );

	m_view    = GFL_NEW( m_heap.pHeap ) GraphicWork( &m_heap );
  m_view->SetAppParam( mainWork.prm );

  m_view->SetGtsUIListener( this );

}



//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
  if( m_view != NULL )
  {
    GFL_DELETE m_view;
    m_view = NULL;
  }

	m_heap.Delete();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeIn( int next )
{
	gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
	gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
	gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, GTS_FADE_SYNC );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeOut( int next )
{
	gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, GTS_FADE_SYNC, false );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Init(void)
{
  pml::pokepara::PokemonParam *pokePara = mainWork.prm->pPokeParty->GetMemberPointer(1);

  // Ǘ[N
  CreateSubWork();

  // {bNXƎ莝O
  PreSearchMyBox_Temochi();

  // {bNXgCɃyCɕ`
  strBuf = GFL_NEW( m_heap.pHeap ) gfl::str::StrBuf( mainWork.prm->pSaveBox->GetTrayName( 0 ), m_heap.pHeap );
  m_view->PrintTrayName( 0, strBuf );
  GFL_DELETE strBuf;

  strBuf = GFL_NEW( m_heap.pHeap ) gfl::str::StrBuf( mainWork.prm->pSaveBox->GetTrayName( 1 ), m_heap.pHeap );
  m_view->PrintTrayName( 1, strBuf );
  GFL_DELETE strBuf;

  strBuf = GFL_NEW( m_heap.pHeap ) gfl::str::StrBuf( mainWork.prm->pSaveBox->GetTrayName( 2 ), m_heap.pHeap );
  m_view->PrintTrayName( 2, strBuf );
  GFL_DELETE strBuf;

  m_view->PrintTemochiName();


/*
  GFL_PRINT( "=%s\n", nn::cfg::GetCountryCodeA2( nn::cfg::CFG_COUNTRY_JAPAN ));
  GFL_PRINT( "=%s\n", nn::cfg::GetCountryCodeA2( nn::cfg::CFG_COUNTRY_BRITISH_VIRGIN_ISLANDS ));
  GFL_PRINT( "=%s\n", nn::cfg::GetCountryCodeA2( nn::cfg::CFG_COUNTRY_JAPAN ));
  GFL_PRINT( "=%s\n", nn::cfg::GetCountryCodeA2( nn::cfg::CFG_COUNTRY_BRITISH_VIRGIN_ISLANDS ));

  {
    nn::cfg::SimpleAddress *simpleAd = new nn::cfg::SimpleAddress;
//    nn::cfg::SimpleAddress simpleAd;
    nn::cfg::GetSimpleAddress( simpleAd );
    GFL_PRINT( "=%s, n於=%s\n", simpleAd->countryName, simpleAd->regionName );
//    GFL_DELETE simpleAd;
    GFL_PRINT("w=");
    for(int i=0;i<10;i++){
      GFL_PRINT("%04x,", simpleAd->countryName[i] );
    }
    GFL_PRINT("\n");

    GFL_PRINT("n於w=");
    for(int i=0;i<10;i++){
      GFL_PRINT("%04x,", simpleAd->regionName[i] );
    }
    GFL_PRINT("\n");
    
    delete simpleAd;
  }
*/

  m_view->SetPaneCondition( GraphicWork::TL_PANE_SENDRECV );
  m_view->SetPaneCondition( GraphicWork::TL_PANE_UPPER_POKE_INFO );
  m_view->SetPaneCondition( GraphicWork::TL_PANE_UPPER_LEFT_OFF );
  m_view->SetPaneCondition( GraphicWork::TL_PANE_UPPER_RIGHT_OFF );

	return SetFadeIn( MAINSEQ_SENDRECVWAIT );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Release(void)
{
	DeleteSubWork();

	return mainWork.nextSeq;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Fade(void)
{
	if( gfl::grp::Fade_IsEnd() != false ){
		return mainWork.fadeNextSeq;
	}
	return MAINSEQ_FADE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Main(void)
{
	if( m_isFinish ||
	    GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
	{
	  m_view->SetInputEnabled( false );
		mainWork.nextSeq = MAINSEQ_END;
		return SetFadeOut( MAINSEQ_RELEASE );
	}
	m_view->SelectMenu_Main();
	return MAINSEQ_MAIN;
}

//=============================================================================================
/**
 * @brief	CV[PXFJnf[^M҂
 *
 * @param   none		
 *
 * @retval  int		
 */
//=============================================================================================
int MainSystem::MainSeq_SendRecvWait(void)
{
  if(wait++>60){
    return MAINSEQ_SAVEWAIT;
  }
  return MAINSEQ_SENDRECVWAIT;

}

//=============================================================================================
/**
 * @brief	CV[PXFZ[u҂
 *
 * @param   none		
 *
 * @retval  int		
 */
//=============================================================================================
int MainSystem::MainSeq_SaveWait(void)
{

  return SetFadeOut( MAINSEQ_WINDOWOPEN );
}

//=============================================================================================
/**
 * @brief	CV[PXFCʂւ̑JځiʃI[vj҂
 *
 * @param   none		
 *
 * @retval  int		
 */
//=============================================================================================
int MainSystem::MainSeq_WindowOpen(void)
{
  m_view->SetPaneCondition( GraphicWork::TL_PANE_MAIN );
  m_view->SetPaneCondition( GraphicWork::TL_PANE_UPPER_LEFT_OFF );
  m_view->SetPaneCondition( GraphicWork::TL_PANE_UPPER_RIGHT_OFF );

  // ʏ`
//  m_view->UpdatePokeInfo( pokePara );
//  m_view->CreateBoxUpperPokeModel( pokePara, &m_heap );
  m_view->DisappearPokeInfo();  // ʕ\OFF

  return SetFadeIn( MAINSEQ_MAIN );
}

//=============================================================================================
/**
 * @brief	CV[PXF
 *
 * @param   none		
 *
 * @retval  int		
 */
//=============================================================================================
int MainSystem::MainSeq_Search(void)
{
  return MAINSEQ_SEARCH;
}




//------------------------------------------------------------------
/**
 * @brief  XP[ύXʒmCxg
 *
 * @param  newScale ύXڕWƂȂXP[l
 */
//------------------------------------------------------------------
void MainSystem::OnScaleChange( float newScale )
{
  if( newScale == 2.0f ){
    xy_snd::PlaySE( SEQ_SE_SYS_001 );
  }
  else{
    xy_snd::PlaySE( SEQ_SE_SYS_002 );
  }
}


//------------------------------------------------------------------
/**
 * @brief  ^E}bvj[̃LZʒmitB[hցj
 */
//------------------------------------------------------------------
void MainSystem::OnMenuCloseAction( void )
{
  xy_snd::PlaySE( SEQ_SE_CLOSE1 );
  m_isFinish = true;
}


//------------------------------------------------------------------
/**
 * @brief  ^E}bvj[̃^[ʒmiobNj[ցj
 */
//------------------------------------------------------------------
void MainSystem::OnMenuReturnAction( void )
{
  xy_snd::PlaySE( SEQ_SE_CANCEL1 );
  m_isFinish = true;
}


//------------------------------------------------------------------
/**
 * @brief  J[\Ă][IDύXꂽʒm
 *
 * @param  newPlace VɃJ[\yCԍ
 *         ][f[^̓yCԍL[ɋt\B
 */
//------------------------------------------------------------------
void MainSystem::OnChangeSelectedZone( s32 newPaneNo )
{
  // eLXgXV
  m_view->UpdatePlaceText( newPaneNo );

  // ANeBuSEĐ܂傤
  xy_snd::PlaySE( SEQ_SE_SELECT1 );
}


//------------------------------------------------------------------
/**
 * @brief ̃][Iꂽۂ̒ʒm
 *
 * @param  selectedPainID IꂽyChc
 *         ][f[^̓yCԍL[ɋt\B
 */
//------------------------------------------------------------------
void MainSystem::OnDecideZone( s32 selectedPainID )
{
  // @TODO Ɍ莞ANVLq
}

//=============================================================================================
/**
 * @brief	莝EBOX|Pݒ
 *
 * @param   none		
 */
//=============================================================================================
void MainSystem::PreSearchMyBox_Temochi( void )
{
  // 莝
  int num = mainWork.prm->pPokeParty->GetMemberCount();
  for(int i=0;i<pml::PokeParty::MAX_MEMBERS;i++){
    if(i<num){
      pml::pokepara::PokemonParam *pokePara = mainWork.prm->pPokeParty->GetMemberPointer(i);
      if(pokePara->IsEgg(pml::pokepara::CHECK_BOTH_EGG)){
        m_view->SetBoxPokeExist( 0, i, 17 );  // ^}SƂĈ
      }else{
        m_view->SetBoxPokeExist( 0, i, pokePara->GetType1() );  // 푰i[
      }
    }else{
      m_view->SetBoxPokeExist( 0, i, -1 );  // Ȃ
    }
  }

  // {bNX
  int traynum = savedata::BoxPokemon::TRAY_POKE_MAX;
  pml::pokepara::CoreParam *corePara = GFL_NEW( m_heap.pHeap ) pml::pokepara::CoreParam( m_heap.pHeap );
  for(int n=0;n<savedata::BOX::TRAY_MAX;n++){
    for(int i=0;i<savedata::BoxPokemon::TRAY_POKE_MAX;i++){
      if(mainWork.prm->pSaveBoxPokemon->CheckPokemon( n, i, m_heap.pHeap )!=false){
        mainWork.prm->pSaveBoxPokemon->GetPokemon( corePara, n, i );
        m_view->SetBoxPokeExist( n+1, i, corePara->GetType1()); // 푰̎擾
      }else{
        m_view->SetBoxPokeExist( n+1, i, -1 ); //Ȃ
      }
    }
  }
  GFL_DELETE corePara;

#ifdef PM_DEBUG
  int count=0;
  for(int i=0;i<6;i++){
    if(m_view->GetBoxPokeExist(0,i)>=0){
      count++;
    }
  }
  for(int n=0;n<31;n++){
    for(int i=0;i<30;i++){
      if(m_view->GetBoxPokeExist(n+1,i)>=0){
        count++;
      }
    }
  }

  GFL_PRINT("p num=%d\n", count);
#endif
}



  }		// gts
}		// app

