//============================================================================================
/**
 * @file		gts_graphic.h
 * @brief		OtBbN֘A
 * @author	Akito Mori
 * @date		12.06.12
 *
 * namespace	app::gts::
 *
 */
//============================================================================================
#if !defined( __GTS_GRAPHIC_H__ )
#define __GTS_GRAPHIC_H__

#include <pm_version.h>
#include <print/xy_msgWin.h>
#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/util/app_util_3d.h>
#include "app/tool/app_tool_MenuWindow.h"
#include "app/tool/app_tool_MenuWindowSystem.h"
#include "app/tool/app_tool_BoxPokeModel.h"
#include "app/tool/app_tool_TimeIcon.h"
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>
#include <poke_tool/poke_model_sys.h>
#include <poke_tool/poke_model.h>
#include <netapp/gts/gts.h>
#include "GtsUIListener.h"
#include "common_res/poke_icon.h"


#include <system/weather/WeatherDefine.h>

namespace netapp {
namespace gts {

class GraphicWork : public app::ui::UIView, public app::ui::UIInputListener
{
public:
  /// [UIInputListener::OnLayoutPaneEvent()]ŒʒmyCID
  typedef enum {
    RESPONSE_UNKNOWN,       ///< syC
    RESPONSE_PANE_SEARCH,   ///< 
    RESPONSE_PANE_RETURN,   ///< ߂
  }RESPONSE_PANE_ID;

  enum MENU_CHOICE {
    MENU_TRADE_POKE=0,    ///< ɂ
    MENU_CHECK_POKE,      ///< 悳݂
    MENU_PICKUP_POKE,     ///< Ɍ
    MENU_STOP,            ///< ߂
  };

  enum MENU_MODE{
    MENU_MODE_2CHOICE=0,
    MENU_MODE_3CHOICE,
  };

  enum POKEMODEL_STATE{
    POKEMODEL_NONE=0, ///< 
    POKEMODEL_INIT,   ///< ̂
    POKEMODEL_LOADED, ///< fǂݍݍς
    POKEMODEL_PUT,    ///< \
    POKEMODEL_RELEASE_REQ,///< NGXg
    POKEMODEL_RELEASE,///< ( ̌㌩Ԃցj
  };

  typedef enum {
    TL_PANE_SENDRECV,         // f[^M
    TL_PANE_MAIN,             // C
    TL_PANE_UPPER_LEFT_ON,    // ʍON
    TL_PANE_UPPER_LEFT_OFF,   // ʍOFF
    TL_PANE_UPPER_RIGHT_ON,   // ʉEON
    TL_PANE_UPPER_RIGHT_OFF,  // ʉEOFF
    TL_PANE_UPPER_POKE_INFO,  // ʃ|P\
  }TL_PANE_MODE;

  /// J[\ǂ̃][ɂĂȂꍇ̒l
  static const s32   UNKNOWN_PAIN = -1;

  /// |PACRCAEgf[^ɓo^Ă鐔 
	static const u32 ICON_MAX = savedata::BoxPokemon::TRAY_POKE_MAX * 3 + pml::PokeParty::MAX_MEMBERS;

  // ʂɕ\|PfOf[^̐
  static const int POKEMODEL_NUM = 2;

  /// {bNXƂĂ|P̐=6+31*30
  static const int ALL_POKE_NUM = pml::PokeParty::MAX_MEMBERS + savedata::BOX::TRAY_MAX*savedata::BoxPokemon::TRAY_POKE_MAX; 

private:
  // AjID
  typedef enum {
    // 
    ANMID_UPPER_WEATHER_CLOUDY = 0,
    ANMID_UPPER_WEATHER_RAIN,
    ANMID_UPPER_WEATHER_SNOW,
    ANMID_UPPER_WEATHER_SUNNY,
    ANMID_UPPER_MAX,
    // 
    ANMID_LOWER_BIG_SCALE = 0,
    ANMID_LOWER_CURSOR,
    ANMID_LOWER_HERO,
    ANMID_LOWER_SMALL_SCALE,
    ANMID_LOWER_MAX
  }ANIME_ID;

  // CAEgID
  typedef enum {
    GTS_LAYOUT_ID_UPPER = 0,
    GTS_LAYOUT_ID_LOWER,
    GTS_LAYOUT_ID_MAX,
  }LAYOUT_ID;

  typedef struct{
    int x,y;
    int tray;
  }CURSOR_POS;

public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		heap		q[v
	 */
	//--------------------------------------------------------------------------------------------
	GraphicWork( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~GraphicWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief p[^̃|C^n
	 */
	//--------------------------------------------------------------------------------------------
  void SetAppParam( netapp::gts::APP_PARAM *AppParam );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void Draw(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   XP[ACR̃Ajݒ
   *
   * @param   isBigIcon g厞̃ACRɕύXȂtrueAʏ펞̃ACRɕύXȂfalseݒ
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetScaleIcon( bool isBigIcon );

  //--------------------------------------------------------------------------------------------
   /**
    * @brief   J[\ʒuɑyChc擾
    *
    * @param   cursorPos J[\ʒu
    * @param   hitPanePos yCWi[BNULLw肷邱Ƃ\
    *
    * @return  ghsyChcBǂɂghsȂꍇ́|Pԋp
    */
   //--------------------------------------------------------------------------------------------
  s32 GetPaneIdWithCursorPos( const gfl::math::VEC3& cursorPos, gfl::math::VEC3* hitPanePos=NULL );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief lACRpyCʒu̎擾
   *
   * @param none
   *
   * @return lACRpyCʒu
   */
  //--------------------------------------------------------------------------------------------
  gfl::math::VEC3 GetPlayerIconPanePos( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief n}pyCʒu̎擾
   *
   * @param none
   *
   * @return n}pyCʒu
   */
  //--------------------------------------------------------------------------------------------
  gfl::math::VEC3 GetMapPanePos( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief j[o[pyCTCY̎擾
   *
   * @param none
   *
   * @return j[o[pyCTCY
   */
  //--------------------------------------------------------------------------------------------
  const nw::lyt::Size GetMenuBarPaneSize( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief wyC̏ꏊɂ킹ĐeLXg{bNXXV
   *
   * @param paneId  XVΏۂƂȂyChc
   * @param townDat QƂ^Ef[^
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  void UpdatePlaceText( s32 painId );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief yCXV
   *
   * @param none
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  void UpdatePane( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief GtsData̒lƂɃyCXV
   *
   * @param isScroll  [in]    J[\ړɂ킹ăXN[Ȃtruew
   * @param moveX     [in]    J[\̂wړ
   * @param moveY     [in]    J[\̂xړ
   * @param scaleRate [in]    g嗦
   * @param mapPos    [in]    n}摜̒SWʒu
   * @param cursorPos [in/out]J[\̍Wʒu
   * @param scroll    [in/out]}bvXN[
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  void CalculateScreen( const bool isScroll, const float moveX, const float moveY, const float scaleRate, const gfl::math::VEC3 mapPos, gfl::math::VEC3& cursorPos, gfl::math::VEC3& scroll );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief ^E}bvpCxgXi[̓o^
   *
   * @param o^^E}bvthʒm惊Xi
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
  void SetGtsUIListener( GtsUIListener *listener );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief CAEgGfB^̃yChcGraphicWork::RESPONSE_PANE_ID֕ϊ
   *
   * @param paneId CAEgGfB^̃yChc
   *
   * @return RESPONSE_PANE_ID
   */
  //--------------------------------------------------------------------------------------------
  static RESPONSE_PANE_ID ConvertResponsePaneID( u32 paneId );


  //--------------------------------------------------------------------------------------------
  /**
   * @brief   |PXV
   *
   * @param   corePoke RA|Pp[^
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void UpdatePokeInfo( const pml::pokepara::CoreParam *coreParam );
  void DisappearPokeInfo( void );


  //--------------------------------------------------------------------------------------------
  /**
   * @brief   {bNXgCXV
   *
   * @param   corePoke RA|Pp[^
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void PrintTrayName( int trayno, gfl::str::StrBuf *strBuf );
  void PrintTemochiName(void);




  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);
  // ^b`pl͒ʒmpXi
  virtual bool OnTouchEvent( gfl::ui::TouchPanel* pTouchPanel, bool isTouch );
  // ^b`pl̃_uNbNʒmpXi
  virtual bool OnDoubleClickEvent( gfl::ui::TouchPanel * pTouchPanel );

  // {bNXʃ|Pf\
  void CreateBoxUpperPokeModel( const pml::pokepara::CoreParam * cp, app::util::Heap * heap );
  void DeleteBoxUpperPokeModel(void);

  // |Pf\
  void InitPokeModelSys( app::util::Heap * heap, gfl::fs::FileReadManager * man );
  void DeletePokeModelSys( void );
  void InitPokeModel( int index, const pml::pokepara::CoreParam *coreParam, app::util::Heap * heap );
  void FreePokeModel( int index );
  void UpdatePokeModel( int index );
  void DrawPokemodel(void); 
  


  // vACR
  void StartTimeIcon( app::util::Heap * heap );
  void EndTimeIcon( void );

  // 2E3j[Ăяo
  void StartSelectMenu( app::util::Heap * heap, int mode );
  int  SelectMenu_Main( void );
  void EndSelectMenu( void );

  /// PANE\E\Rg[
  void SetPaneCondition( TL_PANE_MODE paneMode );
  void SetPaneCondition( TL_PANE_MODE paneMode, const s8 *exist );
  void SetPokemonPaneOnOff( int src_tray, int des_tray );


  // BOXݏ
  void SetBoxPokeExist( int tray, int no, s8 value );
  s8   GetBoxPokeExist( int tray, int no );






private:

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Initialize2D( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief   yCAj̏
	 *
	 * @param   none
	 *
	 * @return  none
	 */
	//--------------------------------------------------------------------------------------------
	void InitPaneAnime( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ݂̓V؂ւ
   *
   * @param   isForceChange IɓVςꍇtrueAVɕωƂςȂfalsew
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetWeather( bool isForceChange );

  void Create3D( app::util::Heap * heap, gfl::fs::FileReadManager * man );
  void Delete3D(void);

  

  // J[\ړ
  void MoveCursor( float moveX, float moveY, bool isScroll );
  // XP[ύXɂJ[\XN[l̕ύX
  void SetCursorPosWithScale( float scale );
  // XP[ύXɂJ[\ړʒu̐ݒ
  void SetBackupCursorInfo( float targetScale );
  // J[\́uXEyCvւ̋z
  bool AdsorbCursorWithPane( void );
  // XP[؂ւ
  void ChangeScale( void );
  // J[\Rg[
  void ControlCursor( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick );
  // uXEyCvʒům葀
  bool DecideRoutePoint( void );

//  int _get_cursor_index( const CURSOR_POS cursor );

  // gCʒu̍Wݒ
  void SetTrayPosition( gfl::math::VEC3 *pos );

  void cursorMove( int mv );
  void trayMove( int mx );

  int  cursor2index( CURSOR_POS *cursor );
  void JudgePokeInfo( CURSOR_POS *cursor );


  inline void            SetCursorPos( const gfl::math::VEC3& pos );
  inline gfl::math::VEC3 GetCursorPos( void );

private:
  app::util::Heap           *heap;
  netapp::gts::APP_PARAM *m_appparam;   // ʐMp[^
  gfl::math::VEC3           m_cursorPos;      // J[\ʒu
  bool                      m_isDraw;         // `ς݃tO
  GtsUIListener*      m_townUIListener;   // ^E}bvthʒm惊Xi
  s32                       m_currentPlace;       // J[\Ăꏊ

	//{^j[pyC
  static const u32          BUTTON_PANE_LIST[2];
  //[g|CgpyC
  static const u32          POINT_PANE_LIST[7];

  app::tool::BoxUpper        *pBoxUpper;  ///< ʃ|PEChENX
	app::tool::BoxPokeModel    *pBoxUpperPokeModel; ///< ʃ|PfONX
	bool                       BoxUpperPokeModelFlag;  ///< fO\Ă邩
  app::tool::TimeIcon        *pTimeIcon;  ///< vACR
	common::resource::PokeIcon *pPokeIcon;  ///< |PACR\[X}l[W
	app::util::G3DUtil         *pG3dUtil;					///< 3D֘A
  poke_tool::PokeModelSystem *mPokeModelSys;  ///< |Pf\VXe
  poke_tool::PokeModel       *mPokeModel[POKEMODEL_NUM];  ///< |Pf\[N
  int                        m_pokemodel_state[POKEMODEL_NUM]; ///< |Pf\ԑJڃtO
  s8                         box_exist[ALL_POKE_NUM]; ///< ̏ꏊɃ|P邩H(Ȃ=-1,=ԍ)

  gfl::math::VEC3            TrayPosition; //
  gfl::math::VEC3            TrayPositionTable[32];
  int                        trayFlag;
  CURSOR_POS                 cursor;

  // j[EChEVXe
  app::tool::MenuWindow        *pMenuWin;
  app::tool::MenuWindowSystem  *pMenuWinSys;

};


}	// gts
}	// netapp
#endif // __GTS_GRAPHIC_H__
