//============================================================================================
/**
 * @file    gts_graphic.cpp
 * @brief    OtBbN֘Ai2D̂݁j
 * @author  Akito Mori
 * @date    12.06.12
 *
 * namespace  app::gts::
 *
 */
//============================================================================================
#include "gts_graphic.h"

#include "arc/arc_def.h"
#include "arc/message.gaix"
#include "message/msg_trade.h"

#include "res_gts_layout.gaix"
#include "res_gts_layout.h"
#include "res_gts_layout_pane.h"

#include "gts_table.cdat"

namespace netapp {
  namespace gts {




// A[JCuIDe[u
//static const gfl::fs::ArcFile::ARCID arcTbl[] = {
//  ARCID_GTS_GRA
//};

static const app::util::G2DUtil::LYT_RES_DATA LytResDataTbl[]={
  { ARCID_GTS_GRA, 0, 0 },
};

// Ajf[^iʁj
static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[] =
{
  LYTRES_RES_GTS_LAYOUT_GTS_LOWER_02_SIDEPANEL_SLIDEIN_BCLAN,
  LYTRES_RES_GTS_LAYOUT_GTS_LOWER_02_SIDEPANEL_SLIDEOUT_BCLAN,
  LYTRES_RES_GTS_LAYOUT_GTS_LOWER_05_SIDEPANEL_SLIDEIN_BCLAN,
  LYTRES_RES_GTS_LAYOUT_GTS_LOWER_05_SIDEPANEL_SLIDEOUT_BCLAN,
};


//{^j[pyC
const u32 GraphicWork::BUTTON_PANE_LIST[2] =
{
  PANENAME_GTS_LOWER_02_PANE_RETURN_ICON_POS,
};


//--------------------------------------------------------------------------------------------
/**
 * @brief    RXgN^
 *
 * @param    heap    q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap ) : app::ui::UIView(heap), m_cursorPos(0,0,0) 
{
  m_isDraw             = false;
  m_townUIListener     = NULL;

  CreateGraphicsSystem( heap );
  Initialize2D( heap );

  // q[ṽ|C^ێ
  this->heap = heap;

  // 3DVXe
  {
    gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gfl::fs::FileReadManager* file_read_manager = game_manager->GetFileReadManager();

    Create3D( heap, file_read_manager );
  }

  // {^}l[W
  u32 paneNum = sizeof(BUTTON_PANE_LIST) / sizeof(BUTTON_PANE_LIST[0]);
  CreateButtonManager( heap, GetLayoutWork(GTS_LAYOUT_ID_LOWER), BUTTON_PANE_LIST, paneNum );

  // InputXi[N
  SetInputListener( this );

  // {bNXgCʒu
  {
   gfl::math::VEC3 pos;
   pos.x = 0;
   pos.y = 0;
   pos.z = 0;
   SetTrayPosition( &pos );
  }

  // vACR
  pTimeIcon = NULL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief    fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork(void)
{
  // |Pf`VXe
  DeletePokeModelSys();

  // |Pʃ[N
  pBoxUpper->DeleteMessage();
  pBoxUpper->DeleteLayout();
  GFL_DELETE pBoxUpper;

  // |PACRVXe
  GFL_DELETE pPokeIcon;


  Delete3D();
  Delete2D();
  DeleteGraphicsSystem();
}


//=============================================================================================
/**
 * @brief	p[^n
 *
 * @param   AppParam  ʐMp[^
 */
//=============================================================================================
void GraphicWork::SetAppParam( netapp::gts::APP_PARAM *AppParam )
{
  m_appparam = AppParam;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief    Abvf[g
 *
 * @param    none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  app::ui::UIView::Update();
  pBoxUpper->Update();

  UpdatePokeModel(0);
  UpdatePokeModel(1);

  // BOX|Pf`
	pG3dUtil->CalculateG3dScene();
	pBoxUpperPokeModel->Update();
	pBoxUpperPokeModel->UpdateAnime();
	pG3dUtil->Update3D( false );


  // XN[lXV̈
  MoveCursor(0.0f, 0.0f, false);
  
  if(pTimeIcon!=NULL){
    if(pTimeIcon->Start()==false){
      pTimeIcon->SetVisible( true );
      pTimeIcon->Update();
    }
  }

  // {֐͍ŌɎsĂI
  UpdatePane();
}

void GraphicWork::DrawPokemodel(void)
{
  gfl::grp::g3d::Scene *scene = pG3dUtil->GetScene();

  
  mPokeModelSys->DrawRareEffectOff();
  scene->StereoEdgeMapDraw( GetGraphicSystem(), pG3dUtil->GetUpperCamera() );
  mPokeModelSys->DrawRareEffectOn();
  
//  mScene->StereoPostEffectDraw(GetGraphicSystem(), GetUpperCamera());
//  mScene->CommandSaveStereoDraw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    `
 *
 * @param    none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
//  m_g2dUtil->Draw2D( m_graphicSystem, GTS_LAYOUT_ID_UPPER );

  m_g2dUtil->Draw2D( m_graphicSystem, GTS_LAYOUT_ID_UPPER );  // ʕ`
  pG3dUtil->Draw3D( GetGraphicSystem() );
  DrawPokemodel();   // O|Pf`
  pBoxUpper->Draw( GetGraphicSystem() );                            // {bNXʕ`
  m_g2dUtil->Draw2D( m_graphicSystem, GTS_LAYOUT_ID_LOWER );  // ʕ`


  // ԃACR
  if(pTimeIcon!=NULL){            
    pTimeIcon->Draw(  );
  }

  // Ij[
  if( pMenuWinSys != NULL ){
    pMenuWinSys->DrawMenuWindow();
  }

  m_isDraw = true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief    2D֘A쐬
 *
 * @param    heap    q[v
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Initialize2D( app::util::Heap * heap )
{
  // CAEgf[^
  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    { // 
      0,
      // @todo ʃCAEgf[^͉
      LYTRES_RES_GTS_LAYOUT_GTS_UPPER_01_BCLYT,     // resID̃CAEgf[^ID
      NULL,                      // Aj[Vf[^IDe[u AĵȂꍇNULL
      0,          // Aj[Vf[^IDe[u AĵȂꍇ0
      0,          // o^Aj[Vő吔
      false,                              // \yCɍsvZs
      app::util::G2DUtil::SETUP_UPPER,    // fBXvC
      true,                               // \ݒ
    },
    { // 
      0,
      LYTRES_RES_GTS_LAYOUT_GTS_LOWER_01_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };

  Create2D( heap, NULL, GTS_LAYOUT_ID_MAX,
                  LytResDataTbl, GFL_NELEMS(LytResDataTbl),
                  layoutData, GFL_NELEMS(layoutData),
                  GARC_message_trade_DAT );

  InitPaneAnime();

  // |Pʏ
  pBoxUpper = GFL_NEW(heap->pHeap) app::tool::BoxUpper( GetLayoutSystem(), heap->pHeap, heap->pDevHeapAllocator);

  pBoxUpper->LoadLayoutResource();
  pBoxUpper->LoadWazaIconResource();
  pBoxUpper->LoadStatusResource();

  pBoxUpper->CreateLayout();
  pBoxUpper->CreateMessage();

  pBoxUpper->WriteDefaultPane();

  // |PACRNX
  pPokeIcon = GFL_NEW( heap->pHeap ) common::resource::PokeIcon( heap->pHeap, 
                                      heap->pDevHeap, 
                                      ICON_MAX+savedata::BoxPokemon::TRAY_POKE_MAX );
  pPokeIcon->OpenArcFile( heap->pHeap, gfl::fs::ArcFile::OPEN );

}


//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create3D( app::util::Heap * heap, gfl::fs::FileReadManager * man )
{
  pG3dUtil = GFL_NEW( heap->pHeap ) app::util::G3DUtil();

  pG3dUtil->CreateG3dSystem( heap );
  pG3dUtil->CreateG3dScene( app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, heap );

  // JvOō쐬
  const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
  {
    {
      gfl::math::VEC3(0.0f,0.0f,1.0f),
      gfl::math::VEC3(0.0f,0.0f,0.0f),
      1.0f,
      1000.0f,
      gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
      0.0f,
      gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
      gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
      gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
    },
  };
  pG3dUtil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );

  pG3dUtil->CreateEdgeSystem( GetGraphicSystem(), app::util::G3DUtil::EDGE_SET_FLAG_UPPER, heap );

  pG3dUtil->SetupG3dScene();

  // {bNXʃ|Pf\VXe
  pBoxUpperPokeModel = GFL_NEW( heap->pHeap )	app::tool::BoxPokeModel( heap->pHeap, heap->pHeapAllocator, heap->pDevHeapAllocator, man );
  BoxUpperPokeModelFlag = false;

  // |Pf\VXe
  InitPokeModelSys( heap, man);
  mPokeModel[0] = NULL;
  mPokeModel[1] = NULL;

}
//poke_tool::PokeModelSystem * GetPokeModelSystem(void);
//=============================================================================================
/**
 * @brief   |Pf`VXe
 *
 * @param   heap	HEAP
 * @param   man		t@C[h}l[W[
 */
//=============================================================================================
void GraphicWork::InitPokeModelSys( app::util::Heap * heap, gfl::fs::FileReadManager * man )
{
  //VXe̍쐬
//  mPokeModelSys = GFL_NEW( heap->pHeap ) poke_tool::PokeModelSystem();
//  mPokeModelSys->InitSystem( heap->pHeapAllocator, heap->pDevHeapAllocator, man );

  // BOXʂ̃|PfVXẽ|C^n
  mPokeModelSys = pBoxUpperPokeModel->GetPokeModelSystem();
  
}

//=============================================================================================
/**
 * @brief   |Pfǂݍ݁E\Jn
 *
 * @param   index		  0:A1:
 * @param   coreParam	|Pf
 * @param   heap		  HEAP
 */
//=============================================================================================
void GraphicWork::InitPokeModel( int index, const pml::pokepara::CoreParam *coreParam, app::util::Heap * heap )
{
  if(mPokeModel[index]==NULL){
    //fIvV  
    poke_tool::PokeModel::SetupOption opt;
    opt.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
    opt.isAsync = true; //񓯊ǂݍ
    //f̍쐬(PokeParamECoreParamEڎw(SimpleParam)܂B
    mPokeModel[index] = mPokeModelSys->CreateModelCoreParam( coreParam , heap->pHeapAllocator,
                                                      heap->pDevHeapAllocator ,&opt );
    m_pokemodel_state[index] = POKEMODEL_INIT;

    
  }else{
    GFL_ASSERT_MSG( 0, "mPokeModel[%d]͊ɓǂݍݍς݂ł\n",index );
  }
}

//=============================================================================================
/**
 * @brief   |Pf`XV
 *
 * @param   index   0:,1:
 */
//=============================================================================================
void GraphicWork::UpdatePokeModel( int index )
{
  const gfl::math::VEC3 tbl[]={
    gfl::math::VEC3( -80.0f, -20.0f, -280.0f ),
    gfl::math::VEC3(  80.0f, -20.0f, -280.0f ),
  };
  //ǂݍݑ҂
  if( mPokeModel[index]!=NULL){
    switch( m_pokemodel_state[index] ){
    case POKEMODEL_NONE:
      break;
    case POKEMODEL_INIT:
      if(mPokeModel[index]->IsFinishLoad()){
        m_pokemodel_state[index] = POKEMODEL_LOADED;
        GFL_PRINT("POKEMODEL_INIT\n");
      }
      break;
    case POKEMODEL_LOADED:
      {
        gfl::grp::g3d::Scene *scene = pG3dUtil->GetScene();
        //f쐬EV[֒ǉ
        mPokeModel[index]->Create();
        mPokeModel[index]->AddScene(scene);
        mPokeModel[index]->SetPosition( tbl[index].x, tbl[index].y, tbl[index].z);
        mPokeModel[index]->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );  // 퓬[VAőҋ@
        mPokeModel[index]->PlayAnime();


        m_pokemodel_state[index] = POKEMODEL_PUT;
        GFL_PRINT("POKEMODEL_LOADED\n");
      }
      break;
    case POKEMODEL_PUT:
      break;
    case POKEMODEL_RELEASE_REQ:
      m_pokemodel_state[index] = POKEMODEL_RELEASE;
      GFL_PRINT("POKEMODEL_RELEASE_REQ\n");
      break;
    case POKEMODEL_RELEASE:
      mPokeModelSys->DeleteModel( mPokeModel[index] );
      mPokeModel[index] = NULL;
      m_pokemodel_state[index] = POKEMODEL_NONE;
      GFL_PRINT("POKEMODEL_RELEASE\n");
      break;
    }
  }
}


//=============================================================================================
/**
 * @brief   |PfE\OFF
 *
 * @param   index  0: A1:  
 */
//=============================================================================================
void GraphicWork::FreePokeModel( int index )
{
  if(mPokeModel[index]!=NULL){
    gfl::grp::g3d::Scene *scene = pG3dUtil->GetScene();
    //f̉
    mPokeModel[index]->RemoveScene(scene);
    m_pokemodel_state[index] = POKEMODEL_RELEASE_REQ;
  }
}

//=============================================================================================
/**
 * @brief	|Pf`VXe
 *
 * @param   none
 */
//=============================================================================================
void GraphicWork::DeletePokeModelSys( void )
{
  //f̉
  FreePokeModel( 0 );
  FreePokeModel( 1 );
  
  //VXẻ
//  mPokeModelSys->ExitSystem();
//  GFL_DELETE mPokeModelSys;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete3D(void)
{
  DeleteBoxUpperPokeModel();
  GFL_DELETE pBoxUpperPokeModel;

  pG3dUtil->DeleteEdgeSystem();

  pG3dUtil->DeleteG3dCamera();

  pG3dUtil->DeleteG3dScene();
  pG3dUtil->DeleteG3dSystem();

  GFL_DELETE	pG3dUtil;
}



//--------------------------------------------------------------------------------------------
//	|Pf
//--------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------
/**
 * @brief   |Pf\o^
 *
 * @param   coreParam |Pp[^
 * @param   heap      q[v
 *
 * ɕ\ĂƂ͉sȂiDeleteKvj
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateBoxUpperPokeModel( const pml::pokepara::CoreParam * cp, app::util::Heap * heap )
{
  if( cp->IsNull() != false || BoxUpperPokeModelFlag){
    return;
  }
  pBoxUpperPokeModel->Create( cp, pG3dUtil->GetScene() );
  BoxUpperPokeModelFlag = true;

}


//--------------------------------------------------------------------------------------------
/**
 * @brief   |Pf\
 *
 * ɕ\Ă鎞͂̊֐ŉKv
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteBoxUpperPokeModel(void)
{
  if(BoxUpperPokeModelFlag == false){
    return;
  }
	pBoxUpperPokeModel->Delete();
  BoxUpperPokeModelFlag = false;
}




//--------------------------------------------------------------------------------------------
/**
 * @brief ^E}bvpCxgXi[̓o^
 *
 * @param o^^E}bvthʒm惊Xi
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetGtsUIListener( GtsUIListener *listener )
{
  m_townUIListener = listener;
}




//--------------------------------------------------------------------------------------------
/**
 * @brief   yCAj̏
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::InitPaneAnime( void )
{
  // Aj[VJn
  //@TODO V̎󂯓n@mȈׁAV؂ւ͕ۗ
//  m_g2dUtil->StartAnime( GTS_LAYOUT_ID_LOWER, ANMID_LOWER_CURSOR        );
//  m_g2dUtil->StartAnime( GTS_LAYOUT_ID_LOWER, ANMID_LOWER_HERO          );

  gamesystem::GameManager*     gameMgr    = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
}






//--------------------------------------------------------------------------------------------
/**
 * @brief CAEgGfB^̃yChcGraphicWork::RESPONSE_PANE_ID֕ϊ
 *
 * @param paneId CAEgGfB^̃yChc
 *
 * @return RESPONSE_PANE_ID
 */
//--------------------------------------------------------------------------------------------
GraphicWork::RESPONSE_PANE_ID GraphicWork::ConvertResponsePaneID( u32 paneId )
{
  switch( paneId )
  {
    case  PANENAME_GTS_LOWER_02_PANE_RETURN_ICON_POS:
      return  RESPONSE_PANE_RETURN;

    default:
      return RESPONSE_UNKNOWN;
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief wyC̏ꏊɂ킹ĐeLXg{bNXXV
 *
 * @param paneId  XVΏۂƂȂyChc
 * @param townDat QƂ^Ef[^
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::UpdatePlaceText( s32 painId )
{
  const u32      placeMax    = 6;
  short          infoMessage = -1;
  short          placeMessage[placeMax]={0};


  // @TODO 
//  townName = placeMessage[0];

//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_MAPNAME,   townName );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_00,  placeMessage[0] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_01,  placeMessage[1] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_02,  placeMessage[2] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_03,  placeMessage[3] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_04,  placeMessage[4] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_PLACE_05,  placeMessage[5] );
//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_UPPER, PANENAME_GTS_UPPER_PANE_INFO_TEXT, infoMessage );

//  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_LOWER, PANENAME_GTS_LOWER_PANE_MAPNAME,   townName );


  //gfl::str::STRCODE GetTrayName( u32 tray )
  //gfl::str::STRCODE	trayName[ TRAY_MAX ][ TRAY_NAME_BUFSIZE ];	// {bNX
}


//--------------------------------------------------------------------------------------------
/**
 * @brief yCXV
 *
 * @param none
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::UpdatePane( void )
{
  const nw::lyt::Size cursorSize = GetPaneSize( GTS_LAYOUT_ID_LOWER, PANENAME_GTS_LOWER_01_PANE_LIST_03 );

  gfl::math::VEC3 cursorPos = GetCursorPos();

  // WύX
  SetPanePos( GTS_LAYOUT_ID_LOWER, PANENAME_GTS_LOWER_01_PANE_LIST_03, &cursorPos );

}


const int tray_tbl[][4]={
  {   0,       110, 0, 0,},
  { 155,       200, 1, 1},
  { 155+200*1, 200, 2, 2},
  { 155+200*2, 200, 3, 3},
  { 155+200*3, 200, 4, 1},
  { 155+200*4, 200, 5, 2},
  { 155+200*5, 200, 6, 3},
  { 155+200*6, 200, 7, 1},
  { 155+200*7, 200, 8, 2},
  { 155+200*8, 160, 0, 3},
};

const int tary2pane[]={
  PANENAME_GTS_LOWER_02_PANE_TEXTBOX_02,
  PANENAME_GTS_LOWER_02_PANE_TEXTBOX_03,
  PANENAME_GTS_LOWER_02_PANE_TEXTBOX_04,
  PANENAME_GTS_LOWER_02_PANE_TEXTBOX_05,
};

//--------------------------------------------------------------------------------------------
/**
 * @brief gC̍WXV
 *
 * @param pos gCXN[W
 *
 * @return none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTrayPosition( gfl::math::VEC3 *pos )
{
  gfl::math::VEC3 box1, box2, box3, box4,box;

  if(pos->x > 1460){
    pos->x = pos->x - (1460+208);
  }
  if(pos->x < -1412){
    pos->x = pos->x + (1460+208);
  }

//  GFL_PRINT("trayPos=%f\n", pos->x );

  // ړʂ牼z̃gCWZo
  for(int i=0;i<9;i++){
    box1 = GetPanePos( GTS_LAYOUT_ID_LOWER, PANENAME_GTS_LOWER_02_PANE_BG_00 );
    TrayPositionTable[i]   = box1;
    TrayPositionTable[i].x = pos->x + tray_tbl[i][0];
    if(TrayPositionTable[i].x > 1443 ){
      TrayPositionTable[i].x -= (155+200*8-50);
    }
//    GFL_PRINT( "tray%d: %f,", i,TrayPositionTable[i].x);
  }
//  GFL_PRINT( "\n" );

  // ړʉʂɓgCyCŕ\
  for(int i=0;i<9;i++){
    if(TrayPositionTable[i].x > -260 && TrayPositionTable[i].x <320){
      box   = GetPanePos( GTS_LAYOUT_ID_LOWER, tary2pane[tray_tbl[i][3]] );
      box.x = TrayPositionTable[i].x;
      SetPanePos( GTS_LAYOUT_ID_LOWER, tary2pane[tray_tbl[i][3]], &box );
    }
  }
  GFL_PRINT("box.y=%f\n", box.y);

}






//--------------------------------------------------------------------------------------------
/**
 * @brief j[o[pyCTCY̎擾
 *
 * @param none
 *
 * @return j[o[pyCTCY
 */
//--------------------------------------------------------------------------------------------
const nw::lyt::Size GraphicWork::GetMenuBarPaneSize( void )
{
  return GetPaneSize( GTS_LAYOUT_ID_LOWER, PANENAME_GTS_LOWER_02_PANE_TOUCHBAR_POS );
}


//--------------------------------------------------------------------------------------------
// }bvJ[\ړ
//--------------------------------------------------------------------------------------------
void GraphicWork::MoveCursor( float moveX, float moveY, bool isScroll )
{
  gfl::math::VEC3       cursorPos  = GetCursorPos();

  // J[\ʒuR~bg
  SetCursorPos( cursorPos );

}






//--------------------------------------------------------------------------------------------
// }bvJ[\쏈
//--------------------------------------------------------------------------------------------
void GraphicWork::ControlCursor( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick )
{
  s32  moveX       = 0;  // Xړ
  s32  moveY       = 0;  // Yړ
  s32  moveSpeed   = 3;  // ړx
  s32  moveDir     = app::ui::UIResponder::GetDirectionFlag( *pKey, *pStick );

  // L[
  if( (moveDir & gfl::ui::BUTTON_UP) != 0 ){
    moveY  = moveSpeed;
  }
  else if( (moveDir & gfl::ui::BUTTON_DOWN) != 0 ){
    moveY  = -moveSpeed;
  }
  if( (moveDir & gfl::ui::BUTTON_LEFT) != 0 ){
    moveX  = -moveSpeed;
  }
  else if( (moveDir & gfl::ui::BUTTON_RIGHT) != 0 ){
    moveX  = moveSpeed;
  }

  // J[\ړ
  if( (moveX != 0) || (moveY != 0) )
  {
    MoveCursor(moveX, moveY, false);
  }
}


//--------------------------------------------------------------------------------------------
// yCANVʒmpXi
//--------------------------------------------------------------------------------------------
bool GraphicWork::OnLayoutPaneEvent( const u32 painId )
{
  GraphicWork::RESPONSE_PANE_ID response = GraphicWork::ConvertResponsePaneID( painId );

  switch( response )
  {
    case  GraphicWork::RESPONSE_PANE_SEARCH:
//      ChangeScale();
      return false;

    case  GraphicWork::RESPONSE_PANE_RETURN:
      if( m_townUIListener != NULL ){
        m_townUIListener->OnMenuReturnAction();
      }
      return false;
  }
  return true;
}


//--------------------------------------------------------------------------------------------
// ^b`pl͒ʒmpXi
//--------------------------------------------------------------------------------------------
bool GraphicWork::OnTouchEvent( gfl::ui::TouchPanel* pTouchPanel, bool isTouch )
{
  // ^b`Ă
  if( isTouch )
  {
    const nw::lyt::Size barSize  = GetMenuBarPaneSize();
    s16                 displayX = pTouchPanel->GetX();
    s16                 displayY = pTouchPanel->GetY();

    // j[o[GA̓^b`ΏۊO
    // @TODO z}ł͕sv
    if( displayY >= (DISPLAY_LOWER_HEIGHT-barSize.height) ){
      return true;
    }

    // ߂ă^b`I
    if( pTouchPanel->IsTouchTrigger() )
    {
      // ʍW烌CAEgWɕϊAJ[\ݒ
      gfl::math::VEC3 cursorPos( (displayX-(DISPLAY_LOWER_WIDTH/2)), ((DISPLAY_LOWER_HEIGHT/2)-displayY), 0.0f );
      SetCursorPos( cursorPos );

    }
    // hbOH
    else
    {
      MoveCursor( pTouchPanel->GetMoveX(), -pTouchPanel->GetMoveY(), true );
    }
    return false;
  }
  return true;
}


//=============================================================================================
/**
 * @brief	|Pʂ̍XV
 *
 * @param   coreParam
 */
//=============================================================================================
void GraphicWork::UpdatePokeInfo( const pml::pokepara::CoreParam *coreParam )
{
  pBoxUpper->WritePokeInfo( coreParam );
  pBoxUpper->PutInfo( true, coreParam );
	pBoxUpperPokeModel->SetVisible( true );

}

//=============================================================================================
/**
 * @brief	BOX|Pʂ̕\OFF
 *
 * @param   none		
 */
//=============================================================================================
void GraphicWork::DisappearPokeInfo( void )
{
  pBoxUpper->PutInfo( false, NULL );
	pBoxUpperPokeModel->SetVisible( false );
}

const int boxname_pane_tbl[]={
  PANENAME_GTS_LOWER_01_PANE_TEXTBOX_05,
  PANENAME_GTS_LOWER_01_PANE_TEXTBOX_00,
  PANENAME_GTS_LOWER_01_PANE_TEXTBOX_01,
};

//=============================================================================================
/**
 * @brief	gC
 *
 * @param   trayno 0-3
 * @param   strBuf {bNX擾gC
 */
//=============================================================================================
void GraphicWork::PrintTrayName( int trayno, gfl::str::StrBuf *strBuf )
{
  SetTextboxPaneString( GraphicWork::GTS_LAYOUT_ID_LOWER, boxname_pane_tbl[trayno], strBuf );
}



// uĂv`
void GraphicWork::PrintTemochiName(void)
{
  SetTextboxPaneMessage( GraphicWork::GTS_LAYOUT_ID_LOWER,   PANENAME_GTS_LOWER_01_PANE_TEXTBOX_05, msg_trade_01_01 );
}

//--------------------------------------------------------------------------------------------
// ^b`pl̃_uNbNʒmpXi
//--------------------------------------------------------------------------------------------
bool GraphicWork::OnDoubleClickEvent( gfl::ui::TouchPanel * pTouchPanel )
{
  return true;
}


//--------------------------------------------------------------------------------------------
// L[͒ʒmpXi
//--------------------------------------------------------------------------------------------
bool GraphicWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{

  if( pKey->IsHold( gfl::ui::BUTTON_A)){
    if( pKey->IsRepeat( gfl::ui::BUTTON_LEFT ) )
    {
      TrayPosition.x += 48;
      SetTrayPosition( &TrayPosition );
    }
    else if( pKey->IsRepeat( gfl::ui::BUTTON_RIGHT ) )
    {
      TrayPosition.x -= 48;
      SetTrayPosition( &TrayPosition );
    }    
    return false;
  }
  if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    if( m_townUIListener != NULL ){
      m_townUIListener->OnMenuReturnAction();
      return false;
    }
  }
  else if( pKey->IsRepeat( gfl::ui::BUTTON_UP ) )
  {
    cursorMove( 0 );
    return false;
  }
  else if( pKey->IsRepeat( gfl::ui::BUTTON_DOWN ) )
  {
    cursorMove( 1 );
    return false;
  }
  else if( pKey->IsRepeat( gfl::ui::BUTTON_LEFT ) )
  {
    cursorMove( 2 );
    return false;
  }
  else if( pKey->IsRepeat( gfl::ui::BUTTON_RIGHT ) )
  {
    cursorMove( 3 );
    return false;
  }
  else if( pKey->IsTrigger( gfl::ui::BUTTON_X ) ){
    StartTimeIcon( heap );
  }
  else if( pKey->IsTrigger( gfl::ui::BUTTON_Y ) ){
    EndTimeIcon();
  }
  else if( pKey->IsTrigger( gfl::ui::BUTTON_R ) ){
    if(pMenuWin==NULL){
      StartSelectMenu( heap, 0 );
    }
  }
  else if( pKey->IsTrigger( gfl::ui::BUTTON_L ) ){
    if(mPokeModel[0]==NULL){
//      pml::pokepara::PokemonParam *pokePara = m_appparam->pPokeParty->GetMemberPointer(0);
//      InitPokeModel( 0, pokePara, heap );
      pml::pokepara::CoreParam *corePara = GFL_NEW( heap->pHeap ) pml::pokepara::CoreParam( heap->pHeap );
      m_appparam->pSaveBoxPokemon->GetPokemon( corePara, 0, 22 );
      InitPokeModel( 0, corePara, heap );
      m_appparam->pSaveBoxPokemon->GetPokemon( corePara, 0, 10 );
      InitPokeModel( 1, corePara, heap );
      GFL_DELETE corePara;
    }else{
      FreePokeModel( 0 );
      FreePokeModel( 1 );
    }
  }
  else if( pKey->IsRepeat( gfl::ui::BUTTON_A ) )
  {
//    TrayPosition.x -= 16;
//    SetTrayPosition( &TrayPosition );
    return false;
  }
#if 0
  else if( pKey->IsRepeat( gfl::ui::BUTTON_RIGHT ) )
  {
    TrayPosition.x += 16;
    SetTrayPosition( &TrayPosition );
    return false;
  }
#endif


  return true;
}


//=============================================================================================
/**
 * @brief	ԃACR\X^[g
 *
 * @param   heap		
 */
//=============================================================================================
void GraphicWork::StartTimeIcon( app::util::Heap * heap )
{
  static const gfl::grp::g2d::LytWkSetUp lyt_wk_setup =
  {
    gfl::math::VEC3(0,-290,0),  // pos
    gfl::math::VEC2(1,1),       // scale
    gfl::math::VEC3(0,0,0),     // rotate
    0,                          // priority
    0                           // groupID
  };

  app::tool::TimeIcon::CREATE_DATA initData;

  // ɋNς݂疳
  if(pTimeIcon!=NULL){
    GFL_PRINT("2dNłI\n");
    return;
  }

  initData.heap           = heap->pHeap;
  initData.devHeap        = heap->pDevHeap;
  initData.devAllocator   = heap->pDevHeapAllocator;
  initData.graSys         = GetGraphicSystem();
  initData.lytSys         = GetLayoutSystem();
  initData.setup          = lyt_wk_setup;
  initData.threadPriority = gfl::base::Thread::DefaultPriority;
  initData.pos            = gfl::math::VEC3( 125.0, 0.0, 0.0 );
  initData.isAutoDraw     = false;

  pTimeIcon = GFL_NEW( heap->pHeap ) app::tool::TimeIcon( &initData );
}

//=============================================================================================
/**
 * @brief	ԃACR\I
 *
 * @param   none		
 */
//=============================================================================================
void GraphicWork::EndTimeIcon( void )
{
  if( pTimeIcon != NULL )
  {
    pTimeIcon->End();

    GFL_DELETE pTimeIcon;
    pTimeIcon = NULL;
  }else{
    GFL_PRINT("ԃACRNĂȂ\n");
  }
  
}


const app::tool::MenuWindow::AlternativeParameter select_menu_tbl3[] = {
  { 0, 0, netapp::gts::GraphicWork::MENU_TRADE_POKE, false, false, },
  { 1, 0, netapp::gts::GraphicWork::MENU_CHECK_POKE, false, false, },
  { 2, 0, netapp::gts::GraphicWork::MENU_STOP,       true,  true, },
};
const app::tool::MenuWindow::AlternativeParameter select_menu_tbl2[] = {
  { 0, 0, netapp::gts::GraphicWork::MENU_PICKUP_POKE, false, false, },
  { 1, 0, netapp::gts::GraphicWork::MENU_STOP,        true,  true, },
};

const u32 select_msg_tbl[]={
  msg_trade_02_02,  // 񂷂
  msg_trade_02_04,  // 悳݂
  msg_trade_02_01,  // Ăɂ݂
  msg_trade_cancel, // ߂
};

static const u32 TEMP_STR_LEN = 18;   // TCY

//=============================================================================================
/**
 * @brief Ij[Ăяo
 *
 * @param   heap		
 * @param   mode		2A3
 */
//=============================================================================================
void GraphicWork::StartSelectMenu( app::util::Heap * heap, int mode )
{
  int x =  148;
  int y = -120;
  int max = 3;
  gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );

  // j[VXe쐬
  pMenuWinSys = GFL_NEW_LOW( heap->pHeap ) app::tool::MenuWindowSystem(
                        heap->pHeap,
                        heap->pDevHeap,
                         pgm->GetUiDeviceManager(),
                        GetGraphicSystem(),
                        GetLayoutSystem(),
                        app::tool::MenuWindowSystem::INPUT_TYPE_RELEASE,
                        app::tool::MenuWindowSystem::DESIGN_APP,
                        app::tool::MenuWindowSystem::NOTIFY_AFTER_ANIME );
  // j[[N쐬
  app::tool::MenuWindow::MenuParameter menu_param = {
    gfl::grp::DISPLAY_LOWER,
    app::tool::MenuWindow::X_POSITION_TYPE_RIGHT,
    app::tool::MenuWindow::Y_POSITION_TYPE_BOTTOM,
    x,
    y,
    app::tool::MenuWindow::MIN_WINDOW_WIDTH,
    max,
    1,
    true
  };
  pMenuWin = GFL_NEW_LOW( heap->pHeap ) app::tool::MenuWindow( heap->pHeap, menu_param );

  // iIځjǉ
  {
    gfl::str::MsgData * msg = GFL_NEW_LOW( heap->pHeap ) gfl::str::MsgData(
                                                          ARCID_MESSAGE,
                                                          GARC_message_trade_DAT,
                                                          heap->pHeap,
                                                          gfl::str::MsgData::LOAD_PART );
    gfl::str::StrBuf *strbuf = GFL_NEW_LOW( heap->pHeap ) gfl::str::StrBuf( TEMP_STR_LEN, heap->pHeap );
  
    for(int i=0;i<max;i++){
      u32 msgid = select_menu_tbl3[i].value;
      msg->GetString( select_msg_tbl[msgid], *strbuf );
      pMenuWin->AddAlternative( select_menu_tbl3[i], strbuf );
    }
    GFL_DELETE strbuf;
    GFL_DELETE msg;
  }

  // IJn
  pMenuWinSys->SetMenuWindow( pMenuWin );
  pMenuWinSys->Start();

}
//=============================================================================================
/**
 * @brief	Ij[C
 *
 * @param   none		
 *
 * @retval  int		
 */
//=============================================================================================
int  GraphicWork::SelectMenu_Main( void )
{
  if(pMenuWinSys!=NULL){
    pMenuWinSys->UpdateControl();
    pMenuWinSys->UpdateView();
  
    if( pMenuWinSys->IsAlternativeSelected() == true ){
      int ret = pMenuWinSys->GetSelectedAlternativeValue();
      EndSelectMenu();
      return ret;
    }
  }
  return -1;
}

//=============================================================================================
/**
 * @brief	Ij[I
 *
 * @param   none		
 */
//=============================================================================================
void GraphicWork::EndSelectMenu( void )
{

  GFL_DELETE pMenuWinSys;
  pMenuWinSys = NULL;

  GFL_DELETE pMenuWin;
  pMenuWin = NULL;
  
}

//=============================================================================================
/**
 * @brief	yCON/OFF
 *
 * @param   paneMode  \[h(gts_main.hŒ`)
 */
//=============================================================================================
void GraphicWork::SetPaneCondition( TL_PANE_MODE paneMode )
{
  switch(paneMode){
  case TL_PANE_SENDRECV:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 1, lower_window_only_tbl[i].paneno, lower_window_only_tbl[i].onoff );
    }
//    GetG2DUtil()->SetPaneVisible( 0, PANENAME_TRADE_UPPER_MATERIAL_BASE_00, false );
//    GetG2DUtil()->SetPaneVisible( 1, PANENAME_TRADE_LOWER_PANE_BOX1, false );
//    GetG2DUtil()->SetPaneVisible( 1, PANENAME_TRADE_LOWER_PANE_BOX_BG, false );
    
    break;
  case TL_PANE_MAIN:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 1, lower_main_panel_tbl[i].paneno, lower_main_panel_tbl[i].onoff );
    }
//    GetG2DUtil()->SetPaneVisible( 0, PANENAME_TRADE_UPPER_MATERIAL_BASE_00, true );
    break;
  case TL_PANE_UPPER_LEFT_ON:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 0, upper_left_poke[i].paneno, true );
    }
    break;
  case TL_PANE_UPPER_LEFT_OFF:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 0, upper_left_poke[i].paneno, false );
    }
    break;
  case TL_PANE_UPPER_RIGHT_ON:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 0, upper_right_poke[i].paneno, true );
    }
    break;
  case TL_PANE_UPPER_RIGHT_OFF:
    for(int i=0;i<LOWER_PANE_GROUP_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 0, upper_right_poke[i].paneno, false );
    }
    break;
  case TL_PANE_UPPER_POKE_INFO:
    for(int i=0;i<UPPER_PANE_BOX_NUM;i++){
      GetG2DUtil()->SetPaneVisible( 0, upper_box_tray[i].paneno, false );
    }
    break;
  default:
    GFL_ASSERT_MSG(0,"ݒs\PANE[h\n");
  }
}

//=============================================================================================
/**
 * @brief	{bNX̃|PݏZbgi-1:ȂAꍇ͑j
 *
 * @param   tray		gCNO
 * @param   index		ꏊNO
 * @param   value		ݏi-1:ȂAꍇ͑j
 */
//=============================================================================================
void GraphicWork::SetBoxPokeExist( int tray, int index, s8 value )
{
  if(tray==0){
    box_exist[index] = value;
  }else{
    tray--;
    box_exist[pml::PokeParty::MAX_MEMBERS+tray*savedata::BoxPokemon::TRAY_POKE_MAX+index] = value;
  }
}

//=============================================================================================
/**
 * @brief	{bNX̃|Pݏ擾
 *
 * @param   tray		gCNO
 * @param   index		ꏊNO
 *
 * @retval  s8	ݏi-1:ȂAꍇ͑j
 */
//=============================================================================================
s8 GraphicWork::GetBoxPokeExist( int tray, int index )
{
  if(tray==0){
    return box_exist[index];
  }
  tray--;
  return box_exist[pml::PokeParty::MAX_MEMBERS+tray*savedata::BoxPokemon::TRAY_POKE_MAX+index];
}


// 0 1   6  7  8  9 10 11  35 36 37 38 39 40  65     95      125
// 2 3  12 13 14 15 16 17  41 42 43 44 45 46  
// 4 5  18 19 20 21 22 22  47 48 49 50 51 52  
//      23 24 25 26 27 28  53 54 55 56 57 58  
//      29 30 31 32 33 34  59 60 61 62 63 64     94     124      154


#define MV_BOX_L ( 100 )
#define MV_BOX_R ( 101 )

static const u8 temochi_tbl[][4]={
	// AAAE
	// 莝
	{ 4,2, MV_BOX_L, 1},
	{ 5,3, 0, MV_BOX_R},
	{ 0,4, MV_BOX_L, 3},
	{ 1,5, 2, MV_BOX_R},
	{ 2,0, MV_BOX_L, 5},
	{ 3,1, 4, MV_BOX_R},
};

//  0  1  2  3  4  5
//  6  7  8  9 10 11
// 12 13 14 15 16 17 
// 18 19 20 21 22 23
// 24 25 26 27 28 29

static const u8 box_tbl[][4]={
	{ 24,  6, MV_BOX_L, 1}, { 25, 7, 0, 2}, { 26, 8, 1, 3}, { 27, 9, 2, 4}, { 28, 10, 3, 5}, { 29, 11, 4, MV_BOX_R},
	{  0, 12, MV_BOX_L, 7}, {  1,13, 6, 8}, {  2,14, 7, 9}, {  3,15, 8,10}, {  4, 16, 9,11}, {  5, 17,10, MV_BOX_R},
	{  6, 18, MV_BOX_L,13}, {  7,19,12,14}, {  8,20,13,15}, {  9,21,14,16}, { 10, 22,15,17}, { 11, 23,16, MV_BOX_R},
	{ 12, 24, MV_BOX_L,19}, { 13,25,18,20}, { 14,26,19,21}, { 15,27,20,22}, { 16, 28,21,23}, { 17, 29,22, MV_BOX_R},
	{ 18,  0, MV_BOX_L,25}, { 19, 1,24,26}, { 20, 2,25,27}, { 21, 3,26,28}, { 22,  4,27,29}, { 23,  5,28, MV_BOX_R},
};

static const u8 temochi_hosei[]={
  0,0,1,2,2,
};

//=============================================================================================
/**
 * @brief	gCړ
 *
 * @param   mv	Xړ(-1=, 1=Ej
 */
//=============================================================================================
void GraphicWork::trayMove( int mx )
{
  int tray_max = 8; //get_traymax(  );
  cursor.tray += mx;  
  if(cursor.tray<0){
    cursor.tray = tray_max;
  }else if(cursor.tray>tray_max){
    cursor.tray = 0;
  }
  
  // gCύX̃J[\ʒuZo
  if(mx<0){
    if(cursor.tray==0){
      cursor.x = 1;
    }else{
      cursor.x = 5;
    }
  }else{
    cursor.x = 0;
  }

  // ړオ莝ƂYʒuϓ
  // (莝YW0-3Ȃ̂ŁA{bNX0-4ړƓs)
  if(cursor.tray==0){
    cursor.y = temochi_hosei[cursor.y];
  }

}


int GraphicWork::cursor2index( CURSOR_POS *cursor )
{
  int pos;
	if(cursor->tray==0){
	  pos = cursor->y*2 + cursor->x;
  }else{
	  pos = cursor->y*6 + cursor->x;
  }
  return pos;
}

//=============================================================================================
/**
 * @brief	J[\ړ
 *
 * @param   mv		J[\ړi0:A1:, 2:, 3:E)
 */
//=============================================================================================
void GraphicWork::cursorMove( int mv )
{
	int move = 0;
	int pos;
	
	// J[\ʒuԍZo
	if(cursor.tray==0){
	  pos = cursor.y*2 + cursor.x;
  }else{
	  pos = cursor.y*6 + cursor.x;
  }
	// ړ̎擾
	if(cursor.tray==0){
		move = temochi_tbl[pos][mv];
	}else{
		move = box_tbl[pos][mv];
	}

	// ړ̔f
	if(move==MV_BOX_L){
		trayMove( -1 );
	}else if(move==MV_BOX_R){
		trayMove( 1 );
	}else{
    if(cursor.tray==0){
  		cursor.x = move%2;
	  	cursor.y = move/2;
    }else{
  		cursor.x = move%6;
	  	cursor.y = move/6;
    }
	}

  GFL_PRINT("C(%d,%d,%d)\n", cursor.x, cursor.y, cursor.tray);

  // J[\ʒuԍWɔf
  {
    int index;
    gfl::math::VEC3 iconpos;
    iconpos.x = 0; iconpos.y = 0; iconpos.z = 0;
    if(cursor.tray==0){
      index = cursor.y*2 + cursor.x;
    }else{
//      index = (cursor.tray-1)*30 + 6 + cursor.y*6 + cursor.x;
      index = cursor.y*6 + cursor.x;
    }

//    iconpos = GetPaneScreenPos( GTS_LAYOUT_ID_LOWER, bound_tbl[tray_tbl[cursor.tray][3]][index][0]);
//    GFL_PRINT("i=%d,%d,(%f,%f)\n", index, bound_tbl[tray_tbl[cursor.tray][3]][index][0], iconpos.x, iconpos.y );
    
    if(iconpos.x>150.0f){
      TrayPosition.x -= 48;     // gCʒu̒
      SetTrayPosition( &TrayPosition );
      // J[\ʒu̍Ď擾
      iconpos.x -= 48.0f;
    }else if(iconpos.x < -150.0f){
    if(iconpos.x<-150.0f){
      TrayPosition.x += 48;     // gCʒu̒
      SetTrayPosition( &TrayPosition );
      // J[\ʒu̍Ď擾
      iconpos.x += 48.0f;
    }
    
    }
    
    SetCursorPos( iconpos );

    JudgePokeInfo( &cursor );
  }
}

void GraphicWork::JudgePokeInfo( CURSOR_POS *cursor )
{
  int index = cursor2index(cursor);
  if(GetBoxPokeExist( cursor->tray, index )<0){
    DisappearPokeInfo();
  }else{
    if(cursor->tray==0){
      pml::pokepara::PokemonParam *pokePara = m_appparam->pPokeParty->GetMemberPointer(index);

      DeleteBoxUpperPokeModel();
      UpdatePokeInfo( pokePara );
      CreateBoxUpperPokeModel( pokePara, heap );
    }else{
      pml::pokepara::CoreParam *corePara = GFL_NEW( heap->pHeap ) pml::pokepara::CoreParam( heap->pHeap );
      m_appparam->pSaveBoxPokemon->GetPokemon( corePara, cursor->tray-1, index );
      DeleteBoxUpperPokeModel();
      UpdatePokeInfo( corePara );
      CreateBoxUpperPokeModel( corePara, heap );
      GFL_DELETE corePara;
    }
  }
}

//--------------------------------------------------------------------------------------------
/**
 * J[\ʒu̐ݒ
 * @param pos ݒW
 */
//--------------------------------------------------------------------------------------------
inline void GraphicWork::SetCursorPos( const gfl::math::VEC3& pos )
{
  m_cursorPos = pos;
}

//--------------------------------------------------------------------------------------------
/**
 * J[\ʒu̎擾
 * @return J[\ʒu
 */
//--------------------------------------------------------------------------------------------
inline gfl::math::VEC3 GraphicWork::GetCursorPos( void )
{
  return m_cursorPos;
}




  }  // gts
}  // app
