//============================================================================================
/**
 * @file		gts.cpp
 * @brief		GTSiO[og[hXgjAv
 * @author	Akito Mori
 * @date		12.06.12
 *
 * namespace	netapp::gts::
 * 
 *
 */
//============================================================================================
#include <netapp/gts/gts.h>
#include "gts_main.h"


namespace netapp {
namespace gts {

//============================================================================================
//	萔`
//============================================================================================
#define	GTS_SYS_HEAP_SIZE		( 1024*2048 )		// VXeq[vTCY(2MB)


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc( APP_PARAM * prm )
{
  pMain  = NULL;  // gts_main.cppNXێ|C^̏
  pParam = prm;   // APP_PARAM̃|C^󂯎ۑ
  CreateHeap();   // q[v쐬
  
  // APP_PARAM̒\
  GFL_PRINT( "pSaveBox       =%8x\n", prm->pSaveBox       );
  GFL_PRINT( "pSaveBoxPokemon=%8x\n", prm->pSaveBoxPokemon);
  GFL_PRINT( "pPokeParty     =%8x\n", prm->pPokeParty     );
  GFL_PRINT( "pMyStatus      =%8x\n", prm->pMyStatus      );

  GFL_PRINT( "pokePartyCount=%d\n", prm->pPokeParty->GetMemberCount() );

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
  DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
  // PROCĂяo鏉
  pMain = GFL_NEW( pHeap )  MainSystem( pParam );   // gts_main.cppN
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
  // PROCĂяoI
  // Ȃ̂̓fXgN^ŌĂяo邩H
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
  //XV
  if( pMain != NULL )
  {
    if( pMain->Update() != false ){ // gts_main̏
      return gfl::proc::RES_CONTINUE;
    }
  }

  if( pMain != NULL )
  {
    GFL_DELETE  pMain;
    pMain = NULL;
  }

	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
  // `Ăяo
  if( pMain != NULL ){
    pMain->Draw();
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
  // gq[vŏ
  pHeap = GFL_CREATE_HEAP(
            gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
            HEAPID_GTS_SYS, GTS_SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
  // gtsō쐬q[v
	gfl::heap::Manager::DeleteHeap( pHeap );
}


}	// gts
}	// app



//--------------------------------------------------------------------------------------------
/**
 * @brief IW[\֐
 */
//--------------------------------------------------------------------------------------------
#if GFL_ENABLE_RO
extern "C" NN_DLL_EXPORT void nnroProlog()
{
  GFL_PRINT( "DllGts: nnroProlog\n");
}

extern "C" NN_DLL_EXPORT void nnroEpilog()
{
  GFL_PRINT( "DllGts: nnroEpilog\n");
}

extern "C" NN_DLL_EXPORT void nnroUnresolved()
{
  GFL_PRINT( "DllGts: nnroUnresolved\n");
}
#endif
