//==============================================================================
/**
 * @file    DeviceTurnWatcher.cpp
 * @brief   3DSt܂ɂȂĂ邩ǂ̔
 * @author  tamada
 * @date    2012.05.26
 */
//==============================================================================
#include <gflib.h>
#include <pmlib.h>

#include "gamesystem/GameData.h"

#include "system/DeviceTurnWatcher.h"

#include "field/zone_id.h"
#include "field/EvTime.h"

namespace xy_system {

//======================================================================
//======================================================================

  static const f32 DEVICE_TURN_Z_VALUE = 0.5f;
  static const u32 DEVICE_TURN_COUNT  = 90;
//------------------------------------------------------------------------
//------------------------------------------------------------------------
DeviceTurnWatcher::DeviceTurnWatcher( gfl::heap::HeapBase * heap, gfl::ui::DeviceManager * device_manager ) :
  m_device_manager(device_manager),
  m_is_turned( false ),
  m_count ( 0 )
{
	m_device_manager->BootAccelerometer( heap, gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
}

//------------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------------
DeviceTurnWatcher::~DeviceTurnWatcher()
{
	m_device_manager->StopAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
void DeviceTurnWatcher::Initialize()
{
  m_is_turned = false;
  m_count = 0;
}

//------------------------------------------------------------------------
/**
 * @todo  Pȃ`FbNA}ȈړȂǂɂǂ邩H
 */
//------------------------------------------------------------------------
void DeviceTurnWatcher::Update()
{
  gfl::ui::Accelerometer * pAccelerometer;
  pAccelerometer = m_device_manager->GetAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD);

  //Lf[^擾łȂԂ͉Ȃ
  if (pAccelerometer->IsValid() == false ) return;

  gfl::math::VEC3 acc;
  pAccelerometer->GetAcceleration(&acc);
  if (acc.z < DEVICE_TURN_Z_VALUE )
  {
    m_count = 0;
  }
  else
  {
    m_count ++;
    if ( m_count > DEVICE_TURN_COUNT ) m_is_turned = true;
  }
#ifdef  PM_DEBUG
	gfl::ui::Button * pButton;									// {^
	pButton     = m_device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	if ( pButton->IsTrigger( gfl::ui::BUTTON_R ) == true )
  {
    m_is_turned = false;
  }
#endif
}

}; //namespace xy_system

