#ifndef __SUBSCRIPTION_PACKET_LISTENER_H__
#define __SUBSCRIPTION_PACKET_LISTENER_H__

//=============================================================================
/**
 * @file   SubscriptionPacketListener.h
 * @brief  Subscription@\̕ωʒmCxg𑼂̃NXɒʒm邽߂̃CxgXi
 * @author h.suzuki
 *
 * @note   Subscriptionʒm󂯎ꍇ́A{NXpAz֐ĂB
 */
//=============================================================================
#include <gflib.h>
#include <gflnet.h>

#include <netapp/pss/PssDefine.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(subscription)

class SubscriptionPacketListener
{
  //GFL_FORBID_COPY_AND_ASSIGN(SubscriptionPacketListener); //RpPbgXgN^{֎~
public:

  //------------------------------------------------------------------
  /**
  * @brief  pPbgǉCxg
  *
  * @param  playerData  ǉΏۂƂȂf[^̎
  *
  * @param  principalId f[^ǉꂽ[ŨvVohc
  *
  * @param  releation   ǉ[U[̏
  */
  //------------------------------------------------------------------
  virtual void OnLoginSubscription( const nn::nex::SubscriptionData& playerData, u32 principalId, netapp::pss::PssDefine::E_PSS_RELATION releation ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  pPbgXVCxg
  *
  * @param  playerData  XVꂽf[^̎
  *
  * @param  principalId f[^XVꂽ[ŨvVohc
  */
  //------------------------------------------------------------------
  virtual void OnUpdateSubscription( const nn::nex::SubscriptionData& playerData, u32 principalId ) = 0;

  //------------------------------------------------------------------
  /**
  * @brief  OAEgʒmCxg
  *
  * @param  principalId OAEg[ŨvVohc
  */
  //------------------------------------------------------------------
  virtual void OnLogoutSubscription( u32 principalId ) = 0;
};


GFL_NAMESPACE_END(subscription)
GFL_NAMESPACE_END(netapp)



#endif // __SUBSCRIPTION_PACKET_LISTENER_H__
