//=============================================================================
/**
 * @file   PssPacketDefine.h
 *
 * @brief  PSSpPbg`pNX
 *
 * @author hisanao suzuki
 */
//=============================================================================

#ifndef __XY_PROJECT_PSS_PACKET_DEFINE_H__
#define __XY_PROJECT_PSS_PACKET_DEFINE_H__

#include <nn.h>
#include <gflib.h>

#include <netapp/pss/PssDefine.h>

namespace netapp {
namespace pss {


//--------------------------------------------------------------------------------------------
// l(96Byte)
//--------------------------------------------------------------------------------------------
struct PacketPersonalInfo
{
  // p[\i
  gfl::str::STRCODE      name[gamesystem::STRLEN_PLAYER_NAME+1];    // O                       26byte(2x(12+1))
  gfl::str::STRCODE      message[gamesystem::STRLEN_PSS_MESSAGE+1]; // bZ[W                 34byte(2x(16+1))
  //----------------------------------------------------------------------------------
  u32                    myPrincipalId;                           // g̃vVoID         4Byte
  u64                    myLocalFriendCode;                       // g̃[JthR[h 8Byte
  //----------------------------------------------------------------------------------
  u32                    iconFriend   : 8;                        // FBEm荇pACRԍ 4byte
  u32                    iconStranger : 8;                        // ႢpACRԍ       0byte
  u32                    sex          : 4;                        //                          0byte
  u32                    padding      : 12;                       // \
  //----------------------------------------------------------------------------------
  u8                     country;                                 // R[h                     1Byte
  u8                     reagion;                                 // nR[h                   1Byte
  u8                     birthMonth;                              // a                       1Byte
  u8                     birthDay;                                // a                       1Byte
  //----------------------------------------------------------------------------------
  //
  xy_system::dress_up::SaveFashionBuffer  fasshion;  // ւ 16Byte

public:
  /***************************************
   * RXgN^
   **************************************/
  PacketPersonalInfo()
  {
    myPrincipalId       = NN_FRIENDS_INVALID_PRINCIPAL_ID;
    myLocalFriendCode   = NN_FRIENDS_INVALID_LOCAL_FRIEND_CODE;
    sex                 = PM_NEUTRAL;
    iconStranger        = 0;
    iconFriend          = 0;
    name[0]             = 0;
    message[0]          = 0;
    country             = nn::cfg::CTR::CFG_COUNTRY_UNDEFINED;
    reagion             = reagion;
    birthMonth          = 1;
    birthDay            = 1;
  }
};


//--------------------------------------------------------------------------------------------
// ʐMΐ̏җpiej40Byte
//--------------------------------------------------------------------------------------------
struct PacketBattleInvite
{
  bit64                 guestFriendKey[PssDefine::PSS_BEACON_GUEST_USER_MAX];  // ґΏۃ[U[ID   24byte(3*8)
  //----------------------------------------------------------------------------------
  u32                   guestUserNum     : 2;                             // ґΏۃ[U[o^    4byte
  u32                   isWIFI           : 1;                             // ʐM^Cv(Wifi/Wireless) 0byte
  u32                   commitUserFlag   : 3;                             // m胆[U[BittOBΐQ҂ƂĊm肵Ă郆[U[rbgtOŊǗB 0byte
  u32                   dummy            : 2;                             // _~[
  u32                   battle_type      : 8;                             // ΐ`                  0byte
  u32                   battle_rule      : 8;                             // ΐ탋[                0byte
  u32                   battle_handicap  : 8;                             // ΐnf                0byte
  //----------------------------------------------------------------------------------
  u32                   ticketID;                                         // `PbgID                4byte
  u8                    reserved[12];                                     // \ 12Byte
};


//--------------------------------------------------------------------------------------------
// ʐMΐ̎QӎvԐMpiqj40Byte
//--------------------------------------------------------------------------------------------
struct PacketBattleRecieve
{
  bit64                 hostFriendKey;                                    // Î҂̃[U[ID        8byte
  u32                   ticketID;                                         // Î҂̃`PbgID        4Byte
  u8                    reserved[28];                                     // \ 28BYTE
};


//--------------------------------------------------------------------------------------------
// ʐM̏җpiej40Byte
//--------------------------------------------------------------------------------------------
struct PacketTradeInvite
{
  bit64                 guestFriendKey;                                   // ґΏۃ[U[ID        8byte
  u32                   ticketID;                                         // `PbgID                4byte
  u8                    guestUserNum;                                     // ґΏۃ[U[o^    1byte
  u8                    isWIFI;                                           // ʐM^Cv(Wifi/Wireless) 1byte
  u8                    commitUserFlag;                                   // m胆[U[BittOB   1byte
  u8                    reserved[25];                                     // \ 25Byte
};


//--------------------------------------------------------------------------------------------
// ʐM̎QӎvԐMpiqj40Byte
//--------------------------------------------------------------------------------------------
struct PacketTradeRecieve
{
  bit64                 hostFriendKey;                                    // Î҂̃[U[ID        8byte
  u32                   ticketID;                                         // Î҂̃`PbgID        4Byte
  u8                    reserved[28];                                     // \ 28BYTE
};


//--------------------------------------------------------------------------------------------
// ̑Q[40byte
//--------------------------------------------------------------------------------------------
struct PacketGameStatus
{
  u32                   crossingCount;                                    // Ⴂ              4Byte
  //
  u32                   kawaigariPokeNo  : 11;                            // |PNo                4byte
  u32                   kawaigariForm    : 5;                             // tHNo                0byte
  u32                   kawaigariSex     : 1;                             //                       0
  u32                   kawaigariReserve : 15;                            // \                      0
  //
  u8                    trainingInfo[3];                                  // g[jO          3Byte
  u8                    assistInfo[1];                                    // AVXg              1Byte
  u8                    profile[23];                                      // vtB[              23BYTE
  u8                    reserved[5];                                      // \ 5BYTE
};


//--------------------------------------------------------------------------------------------
// ʐMΐpPbgp(40Byte)
//
// ȍ~̏32Byteʗ̈Ŏgp
// ꂩP̏񂵂ێłȂ
//
//--------------------------------------------------------------------------------------------
typedef union
{
  PacketBattleInvite     battleInvite;                                    // ogґ
  PacketBattleRecieve    battleReceive;                                   // ogQ
  PacketTradeInvite      tradeInvite;                                     // g[hґ
  PacketTradeRecieve     tradeReceive;                                    // g[hQ
  PacketGameStatus       status;                                          // Q[
}UnionPacket;



//--------------------------------------------------------------------------------------------
// PSSpMf[^ ( MAX: gflnet::BEACON_CONNECT_MAXBYTE )
//
// 8ByteACgI 144ByteŒ
//--------------------------------------------------------------------------------------------
struct PssPacketData
{
  //----------------------------------------------------------------------------------
  u32                    version        : 24;    // r[Ro[W           4byte
  u32                    requestCommand : 8;     // NGXgR}h^Cv     0byte
  //----------------------------------------------------------------------------------
  u32                    timestamp;              // ^CX^v               4byte
  //----------------------------------------------------------------------------------
  PacketPersonalInfo     personalInfo;           // l                     96byte
  //----------------------------------------------------------------------------------
  // ݂͂ȂŎgI
  UnionPacket            unionInfo;              // L                     40byte
  //----------------------------------------------------------------------------------

  /*******************************************************************
   * @brief  RXgN^
   *
   * @param  none
   *
   * @return none
   *******************************************************************/
  PssPacketData()
  {
    version             = PssDefine::PSS_BEACON_VERSION;
    requestCommand      = 0;
    timestamp           = 0;

    // TCY`FbN
    if( (sizeof(PssPacketData) > gflnet::base::BEACON_CONNECT_MAXBYTE) ){
      SUZUKI_PRINT( "BEACON SIZE[%u][%d] / [%u][%u]\n", sizeof(PssPacketData), gflnet::base::BEACON_CONNECT_MAXBYTE, sizeof(PacketPersonalInfo), sizeof(UnionPacket) );
    }
    GFL_ASSERT( (sizeof(PssPacketData) <= gflnet::base::BEACON_CONNECT_MAXBYTE) );
  }

};



}	// pss
}	// netapp


#endif // __XY_PROJECT_PSS_PACKET_DEFINE_H__
