//======================================================================
/**
 * @file	  GFSharePlayNet.cpp
 * @brief	  VFAvCM
 * @author	k.ohno
 * @data	  2011/08/10
 */
//======================================================================

#include <gflib.h>
#include <gflnet.h>
#include <nn/socket.h>
#include <net/net_define.h>
#include <netapp/gfeachother/GFSharePlayNet.h>
#include <net/XyNetManager.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(beacon)







GFSharePlayNet::GFSharePlayNet(gfl::heap::HeapBase* pBase, gfl::heap::HeapBase *pDev,netapp::share::SharePlaySystem* pSharePlaySystem )
{
  mpHeapMem    = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );
  mpDeviceMem  = pDev;
  mbFinal      = false;
  mbFinalD     = false;
  mbContinue   = false;
  mpSharePlaySystem = pSharePlaySystem;
  mMode        = _BEACON_SEARCH;
  mSendPict    = 0;
}

GFSharePlayNet::~GFSharePlayNet()
{
  if(mbMainAdd){
    GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->Finalize();
  }
}

//--------------------------------------------------------------
/**
 * @brief   
 * @param   sendData   f[^
 */
//--------------------------------------------------------------
bool GFSharePlayNet::Initialize(const u8* sendData, bool bMainAdd)
{

  if(mNetMng==NULL){
    mbFinal      = false;
    mbFinalD     = false;
    mbContinue   = false;
    mMode        = _BEACON_SEARCH;
    mSendPict    = 0;
    bConnect = false;
    maTransferedID[0]=0;
    maTransferedID[1]=0;
    maTransferedID[2]=0;

    memcpy(mSendBeacon,sendData, gflnet::base::BEACON_CONNECT_MAXBYTE);
    netInitParam.pHeapBase = mpHeapMem;
    netInitParam.pHeapDev = mpDeviceMem;
    netInitParam.TransferedID = netapp::cfg::GetTransferableId();
    mMy_TransferedID = netInitParam.TransferedID;

    mNetMng = GFL_NEW(mpHeapMem)gflnet::Manager(mpHeapMem);
    mNetMng->CreateNetwork(&netInitParam,
                           GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetInitParameterFixed(), GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetBeaconManager());

    if(!mNetMng->GetBeaconManager()->SetBeacon(sendData,gflnet::base::BEACON_CONNECT_MAXBYTE )){
      //oȂꍇ  @todo
  //    GFL_ASSERT(0);
    }
  }
  if(bMainAdd){
    GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->Initialize(this);
    mbMainAdd = true;
  }
  return true;
}





void GFSharePlayNet::beaconSearchMain(int mode)
{
  if(mNetMng){

    mNetMng->StateProcess();

    if(mbFinalX){
      if(mNetMng->EndingNetwork()){
        mbFinal = true;
        mbFinalD = true;
        mbFinalX=false;
      }
    }
    else if(mbFinalD){
      if( mNetMng->DeleteNetwork()){
        mbFinalD=false;
      }
    }
    if(gfl::proc::MAINSTATUS_NULL == mNetMng->Main()){
      GFL_DELETE mNetMng;
      mNetMng = NULL;
      if(mode){
        mMode = mode;
      }
    }
  }
}



//--------------------------------------------------------------
/**
* @brief    }X^[ڑI
* @retval   true   ʐMIJn
* @retval   false  G[N
*/
//--------------------------------------------------------------
bool GFSharePlayNet::MasterFinalize(void)
{
  if( mpNetGame == NULL ){
    return true;
  }

  if( mMode == _CREATE_MASTER_MAIN4 )
  {
    if(!mpNetGame->IsInitialize()){
      return false;;
    }
    OHNO_PRINT("  GFSharePlayNet::MasterFinalize \n" );
    mMode = _CREATE_MASTER_MAIN5;
    return true;
  }
  return false;
}





void GFSharePlayNet::createMasterMain(void)
{
  gfl::proc::MainStatus ms;
  if(mpP2pManager){
    ms = mpP2pManager->NetMain();
  }

  switch(mMode){
  case _CREATE_MASTER:
    beaconSearchMain( _CREATE_MASTER_MAIN );
    break;
  case _CREATE_MASTER_MAIN:
    initP2p();
    mMode++;
    OHNO_PRINT("_CREATE_MASTER_MAIN\n");
    break;
  case _CREATE_MASTER_MAIN1:
    mpP2pManager->Connect();
    mMode++;
    OHNO_PRINT("_CREATE_MASTER_MAIN1\n");
    break;
  case _CREATE_MASTER_MAIN2:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      initSetup();
      OHNO_PRINT("_CREATE_MASTER_MAIN2\n");
      mMode++;
    }
    break;
  case _CREATE_MASTER_MAIN3:
    {
          //@todo
      if( mpP2pManager->GetBeaconManager()->SetBeacon( mSendBeacon, gflnet::base::BEACON_CONNECT_MAXBYTE) ){
        OHNO_PRINT("r[RZbg\n");
        mMode++;
      }
    }
    break;
  case _CREATE_MASTER_MAIN4:
    if(!mpNetGame->IsInitialize()){
      break;
    }
//    OHNO_PRINT("%d - \n",mpP2pManager->GetConnectionCount());
    if( mpP2pManager->GetConnectionCount()==2 ){
 //     OHNO_PRINT("ӂ\n");
      if(mpP2pManager->GameStart()){
        mMode++;
      }
    }
    break;
  case _CREATE_MASTER_MAIN41:
        //ŃV[PX~߂Ă
        bConnect = true;


    break;
  case _CREATE_MASTER_MAIN5:
    OHNO_PRINT("Disconnect\n");
    mMode++;
    mpP2pManager->Disconnect();
    mpP2pManager->Shutdown();
    mpNetGame->Finalize();
    break;
  case _CREATE_MASTER_SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      OHNO_PRINT("_SHUTDOWN\n");
      deleteP2p();
      mMode = _END;
    }
    break;
  }
}



void GFSharePlayNet::initSetup(void)
{
  if(mTransferedID!=0){
    mpNetPlayer = GFL_NEW(mpHeapMem) gflnet::p2p::NetPlayer();
    mpNetPlayer->SetTransferedID( mTransferedID );
    mpNetGame->Initialize();
    mpP2pManager->CreateMaster(mpNetPlayer);
  }
  else{
    for(int i=0;i<3;i++){
      mpNetPlayers[i] = GFL_NEW(mpHeapMem) gflnet::p2p::NetPlayer();
      mpNetPlayers[i]->SetTransferedID( maTransferedID[i] );
    }
    mpNetGame->Initialize();
    mpP2pManager->CreateMaster(mpNetPlayers[0]);
    mpP2pManager->AddPlayer(mpNetPlayers[1]);
    mpP2pManager->AddPlayer(mpNetPlayers[2]);
  }
}


//--------------------------------------------------------------
/**
* @brief    }b`OڑI
* @retval   true   ʐMIJn
* @retval   false  G[N
*/
//--------------------------------------------------------------
bool GFSharePlayNet::MatchingFinalize(void)
{
  if( mpNetGame == NULL ){
    return true;
  }
  mMode = _MATCHING6;
  return true;
}


void GFSharePlayNet::matchingMain(void)
{
  gfl::proc::MainStatus ms;
  if(mpP2pManager){
    ms = mpP2pManager->NetMain();
  }

  switch(mMode){
  case _MATCHING:
    beaconSearchMain( _MATCHING1 );
    break;
  case _MATCHING1:
    initP2p();
    mMode++;
    OHNO_PRINT("_MATCHING1\n");
    break;
  case _MATCHING2:
    mpP2pManager->Connect();
    mMode++;
    OHNO_PRINT("_MATCHING2\n");
    break;
  case _MATCHING3:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      mMode++;
      OHNO_PRINT("_MATCHING3\n");
    }
    break;
  case _MATCHING4:
    mpNetPlayer = GFL_NEW(mpHeapMem) gflnet::p2p::NetPlayer();
    mpNetPlayer->SetTransferedID( mTransferedID );
    mpNetGame->Initialize();
    mpP2pManager->Matching(mpNetPlayer);
    mMode++;
    OHNO_PRINT("_MATCHING4\n");
    break;
  case _MATCHING5:
    if(mpP2pManager->IsMatchingEnd()){
      if(mpNetGame->IsInitialize()){

        // ŃV[PX~߂Ă
        bConnect=true;
      }
    }
    break;
  case _MATCHING6:
    mMode++;
    OHNO_PRINT("_MATCHING6\n");
    mpP2pManager->Disconnect();
    mpP2pManager->Shutdown();
    mpNetGame->Finalize();
    break;
  case _SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      deleteP2p();
      mMode = _END;
      OHNO_PRINT("_SHUTDOWN\n");
    }
    break;
  }
}


//--------------------------------------------------------------
/**
 * @brief   قe@
 */
//--------------------------------------------------------------


void GFSharePlayNet::sendShotMain(void)
{
  gfl::proc::MainStatus ms;
  if(mpP2pManager){
    ms = mpP2pManager->NetMain();
  }

  switch(mMode){
  case _SHOT_SENDMODE:
    beaconSearchMain( _SHOT_SENDMODE_MAIN );
    break;
  case _SHOT_SENDMODE_MAIN:
    initP2p();
    mMode++;
    OHNO_PRINT("_SHOT\n");
    break;
  case _SHOT_SENDMODE_MAIN1:
    mpP2pManager->Connect();
    mMode++;
    OHNO_PRINT("_SHOT1\n");
    break;
  case _SHOT_SENDMODE_MAIN2:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      mpNetPlayer = GFL_NEW(mpHeapMem) gflnet::p2p::NetPlayer();
      mpNetPlayer->SetTransferedID( mTransferedID );
      mpNetGame->Initialize();
      mpP2pManager->CreateMaster(mpNetPlayer);

//      if(mpP2pManager->GetMyBeaconData()){
//      }
      OHNO_PRINT("_SHOT2\n");
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_MAIN3:
    {
//      DEFAULT_BEACON_SEND_DATA* pData = (DEFAULT_BEACON_SEND_DATA*)(&mSendBeacon[0]);
  //    pData->isScreenShotShare = true;
      //@todo
      if(mpP2pManager->GetBeaconManager()->SetBeacon(mSendBeacon,gflnet::base::BEACON_CONNECT_MAXBYTE)){
        mMode++;
        OHNO_PRINT("r[RZbg\n");
      }
    }
    break;
  case _SHOT_SENDMODE_MAIN4:
    if(!mpNetGame->IsInitialize()){
      break;
    }
    if( mpP2pManager->GetConnectionCount()==2 ){
      if(mpP2pManager->GameStart()){
        mMode++;
      }
    }
    break;
  case _SHOT_SENDMODE_MAIN41:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_01)){
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_MAIN42:
    {
      size_t size = mpSharePlaySystem->GetSize();
      if( mpNetGame->SendData((char*)&size,sizeof(size_t))){
        mMode++;
      }
    }
    break;
  case _SHOT_SENDMODE_MAIN4z:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_02)){
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_DATASEND:
    // q@ɑM
    if( mpNetGame->SendDataCommandSendBit(
      mpSharePlaySystem->GetCopyMemoryAddress(1024 * mSendPict)  ,1024, 1, 0x02)  ){
      OHNO_PRINT("Sdn %d\n",mSendPict);
      if(mpSharePlaySystem->GetSize() < (1024 * mSendPict)){
        mMode++;
        break;
      }
      mSendPict++;
    }
    break;
  case _SHOT_SENDMODE_TIMI3:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_03)){
      OHNO_PRINT("T3\n");
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_COMMENT1:
    if(mpSharePlaySystem->SendMessage(mpNetGame)){
      OHNO_PRINT("SendMessage\n");
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_COMMENT2:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_04)){
      OHNO_PRINT("_SHOT_SENDMODE_COMMENT2\n");
      mMode++;
    }
    break;
  case _SHOT_SENDMODE_MAIN5:
    OHNO_PRINT("SHOT_SEND 5\n");

    mMode++;
    mpP2pManager->Disconnect();
    mpP2pManager->Shutdown();
    mpNetGame->Finalize();
    mpSharePlaySystem->ResetMyPicture();
    break;
  case _SHOT_SENDMODE_SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      OHNO_PRINT("_SHUTDOWN\n");
      deleteP2p();
      mMode = _END;
    }
    break;
  }
}



//--------------------------------------------------------------
/**
 * @brief   󂯎قq@
 */
//--------------------------------------------------------------

void GFSharePlayNet::recvShotMain(void)
{
  gfl::proc::MainStatus ms;
  if(mpP2pManager){
    ms = mpP2pManager->NetMain();
  }

  switch(mMode){
  case _SHOT_RECVMODE:
    beaconSearchMain( _SHOT_RECVMODE1 );
    break;
  case _SHOT_RECVMODE1:
    initP2p();
    mMode++;
    OHNO_PRINT("_SHOT_R1\n");
    break;
  case _SHOT_RECVMODE2:
    mpP2pManager->Connect();
    mMode++;
    OHNO_PRINT("_SHOT_R2\n");
    break;
  case _SHOT_RECVMODE3:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      mMode++;
      OHNO_PRINT("_SHOT_R3\n");
    }
    break;
  case _SHOT_RECVMODE4:
    mpNetPlayer = GFL_NEW(mpHeapMem) gflnet::p2p::NetPlayer();
    mpNetPlayer->SetTransferedID( mTransferedID );
    mpNetGame->Initialize();
    mpP2pManager->Matching(mpNetPlayer);
    mMode++;
    OHNO_PRINT("_SHOT_R4\n");
    break;
  case _SHOT_RECVMODE5:
    if(mpP2pManager->IsMatchingEnd()){
      if(mpNetGame->IsInitialize()){
        OHNO_PRINT("_SHOT_R5\n");
        mMode++;
      }
    }
    break;
  case _SHOT_RECVMODE_TIMI1:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_01)){
      mMode++;
    }
    break;
  case _SHOT_RECVMODE_TIMI2:
    if( mpNetGame->RecvData(0, (char*)&mGetSize, 4) ){
      mMode++;
    }
    break;
  case _SHOT_RECVMODE_TIMIz:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_02)){
      mMode++;
    }
    break;

  case _SHOT_RECVMODE_DATASEND:
    // Ƃ
    if( mpNetGame->RecvData(0, mpSharePlaySystem->GetTempRecvMemoryAddress(1024*mSendPict), 1024) ){
//      OHNO_PRINT("_Ƃ\n");
      if((mSendPict*1024) > mGetSize){
        OHNO_PRINT("_SHOT_RECVMODE_DATASEND\n");
        mMode++;
        break;
      }
      mSendPict++;
    }
    break;
  case _SHOT_RECVMODE_TIMI3:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_03)){
      OHNO_PRINT("_SHOT_RECVMODE_TIMI3\n");
      mpSharePlaySystem->Decoder(mGetSize);
      mMode++;
    }
    break;
  case _SHOT_RECVMODE_COMMENT1:
    if(mpSharePlaySystem->RecvMessage(mpNetGame)){
      mMode++;
    }
    break;
  case _SHOT_RECVMODE_COMMENT2:
    if(mpNetGame->IsTimingLoopCheck(_TIMING_04)){
      OHNO_PRINT("_SHOT_RECVMODE_COMMENT2\n");
      mMode++;
    }
    break;
  case _SHOT_RECVMODE6:
    mMode++;
    OHNO_PRINT("_SHOT_RECVMODE6\n");
    mpP2pManager->Disconnect();
    mpP2pManager->Shutdown();
    mpNetGame->Finalize();
    mpSharePlaySystem->SetRecvPicture();  //G̎M
    break;
  case _SHOT_RECVMODE_SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      deleteP2p();
      mMode = _END;
      OHNO_PRINT("_SHUTDOWN\n");
    }
    break;
  }
}


//--------------------------------------------------------------
/**
 * @brief   C[v
 */
//--------------------------------------------------------------
void GFSharePlayNet::Main(void)
{
  {
    if(GFL_SINGLETON_INSTANCE(xynet::XyNetErrManager)->IsError()){
      if(mpP2pManager){
        OHNO_PRINT("MatchingFinalize\n");
        MatchingFinalize();
      }
      else{
        OHNO_PRINT("Finalize\n");
        Finalize();
      }
      GFL_SINGLETON_INSTANCE(xynet::XyNetErrManager)->ResetError();
    }
  }


  switch(mMode){
  case _BEACON_SEARCH:
    beaconSearchMain( 0 );
    screenShotCheck();
    break;
  case _CREATE_MASTER:
  case _CREATE_MASTER_MAIN:
  case _CREATE_MASTER_MAIN1:
  case _CREATE_MASTER_MAIN2:
  case _CREATE_MASTER_MAIN3:
  case _CREATE_MASTER_MAIN4:
  case _CREATE_MASTER_MAIN41:
  case _CREATE_MASTER_MAIN5:
  case _CREATE_MASTER_SHUTDOWN:
    createMasterMain();
    break;

  case _MATCHING:
  case _MATCHING1:
  case _MATCHING2:
  case _MATCHING3:
  case _MATCHING4:
  case _MATCHING5:
  case _MATCHING6:
  case _SHUTDOWN:
    matchingMain();
    break;

  case _SHOT_SENDMODE:
  case _SHOT_SENDMODE_MAIN:
  case _SHOT_SENDMODE_MAIN1:
  case _SHOT_SENDMODE_MAIN2:
  case _SHOT_SENDMODE_MAIN3:
  case _SHOT_SENDMODE_MAIN4:
  case _SHOT_SENDMODE_MAIN41:
  case _SHOT_SENDMODE_MAIN42:
  case _SHOT_SENDMODE_MAIN4z:
  case _SHOT_SENDMODE_DATASEND:
  case _SHOT_SENDMODE_TIMI3:
  case _SHOT_SENDMODE_COMMENT1:
  case _SHOT_SENDMODE_COMMENT2:
  case _SHOT_SENDMODE_MAIN5:
  case _SHOT_SENDMODE_SHUTDOWN:


    sendShotMain();
    break;

  case _SHOT_RECVMODE:   //炪Ȃɍs ȂɍsĊG炤
  case _SHOT_RECVMODE1:
  case _SHOT_RECVMODE2:
  case _SHOT_RECVMODE3:
  case _SHOT_RECVMODE4:
  case _SHOT_RECVMODE5:
  case _SHOT_RECVMODE_TIMI1:
  case _SHOT_RECVMODE_TIMI2:
  case _SHOT_RECVMODE_TIMIz:
  case _SHOT_RECVMODE_DATASEND:
  case _SHOT_RECVMODE_TIMI3:
  case _SHOT_RECVMODE_COMMENT1:
  case _SHOT_RECVMODE_COMMENT2:
  case _SHOT_RECVMODE6:
  case _SHOT_RECVMODE_SHUTDOWN:
    recvShotMain();
    break;


  case _RESPOND:
    break;
  }

}



bool GFSharePlayNet::IsConnect(void)
{
  return bConnect;
}


//--------------------------------------------------------------
/**
 * @brief    r[R͑Ƃ߂܂AʐM͂ɏIȂ̂ŁAI̊Jns܂
 * @retval   true   ʐMIJn
 * @retval   false  G[N
 */
//--------------------------------------------------------------
bool GFSharePlayNet::SearchFinalize(void)
{
  if(mNetMng){
    if(mNetMng->EndingNetwork()){
      mbFinal = true;
      mbFinalD = true;
    }
    else{
      mbFinalX = true;
    }
  }
  return true;
}


//--------------------------------------------------------------
/**
 * @brief    r[R͑Ƃ߂܂AʐM͂ɏIȂ̂ŁAI̊Jns܂
 * @retval   true   ʐMIJn
 * @retval   false  G[N
 */
//--------------------------------------------------------------
bool GFSharePlayNet::Finalize(void)
{
  static int debugno = 0;


  if(mbContinue){
    mbContinue=false;
  }
  SearchFinalize();
  if(IsConnect()){
    debugno++;
    if(debugno==2){
      OHNO_PRINT("  Finalize \n" );
    }

    OHNO_PRINT("  GFSharePlayNet::Finalize \n" );

    mMode = _CREATE_MASTER_MAIN5;    //ؒfKv @todo
  }

  return true;
}


//--------------------------------------------------------------
/**
 * @brief    IǂmFł܂ IĂJł܂
 * @retval   true  ʐMI
 * @retval   false ʐMI
 */
//--------------------------------------------------------------
bool GFSharePlayNet::IsFinalized(void)
{
  if(mbFinal && (mNetMng == NULL)){
    return true;
  }
  return false;
}


//--------------------------------------------------------------
/**
 * @brief   r[RƂ肾
 * @param   index      r[R̕ۑ
 * @return  r[Rf[^
 */
//--------------------------------------------------------------
void* GFSharePlayNet::GetBeacon(int index)
{
  if(mNetMng){
    GFL_ASSERT(index < BEACON_MAX);
    if(index < BEACON_MAX){
      gflnet::base::BeaconData* pData = mNetMng->GetBeaconManager()->GetBeaconAddress(index);
      if(pData){
        gflnet::base::Beacon beacon(pData);
        return beacon.GetBeaconBody();
      }

    }
  }
  return NULL;
}


//--------------------------------------------------------------
/**
 * @brief   r[RƂ肾
 * @param   transferedID      transferedID
 * @return  r[Rf[^
 */
//--------------------------------------------------------------
void* GFSharePlayNet::GetBeacon(bit64 transferedID)
{
  if(mNetMng){
    for(int index = 0;index <BEACON_MAX;index++){
      gflnet::base::BeaconData* pData = mNetMng->GetBeaconManager()->GetBeaconAddress(transferedID);
      if(pData){
        gflnet::base::Beacon beacon(pData);
        if( transferedID == beacon.GetTransferedID()){
          return beacon.GetBeaconBody();
        }
      }
    }
  }
  return NULL;
}



//--------------------------------------------------------------
/**
 * @brief   r[RMAC擾\ł
 * @param   index      r[R̕ۑ
 * @return  r[RMAC
 */
//--------------------------------------------------------------
bit64 GFSharePlayNet::GetBeaconTransferedID(int index)
{
  if(mNetMng){
    GFL_ASSERT(index < BEACON_MAX);
    if(index < BEACON_MAX){
      gflnet::base::BeaconData* pData = mNetMng->GetBeaconManager()->GetBeaconAddress(index);
      if(pData){
        gflnet::base::Beacon beacon(pData);
        return beacon.GetTransferedID();
      }

//      return mNetMng->GetRecvBeaconTransferedID(index);
    }
  }
  return 0;
}


//--------------------------------------------------------------
/**
 * @brief   MACAhXAĂяoĂ邩ǂmF
   MAC AhX͖{̂ƂɃj[NȒlłACȂǂɂĕύXĂ\܂B
   {̂̓sꍇ nn::cfg::GetTransferableId ֐gpĂB
 * @return  Ăяo󂯂Ăindex Ȃ-1
 */
//--------------------------------------------------------------
int GFSharePlayNet::GetMyMacAddressCallIndex(void)
{
  int index;

  bit64 id = mMy_TransferedID;
  if(mNetMng){
    for(index = 0; index < BEACON_MAX ; index++){
//      if( mNetMng->CheckRecvBeaconCallTransferedID(index, id) ){
//        return index;
//      }
      gflnet::base::BeaconData* pData = mNetMng->GetBeaconManager()->GetBeaconAddress(index);

      if(pData){
        gflnet::base::Beacon beacon(pData);
        if( beacon.CheckCallTransferedID(id) ){
          return index;
        }
      }

    }
  }
  return -1;
}

//--------------------------------------------------------------
/**
 * @brief   MACAhXAĂяoĂ邩ǂmF
   MAC AhX͖{̂ƂɃj[NȒlłACȂǂɂĕύXĂ\܂B
   {̂̓sꍇ nn::cfg::GetTransferableId ֐gpĂB
 * @return  Ăяo󂯂Ăindex Ȃ-1
 */
//--------------------------------------------------------------
int GFSharePlayNet::GetMyMacAddressCallIndexNoShot(void)
{
  int index;

  bit64 id = mMy_TransferedID;
  if(mNetMng){
    for(index = 0; index < BEACON_MAX ; index++){
      gflnet::base::BeaconData* pData = mNetMng->GetBeaconManager()->GetBeaconAddress(index);
      if(pData){
        gflnet::base::Beacon beacon(pData);
        if( beacon.CheckCallTransferedID(id) ){
          if( beacon.CheckBeaconCommand( xynet::XYNET_SCREENSHOTSHARE_COMMNAD,xynet::XYNET_COMMNADNO_SCREENSHOT) ){
            return index;
          }
        }
      }
    }
  }
  return -1;
}




//--------------------------------------------------------------
/**
 * @brief   r[Rf[^ύX܂
 * @param   heap       workƂ邽߂̃NX
 * @param   parent     ẽCxgNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::ChangeData(const u8* sendData, u32 size )
{
  GFL_ASSERT( size <= gflnet::base::BEACON_CONNECT_MAXBYTE );

  memcpy(mSendBeacon, sendData, size);

  return mNetMng->GetBeaconManager()->SetBeacon(sendData,size);
}


//--------------------------------------------------------------
/**
 * @brief   w肵Đe@ɂȂ
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::CreateMaster(int index)
{
  return CreateMaster(GetBeaconTransferedID( index ));
}

bool GFSharePlayNet::CreateMaster(u64 transferedID)
{
  if(mMode==_BEACON_SEARCH){
    mTransferedID = transferedID;
    SearchFinalize();
    mMode = _CREATE_MASTER;
    return true;
  }
  return false;
}

bool GFSharePlayNet::CreateMaster(const u64* transferedID)
{
  if(mMode==_BEACON_SEARCH){
    memcpy(maTransferedID,transferedID , sizeof(maTransferedID));
    SearchFinalize();
    mMode = _CREATE_MASTER;
    return true;
  }
  return false;
}




//--------------------------------------------------------------
/**
 * @brief   w肵Đe@ɂȂ  XN[Vbg𑗂
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::CreateMasterShot(int index)
{
  if(mMode==_BEACON_SEARCH){
    OHNO_PRINT("Vbg𑗂\n");
    mTransferedID = GetBeaconTransferedID( index );
    SearchFinalize();
    mMode = _SHOT_SENDMODE;
    return true;
  }
  return false;
}



//--------------------------------------------------------------
/**
 * @brief   w肵ă}b`O
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::Matching(u64 transferedID)
{
  if(mMode==_BEACON_SEARCH){
    mTransferedID = transferedID;
    OHNO_PRINT(" GFSharePlayNet::Matching %llu \n",mTransferedID);
    SearchFinalize();
    mMode = _MATCHING;
    return true;
  }
  return false;
}

//--------------------------------------------------------------
/**
 * @brief   w肵ă}b`O
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::Matching(int index)
{
  return Matching(GetBeaconTransferedID( index ));
}


//--------------------------------------------------------------
/**
 * @brief   w肵ă}b`O
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::MatchingShot(int index)
{
  if(mMode==_BEACON_SEARCH){
    OHNO_PRINT("Vbg炤\n");
    mTransferedID = GetBeaconTransferedID( index );
    NN_LOG(" GFSharePlayNet::Matching %d %llu \n",index,mTransferedID);
    SearchFinalize();
    mMode = _SHOT_RECVMODE;
    return true;
  }
  return false;
}


//--------------------------------------------------------------
/**
 * @brief   ڑJn   CreateMaster CreateMasterShot Matching MatchingShotƓ
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::ConnectStart(int index)
{
  if(GetBeacon( index )){
    if(CreateMaster( index )){
      return true;
    }
  }
  return false;
}



//--------------------------------------------------------------
/**
 * @brief   ڑJn   CreateMaster CreateMasterShot Matching MatchingShotƓ
 * @param   index      Er[R̃CfbNX
 */
//--------------------------------------------------------------
bool GFSharePlayNet::ConnectStart(u64 transferedID)
{
  if(CreateMaster( transferedID )){
    return true;
  }
  return false;
}


//--------------------------------------------------------------
/**
 * @brief   ċNKvȏꍇ̌
 * @return  ċNKvȎTRUE
 */
//--------------------------------------------------------------
bool GFSharePlayNet::IsReboot(void)
{
  switch(mMode){
  case _END:
    OHNO_PRINT("ENDłREBOOT\n");
    return true;
  }


  return false;
}


//--------------------------------------------------------------
/**
 * @brief r[RԕωʒmpXi̓o^
 * @param listener ʒm惊Xi[NXւ̃|C^
 */
//--------------------------------------------------------------
void GFSharePlayNet::RegistListener( GFSharePlayNetListener *listener )
{
  if(mNetMng){
    mNetMng->GetBeaconManager()->SetBeaconListener(listener);
  }
}

//--------------------------------------------------------------
/**
 * @brief   ʐM𑱂邪GFSharePlayNetIꍇɌĂт܂
 */
//--------------------------------------------------------------

bool GFSharePlayNet::NetworkContinue(void)
{
  mbContinue = true;
  GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->ContinueNetwork(mpP2pManager,mpNetGame,mpNetPlayer);
  return true;
}


void GFSharePlayNet::deleteP2p( void )
{
  mpP2pManager->Exit();

  for(int i=0;i<3;i++){
    if(mpNetPlayers[i]!=NULL){
      GFL_DELETE mpNetPlayers[i];
      mpNetPlayers[i] = NULL;
    }
  }
  if(mpNetPlayer!=NULL){
    GFL_DELETE mpNetPlayer;
    mpNetPlayer=NULL;
  }
  GFL_DELETE mpNetGame;
  GFL_DELETE mpP2pManager;
  mpNetGame=NULL;
  mpP2pManager=NULL;
}

void GFSharePlayNet::initP2p( void )
{
  gflnet::p2p::NETWORK_CONFIG cfg = {
    0,//  u32 maxSilenceTime;
    0,//  u32 keepAliveTimeout;
    0,//  u32 maxWindowMapSize;
    false,//  bool useUserDO;   //IuWFNg Duplicated Object̂
    // lbg[Ng|W֘AB
    nn::nex::NetworkTopology::Peer2Peer,
    false, // bool testRouting;

    // bZ[Woh֘A
    false, //  bool enableMessageBundle;
    0,//  u16  messageBundleFlushDelay;
    0,//  u16  messageBundleFlushCheckPeriod;

    // pPbgoh֘A
    false,//  bool enablePacketBundle;
    0,//  u32  packetBundleFlushDelay;

  };

  gflnet::InitParameter GFSharePlayNet::netInitParam = {
    0,
    NULL,
    NULL,
    NULL,
    gflnet::TYPE_WIRELESS_INIT,
    true,
    DEBUG_GAMENO_MATCH,
    2, //ڑl
    BEACON_MAX,
  };


  
  netInitParam.beaconNum=10;

  mpP2pManager = GFL_NEW(mpHeapMem) gflnet::p2p::P2pManager( mpHeapMem,  mpDeviceMem, mpHeapMem );
  mpP2pManager->Initialize( &cfg,&netInitParam,
                            GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetInitParameterFixed(),
                            GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetBeaconManager() );

  gflnet::p2p::GameInitialize init;
  init.max = 2;   //ڑMAX
  init.pHeapSystem = mpHeapMem;  //ʐMŎgHEAPID
  mpNetGame = GFL_NEW( mpHeapMem ) gflnet::p2p::NetGame(&init, mpP2pManager->GetInitParam());
}

void GFSharePlayNet::screenShotCheck(void)
{
#if 0
  //XN[VbgvO
  if(!mpSharePlaySystem){
    return;
  }
  //Ƀr[RT[`ŉĂȂ
  if(mMode != _BEACON_SEARCH){
    return;
  }

  if(mpSharePlaySystem->IsMyPicture()){ //łƂG
//    mMode = _SHOT_SENDMODE;   //Vbg[ǂɑJ

    if(GetBeacon( 0 )){  //N
      if(CreateMasterShot(0)){      //@todor[RZbg
        return;
      }
    }
  }
  {
    int	i;
    i = GetMyMacAddressCallIndex();
 //   OHNO_PRINT("-----\n");
    if( i != -1){
//      const DEFAULT_BEACON_SEND_DATA* pBeacon = (const DEFAULT_BEACON_SEND_DATA *)GetBeacon( i );
  //    if( pBeacon != NULL ){
    //    if(pBeacon->isScreenShotShare){
      //    MatchingShot(i);
        //  return;
//        }
  //    }
    }
  }
#endif
}



GFL_NAMESPACE_END(beacon)
GFL_NAMESPACE_END(netapp)
