#ifndef __GFEACHOTHER_H__
#define __GFEACHOTHER_H__
//======================================================================
/**
 * @file	  GFSharePlayNet.h
 * @brief	  GF^Cv̂ႢʐM
 * @author	k.ohno
 * @data	  2011/08/08
 */
//======================================================================

#include <gflib.h>
#include <gflnet.h>
#include <net/XyNetInterface.h>
#include "netapp/share/SharePlaySystem.h"
#include "netapp/share/ShareScreenShot.h"
#include <netapp/gfeachother/GFSharePlayNetListener.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(beacon)


class GFSharePlayNet : public xynet::XyNetInterface
{
  GFL_FORBID_COPY_AND_ASSIGN( GFSharePlayNet );
public:
  static const int BEACON_MAX = 100;  //Sl
private:

  enum{
    _NULL_MODE,
    _BEACON_SEARCH,
    _CREATE_MASTER,
    _CREATE_MASTER_MAIN,
    _CREATE_MASTER_MAIN1,
    _CREATE_MASTER_MAIN2,
    _CREATE_MASTER_MAIN3,
    _CREATE_MASTER_MAIN4,
    _CREATE_MASTER_MAIN41,
    _CREATE_MASTER_MAIN5,
    _CREATE_MASTER_SHUTDOWN,  //10
    _RESPOND,
    _MATCHING,
    _MATCHING1,
    _MATCHING2,
    _MATCHING3,
    _MATCHING4,
    _MATCHING5,
    _MATCHING6,
    _SHUTDOWN,

    _SHOT_SENDMODE, //20
    _SHOT_SENDMODE_MAIN,
    _SHOT_SENDMODE_MAIN1,
    _SHOT_SENDMODE_MAIN2,
    _SHOT_SENDMODE_MAIN3,
    _SHOT_SENDMODE_MAIN4,
    _SHOT_SENDMODE_MAIN41,
    _SHOT_SENDMODE_MAIN42,
    _SHOT_SENDMODE_MAIN4z,
    _SHOT_SENDMODE_DATASEND,
    _SHOT_SENDMODE_TIMI3,
    _SHOT_SENDMODE_COMMENT1,
    _SHOT_SENDMODE_COMMENT2,
    _SHOT_SENDMODE_MAIN5,
    _SHOT_SENDMODE_SHUTDOWN,


    _SHOT_RECVMODE,  //21
    _SHOT_RECVMODE1,
    _SHOT_RECVMODE2,
    _SHOT_RECVMODE3,
    _SHOT_RECVMODE4,
    _SHOT_RECVMODE5,
    _SHOT_RECVMODE_TIMI1,
    _SHOT_RECVMODE_TIMI2,
    _SHOT_RECVMODE_TIMIz,
    _SHOT_RECVMODE_DATASEND,
    _SHOT_RECVMODE_TIMI3,
    _SHOT_RECVMODE_COMMENT1,
    _SHOT_RECVMODE_COMMENT2,
    _SHOT_RECVMODE6,
    _SHOT_RECVMODE_SHUTDOWN,

    _END,
  };


  enum{
    _TIMING_01=23,
    _TIMING_02,
    _TIMING_03,
    _TIMING_04,
    _TIMING_05,
  };

  static gflnet::InitParameter netInitParam;//\
  static gflnet::InitParameterFixed netInitParamFix;//\

  u8 mSendBeacon[gflnet::BEACON_MAXBYTE];  ///< r[R
  gfl::heap::HeapBase*  mpHeapMem;         ///< {HEAP
  gfl::heap::HeapBase*  mpDeviceMem;       ///< foCXq[v

  gflnet::p2p::P2pManager* mpP2pManager;
  gflnet::p2p::NetGame* mpNetGame;
  gflnet::p2p::NetPlayer* mpNetPlayer;
  netapp::share::SharePlaySystem* mpSharePlaySystem;

  gflnet::Manager* mNetMng;  ///< gflnet::managerǗ
  bool mbFinal;   ///< I̊Ǘ
  bool mbFinalD;  ///< I̊Ǘ
  bool mbFinalX;  ///< I̊Ǘ
  int mMode;  ///샂[h
  int mTimer;
  int callNo;
  bool bConnect;
  bool mbMainAdd;
  bool mbContinue;
  int mSendPict;
  size_t mGetSize;   ///XN[Vbg摜TCY

//  u8 mBuff[MAC_ADDRESS_SIZE];  //MACADDRESS
  bit64 mTransferedID; //TransferedID
  bit64 mMy_TransferedID; //TransferedID
  bit64 maTransferedID[3];  //Ol
  gflnet::p2p::NetPlayer* mpNetPlayers[3];
  

public:
  //--------------------------------------------------------------
  /**
   * @brief   GFr[RNXRXgN^
   * @param   pBase  {HEAP
   * @param   pDev   foCXq[v
   */
  //--------------------------------------------------------------
  GFSharePlayNet(gfl::heap::HeapBase* pBase, gfl::heap::HeapBase *pDev,
              netapp::share::SharePlaySystem* pSharePlaySystem);
  virtual ~GFSharePlayNet();
  //--------------------------------------------------------------
  /**
   * @brief   
   * @param   sendData   f[^
   * @param   Mainŏsꍇ true
   */
  //--------------------------------------------------------------
  bool Initialize(const u8* sendData, bool bMainAdd);
  //--------------------------------------------------------------
  /**
   * @brief   C[v
   */
  //--------------------------------------------------------------
  void Main(void);
  //--------------------------------------------------------------
  /**
   * @brief    T[`ԂI
   * @retval   true   ʐMIJn
   * @retval   false  G[N
   */
  //--------------------------------------------------------------
  bool SearchFinalize(void);
  //--------------------------------------------------------------
  /**
   * @brief    }X^[ڑI
   * @retval   true   ʐMIJn
   * @retval   false  G[N
   */
  //--------------------------------------------------------------
  bool MasterFinalize(void);
  //--------------------------------------------------------------
  /**
  * @brief    }b`OڑI
  * @retval   true   ʐMIJn
  * @retval   false  G[N
  */
  //--------------------------------------------------------------
  bool MatchingFinalize(void);
  //--------------------------------------------------------------
  /**
   * @brief    ʐM͂ɏIȂ̂ŁAI̊Jns܂
   * @retval   true   ʐMIJn
   * @retval   false  G[N
   */
  //--------------------------------------------------------------
  bool Finalize(void);
  //--------------------------------------------------------------
  /**
   * @brief    IǂmFł܂ IĂ炱̃NXJł܂
               MainЂÂĂł
   * @retval   true  ʐMI
   * @retval   false ʐMI
   */
  //--------------------------------------------------------------
  bool IsFinalized(void);
  //--------------------------------------------------------------
  /**
   * @brief   r[R擾\ł
                ̃obt@̒g͒ʐMmainʂт
                      ύX\܂
                      ԎQƂꍇRs[ĎgĂ
   * @param   index   r[R̕ۑ
   * @return  r[Rf[^
   */
  //--------------------------------------------------------------
  void* GetBeacon(int index);
  //--------------------------------------------------------------
  /**
   * @brief   r[RMAC擾\ł
   * @param   transferedID      transferedID
   * @return  r[Rf[^
   */
  //--------------------------------------------------------------
  void* GetBeacon(bit64 transferedID);
  //--------------------------------------------------------------
  /**
   * @brief   r[RMAC擾\ł
   * @param   index      r[R̕ۑ
   * @return  r[RMAC
   */
  //--------------------------------------------------------------
  bit64 GetBeaconTransferedID(int index);
  //--------------------------------------------------------------
  /**
   * @brief   r[Rf[^ύX܂
   * @param   sendData     r[Rf[^
   */
  //--------------------------------------------------------------
  bool ChangeData(const u8* sendData);
  //--------------------------------------------------------------
  /**
   * @brief   MACAhXAĂяoĂ邩ǂmF
   *          MAC AhX͖{̂ƂɃj[NȒlłACȂǂɂĕύXĂ\܂B
   *          {̂̓sꍇ nn::cfg::GetTransferableId ֐gpĂB
   * @return  Ăяo󂯂Ăindex Ȃ-1
   */
  //--------------------------------------------------------------
  int GetMyMacAddressCallIndex(void);
  int GetMyMacAddressCallIndexNoShot(void);

  //--------------------------------------------------------------
  /**
   * @brief   w肵Đe@ɂȂ
   * @param   index      Er[R̃CfbNX
   */
  //--------------------------------------------------------------
  bool CreateMaster(int index);
  bool CreateMaster(u64 transferedID);
  bool CreateMasterShot(int index);
  bool CreateMaster(const u64* transferedIDBuff);

  //--------------------------------------------------------------
  /**
   * @brief   w肵Ďq@ɂȂ
   * @param   index      Er[R̃CfbNX
   */
  //--------------------------------------------------------------
  bool Matching(int index);
  bool MatchingShot(int index);
  bool Matching(u64 transferedID);

  //--------------------------------------------------------------
  /**
   * @brief   ڑJn   CreateMaster CreateMasterShot Matching MatchingShotƓ
   * @param   index      Er[R̃CfbNX
   */
  //--------------------------------------------------------------
  bool ConnectStart(int index);
  bool ConnectStart(u64 transferedID);
  //--------------------------------------------------------------
  /**
   * @brief   ڑtrue
   * @return  ڑ true
   */
  //--------------------------------------------------------------
  bool IsConnect(void);
  inline void ResetConnect(void){ bConnect = false; };

  //--------------------------------------------------------------
  /**
   * @brief   ċNKvȏꍇ̌
   * @return  ċNKvȎTRUE
   */
  //--------------------------------------------------------------
  bool IsReboot(void);

  //--------------------------------------------------------------
  /**
   * @brief r[RԕωʒmpXi̓o^
   * @param listener ʒm惊Xi[NXւ̃|C^
   */
  //--------------------------------------------------------------
  void RegistListener( GFSharePlayNetListener *listener );

  //--------------------------------------------------------------
  /**
   * @brief   Ă񂾐l̔ԍoĂ
   * @param ΂񂲂
   */
  //--------------------------------------------------------------
  inline void SetCallMatchingNo(int no){ callNo = no; };

  //--------------------------------------------------------------
  /**
   * @brief   Ă񂾐l̔ԍoĂ
   * @return ΂񂲂
   */
  //--------------------------------------------------------------
  inline int GetCallMatchingNo(void){ return callNo; };

  //--------------------------------------------------------------
  /**
   * @brief   ʐM𑱂邪GFSharePlayNetIꍇɌĂт܂
   */
  //--------------------------------------------------------------
  bool NetworkContinue(void);


  virtual void Update( void ){ Main(); };



private:
  void beaconSearchMain(int mode);
  void createMasterMain(void);
  void matchingMain(void);
  void initP2p( void );
  void deleteP2p( void );
  void screenShotCheck(void);
  void sendShotMain(void);
  void recvShotMain(void);
  void initSetup(void);


};



GFL_NAMESPACE_END(beacon)
GFL_NAMESPACE_END(netapp)

#endif //__GFEACHOTHER_H__
