
//=============================================================================
/**
 * @file   CameraCollision.cpp
 * @brief  JRWNX
 * @author rc N
 * @date   2012.06.11
 */
//=============================================================================

#include "CameraCollision.h"
#include <system/CollisionModel.h>

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraCollision::CCameraCollision() :
  m_pColModel(NULL)
  {
	return ;
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraCollision::DrawDebug(const CCameraTarget& inTarget)
  {
    if( m_pColModel )
    {

    }
  }

} // namespace field

/*  EOF  */


#if 0

//-----------------------------------------------------------------------------
// t[
//-----------------------------------------------------------------------------
void CCameraCollision::onUpdate(ti::CCamera* pCamera,CCameraLookAtOffset* pLookAtOffset,CCameraDistToLookAt* pDistToLookAt,CCameraTarget* pTarget,
								const ti::CCamera& inPreCamera,const CCameraLookAtBase& inLookAtBase,const EGameCameraMode eMode,const float fDiffTime)
{
	const float UP_OFST      = 0.1f*GAME_BASE_LENGTH;
	const float LOOK_AT_OFST = 0.2f*GAME_BASE_LENGTH;

	if(eMode == GAME_CAMERA_MODE_RESET)
		updateByWarp(pCamera,pLookAtOffset,pDistToLookAt,inLookAtBase,pTarget->getVisibleCheckPosition(),UP_OFST);
	else
	{
		const tiVector inPrePosi    = inPreCamera.m_inPosi;
		const tiVector inCurPosi    = pCamera->m_inPosi;
		const tiVector inLookAtPosi = pCamera->m_inLookAtPosi;

		tiVector inPreCurHitPosi,inPreCurHitNormal;
		if(gameUtil::checkCollisionHit(&inPreCurHitPosi,&inPreCurHitNormal,inPrePosi,inCurPosi) == TRUE)
		{
			const gameUtil::CPlane inPreCurColPlane(inPreCurHitPosi,inPreCurHitNormal);
			const tiVector inTargetPosi = pTarget->getVisibleCheckPosition();

			// ^[QbgBĂ烏[v
			if(inPreCurColPlane.getDistance(inTargetPosi) < 0.0f)
				updateByWarp(pCamera,pLookAtOffset,pDistToLookAt,inLookAtBase,inTargetPosi,UP_OFST);
			else
			{
				tiVector inFilterLookAtPosi = inLookAtPosi;
				tiVector inLookAtDir = inLookAtPosi - inTargetPosi;
				if(gameUtil::checkAndGetNormalizeVector(&inLookAtDir,NULL,inLookAtDir,TRUE) == TRUE)
				{
					// _BĂ猩ꏊɈړ
					const tiVector inLookAtOst = LOOK_AT_OFST*inLookAtDir;
					const tiVector inDestPosi  = inLookAtPosi + inLookAtOst;
					if(inPreCurColPlane.getDistance(inDestPosi) < 0.0f)
					{
						if(inPreCurColPlane.isHitLine(&inFilterLookAtPosi,inTargetPosi,inDestPosi) == TRUE)
							inFilterLookAtPosi -= inLookAtOst;
						else
							DBG_PRINT("JRWyxG[1 \n");
					}
				}

				tiVector inPostPosi = inPrePosi;
				if(inPreCurColPlane.isHitLine(&inPostPosi,inFilterLookAtPosi,inCurPosi) == TRUE)
					inPostPosi += UP_OFST*tiVector(inFilterLookAtPosi-inCurPosi).normalize3();
				else
					DBG_PRINT("JRWyxG[2 \n");

				if(gameUtil::checkCollisionHit(&inPostPosi,NULL,inPreCurHitPosi,inPostPosi) == TRUE)
					inPostPosi = getCenterValue(inPreCurHitPosi,inPostPosi);

				updateCamera(pCamera,pLookAtOffset,pDistToLookAt,inLookAtBase,inPostPosi);
			}
		}
		else
		{
			// lɓꂽRW`FbN
			tiVector inPostPosi;
			const tiVector inDestPosi = inCurPosi - UP_OFST*pCamera->m_inDir;
			if(gameUtil::checkCollisionHit(&inPostPosi,NULL,inCurPosi,inDestPosi) == TRUE)
			{
				const tiVector inTempPosi = inPostPosi;
				inPostPosi += UP_OFST*pCamera->m_inDir;
				if(gameUtil::checkCollisionHit(&inPostPosi,NULL,inTempPosi,inPostPosi) == TRUE)
					inPostPosi = getCenterValue(inTempPosi,inPostPosi);

				updateCamera(pCamera,pLookAtOffset,pDistToLookAt,inLookAtBase,inPostPosi);
			}
		}
	}

	// ^[Qbǧt[
	pTarget->postOnUpdate(pCamera,pLookAtOffset,pDistToLookAt,inPreCamera,inLookAtBase,UP_OFST,eMode,fDiffTime);
}

//-----------------------------------------------------------------------------
// [vɂXVs
//-----------------------------------------------------------------------------
bool CCameraCollision::updateByWarp(ti::CCamera* pCamera,CCameraLookAtOffset* pLookAtOffset,CCameraDistToLookAt* pDistToLookAt,const CCameraLookAtBase& inLookAtBase,const tiVector& inTargetPosi,const float fUpOfst)
{
	const tiVector inUpOfst = fUpOfst*tiVector(inTargetPosi - pCamera->m_inPosi).normalize3();

	tiVector inHitPosi;
	if(gameUtil::checkCollisionHit(&inHitPosi,NULL,inTargetPosi,pCamera->m_inPosi-inUpOfst) == TRUE)
	{
		updateCamera(pCamera,pLookAtOffset,pDistToLookAt,inLookAtBase,inHitPosi + inUpOfst);
		return TRUE;
	}
	else
		return FALSE;
}

//-----------------------------------------------------------------------------
// JXV
//-----------------------------------------------------------------------------
void CCameraCollision::updateCamera(ti::CCamera* pCamera,CCameraLookAtOffset* pLookAtOffset,CCameraDistToLookAt* pDistToLookAt,const CCameraLookAtBase& inLookAtBase,const tiVector& inCamPosi)
{
	pCamera->onUpdateAnyByPosiKeepDir(inCamPosi);
	pLookAtOffset->outUpdate(pCamera->m_inLookAtPosi,inLookAtBase);
	pDistToLookAt->outReset(pCamera->m_fDistToLookAt);
}

#endif





