#!/usr/bin/ruby
#===================================================================
#
# @brief  f[^쐬
#
# @data   12.06.11
# @author keisuke_takada
#
#===================================================================

# R[hw
$KCODE = 'SJIS'

#CSVǂݍ
require "csv"

#=======================================================================
# 萔
#=======================================================================
CSVNO_STEP = 0
CSVNO_FASTER_TIME_TO_DECISION = 1
CSVNO_MAX_NUM_OF_SIMULTANEOUS_APPEARANCE = 2
CSVNO_NUM_OF_GO_TO_THE_NEXT_STEP = 3
CSVNO_MAX_STAY_TIME = 4
CSVNO_MIN_STAY_TIME = 5
CSVNO_MINUS_STAY_TIME = 6
CSVNO_SWING_OF_STAY_TIME = 7
CSVNO_MAX_APPEARANCE_INTERVAL = 8
CSVNO_MIN_APPEARANCE_INTERVAL = 9
CSVNO_MINUS_APPEARANCE_INTERVAL = 10
CSVNO_INTERVAL_OF_TIME_QUICKLY_RAISED = 11

CSVNO_INFINITE_TABLE = 0

#=======================================================================
# ֐
#=======================================================================

def ElemPrintOfStepInfo( row )
  output = ""
  output += sprintf("\t\t{")
  output += sprintf("\t%d,", row[ CSVNO_FASTER_TIME_TO_DECISION ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MAX_NUM_OF_SIMULTANEOUS_APPEARANCE ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_NUM_OF_GO_TO_THE_NEXT_STEP ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MAX_STAY_TIME ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MIN_STAY_TIME ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MINUS_STAY_TIME ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_SWING_OF_STAY_TIME ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MAX_APPEARANCE_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MIN_APPEARANCE_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MINUS_APPEARANCE_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_INTERVAL_OF_TIME_QUICKLY_RAISED ].to_i )
  output += sprintf("\t},\n")
  return output;
end

def ElemPrintOfStepInfoOfInfiniteTable( row )
  output = ""
  output += sprintf("\t%d,", row[ CSVNO_INFINITE_TABLE ].to_i - 1 )
  return output;
end

def MakeCdatOfStepInfo()
  # CSVI[v
  step_info_csv = CSV.open( ARGV[0], 'r')

  #sXLbv
  step_info_csv.shift

  output =<<END_OF_STRING
//======================================================================
/**
 * @file  step_information.cdat
 * @bfief  Xebṽe[u
 * @author  takada GAMEFREAK inc.
 *
 * ̃t@C #{__FILE__} ɂ莩Ă܂
 */
//======================================================================
END_OF_STRING
  tail_string =<<END_OF_STRING
};
END_OF_STRING

output += sprintf( "const app::nuts2::PokemonData::StepInformation app::nuts2::PokemonData::stepInformation[ app::nuts2::DEGREE_OF_DIFFICULTY_NUM ][ app::nuts2::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

step_info_csv.each { |row|
  if row[ CSVNO_STEP ] == nil
  elsif row[ CSVNO_STEP ] =~ /\*/

  elsif count == 0 
    output += sprintf("\t{\n")
    output += ElemPrintOfStepInfo( row )
    count = count + 1
  elsif row[ CSVNO_STEP ] =~ /\#/
    output += sprintf("\t},\n\n")
    count = 0
  else
    output += ElemPrintOfStepInfo( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
step_info_csv.close

#=======================================================================
#=======================================================================

# CSVI[v
step_info_of_infinite_table_csv = CSV.open( ARGV[1], 'r')

#sXLbv
step_info_of_infinite_table_csv.shift

output += sprintf( "\nconst u32 app::nuts2::PokemonData::stepInformationOfInfiniteTable[ app::nuts2::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

step_info_of_infinite_table_csv.each { |row|
  if row[ CSVNO_INFINITE_TABLE ] == nil
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\*/

  elsif count == 0 
    output += ElemPrintOfStepInfoOfInfiniteTable( row )
    count = count + 1
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\#/
    output += sprintf("\t\n\n")
    count = 0
  else
    output += ElemPrintOfStepInfoOfInfiniteTable( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
step_info_of_infinite_table_csv.close

return output
end

File.open("step_information.cdat","w"){|file|
  cdat = MakeCdatOfStepInfo()
  file.puts cdat
}
