#!/usr/bin/ruby
#===================================================================
#
# @brief  f[^쐬
#
# @data   12.06.11
# @author keisuke_takada
#
#===================================================================

# R[hw
$KCODE = 'SJIS'

#CSVǂݍ
require "csv"

#=======================================================================
# 萔
#=======================================================================
CSVNO_STEP = 0
CSVNO_FIRST_INTERVAL = 1
CSVNO_CHANGE_VALUE_INTERVAL_SUCCESS = 2
CSVNO_CHANGE_VALUE_INTERVAL_ON_JUST = 3
CSVNO_MINIMUM_INTERVAL = 4
CSVNO_FIVER_INTERVAL = 5
CSVNO_TIME_LIMIT = 6
CSVNO_NUMBER_OF_STARTfEVER_TIME = 7

CSVNO_INFINITE_TABLE = 0

#=======================================================================
# ֐
#=======================================================================

def ElemPrintOfStepInfo( row )
  output = ""
  output += sprintf("\t\t{")
  output += sprintf("\t%d,", row[ CSVNO_FIRST_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_CHANGE_VALUE_INTERVAL_SUCCESS ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_CHANGE_VALUE_INTERVAL_ON_JUST ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_MINIMUM_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_FIVER_INTERVAL ].to_i )
  output += sprintf("\t%d,", row[ CSVNO_TIME_LIMIT ].to_i * 60 )
  output += sprintf("\t%d,", row[ CSVNO_NUMBER_OF_STARTfEVER_TIME ].to_i )
  output += sprintf("\t},\n")
  return output;
end

def ElemPrintOfStepInfoOfInfiniteTable( row )
  output = ""
  output += sprintf("\t%d,", row[ CSVNO_INFINITE_TABLE ].to_i - 1 )
  return output;
end

def MakeCdatOfStepInfo()
  # CSVI[v
  step_info_csv = CSV.open( ARGV[0], 'r')

  #sXLbv
  step_info_csv.shift

  output =<<END_OF_STRING
//======================================================================
/**
 * @file  step_information.cdat
 * @bfief  Xebṽe[u
 * @author  takada GAMEFREAK inc.
 *
 * ̃t@C #{__FILE__} ɂ莩Ă܂
 */
//======================================================================
END_OF_STRING
  tail_string =<<END_OF_STRING
};
END_OF_STRING

output += sprintf( "const app::heading::StepInfo app::heading::Process::stepInfo[ app::heading::DEGREE_OF_DIFFICULTY_NUM ][ app::heading::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

step_info_csv.each { |row|
  if row[ CSVNO_STEP ] == nil
  elsif row[ CSVNO_STEP ] =~ /\*/

  elsif count == 0 
    output += sprintf("\t{\n")
    output += ElemPrintOfStepInfo( row )
    count = count + 1
  elsif row[ CSVNO_STEP ] =~ /\#/
    output += sprintf("\t},\n\n")
    count = 0
  else
    output += ElemPrintOfStepInfo( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
step_info_csv.close

#=======================================================================
#=======================================================================

# CSVI[v
step_info_of_infinite_table_csv = CSV.open( ARGV[1], 'r')

#sXLbv
step_info_of_infinite_table_csv.shift

output += sprintf( "\nconst u32 app::heading::Process::stepInformationOfInfiniteTable[ app::heading::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

step_info_of_infinite_table_csv.each { |row|
  if row[ CSVNO_INFINITE_TABLE ] == nil
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\*/

  elsif count == 0 
    output += ElemPrintOfStepInfoOfInfiniteTable( row )
    count = count + 1
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\#/
    output += sprintf("\t\n\n")
    count = 0
  else
    output += ElemPrintOfStepInfoOfInfiniteTable( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
step_info_of_infinite_table_csv.close

return output
end

File.open("step_information.cdat","w"){|file|
  cdat = MakeCdatOfStepInfo()
  file.puts cdat
}
