#!/usr/bin/ruby
#===================================================================
#
# @brief  f[^쐬
#
# @data   12.06.11
# @author keisuke_takada
#
#===================================================================

# R[hw
$KCODE = 'SJIS'

#CSVǂݍ
require "csv"

#=======================================================================
# 萔
#=======================================================================
CSVNO_STEP = 0
CSVNO_KUZURE_PROBABILITY = 1
CSVNO_HEAVY_PROBABILITY = 2
CSVNO_FALL_INITIAL_SPEED_OF_PINK_BALL = 3
CSVNO_FALL_ACCELERATION_OF_PINK_BALL = 4
CSVNO_BACK_INITIAL_SPEED_OF_PINK_BALL = 5
CSVNO_BACK_ACCELERATION_OF_PINK_BALL = 6
CSVNO_JUST_BACK_INITIAL_SPEED_OF_PINK_BALL = 7
CSVNO_JUST_BACK_ACCELERATION_OF_PINK_BALL = 8
CSVNO_FALL_INITIAL_SPEED_OF_ORANGE_BALL = 9
CSVNO_FALL_ACCELERATION_OF_ORANGE_BALL = 10
CSVNO_BACK_INITIAL_SPEED_OF_ORANGE_BALL = 11
CSVNO_BACK_ACCELERATION_OF_ORANGE_BALL = 12
CSVNO_JUST_BACK_INITIAL_SPEED_OF_ORANGE_BALL = 13
CSVNO_JUST_BACK_ACCELERATION_OF_ORANGEbALL = 14
CSVNO_FALL_INITIAL_SPEED_OF_BLUE_BALL = 15
CSVNO_FALL_ACCELERATION_OF_BbLUE_BALL = 16
CSVNO_BACK_INITIAL_SPEED_OF_BLUE_BALL = 17
CSVNO_BACK_ACCELERATION_OF_BLUE_BALL = 18
CSVNO_JUST_BACK_INITIAL_SPEED_OF_BLUE_BALL = 19
CSVNO_JUST_BACK_ACCELERATION_OF_BLUE_BALL = 20
CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_PINK_BALL = 21
CSVNO_FALL_ACCELERATION_OF_KUZURE_PINK_BALL = 22
CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_PINK_BALL = 23
CSVNO_BACK_ACCELERATION_OF_KUZURE_PINK_BALL = 24
CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_PINK_BALL = 25
CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_PINK_BALL = 26
CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL = 27
CSVNO_FALL_ACCELERATION_OF_KUZURE_ORANGE_BALL = 28
CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL = 29
CSVNO_BACK_ACCELERATION_OF_KUZURE_ORANGE_BALL = 30
CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL = 31
CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_ORANGE_BALL = 32
CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_BLUE_BALL = 33
CSVNO_FALL_ACCELERATION_OF_KUZURE_BLUE_BALL = 34
CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_BLUE_BALL = 35
CSVNO_BACK_ACCELERATION_OF_KUZURE_BLUE_BALL = 36
CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_BLUE_BALL = 37
CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_BLUE_BALL = 38
CSVNO_FALL_INITIAL_SPEED_OF_HEAVY_BALL = 39
CSVNO_FALL_ACCELERATION_OF_HEAVY_BALL = 40
CSVNO_BACK_INITIAL_SPEED_OF_HEAVY_BALL = 41
CSVNO_BACK_ACCELERATION_OF_HEAVY_BALL = 42
CSVNO_JUST_BACK_INITIAL_SPEED_OF_HEAVY_BALL = 43
CSVNO_JUST_BACK_ACCELERATION_OF_HEAVY_BALL = 44
CSVNO_FALL_INITIAL_SPEED_OF_BIG_BALL = 45
CSVNO_FALL_ACCELERATION_OF_BIG_BALL = 46
CSVNO_BACK_INITIAL_SPEED_OF_BIG_BALL = 47
CSVNO_BACK_ACCELERATION_OF_BIG_BALL = 48
CSVNO_JUST_BACK_INITIAL_SPEED_OF_BIG_BALL = 49
CSVNO_JUST_BACK_ACCELERATION_OF_BIG_BALL = 50

CSVNO_INFINITE_TABLE = 0

FALL_INITIAL_SPEED_FACTORS = 100.0;
BACK_INITIAL_SPEED_FACTORS = 10.0;
ACCELERATION_SPEED_FACTORS = 50.0;

#=======================================================================
# ֐
#=======================================================================

def ElemPrintOfBallInfo( row )
  output = ""
  output += sprintf("\t\t{")
  output += sprintf("\t%d,", row[ CSVNO_KUZURE_PROBABILITY ].to_i );
  output += sprintf("\t%d,", row[ CSVNO_HEAVY_PROBABILITY ].to_i );
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_PINK_BALL ].to_f / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_PINK_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_PINK_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_ORANGE_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_ORANGE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_ORANGE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_ORANGE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_ORANGE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_ORANGEbALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_BLUE_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_BbLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_BLUE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_BLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_BLUE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_BLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_PINK_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_KUZURE_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_PINK_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_KUZURE_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_PINK_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_PINK_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_KUZURE_ORANGE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_KUZURE_ORANGE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_ORANGE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_ORANGE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_KUZURE_BLUE_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_KUZURE_BLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_KUZURE_BLUE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_KUZURE_BLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_KUZURE_BLUE_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_KUZURE_BLUE_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_HEAVY_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_HEAVY_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_HEAVY_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_HEAVY_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_HEAVY_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_HEAVY_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_INITIAL_SPEED_OF_BIG_BALL ].to_f  / FALL_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_FALL_ACCELERATION_OF_BIG_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_INITIAL_SPEED_OF_BIG_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_BACK_ACCELERATION_OF_BIG_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_INITIAL_SPEED_OF_BIG_BALL ].to_f  / BACK_INITIAL_SPEED_FACTORS )
  output += sprintf("\t%f,", row[ CSVNO_JUST_BACK_ACCELERATION_OF_BIG_BALL ].to_f / ACCELERATION_SPEED_FACTORS )
  output += sprintf("\t},\n")

  return output;
end

def ElemPrintOfBallInfoOfInfiniteTable( row )
  output = ""
  output += sprintf("\t%d,", row[ CSVNO_INFINITE_TABLE ].to_i - 1 )
  return output;
end

def MakeCdatOfBallInfo()
  # CSVI[v
  ball_info_csv = CSV.open( ARGV[0], 'r')

  #sXLbv
  ball_info_csv.shift

  output =<<END_OF_STRING
//======================================================================
/**
 * @file  ball_information.cdat
 * @bfief  {[̃e[u
 * @author  takada GAMEFREAK inc.
 *
 * ̃t@C #{__FILE__} ɂ莩Ă܂
 */
//======================================================================
END_OF_STRING
  tail_string =<<END_OF_STRING
};
END_OF_STRING

output += sprintf( "const app::heading::Ball::BallInfo app::heading::Ball::ballInfo[ app::heading::DEGREE_OF_DIFFICULTY_NUM ][ app::heading::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

ball_info_csv.each { |row|
  if row[ CSVNO_STEP ] == nil
  elsif row[ CSVNO_STEP ] =~ /\*/

  elsif count == 0 
    output += sprintf("\t{\n")
    output += ElemPrintOfBallInfo( row )
    count = count + 1
  elsif row[ CSVNO_STEP ] =~ /\#/
    output += sprintf("\t},\n\n")
    count = 0
  else
    output += ElemPrintOfBallInfo( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
ball_info_csv.close

#=======================================================================
#=======================================================================

# CSVI[v
ball_info_of_infinite_table_csv = CSV.open( ARGV[1], 'r')

#sXLbv
ball_info_of_infinite_table_csv.shift

output += sprintf( "\nconst u32 app::heading::Ball::ballInformationOfInfiniteTable[ app::heading::NUMBER_OF_TABLE_OF_INFINITE ] = \n" )
output += sprintf( "{\n\n" )

#CSVo
count = 0

ball_info_of_infinite_table_csv.each { |row|
  if row[ CSVNO_INFINITE_TABLE ] == nil
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\*/

  elsif count == 0 
    output += ElemPrintOfBallInfoOfInfiniteTable( row )
    count = count + 1
  elsif row[ CSVNO_INFINITE_TABLE ] =~ /\#/
    output += sprintf("\t\n\n")
    count = 0
  else
    output += ElemPrintOfBallInfoOfInfiniteTable( row )
    count = count + 1
  end
}
output += tail_string

#CSV N[Y
ball_info_of_infinite_table_csv.close

return output
end

File.open("ball_information.cdat","w"){|file|
  cdat = MakeCdatOfBallInfo()
  file.puts cdat
}
