#TAPŎgpĂRo[^XYpɉ by soga
#CMDLA͖AG^[i
#AjZbgƂ͈ꉞ\ɂĂ
#
require File.dirname(__FILE__) + '/gaix_array.rb'
$KCODE = "SJIS"

NONE_CODE = 0xffffffff

class AnmData
  def initialize( dir_name )
    @mAnmName = ""
    @mSklaIdx = NONE_CODE
    @mMataIdx = NONE_CODE

    @mSklaOfs = NONE_CODE
    @mMataOfs = NONE_CODE

    @mAnmDataCountSkla = 0
    @mAnmDataCountMata = 0

    @mActName = ""
    @mIdxOfs = 0
    @mDirName = dir_name
  end

  def Set(inActName, inRow, inGaixAry, inOfs)
    ofs = inOfs
    @mIdxOfs = inOfs

    @mAnmName = inRow[0].to_s
    @mActName = inActName

    skla_name = inRow[1].to_s
    mata_name = inRow[2].to_s

    @mSklaIdx = GetIdx(skla_name, inGaixAry, "BCSKLA_LZ")
    @mMataIdx = GetIdx(mata_name, inGaixAry, "BCMATA_LZ")

    if @mSklaIdx != NONE_CODE then
      @mSklaOfs = ofs
      ofs += 1
    end
    if @mMataIdx != NONE_CODE then
      @mMataOfs = ofs
      ofs += 1
    end

    if @mSklaIdx != NONE_CODE then
      count = GetAnmCount( skla_name, ".cskla" )
      if @mAnmDataCountSkla < count
        @mAnmDataCountSkla = count
      end
    end
    if @mMataIdx != NONE_CODE then
      count = GetAnmCount( mata_name, ".cmata" )
      if @mAnmDataCountMata < count
        @mAnmDataCountMata = count
      end
    end

    return ofs
  end

  def GetIdx( inName, inGaixAry, inFileTypeName )
    if inName == "NONE" then
      return NONE_CODE
    else
      name = "GARC_" + inGaixAry.GetName() + "_" + inName + "_" + inFileTypeName

      if inGaixAry.IsExist(name) == false then
        printf("(anm_data_cnv.rb) ERROR:: no exist %s", name)
        exit -1
      end
      return inGaixAry.GetIdx( name )
    end
  end

  def GetAnmCount( inName, inFileExtName )
    file_name = @mDirName + "\\" + inName + inFileExtName
    file = open( file_name, "r" )
    anm_count = 0

    while line = file.gets
      if line.index("<MemberAnimationData") != nil
        anm_count += 1
      end
    end

    file.close

    return anm_count
  end

  def GetSklaOfs()
    return @mSklaOfs
  end

  def GetMataOfs()
    return @mMataOfs
  end

  def GetAnmDataCountSkla()
    return @mAnmDataCountSkla
  end

  def GetAnmDataCountMata()
    return @mAnmDataCountMata
  end

  def Write(outFile)
    ary = Array.new
    ary << @mIdxOfs
    ary << @mSklaIdx
    ary << @mMataIdx
    pack_str = ary.pack("L3")
    outFile.write(pack_str)
  end

  def WriteEnumCode(inActName, outFile)
    outFile.printf("\tANM_%s_%s,\n",inActName.upcase, @mAnmName.upcase)
  end

  def Dump()
    printf("%d %s (%d, %d)\n",@mIdxOfs, @mAnmName, @mSklaIdx, @mMataIdx)
  end
end

class Pattern
  def initialize( anm_count_skla )
    @mDataAry = Array.new
    @mFirstSklaIdx = NONE_CODE
    @mFirstMataIdx = NONE_CODE
    @mAnmDataCountSkla = anm_count_skla
    @mAnmDataCountMata = 0
  end

  def SetData(data, idx)
    @mDataAry << data
    if @mFirstSklaIdx == NONE_CODE then
      @mFirstSklaIdx = data.GetSklaOfs()
    end

    if @mFirstMataIdx == NONE_CODE then
      @mFirstMataIdx = data.GetMataOfs()
    end
    count = data.GetAnmDataCountSkla
    if @mAnmDataCountSkla < count
      @mAnmDataCountSkla = count
    end
    count = data.GetAnmDataCountMata
    if @mAnmDataCountMata < count
      @mAnmDataCountMata = count
    end
  end

  def WriteActionNum(outFile)
    ary = Array.new
    ary << @mDataAry.length
    pack_str = ary.pack("L1")
    outFile.write(pack_str)
  end

  def WriteActionAryTop(idx, outFile)
    ary = Array.new
    ary << idx
    pack_str = ary.pack("L1")
    outFile.write(pack_str)
    idx += @mDataAry.length
    return idx
  end

  def WriteFirstAnmIdx(outFile)
    ary = Array.new
    ary << @mFirstSklaIdx
    ary << @mFirstMataIdx
    pack_str = ary.pack("L2")
    outFile.write(pack_str)
  end

  def WriteAnmDataCount(outFile)
    ary = Array.new
    ary << @mAnmDataCountSkla
    ary << @mAnmDataCountMata
    pack_str = ary.pack("L2")
    outFile.write(pack_str)
  end

  def Write(outFile)
    @mDataAry.each{|d|
      d.Write(outFile)
    }
  end

  def WriteEnumCode(inActName, outFile)
    @mDataAry.each{|d|
      d.WriteEnumCode(inActName, outFile)
    }
  end

  def Dump()
    @mDataAry.each{|d|
      d.Dump()
    }
  end
end

class AnmCsv
  def initialize
    @mPatternAry = Array.new
    @mActName = ""
    @mDirName = ""
  end

  def GetBoneCount( inActName )
    file_name = @mDirName + "\\" + inActName + ".cmdl"
    file = open( file_name, "r" )
    bone_count = 0
    while line = file.gets
      if line.index("BoneCount") != nil
        line.gsub!(/\s+/,"")
        line.gsub!(/\"/," ")
        bone_count = line.split(/ /)[ 3 ].to_i
        break
      end
    end

    file.close

    return bone_count
  end

  def Setup(inFileName, inGaixAry)
    ofs_idx = 0
    action_idx = 0
    #@mActName = inFileName.sub(".csv","").sub("./tmp/","")
    @mActName = File::basename( inFileName, ".*" )
    @mDirName = File::dirname( inFileName )
    bone_count = GetBoneCount( @mActName )
    end_flg = false
    file = open(inFileName,"r")
    #sƂ΂
    line = file.gets
    while line = file.gets
      #u#ENDvĎ
      if line =~/^#END/ then
        end_flg = true
        break
      end
      
      row = line.split(",")
      #u#PATTERNvĎ
      if row[0].to_s == "#PATTERN" then
        pattern = Pattern.new( bone_count )
        @mPatternAry << pattern
        ofs_idx = 0
        action_idx = 0
      else
        pat = @mPatternAry.pop
        data = AnmData.new( @mDirName )
        ofs_idx = data.Set(@mActName, row, inGaixAry, ofs_idx)
        pat.SetData( data, action_idx )
        action_idx += 1
        @mPatternAry << pat
      end
    end

    file.close
    
    if end_flg == false then
      printf("(anm_data_cnv.rb) ERROR:: #END nothing")
      exit -1
    end
  end

  def Write(outFile)
    #p^[Lq
    ary = Array.new
    ary << @mPatternAry.length
    pack_str = ary.pack("L1")
    outFile.write(pack_str)
    #ep^[̃ANVLq
    @mPatternAry.each{|p|
      p.WriteActionNum(outFile)
    }

    #ep^[̃ANVItZbgLq
    idx = 0
    @mPatternAry.each{|p|
      idx = p.WriteActionAryTop(idx, outFile)
    }

    #p^[̊eAjoCfbNXLq
    @mPatternAry.each{|p|
      p.WriteFirstAnmIdx(outFile)
    }

    #p^[̊eAjf[^őJEgLq
    @mPatternAry.each{|p|
      p.WriteAnmDataCount(outFile)
    }

    #eANṼAjf[^Lq
    @mPatternAry.each{|p|
      p.Write(outFile)
    }
  end

  def MakeHeader(inHeaderDir)
    file_name = inHeaderDir + "anm_" + @mActName + "_def.h"
    file = open(file_name, "w")
    file.print("// create by anm_data_cnv.rb\n")
    file.printf("#if !defined(__%s_H__)\n",File::basename(file_name,".*").upcase)
    file.printf("#define __%s_H__\n",File::basename(file_name,".*").upcase)
    file.print("\n")
    
    @mPatternAry.each{|p|
      file.print("enum{\n")
      p.WriteEnumCode(@mActName, file)
      file.print("};\n")
    }
    file.print("#endif\n")
    file.close
  end

  def Dump()
    @mPatternAry.each{|p|
      p.Dump()
    }
  end
end

csv_file_name = ARGV.shift
bin_dir = ARGV.shift
header_dir = ARGV.shift
g3d_gaix_file_name = ARGV.shift
gaix_ary = GaixAry.new
gaix_ary.Setup(g3d_gaix_file_name)

anm_csv = AnmCsv.new
anm_csv.Setup(csv_file_name, gaix_ary)
#anm_csv.Dump()
out_file_name = csv_file_name.sub(".csv",".anmbin").sub("./tmp/",bin_dir)
out_file = open(out_file_name,"wb")
anm_csv.Write(out_file)
anm_csv.MakeHeader(header_dir)
out_file.close
