//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_MailListView.cpp
 *	@brief  ʃ[Xg
 *	@author	Toru=Nagihashi
 *	@date		2012.06.11
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_MailListView.h"
#include <arc/arc_def.h>
#include <arc/message.gaix>
#include <arc/hologram_mail_gra.gaix>
#include "hologram_lower.h"
#include "hologram_lower_pane.h"
#include "app_hologrammail_common_define.h"
#include <message/msg_hologram_mail.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
static const app::tool::PaneList::PANE_DATA ListPaneData[] =
{
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_00,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_00,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_00,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_01,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_01,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_01,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_02,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_02,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_02,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_03,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_03,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_03,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_04,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_04,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_04,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_05,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_05,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_05,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_06,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_06,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_06,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_07,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_07,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_07,	    // bounding
	},
	{
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_LIST_08,		// picture
		PANENAME_HOLOGRAM_LOWER_PANE_HOLO_TEXT_08,		// text
		PANENAME_HOLOGRAM_LOWER_PANE_BOUNDING_08,	    // bounding
	},
};



//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param mail_manager  [}l[W[
 */
MailListView::MailListView( app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, MailManager *mail_manager ):
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_mail_manager( mail_manager ),
  m_listener( NULL ),
  m_pane_list_result( app::tool::PaneList::RET_NONE ),
  m_list_mode( LIST_MODE_MAIL )
{
  m_graphicSystem = graphics_system;
  this->CreateLayout( heap, layout_system );
  LocalMail::SetMsgData( m_g2dUtil->GetMessageData() );
  this->CreatePaneList( heap, mail_manager->GetMailMax() );
  this->CreateTouchbar( heap, layout_system );
}

/**
 * @brief fXgN^
 */
MailListView::~MailListView()
{
  this->DeleteTouchbar();
  this->DeletePaneList();
  this->DeleteLayout();
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void MailListView::Update( void )
{
  m_pane_list_result  = m_pane_list->Update();
	switch( m_pane_list_result )
  {
  case app::tool::PaneList::RET_LIST_SELECT:
    switch( m_list_mode )
    {
    case LIST_MODE_MAIL:
      break;
    case LIST_MODE_PERSON:
      m_list_mode = LIST_MODE_MAIL;
      //l͂PIW
      m_mail_manager->SortPerson( static_cast<Person>(m_pane_list->GetItemPos() +1) );
      this->DeletePaneList();
      this->CreatePaneList( m_heap, m_mail_manager->GetMailMax() );
      break;
    case LIST_MODE_TAG:
      m_list_mode = LIST_MODE_MAIL;
      m_mail_manager->SortTag( static_cast<MailTag>(m_pane_list->GetItemPos()) );
      this->DeletePaneList();
      this->CreatePaneList( m_heap, m_mail_manager->GetMailMax() );
      break;
    }
    break;
  case app::tool::PaneList::RET_NONE:
    m_scroll_bar->SetRequest( app::util::ScrollBar::REQ_BAR_OUT );
    break;
  default:
    m_scroll_bar->SetRequest( app::util::ScrollBar::REQ_BAR_IN );
    break;
  }

  if( m_listener )
  {
    m_listener->OnSelectedExitButton();
  }

  this->app::ui::UIView::Update();
}

/**
 * @brief `
 */
void MailListView::Draw( void )
{
  m_g2dUtil->Draw2D( m_graphicSystem, 0);
  

  u32	pos;
	f32	scroll;
	m_pane_list->GetCursorData( &pos, &scroll );
	m_scroll_bar->Draw( scroll );
  
  m_touchbar_view->Draw();
}
/**
 * @brief Xi[Zbg
 *
 * @param listener  Xi[
 */
void MailListView::SetLister( MailListViewListener *listener )
{
  m_listener  = listener;
}

//-----------------------------------------------------------------------
// app::tool::PaneList::CallBack̎
//-----------------------------------------------------------------------
// J[\ړ̃R[obN֐
void MailListView::CallBack_CursorMove( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
  if( pane_index != app::tool::PaneList::CALLBACK_PANE_NONE )
  {
    gfl::grp::g2d::LytPane* lyt_pane = this->GetLayoutWork(0)->GetPane( pane[pane_index].text );
    lyt_pane->SetAlpha( 128 );
  }
}
// J[\\ɂR[obN֐
void MailListView::CallBack_CursorOff( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
	if( pane_index != app::tool::PaneList::CALLBACK_PANE_NONE )
  {
    gfl::grp::g2d::LytPane* lyt_pane = this->GetLayoutWork(0)->GetPane( pane[pane_index].text );
    lyt_pane->SetAlpha( 255 );
  }
}
// Xg̍ڂ`悷R[obN֐
void MailListView::CallBack_ListWrite( void * work, const app::tool::PaneList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
	if( pane_index != app::tool::PaneList::CALLBACK_PANE_NONE )
  {
    switch( m_list_mode )
    {
    case LIST_MODE_MAIL:
      {
        IMail *mail = m_mail_manager->GetMail( pos );
        gfl::str::StrBuf *strbuf = m_g2dUtil->GetTmepStrBuf(1);
        mail->GetTitle( strbuf, m_heap->GetSystemHeap() );
        this->SetTextboxPaneString( 0, pane[pane_index].text, strbuf );
      }
      break;
    case LIST_MODE_PERSON:
      this->SetTextboxPaneMessage( 0, pane[pane_index].text,msg_holo_person_00+pos );
      break;
    case LIST_MODE_TAG:
      this->SetTextboxPaneMessage( 0, pane[pane_index].text,msg_holo_tag_00+pos );
      break;
    }
  }
}
// ւpR[obN֐
void MailListView::CallBack_ItemChange( void * work, u32 pos1, u32 pos2 )
{
}

//-----------------------------------------------------------------------
// app::ui::UITouchBarListener̎
//-----------------------------------------------------------------------
/**
 * @brief {^ꂽƂʒm
 * @param buttonID
 * @retval t[ő̓CxgȂtrue
 * @retval ̃CxgrȂfalse
 */
bool MailListView::OnSelectedButton( u32 buttonID )
{
  switch( buttonID )
  {
  case app::ui::UITouchBarView::BUTTON_ID_EXIT:   ///<~{^
    if( m_listener )
    {
      m_listener->OnSelectedExitButton();
    }
    break;
  case app::ui::UITouchBarView::BUTTON_ID_RETURN: ///<߂{^
    if( m_listener )
    {
      m_listener->OnSelectedReturnButton();
    }
    break;
  case app::ui::UITouchBarView::BUTTON_ID_WINDOW_00:
    m_list_mode = LIST_MODE_MAIL;
    //l͂PIW
    m_mail_manager->SortOrder();
    this->DeletePaneList();
    this->CreatePaneList( m_heap, m_mail_manager->GetMailMax() );
    break;
  case app::ui::UITouchBarView::BUTTON_ID_WINDOW_01:
    m_list_mode = LIST_MODE_PERSON;
    //l͂PIW
    m_mail_manager->SortOrder();
    this->DeletePaneList();
    this->CreatePaneList( m_heap, PERSON_MAX );
    break;
  case app::ui::UITouchBarView::BUTTON_ID_WINDOW_02:
    m_list_mode = LIST_MODE_TAG;
    //l͂PIW
    m_mail_manager->SortOrder();
    this->DeletePaneList();
    this->CreatePaneList( m_heap, MAIL_TAG_MAX );
    break;
  }
    

  return false;
}


//-----------------------------------------------------------------------
// app::ui::UIResponder̎
//-----------------------------------------------------------------------
/**
* @brief  {^̃AjԂ擾
*
* @param  none
*
* @return trueAj  falseAjĂȂ
* 
* @note ̊֐I[o[[h邱ƂŁAAj[VrOŐݒł
*       {^}l[W[̃`FbNȂȂ̂ŁAOōs
*/
bool MailListView::IsButtonAnimation( void ) const
{
  bool ret = this->app::ui::UIResponder::IsButtonAnimation();
  
  if( ret || m_pane_list_result != app::tool::PaneList::RET_NONE )
  {
    return true;
  }
  else
  {
    return false;
  }
}
  
//-----------------------------------------------------------------------
// Private
//-----------------------------------------------------------------------
/**
 * @brief CAEg쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void MailListView::CreateLayout( app::util::Heap * heap,gfl::grp::g2d::LytSys* layout_system )
{
  static const app::util::G2DUtil::LYT_RES_DATA LYTRES_TABLE[] =
  {
    {
      ARCID_HOLOGRAM_MAIL_GRA, GARC_hologram_mail_gra_hologram_lower_LYTDAT_LZ, 0
    }
  };
  static const app::util::G2DUtil::LYTWK_DATA LYTWK_DATA_TABLE[]  =
  {
    {
      0,
      LYTRES_HOLOGRAM_LOWER_HOLOGRAM_LOWER_BCLYT,
      NULL,
      0,
      0,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    }
  };

  this->Create2D( heap, layout_system, GFL_NELEMS(LYTWK_DATA_TABLE), LYTRES_TABLE, GFL_NELEMS(LYTRES_TABLE), LYTWK_DATA_TABLE, GFL_NELEMS(LYTWK_DATA_TABLE), GARC_message_hologram_mail_DAT );
}

/**
 * @brief CAEgj
 */
void MailListView::DeleteLayout( void )
{
  this->Delete2D();
}

/**
 * @brief yCXg쐬
 *
 * @param heap  q[v
 */
void MailListView::CreatePaneList( app::util::Heap * heap, u32 max )
{
  app::tool::PaneList::SETUP_PARAM list_setup = {
		heap->GetSystemHeap(),
		this->GetLayoutWork(0),
		ListPaneData,
		GFL_NELEMS(ListPaneData),

		max,
		GFL_NELEMS(ListPaneData)-3,
	  0,  //J[\ʒu
		0,  //XN[ʒu

		90.0f,
		320.0f,
		30.0f,

		-1,

		app::tool::PaneList::PAGE_SKIP_LR_BUTTON,
		true,
		false,

		SEQ_SE_SELECT1,

		this,
		NULL
	};

	m_pane_list = GFL_NEW( heap->GetSystemHeap() ) app::tool::PaneList( &list_setup );
  

  app::util::ScrollBar::SETUP_PARAM bar_setup = {
    gfl::grp::DISPLAY_LOWER,
		app::tool::ScrollBar::SCROLL_DIRECTION_VERTICAL,
		180,
		150,
		15,
		0
	};
  
  bar_setup.max = max-6;
  m_scroll_bar  = GFL_NEW( heap->GetSystemHeap() ) app::util::ScrollBar( heap->GetSystemHeap(), m_graphicSystem, &bar_setup );
}
/**
 * @brief yCXgj
 */
void MailListView::DeletePaneList( void )
{
  GFL_SAFE_DELETE( m_scroll_bar );
  GFL_SAFE_DELETE( m_pane_list );
}
/**
 * @brief ^b`o[쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void MailListView::CreateTouchbar( app::util::Heap * heap, gfl::grp::g2d::LytSys* layout_system )
{
  app::ui::UITouchBarView::SETUP  setup[] =
  {
    {
      app::ui::UITouchBarView::BUTTON_ID_EXIT,
      PANENAME_HOLOGRAM_LOWER_PANE_EXIT_ICON_POS
    },
    {
      app::ui::UITouchBarView::BUTTON_ID_RETURN,
      PANENAME_HOLOGRAM_LOWER_PANE_RETURN_ICON_POS
    },
    {
      app::ui::UITouchBarView::BUTTON_ID_WINDOW_00,
      PANENAME_HOLOGRAM_LOWER_PANE_TIMELINE_BTN_00
    },
    {
      app::ui::UITouchBarView::BUTTON_ID_WINDOW_01,
      PANENAME_HOLOGRAM_LOWER_PANE_PERSON_BTN_00
    },
    {
      app::ui::UITouchBarView::BUTTON_ID_WINDOW_02,
      PANENAME_HOLOGRAM_LOWER_PANE_TAG_BTN_00
    },
  };

  m_touchbar_view = GFL_NEW(heap->GetSystemHeap()) app::ui::UITouchBarView( heap, m_graphicSystem, layout_system, this->GetLayoutWork(0), setup, GFL_NELEMS(setup) );
  m_touchbar_view->SetListener( this );
  this->AddSubView( m_touchbar_view );
}
/**
 * @brief ^b`o[j
 */
void MailListView::DeleteTouchbar( void )
{
  m_touchbar_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_touchbar_view );
}

GFL_NAMESPACE_END(hologrammaill)
GFL_NAMESPACE_END(app)
