//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_MailManager.h
 *	@brief  [Ǘ
 *	@author	Toru=Nagihashi
 *	@date		2012.06.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_HOLOGRAMMAIL_MAILMANAGER_H__)
#define __APP_HOLOGRAMMAIL_MAILMANAGER_H__

#include <gflib.h>
#include <savedata/sv_hologrammail.h>
#include "app_hologrammail_common_define.h"
#include "app_hologrammail_MailData.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

class MailManager
{
  GFL_FORBID_COPY_AND_ASSIGN(MailManager);
public:
  /**
   * @brief }l[W[̃^Cv
   */
  enum Mode
  {
    MODE_SENARIO,   ///< ViI[
    MODE_NETWORK,   ///< lbg[Np[
  };

public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param mode  }l[W[̋N[h
   * @param save  Z[uf[^
   * @param heap  Xg쐬pq[v
   */
  MailManager( Mode mode, savedata::HologramMailData * save, gfl::heap::HeapBase *heap );
  /**
   * @brief fXgN^
   */
  virtual ~MailManager();
  
  //-----------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------
  /**
   * @brief [XgԂB[XgƂ̓\[gs[̂
   *
   * @return [Xg
   */
  u32 GetMailMax( void ) const;
  
  /**
   * @brief [Xg烁[擾
   *
   * @param index CfbNX
   *
   * @return  [
   */
  IMail * GetMail( u32 index ) const;
  
  /**
   * @brief [Xg[J[擾i[J[łȂꍇAT[gɂȂj
   *
   * @param index CfbNX
   *
   * @return  [J[
   */
  LocalMail * GetLocalMail( u32 index ) const;

  //-----------------------------------------------------------------------
  // 
  //  ViÎƂgȂ
  //-----------------------------------------------------------------------
  /**
   * @brief SĂԂɕׂ
   */
  void SortOrder( void );
  /**
   * @brief wlɂ
   *
   * @param person  l
   */
  void SortPerson( Person person );
  /**
   * @brief w^Oɂ
   *
   * @param tag ^O
   */
  void SortTag( MailTag tag );

private:
  void CreateMailList( gfl::heap::HeapBase * heap );
  void DeleteMailList( void );
  void SortMailList( MailTag tag, Person person );
  void CreateLocalMailList( gfl::heap::HeapBase * heap );

private:
  savedata::HologramMailData * m_save;  ///<Z[u[N
  IMail   **m_mail;   ///<
  u32     m_mail_max; ///<̂̍ő吔
  IMail   **m_sort_mail;    ///<\[g̗î̂̂QƁj
  u32     m_sort_mail_max;  ///<\[g[̍ő吔
  Mode    m_mode;           ///<[h
};


GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

#endif		// __APP_HOLOGRAMMAIL_MAILMANAGER_H__
