//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_MailManager.cpp
 *	@brief  [Ǘ
 *	@author	Toru=Nagihashi
 *	@date		2012.06.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_hologrammail_MailManager.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param mode  }l[W[̋N[h
 * @param save  Z[uf[^
 * @param heap  Xg쐬pq[v
 */
MailManager::MailManager( Mode mode, savedata::HologramMailData * save, gfl::heap::HeapBase *heap ) :
  m_save( save ),
  m_mode( mode )
{
#ifdef PM_DEBUG
  for( int i = 0; i < 10; ++i )
  {
    app::hologrammail::LocalMailData  data  = {};
    data.mail_id  = i+1;
    data.is_read  = false;
    m_save->AddLocalMailData( &data );
  }
#endif

  this->CreateMailList( heap );
  this->SortOrder();
}

/**
 * @brief fXgN^
 */
MailManager::~MailManager()
{
  this->DeleteMailList();
}


//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief [XgԂB[XgƂ͉LSortsȂ
 *
 * @return [Xg
 */
u32 MailManager::GetMailMax( void ) const
{
  return m_sort_mail_max;
}


/**
 * @brief [擾
 *
 * @param index CfbNX
 *
 * @return  [
 */
IMail * MailManager::MailManager::GetMail( u32 index ) const
{
  GFL_ASSERT( index < this->GetMailMax() );
  return m_sort_mail[ index ];
}


/**
 * @brief [J[擾i[J[łȂꍇAT[gɂȂj
 *
 * @param index CfbNX
 *
 * @return  [J[
 */
LocalMail * MailManager::GetLocalMail( u32 index ) const
{
  GFL_ASSERT( index < this->GetMailMax() );
  GFL_ASSERT( m_mode == MODE_SENARIO ); ///<ViI[hłLocalMailɂȂȂ
  return reinterpret_cast<LocalMail *>(m_sort_mail[ index ]);
}


//-----------------------------------------------------------------------
// 
//  ViÎƂgȂ
//-----------------------------------------------------------------------
/**
 * @brief SĂԂɕׂ
 */
void MailManager::SortOrder( void )
{
  this->SortMailList( MAIL_TAG_MAX, PERSON_NONE );
}

/**
 * @brief wlɂ
 *
 * @param person  l
 */
void MailManager::SortPerson( Person person )
{
  this->SortMailList( MAIL_TAG_MAX, person );
}

/**
 * @brief w^Oɂ
 *
 * @param tag ^O
 */
void MailManager::SortTag( MailTag tag )
{
  this->SortMailList( tag, PERSON_NONE );
}

//-----------------------------------------------------------------------
// [Xg쐬
//-----------------------------------------------------------------------
/**
 * @brief [Xg쐬
 *
 * @param heap  쐬邽߂̃q[v
 */
void MailManager::CreateMailList(  gfl::heap::HeapBase * heap )
{
  if( m_mode == MODE_SENARIO )
  {
    this->CreateLocalMailList( heap );
  }
  else
  {
    //@todo lbg[N[̏ꍇ
    GFL_ASSERT(0);  //쐬
  }

  //[̕ёւXg쐬
  m_sort_mail_max = 0;  ///<\[gOȂ̂łO  S悤ɍő啪m
  m_sort_mail = static_cast<IMail**>(GflHeapAllocMemory( heap, sizeof(IMail*)*m_mail_max ));
}
/**
 * @brief [Xgj
 */
void MailManager::DeleteMailList( void )
{
  GflHeapFreeMemory( m_sort_mail );
  m_sort_mail_max = 0;
  
  for( int i = 0; i < m_mail_max; ++i )
  {
    GFL_SAFE_DELETE( m_mail[i] );
  }
  GflHeapFreeMemory( m_mail );
  m_mail_max  = 0;
}
/**
 * @brief [Xg\[g
 *
 * @param tag     \[g^O  iMAIL_TAG_MAXƃ^O\[gȂj
 * @param person  \[gl  iPERSON_NONEƐl\[gȂj
 */
void MailManager::SortMailList( MailTag tag, Person person )
{
  GFL_ASSERT( m_mode == MODE_SENARIO ); ///<ViI[hł\[głȂ
  int cnt = 0;
  for( int i=0; i<m_mail_max; ++i )
  {
    LocalMail *mail = reinterpret_cast<LocalMail *>(m_mail[i]);
    if( tag != MAIL_TAG_MAX )
    {
      if( mail->ExistTag( tag ) == false )
      {
        continue;
      }
    } 
    if( person != PERSON_NONE )
    {
      if( mail->ExistPerson( person ) == false )
      {
        continue;
      }
    }
    //ɖȂ̂continueŔĂ
    m_sort_mail[cnt++]  = m_mail[i];
  }
  
  m_sort_mail_max = cnt;
}

/**
 * @brief [J[̃Xg쐬
 *
 * @param heap@q[v
 */
void MailManager::CreateLocalMailList( gfl::heap::HeapBase * heap )
{
  GFL_ASSERT( m_mode == MODE_SENARIO ); ///<ViI[hł쐬łȂ
  m_mail_max  = m_save->GetLocalMailDataNum();
  m_mail = static_cast<IMail**>(GflHeapAllocMemory( heap, sizeof(IMail*)*m_mail_max ));
  for( int i = 0; i < m_mail_max; ++i )
  {
    m_mail[i] = GFL_NEW(heap) LocalMail( m_save->GetLocalMailData(i) );
  }
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
