//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_hologrammail_MailData.cpp
 *	@brief  [f[^
 *	@author	Toru=Nagihashi
 *	@date		2012.06.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <arc/arc_def.h>
#include "app_hologrammail_MailData.h"
#include <arc/hologram_mail_data.gaix>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
  
//=========================================================================
//[J[
//=========================================================================
LocalMail::DefineData *LocalMail::m_def_data  = NULL;
int LocalMail::m_def_max  = 0;
gfl::str::MsgData *LocalMail::m_msg_data  = NULL;

/**
 * @brief 
 *
 * @param heap  q[v
 * @param msg_data  bZ[Wf[^
 */
void LocalMail::Boot( gfl::heap::HeapBase * heap )
{
  gfl::fs::ArcFile  *file = GFL_NEW( heap->GetLowerHandle() ) gfl::fs::ArcFile( heap->GetLowerHandle(), ARCID_HOLOGRAM_MAIL_DATA, gfl::fs::ArcFile::OPEN );
 
  size_t size = file->GetDataSize( GARC_hologram_mail_data_hologram_mail_mail_DAT ); 
  m_def_data  = reinterpret_cast<DefineData *>( GflHeapAllocMemory(heap, size ) );
  file->LoadData( GARC_hologram_mail_data_hologram_mail_mail_DAT, m_def_data );
  m_def_max = size / sizeof(DefineData);
  GFL_SAFE_DELETE( file );
}
/**
 * @brief I
 */
void LocalMail::Terminate( void )
{
  m_msg_data  = NULL;
  GflHeapFreeMemory( m_def_data );
}
/**
 * @brief bZ[Wf[^ݒ
 *
 * @param msg_data  bZ[Wf[^
 */
void LocalMail::SetMsgData( gfl::str::MsgData *msg_data )
{
  m_msg_data  = msg_data;
}
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param save  [J[f[^
 */
LocalMail::LocalMail( LocalMailData *save ) :
  IMail(),
  m_save( save )
{
}

/**
 * @brief fXgN^
 */
LocalMail::~LocalMail()
{
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ^Cg擾
 *
 * @param strbuf  󂯎obt@
 * @param heap  e|q[v
 */
void LocalMail::GetTitle( gfl::str::StrBuf *strbuf, gfl::heap::HeapBase *heap ) const
{
  m_msg_data->GetString( this->GetDefData()->title_str_id, *strbuf );
}

/**
 * @brief XNvgID擾
 *
 * @return XNvgID
 */
u32 LocalMail::GetScriptId( void ) const
{
  return this->GetDefData()->script_id;
}

/**
 * @brief ǂ`FbN
 *
 * @return true false܂
 */
bool LocalMail::IsRead( void ) const
{
  return m_save->is_read;
}

/**
 * @brief ǂɂ
 */
void LocalMail::SetRead( void )
{
  m_save->is_read = true;
}

/**
 * @brief ^O邩`FbN
 *
 * @param tag ׂ^O
 *
 * @return  trueŎw̃^O  falsełȂ
 */
bool LocalMail::ExistTag( MailTag tag ) const
{
  return this->GetDefData()->tag & (1<<tag) != 0;
}

/**
 * @brief l邩`FbN
 *
 * @param person  ׂl
 *
 * @return  trueŎw̐l  falsełȂ
 */
bool LocalMail::ExistPerson( Person person ) const
{
  return this->GetDefData()->person & (1<<person) != 0;
}

//-----------------------------------------------------------------------
// ȉAprivate
//-----------------------------------------------------------------------
/**
 * @brief `f[^擾
 *
 * @return  `f[^
 */
LocalMail::DefineData * LocalMail::GetDefData( void ) const
{
  GFL_ASSERT( m_save->mail_id != 0 );
  GFL_ASSERT_MSG( m_save->mail_id - 1 < m_def_max, "mail_id%d < def_max%d\n", m_save->mail_id - 1,  m_def_max );
  
  return &m_def_data[ m_save->mail_id - 1 ];
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
