#if PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		DressUpCharacterFashion.cpp
 *	@brief  [ւLN^] t@bVύX
 *	@author	Koji Kawada
 *	@date		2012.06.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0
http://www.emit.jp/prog/prog_cpp0.html
o֐̃e[u
statico֐
statico֐
privateo֐
#endif


// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "system/main.h"           // HEAP_DEFINE
#include "gamesystem/GameProc.h"
#include "trainer/TrModelManager.h"

// dress_up
#include "system/dress_up/DressUpInclude.h"

// test/kawada
#include "DressUpCharacterFashion.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 

// [V̒`
#include "../../../../src/field/movemodel/Move3DModelMotion.h"  // tB[h[V̒`
                   // src/field/movemodel/motion/tr0001.h

#include "trainer/tr_mot_def.h"  // og[V̒`


namespace test {
namespace kawada {
namespace dress_up_character {


// ؂ւ
#define TEST_FOR_FIELD  (0)
#define TEST_FOR_BATTLE (1)
#define TEST_KAWADA_DRESS_UP_CHARACTER_TEST (TEST_FOR_FIELD)


//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterFashionProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  test::kawada::util::AllSystem::CreateMemory();
  
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  m_util_sys = GFL_NEW(heap_memory) test::kawada::util::AllSystem;

  gfl::heap::NwAllocator* heap_allocator   = m_util_sys->GetHeapAllocator();
  gfl::heap::NwAllocator* device_allocator = m_util_sys->GetDeviceAllocator();
  gfl::grp::GraphicsSystem* graphics_system = m_util_sys->GetGraphicsSystem();

  // g3d
  {
    // VXe
    gfl::grp::g3d::System::Description sys_desc;
    sys_desc.resource_object_num_max = 1024;
    sys_desc.model_object_num_max    = 1024;
    m_system = GFL_NEW(heap_memory) gfl::grp::g3d::System( heap_allocator, device_allocator, &sys_desc );
    
    // V[
    gfl::grp::g3d::Scene::Description scene_desc;
    scene_desc.scene_calculate_group_num = CALC_GROUP_MAX;
    scene_desc.scene_draw_group_num = DRAW_GROUP_MAX;
    m_scene  = GFL_NEW(heap_memory) gfl::grp::g3d::Scene( device_allocator, &scene_desc, heap_allocator );
    
    // GbW}bv  // src/field/FieldGraphics.cpp, src/battle/btlv/btlv_core.cpp
    {
      gfl::grp::RenderTarget::Description   render_desc;
      gfl::grp::FrameBufferManager*         frame_buffer_manager = graphics_system->GetFrameBufferManager();
      gfl::grp::RenderTarget*               left_render_target = frame_buffer_manager->GetRenderTarget(
          graphics_system->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER) );
      render_desc.depth_address = left_render_target->GetDepthAddress();
      render_desc.depth_area = gfl::grp::MEMORY_AREA_VRAMB;  // @todo ǂ̃(MEMORY_AREA_H)left_render_target->GetDepthAddress()̂悤
                                                             //       left_render_targetȂH
      m_scene->CreateEdgeMapSystem(heap_allocator, device_allocator, DRAW_GROUP_EDGE_MAP, &render_desc);
    }
    // |XgGtFNgGbW
#if TEST_KAWADA_DRESS_UP_CHARACTER_TEST == TEST_FOR_FIELD
    {
      // tB[hp
      gfl::grp::g3d::G3DPostEffectSystem::Description  post_desc;
      post_desc.edge_draw_group_id = DRAW_GROUP_EDGE;
      post_desc.edge_enable = true;
      post_desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::INSIDE_EDGE;
      post_desc.bloom_filter_enable = false;
      m_scene->CreatePostEffectSystem( heap_allocator, device_allocator, &post_desc, graphics_system,  gfl::grp::MEMORY_AREA_VRAMA );
    
      const u8 EDGE_COLOR[4] = { 0,0,0, 255 };
      m_scene->SetEdgeColor(
        static_cast<f32>(EDGE_COLOR[0]) / 255.0f,
        static_cast<f32>(EDGE_COLOR[1]) / 255.0f,
        static_cast<f32>(EDGE_COLOR[2]) / 255.0f );
      m_scene->EdgeMapTex1Enable( true );//@todo Œ
      m_scene->EdgeMapVColAEnable( true );//@todo Œ
    }
#elif TEST_KAWADA_DRESS_UP_CHARACTER_TEST == TEST_FOR_BATTLE
    {
      // ogp
      gfl::grp::g3d::G3DPostEffectSystem::Description  post_desc;
      post_desc.edge_draw_group_id = DRAW_GROUP_EDGE;
      post_desc.edge_enable = true;
      post_desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DOUBLE_LAYERED_EDGE;
      post_desc.bloom_filter_enable = false;
      m_scene->CreatePostEffectSystem( heap_allocator, device_allocator, &post_desc, graphics_system,  gfl::grp::MEMORY_AREA_VRAMA );

      m_scene->SetEdgeColor( 0.4f,0.4f,0.4f );
    }
#endif  // TEST_KAWADA_DRESS_UP_CHARACTER_TEST

    // J
    m_camera = GFL_NEW(heap_memory) gfl::debug::DebugG3dStereoCamera();
    m_camera->Create(
        device_allocator,
        gfl::math::VEC3(0.0f, 0.0f, 45.0f),
        gfl::math::VEC3(0.0f, 0.0f, 0.0f)
    );
    m_camera->SetAspect(400.0f/240.0f);
    m_scene->AddSceneNode( m_camera );
  }

  // g[i[fɍœKȃV[
  {
    m_env = GFL_NEW(heap_memory) trainer::TrModelEnvMember;
    trainer::CreateTrModelEnv(
        heap_allocator,
        device_allocator,
        m_env,
        m_scene,
        CALC_GROUP_MAIN
    );
  }

  // ւt@bVI(fobOp)
  m_fashion_select = GFL_NEW(heap_memory) ::dress_up_test::DebugDressUpFashionSelect;

  // [h
  m_mode = MODE_TOP;
  m_next_mode = MODE_TOP;  // ĂƁ[
  m_mode_cursor = 0;
  m_mode_seq    = 0;

  // tO
  m_change_mode_flag = false;
  m_finish_flag = false;
  
  // DressUpCharacterManager
  constructorDressCharaSeq();

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterFashionProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  gfl::ui::DeviceManager* device_manager = m_util_sys->GetDeviceManager();
  gfl::grp::GraphicsSystem* graphics_system = m_util_sys->GetGraphicsSystem();

  gfl::ui::Button*       button      = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  gfl::ui::VectorDevice* cross_key   = device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
  gfl::ui::VectorDevice* stick       = device_manager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
  gfl::ui::TouchPanel*   touch_panel = device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

  //////////////////////
  ///// [hύX /////
  //////////////////////
  if( m_change_mode_flag ) changeMode();

  //////////////////////
  //////// vZ ////////
  //////////////////////
  m_util_sys->Calculate();

  // [hƂ̌vZ
  calcModeBefore();
  
  // g3d  // J
  if( button->IsHold( gfl::ui::BUTTON_R ) )
  {
    m_camera->Control(device_manager);
  }

  // ւt@bVI(fobOp)
  if( m_dress_up_character_manager )
  {
    m_fashion_select->Calculate(
      device_manager,
      m_dress_up_character_manager->GetCharacterModel(m_dress_up_character_id[0])
    );
  }

  // g3d  // vZ
  m_scene->Calculate();

  // [hƂ̌vZ
  calcModeAfter();

  // g3d
  {
    // SubmitView
    m_scene->SubmitView(m_camera, true,  true, 0);

    // GbW
    m_scene->SubmitViewOfEdge(m_camera, false);
  }
  
  //////////////////////
  //////// ` //////// 
  //////////////////////
  {
    m_util_sys->StartRendering();

    gfl::grp::RenderTarget* lower_render_target       = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_LOWER ) );
    gfl::grp::RenderTarget* upper_render_target       = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    gfl::grp::RenderTarget* upper_right_render_target = graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER_RIGHT ) );

    // [hƂ̕`
    drawMode();

    // g3d
    {
      // GbW}bv
      m_scene->StereoEdgeMapDraw( graphics_system, m_camera );

      // Draw
      m_scene->CommandSaveStereoDraw(
          graphics_system,
          m_camera,
          upper_render_target,
          upper_right_render_target
      );

      // |XgGtFNgGbW
      m_scene->StereoPostEffectDraw( graphics_system, m_camera );
    }

    // ւt@bVI(fobOp)
    m_fashion_select->Draw(
        graphics_system
    );

    m_util_sys->EndRendering();
  }

  //////////////////////////
  //////// I ////////
  //////////////////////////
  if( button->IsTrigger( gfl::ui::BUTTON_START ) )
  {
    m_finish_flag = true;
    if( DRESS_CHARA_SEQ_NONE < m_dress_chara_seq && m_dress_chara_seq < DRESS_CHARA_SEQ_DESTROY_START )
    {
      m_dress_chara_seq = DRESS_CHARA_SEQ_DESTROY_START;
    }
  }
  if( m_finish_flag && m_dress_chara_seq == DRESS_CHARA_SEQ_NONE )
  {
    return gfl::proc::RES_FINISH;
  }
  else
  {
    return gfl::proc::RES_CONTINUE;
  }
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result DressUpCharacterFashionProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  // ւt@bVI(fobOp)
  GFL_DELETE m_fashion_select;

  // g[i[fɍœKȃV[
  {
    trainer::DestroyTrModelEnv(
        m_env,
        m_scene
    );
    GFL_DELETE m_env;
  }

  // g3d
  {
    m_scene->DestroyOwnObject();
    GFL_DELETE m_camera;
    GFL_DELETE m_scene;
    GFL_DELETE m_system;
  }

  GFL_DELETE m_util_sys;

  test::kawada::util::AllSystem::DestroyMemory();

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  [hƂ̌vZ / `
 */
//------------------------------------------------------------------
void DressUpCharacterFashionProc::requestChangeMode(Mode next_mode)
{
  m_next_mode = next_mode;
  m_change_mode_flag = true;
}
void DressUpCharacterFashionProc::changeMode(void)
{
  m_mode = m_next_mode;
  m_mode_cursor = 0;
  m_mode_seq    = 0;
  m_change_mode_flag = false;
}

// ֐e[uɂEEE
void DressUpCharacterFashionProc::calcModeBefore(void)
{
  switch(m_mode)
  {
  case MODE_TOP:              modeTopCalcBefore();   break;
  case MODE_HEROINE_FIELD:    modeCharaCalcBefore(); break;
  case MODE_HEROINE_BATTLE:   modeCharaCalcBefore(); break;
  case MODE_HEROINE_ALL:      modeCharaCalcBefore(); break;
  case MODE_HERO_FIELD:       modeCharaCalcBefore(); break;
  case MODE_HERO_BATTLE:      modeCharaCalcBefore(); break;
  case MODE_HERO_ALL:         modeCharaCalcBefore(); break;
  case MODE_FULL_HEROINE_ALL: modeCharaCalcBefore(); break;
  case MODE_FULL_HERO_ALL:    modeCharaCalcBefore(); break;
  }
}
void DressUpCharacterFashionProc::calcModeAfter(void)
{
  switch(m_mode)
  {
  case MODE_TOP:              modeTopCalcAfter();   break;
  case MODE_HEROINE_FIELD:    modeCharaCalcAfter(); break;
  case MODE_HEROINE_BATTLE:   modeCharaCalcAfter(); break;
  case MODE_HEROINE_ALL:      modeCharaCalcAfter(); break;
  case MODE_HERO_FIELD:       modeCharaCalcAfter(); break;
  case MODE_HERO_BATTLE:      modeCharaCalcAfter(); break;
  case MODE_HERO_ALL:         modeCharaCalcAfter(); break;
  case MODE_FULL_HEROINE_ALL: modeCharaCalcAfter(); break;
  case MODE_FULL_HERO_ALL:    modeCharaCalcAfter(); break;
  }
}
void DressUpCharacterFashionProc::drawMode(void)
{
  switch(m_mode)
  {
  case MODE_TOP:              modeTopDraw();   break;
  case MODE_HEROINE_FIELD:    modeCharaDraw(); break;
  case MODE_HEROINE_BATTLE:   modeCharaDraw(); break;
  case MODE_HEROINE_ALL:      modeCharaDraw(); break;
  case MODE_HERO_FIELD:       modeCharaDraw(); break;
  case MODE_HERO_BATTLE:      modeCharaDraw(); break;
  case MODE_HERO_ALL:         modeCharaDraw(); break;
  case MODE_FULL_HEROINE_ALL: modeCharaDraw(); break;
  case MODE_FULL_HERO_ALL:    modeCharaDraw(); break;
  }
}

void DressUpCharacterFashionProc::modeTopCalcBefore(void)
{
  gfl::ui::DeviceManager* device_manager = m_util_sys->GetDeviceManager();
  
  gfl::ui::Button*       button    = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  gfl::ui::VectorDevice* cross_key = device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );

  s32 menu_max = MODE_MENU_NUM;

  if( button->IsTrigger( gfl::ui::BUTTON_A ) )
  {
    Mode next_mode = static_cast<Mode>(m_mode_cursor +1);
    setDressCharaIndividual(next_mode);
    requestChangeMode(next_mode);
  }
  else if( cross_key->IsRepeat( gfl::ui::DIR_UP ) )
  {
    m_mode_cursor -= 1;
    if( m_mode_cursor < 0 ) m_mode_cursor = menu_max -1;
  }
  else if( cross_key->IsRepeat( gfl::ui::DIR_DOWN ) )
  {
    m_mode_cursor += 1;
    if( m_mode_cursor >= menu_max ) m_mode_cursor = 0;
  }
}
void DressUpCharacterFashionProc::modeTopCalcAfter(void)
{
  // Ȃ
}
void DressUpCharacterFashionProc::modeTopDraw(void)
{
  // ModeƏԂ킹Ă
  static const wchar_t* MODE_TOP_MENU[MODE_MAX-1] =
  {
    L"tB[hqC",
    L"ogqC",
    L"SqC",
    L"tB[hq[[",
    L"ogq[[",
    L"Sq[[",
    L"to[\ASqC",
    L"to[\ASq[[",
  };

  gfl::grp::GraphicsSystem* graphics_system = m_util_sys->GetGraphicsSystem();
  
  s32 menu_max = MODE_MENU_NUM;
  
  // ̊ȈՕ`
  {
    // 
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    graphics_system->BindCurrentCommandList( lower_frame_buffer );
    gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer );
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
    gfl::grp::util::DrawUtil::SetTextScale( 0.4f, 0.4f );   // オ(0, 0)

    //s32 text_x_pos = 10;
    s32 text_y_pos = 4;
    const s32 text_y_pos_add = 9;

    const s32 text_x_pos_page    = 15;   // [ւ]
    const s32 text_x_pos_title   = 30;   // Xq
    const s32 text_x_pos_explain = 15;   // \L[㉺ŁEEE

    const gfl::math::VEC4 text_color_plain(1.0f, 1.0f, 1.0f, 1.0f);
    const gfl::math::VEC4 text_color_emphasis(1.0f, 0.0f, 0.0f, 1.0f);

    {
      gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
      gfl::grp::util::DrawUtil::DrawText( text_x_pos_page, text_y_pos, L"[[hI]" );
      text_y_pos += text_y_pos_add;

      for(s32 i=0; i<menu_max; ++i)
      {
        if( i == m_mode_cursor )
        {
          gfl::grp::util::DrawUtil::SetTextColor( text_color_emphasis );
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_title, text_y_pos, MODE_TOP_MENU[i] );
        }
        else
        {
          gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_title, text_y_pos, MODE_TOP_MENU[i] );
        }
        text_y_pos += text_y_pos_add;
      }
    }
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 0.0f, 1.0f) );
    gfl::grp::util::DrawUtil::DrawText( 4, 218, L"\L[㉺ňړBAŌB" );
    gfl::grp::util::DrawUtil::DrawText( 4, 227, L"STARTŏIB" );
    
    gfl::grp::util::DrawUtil::EndRender();
  }
}

void DressUpCharacterFashionProc::modeCharaCalcBefore(void)
{
  gfl::ui::DeviceManager* device_manager = m_util_sys->GetDeviceManager();
  
  gfl::ui::Button*       button    = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  gfl::ui::VectorDevice* cross_key = device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );

  switch( m_mode_seq )
  {
  case 0:
    initializeDressCharaSeq();
    ++m_mode_seq;
    break;
  case 1:
    updateDressCharaSeqBefore();
    break;
  }
  
  if( button->IsHold( gfl::ui::BUTTON_L ) && button->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    if( DRESS_CHARA_SEQ_NONE < m_dress_chara_seq && m_dress_chara_seq < DRESS_CHARA_SEQ_DESTROY_START )
    {
      m_dress_chara_seq = DRESS_CHARA_SEQ_DESTROY_START;
    }
  }
  if( m_dress_chara_seq == DRESS_CHARA_SEQ_NONE )
  {
    requestChangeMode(static_cast<Mode>(MODE_TOP));
  }
}

void DressUpCharacterFashionProc::modeCharaCalcAfter(void)
{
  updateDressCharaSeqAfter();
}

void DressUpCharacterFashionProc::modeCharaDraw(void)
{
  gfl::grp::GraphicsSystem* graphics_system = m_util_sys->GetGraphicsSystem();
  
  // ̊ȈՕ`
  {
    // 
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    graphics_system->BindCurrentCommandList( lower_frame_buffer );
    gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer );
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 0.0f, 1.0f) );  // RGBA
    gfl::grp::util::DrawUtil::SetTextScale( 0.4f, 0.4f );   // オ(0, 0)

    s32 text_x_pos = 4;
    s32 text_y_pos = 218;
    s32 text_y_pos_add = 9;
    
    gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"AŌBR(+AorBorXorY)+XChpbhŃJB" );
    text_y_pos += text_y_pos_add;
    gfl::grp::util::DrawUtil::DrawText( text_x_pos, text_y_pos, L"L+BŖ߂BSTARTŏIB" );
    text_y_pos += text_y_pos_add;
 
    gfl::grp::util::DrawUtil::EndRender();
  }
}

//------------------------------------------------------------------
/**
 * @brief	  DressUpCharacterManager
 */
//------------------------------------------------------------------
void DressUpCharacterFashionProc::constructorDressCharaSeq(void)
{
  m_dress_chara_seq = DRESS_CHARA_SEQ_NONE;
  m_dress_up_character_manager = NULL;
  m_dress_up_character_num = 0; 

  for(s32 i=0; i<DRESS_UP_CHARACTER_MAX_NUM; ++i)
  {
    //m_individual[i] = ;  // gOɕKĂ邩Ał͉ݒ肵ȂƂɂB
    m_dress_up_character_id[i] = xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE;
    m_dress_chara_state[i] = DRESS_CHARA_STATE_CREATE;
  }
}

void DressUpCharacterFashionProc::setDressCharaIndividual(Mode mode)
{
  switch(mode)
  {
  case MODE_HEROINE_FIELD   :
    m_dress_up_character_num = 1; 
    //
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_FIELD;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HEROINE;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HEROINE_FASHION_DEFAULT;
    break;
  case MODE_HEROINE_BATTLE  :
    m_dress_up_character_num = 1; 
    //
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HEROINE;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HEROINE_FASHION_DEFAULT;
    break;
  case MODE_HEROINE_ALL     :
    m_dress_up_character_num = 2; 
    // 
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_FIELD;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HEROINE;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HEROINE_FASHION_DEFAULT;
    // 
    m_individual[1].section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
    m_individual[1].model_type   = xy_system::dress_up::MODEL_TYPE_HEROINE;
    m_individual[1].change_flag  = true;
    m_individual[1].fashion      = &xy_system::dress_up::HEROINE_FASHION_DEFAULT;
    break;
  case MODE_HERO_FIELD      :
    m_dress_up_character_num = 1; 
    //
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_FIELD;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HERO;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HERO_FASHION_DEFAULT;
    break;
  case MODE_HERO_BATTLE     :
    m_dress_up_character_num = 1; 
    //
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HERO;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HERO_FASHION_DEFAULT;
    break;
  case MODE_HERO_ALL        :
    m_dress_up_character_num = 2; 
    // 
    m_individual[0].section_type = xy_system::dress_up::SECTION_TYPE_FIELD;
    m_individual[0].model_type   = xy_system::dress_up::MODEL_TYPE_HERO;
    m_individual[0].change_flag  = true;
    m_individual[0].fashion      = &xy_system::dress_up::HERO_FASHION_DEFAULT;
    // 
    m_individual[1].section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
    m_individual[1].model_type   = xy_system::dress_up::MODEL_TYPE_HERO;
    m_individual[1].change_flag  = true;
    m_individual[1].fashion      = &xy_system::dress_up::HERO_FASHION_DEFAULT;
    break;
  //case MODE_FULL_HEROINE_ALL:
  //case MODE_FULL_HERO_ALL   :
  }
}

void DressUpCharacterFashionProc::setDressCharaMotion(s32 index)
{
  proj::motion::BaseMotionCharacter* motion = m_dress_up_character_manager->GetCharacterMotion(m_dress_up_character_id[index]);
  motion->GetRootPosition()->SetY(-50.0f);
  switch(m_mode)
  {
  case MODE_HEROINE_FIELD   :
    if(index==0)
    {
      motion->Change( field::mmodel::PLAYER_tr0001_00_fi20_walk01 );
    }
    break;
  case MODE_HEROINE_BATTLE  :
    if(index==0)
    {
      motion->Change( gfl::motion::MotionBase::MOTION_BEGIN + TRMOT_BTL_BA01_TOUJYOU01 );
    }
    break;
  case MODE_HEROINE_ALL     :
    if(index==0)
    {
      motion->Change( field::mmodel::PLAYER_tr0001_00_fi20_walk01 );
      motion->GetRootPosition()->SetX(-30.0f);
    }
    else if(index==1)
    {
      motion->Change( gfl::motion::MotionBase::MOTION_BEGIN + TRMOT_BTL_BA01_TOUJYOU01 );
      motion->GetRootPosition()->SetX(30.0f);
    }
    break;
  case MODE_HERO_FIELD      :
    if(index==0)
    {
      motion->Change( field::mmodel::PLAYER_tr0001_00_fi20_walk01 );
    }
    break;
  case MODE_HERO_BATTLE     :
    if(index==0)
    {
      motion->Change( gfl::motion::MotionBase::MOTION_BEGIN + TRMOT_BTL_BA01_TOUJYOU01 );
    }
    break;
  case MODE_HERO_ALL        :
    if(index==0)
    {
      motion->Change( field::mmodel::PLAYER_tr0001_00_fi20_walk01 );
      motion->GetRootPosition()->SetX(-30.0f);
    }
    else if(index==1)
    {
      motion->Change( gfl::motion::MotionBase::MOTION_BEGIN + TRMOT_BTL_BA01_TOUJYOU01 );
      motion->GetRootPosition()->SetX(30.0f);
    }
    break;
  //case MODE_FULL_HEROINE_ALL:
  //case MODE_FULL_HERO_ALL   :
  }
}

void DressUpCharacterFashionProc::initializeDressCharaSeq(void)
{
  m_dress_chara_seq = DRESS_CHARA_SEQ_CREATE_START;
}

void DressUpCharacterFashionProc::updateDressCharaSeqBefore(void)
{
  gfl::heap::HeapBase* heap_memory  = test::kawada::util::AllSystem::GetHeapMemory();
  gfl::heap::HeapBase* device_memory = test::kawada::util::AllSystem::GetDeviceMemory();

  gfl::heap::NwAllocator*   heap_allocator    = m_util_sys->GetHeapAllocator();
  gfl::heap::NwAllocator*   device_allocator  = m_util_sys->GetDeviceAllocator();
  gfl::fs::FileReadManager* file_read_manager = m_util_sys->GetFileReadManager();

  switch(m_dress_chara_seq)
  {
  case DRESS_CHARA_SEQ_CREATE_START:
    {
      // }l[W
      m_dress_up_character_manager = GFL_NEW(heap_memory) xy_system::dress_up::DressUpCharacterManager(
          file_read_manager,
          heap_memory,
          heap_memory,
          device_memory,
          heap_memory,
          DRESS_UP_CHARACTER_MAX_NUM
      );
      
      // LN^
      for(s32 i=0; i<m_dress_up_character_num; ++i)
      {
        m_dress_up_character_id[i] = m_dress_up_character_manager->RequestAsyncCreateObject(
            heap_memory,
            heap_allocator,
            heap_allocator,
            device_allocator,
            &(m_individual[i]),
            heap_memory
        );
        m_dress_chara_state[i] = DRESS_CHARA_STATE_CREATE;
      }

      ++m_dress_chara_seq;
      break;
    }
  case DRESS_CHARA_SEQ_CREATE_NOW:
    {
      b32 create_end = true;
      for(s32 i=0; i<m_dress_up_character_num; ++i)
      {
        if( m_dress_chara_state[i] == DRESS_CHARA_STATE_CREATE )
        {
          // LN^
          if( m_dress_up_character_manager->DoesExistObject(m_dress_up_character_id[i]) )
          {
            // LN^
            // LN^̃fV[ɒǉ
            m_dress_up_character_manager->AddCharacterModelToScene(
              m_dress_up_character_id[i],
              m_scene,
              CALC_GROUP_MAIN,
              DRAW_GROUP_MAIN
            );
            // LN^̃[Vݒ肷
            setDressCharaMotion(i);
            m_dress_chara_state[i] = DRESS_CHARA_STATE_ADD_TO_SCENE;
          }
          else
          {
            create_end = false;
          }
        }
      }
      if( create_end )
      {
        // ւt@bVI(fobOp)
        m_fashion_select->Initialize(
          xy_system::dress_up::MODEL_TYPE_HEROINE,
          m_dress_up_character_manager->GetCharacterModel(m_dress_up_character_id[0])->GetFashion()
        );

        ++m_dress_chara_seq;
      }
      break;
    }
  case DRESS_CHARA_SEQ_CREATE_END:
    {
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_START:
    {
      b32 destroy_start = true;
      for(s32 i=0; i<m_dress_up_character_num; ++i)
      {
        if( m_dress_chara_state[i] == DRESS_CHARA_STATE_ADD_TO_SCENE )
        {
          // ւt@bVI(fobOp)
          m_fashion_select->Finalize();

          // LN^̃fV[O  // 1t[҂ĂjsƁI
          m_dress_up_character_manager->RemoveCharacterModelFromScene(
              m_dress_up_character_id[i],
              m_scene
          );
          m_dress_chara_state[i] = DRESS_CHARA_STATE_REMOVE_FROM_SCENE;
          destroy_start = false;
        }
        else
        {
          if( m_dress_chara_state[i] != DRESS_CHARA_STATE_DESTROY )
          {
            // LN^j
            m_dress_up_character_manager->RequestAsyncDestroyObject(
                m_dress_up_character_id[i]
            );
            m_dress_chara_state[i] = DRESS_CHARA_STATE_DESTROY;
          }
        }
      }
      if( destroy_start )
      {
        ++m_dress_chara_seq;
      }
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_NOW:
    {
      b32 destroy_end = true;
      for(s32 i=0; i<m_dress_up_character_num; ++i)
      {
        // LN^j
        if( m_dress_up_character_id[i] != xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE )
        {
          if( m_dress_up_character_manager->DoesNotExistObject(m_dress_up_character_id[i]) )
          {
            // LN^j
            m_dress_up_character_id[i] = xy_system::dress_up::DressUpCharacterManager::OBJECT_ID_NONE;
          }
          else
          {
            destroy_end = false;
          }
        }
      }
      if( destroy_end )
      {
        // jł悤ɂȂ܂ő҂
        if( m_dress_up_character_manager->IsAbleToDestroy() )
        {
          // }l[Wj
          GFL_DELETE m_dress_up_character_manager;
          m_dress_up_character_manager = NULL;
          
          ++m_dress_chara_seq;
        }
      }
      break;
    }
  case DRESS_CHARA_SEQ_DESTROY_END:
    {
      m_dress_chara_seq = DRESS_CHARA_SEQ_NONE;
      constructorDressCharaSeq();
      break;
    }
  }

  // OvZ
  if( m_dress_up_character_manager )
  {
    m_dress_up_character_manager->CalculateBefore();
  }
}

void DressUpCharacterFashionProc::updateDressCharaSeqAfter(void)
{
  // vZ
  if( m_dress_up_character_manager )
  {
    m_dress_up_character_manager->CalculateAfter();
  }
}

}  // namespace dress_up_character
}  // namespace kawada
}  // namespace test

#endif // PM_DEBUG

