//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   DebugDressUpFashionSelect.cpp
 *  @brief  ւt@bVI(fobOp)
 *  @author Koji Kawada
 *  @date   2012.06.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>

#include "system/dress_up/DressUpInclude.h"

#include "DebugDressUpFashionSelect.h"


namespace dress_up_test {


#if PM_DEBUG

//###########################
//###########################
//
// Jo
//
//###########################
//###########################

//-----------------------------------------------------------------------------
/**
 *   @brief  RXgN^
 */
//-----------------------------------------------------------------------------
DebugDressUpFashionSelect::DebugDressUpFashionSelect(void)
  : m_is_initialized(false),
    m_model_type(xy_system::dress_up::MODEL_TYPE_NONE),
    m_ng(false),
    m_target_index(0),
    m_sub_index(0)
{
  // Ȃ
}

//-----------------------------------------------------------------------------
/**
 *   @brief  fXgN^
 */
//-----------------------------------------------------------------------------
DebugDressUpFashionSelect::~DebugDressUpFashionSelect()
{
  // Ȃ
}

//-----------------------------------------------------------------------------
/**
 *   @brief  
 */
//-----------------------------------------------------------------------------
void DebugDressUpFashionSelect::Initialize(
  xy_system::dress_up::ModelType model_type,   
  const xy_system::dress_up::IFashion* fashion
)
{
  if( !m_is_initialized )
  {
    b32 is_copied = false;
    switch(model_type)
    {
    case xy_system::dress_up::MODEL_TYPE_HEROINE:
      xy_system::dress_up::CopyHeroineFashion(m_fashion_buffer, fashion);
      is_copied = true;
      break;
    case xy_system::dress_up::MODEL_TYPE_HERO:
      xy_system::dress_up::CopyHeroFashion(m_fashion_buffer, fashion);
      is_copied = true;
      break;
    }
    if( is_copied )
    {
      m_model_type = model_type;
      m_is_initialized = true;
    }
  }
  else
  {
    GFL_ASSERT_MSG(0, "ɏς݂łBꍇFinalizeĂяoĂsĉB\n");
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  I
 */
//-----------------------------------------------------------------------------
void DebugDressUpFashionSelect::Finalize(void)
{
  m_is_initialized = false;
  m_model_type = xy_system::dress_up::MODEL_TYPE_NONE;
  m_ng = false;
  m_target_index = 0;
  m_sub_index = 0;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  vZ
 */
//-----------------------------------------------------------------------------
void DebugDressUpFashionSelect::Calculate(
  gfl::ui::DeviceManager*             device_manager,
  xy_system::dress_up::DressUpIModel* model
)
{
  if( !m_is_initialized ) return;

  gfl::ui::Button*       button      = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  gfl::ui::VectorDevice* cross_key   = device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
  gfl::ui::VectorDevice* stick       = device_manager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
  gfl::ui::TouchPanel*   touch_panel = device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

  // ModelTypëႢz
  s32 place_max = \
                    (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                  ? (xy_system::dress_up::heroine::PLACE_MAX) \
                  : (xy_system::dress_up::hero::PLACE_MAX);

  s32 skin_max = \
                    (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                  ? (xy_system::dress_up::heroine::SKIN_MAX) \
                  : (xy_system::dress_up::hero::SKIN_MAX);

  s32 haircolor_max = \
                    (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                  ? (xy_system::dress_up::heroine::HAIRCOLOR_MAX) \
                  : (xy_system::dress_up::hero::HAIRCOLOR_MAX);



  //////////////// t@bV̑gݍ킹ɖ肪Ȃ`FbN ////////////////
  if( button->IsTrigger( gfl::ui::BUTTON_A ) )
  {
    checkFashion(model);
  }
  //////////////// t@bVύX ////////////////
  else
  {
    //// ㉺ړ ////
    s32 updown_dir = 0;  // updown_dir=1̂ƂdownAupdown_dir=-1̂ƂupAupdown_dir=0̂ƂĂȂ
    if( cross_key->IsRepeat( gfl::ui::DIR_UP ) )
    {
      updown_dir = -1;
      switch(m_target_index)
      {
      case TARGET_SKIN:
        {
          m_target_index = TARGET_PLACE;
          m_sub_index = place_max -1;
        }
        break;
      case TARGET_HAIRCOLOR:
        {
          m_target_index = TARGET_SKIN;
        }
        break;
      case TARGET_PLACE:
        {
          --m_sub_index;
          if( m_sub_index < 0 )
          {
            m_target_index = TARGET_HAIRCOLOR;
          }
        }
        break;
      }
    }
    else if( cross_key->IsRepeat( gfl::ui::DIR_DOWN ) )
    {
      updown_dir = 1;
      switch(m_target_index)
      {
      case TARGET_SKIN:
        {
          m_target_index = TARGET_HAIRCOLOR;
        }
        break;
      case TARGET_HAIRCOLOR:
        {
          m_target_index = TARGET_PLACE;
          m_sub_index = 0;
        }
        break;
      case TARGET_PLACE:
        {
          ++m_sub_index;
          if( m_sub_index >= place_max )
          {
            m_target_index = TARGET_SKIN;
          }
        }
        break;
      }
    }

    //// Eړ ////
    if( updown_dir == 0 )
    {
      s32 leftright_dir = 0;  // leftright_dir=-1̂ƂleftAleftright_dir=1̂ƂrightAleftright_dir=0̂ƂĂȂ
      if( cross_key->IsRepeat( gfl::ui::DIR_LEFT ) )
      {
        leftright_dir = -1;
      }
      else if( cross_key->IsRepeat( gfl::ui::DIR_RIGHT ) )
      {
        leftright_dir = 1;
      }

      #define ITEM_LEFTRIGHT(fashion, item) \
              fashion->item += leftright_dir; \
              if( fashion->item < 0 ) fashion->item = item##_max -1; \
              else if( fashion->item >= item##_max ) fashion->item = 0;

      switch(m_target_index)
      {
      case TARGET_SKIN:
        {
          switch(m_model_type)
          {
          case xy_system::dress_up::MODEL_TYPE_HEROINE:
            {
              xy_system::dress_up::HeroineFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroineFashion*>(m_fashion_buffer);
              ITEM_LEFTRIGHT(fashion, skin)
              break;
            }
          case xy_system::dress_up::MODEL_TYPE_HERO:
            {
              xy_system::dress_up::HeroFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroFashion*>(m_fashion_buffer);
              ITEM_LEFTRIGHT(fashion, skin)
              break;
            }
          }
        }
        break;
      case TARGET_HAIRCOLOR:
        {
          switch(m_model_type)
          {
          case xy_system::dress_up::MODEL_TYPE_HEROINE:
            {
              xy_system::dress_up::HeroineFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroineFashion*>(m_fashion_buffer);
              ITEM_LEFTRIGHT(fashion, haircolor)
              break;
            }
          case xy_system::dress_up::MODEL_TYPE_HERO:
            {
              xy_system::dress_up::HeroFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroFashion*>(m_fashion_buffer);
              ITEM_LEFTRIGHT(fashion, haircolor)
              break;
            }
          }
        }
        break;
      case TARGET_PLACE:
        {
          if( leftright_dir != 0 )
          {
            s16 id_num = 0;
            if(model)
            {
              id_num = model->GetIdNumOfPlace(m_sub_index);
            }

            if( id_num > 0 )
            {
              // 1͂Ƃ //
              s16 id_no = -1;

              if( *(getFashionPlacePointer(m_sub_index)) == xy_system::dress_up::ID_SYSTEM_NONE )
              {
                if( leftright_dir > 0 )
                {
                  id_no = 0;
                }
                else
                {
                  id_no = id_num -1;
                }
              }
              else
              {
                for(id_no=0; id_no<id_num; ++id_no)
                {
                  if( *(getFashionPlacePointer(m_sub_index)) == model->GetIdOfPlace(m_sub_index, id_no) )
                  {
                    break;
                  }
                }
                id_no += leftright_dir;
                if( id_no < 0 || id_no >= id_num ) id_no = -1;
              }

              if( id_no >= 0 )
              {
                *(getFashionPlacePointer(m_sub_index)) = model->GetIdOfPlace(m_sub_index, id_no);
              }
              else
              {
                *(getFashionPlacePointer(m_sub_index)) = xy_system::dress_up::ID_SYSTEM_NONE;
              }
            }
            else
            {
              // 1ȂƂ //
              *(getFashionPlacePointer(m_sub_index)) = xy_system::dress_up::ID_SYSTEM_NONE;
            }
          }
        }
        break;
      }

      #undef ITEM_LEFTRIGHT
    
    }
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  `
 */
//-----------------------------------------------------------------------------
void DebugDressUpFashionSelect::Draw(
    gfl::grp::GraphicsSystem* graphics_system
)
{
  if( !m_is_initialized ) return;
  
  // ̊ȈՕ`ɕKvȑO㏈͌ĂяoĂĂ͂B
  
  // ̊ȈՕ`
  {
    // 
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    graphics_system->BindCurrentCommandList( lower_frame_buffer );
    gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer );
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
    gfl::grp::util::DrawUtil::SetTextScale( 0.4f, 0.4f );   // オ(0, 0)

    //s32 text_x_pos = 10;
    s32 text_y_pos = 4;
    const s32 text_y_pos_add = 9;

    const s32 text_x_pos_page    = 15;   // [ւ]
    const s32 text_x_pos_page2   = 150;  // HEROINE
    const s32 text_x_pos_info    = 260;  // NG
    const s32 text_x_pos_title   = 30;   // Xq
    const s32 text_x_pos_element = 120;  // hat0001
    const s32 text_x_pos_explain = 15;   // \L[㉺ŁEEE

    const gfl::math::VEC4 text_color_plain(1.0f, 1.0f, 1.0f, 1.0f);
    const gfl::math::VEC4 text_color_emphasis(1.0f, 0.0f, 0.0f, 1.0f);


    // ModelTypëႢz
    s16 place_max = \
                      (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                    ? (xy_system::dress_up::heroine::PLACE_MAX) \
                    : (xy_system::dress_up::hero::PLACE_MAX);

    const wchar_t** place_name_table = \
                      (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                    ? (xy_system::dress_up::heroine::PLACE_DEBUG_NAME_TABLE) \
                    : (xy_system::dress_up::hero::PLACE_DEBUG_NAME_TABLE);

    const wchar_t** id_name_table = \
                      (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                    ? (xy_system::dress_up::heroine::ID_DEBUG_NAME_TABLE) \
                    : (xy_system::dress_up::hero::ID_DEBUG_NAME_TABLE);

    const wchar_t** skin_name_table = \
                      (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                    ? (xy_system::dress_up::heroine::SKIN_DEBUG_NAME_TABLE) \
                    : (xy_system::dress_up::hero::SKIN_DEBUG_NAME_TABLE);

    const wchar_t** haircolor_name_table = \
                      (m_model_type==xy_system::dress_up::MODEL_TYPE_HEROINE) \
                    ? (xy_system::dress_up::heroine::HAIRCOLOR_DEBUG_NAME_TABLE) \
                    : (xy_system::dress_up::hero::HAIRCOLOR_DEBUG_NAME_TABLE);

    s16 skin = 0;
    s16 haircolor = 0;

    switch(m_model_type)
    {
    case xy_system::dress_up::MODEL_TYPE_HEROINE:
      {
        xy_system::dress_up::HeroineFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroineFashion*>(m_fashion_buffer);
        skin = fashion->skin;
        haircolor = fashion->haircolor;
        break;
      }
    case xy_system::dress_up::MODEL_TYPE_HERO:
      {
        xy_system::dress_up::HeroFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroFashion*>(m_fashion_buffer);
        skin = fashion->skin;
        haircolor = fashion->haircolor;
        break;
      }
    }

    {
      gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
      gfl::grp::util::DrawUtil::DrawText( text_x_pos_page, text_y_pos, L"[ւ]" );

      switch(m_model_type)
      {
      case xy_system::dress_up::MODEL_TYPE_HEROINE:
        {
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_page2, text_y_pos, L"qC" );
          break;
        }
      case xy_system::dress_up::MODEL_TYPE_HERO:
        {
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_page2, text_y_pos, L"q[[" );
          break;
        }
      }

      {
        if( m_ng )
        {
          gfl::grp::util::DrawUtil::SetTextColor( text_color_emphasis );
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_info, text_y_pos, L"NG" );
          // sȂ̂ŉEɏoĂ
        }
      }
      
      text_y_pos += text_y_pos_add;

      {
        if( m_target_index == TARGET_SKIN )
          gfl::grp::util::DrawUtil::SetTextColor( text_color_emphasis );
        else
          gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_title,   text_y_pos, L"" );
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_element, text_y_pos, skin_name_table[skin] );
        text_y_pos += text_y_pos_add;
      }

      {
        if( m_target_index == TARGET_HAIRCOLOR )
          gfl::grp::util::DrawUtil::SetTextColor( text_color_emphasis );
        else
          gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_title,   text_y_pos, L"F" );
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_element, text_y_pos, haircolor_name_table[haircolor] );
        text_y_pos += text_y_pos_add;
      }

      for( s16 i=0; i<place_max; ++i )
      {
        if( m_target_index == TARGET_PLACE && m_sub_index == i )
          gfl::grp::util::DrawUtil::SetTextColor( text_color_emphasis );
        else
          gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
        gfl::grp::util::DrawUtil::DrawText( text_x_pos_title,   text_y_pos, place_name_table[i] );
        if( *getFashionPlacePointer(i) >= 0 )
        {
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_element, text_y_pos, id_name_table[*getFashionPlacePointer(i)] );
        }
        else
        {
          gfl::grp::util::DrawUtil::DrawText( text_x_pos_element, text_y_pos, L"--NONE--" );
        }
        text_y_pos += text_y_pos_add;
      }

      gfl::grp::util::DrawUtil::SetTextColor( text_color_plain );
      gfl::grp::util::DrawUtil::DrawText( text_x_pos_explain, text_y_pos, L"\L[㉺ōڈړAEŕύXBAŃ`FbNB" );
      text_y_pos += text_y_pos_add;
    }

    gfl::grp::util::DrawUtil::EndRender();
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  t@bV擾
 */
//-----------------------------------------------------------------------------
const xy_system::dress_up::IFashion* DebugDressUpFashionSelect::GetFashion(
    xy_system::dress_up::DressUpIModel* model
)
{
  if( !m_is_initialized ) return NULL;
  
  checkFashion(model);

  if( m_ng )
  {
    return NULL;
  }
  else
  {
    return reinterpret_cast<xy_system::dress_up::IFashion*>(m_fashion_buffer);
  }
}


//###########################
//###########################
//
// Jo
//
//###########################
//###########################

// @brief  t@bV̑gݍ킹ɖ肪Ȃ`FbN
void DebugDressUpFashionSelect::checkFashion(
    xy_system::dress_up::DressUpIModel* model
)
{
  if( !m_is_initialized ) return;

  b32 is_ok = true;
  {
    if(model)
    {
      is_ok = model->ChangeCheckFashion(m_fashion_buffer);
    }
  }
  
  if(!is_ok)  // gݍ킹ɖ肪
  {
    m_ng = true;
  }
  else  // gݍ킹ɖ肪Ȃ
  {
    m_ng = false;
  }
}

// @brief  t@bV̕ʂ̃|C^𓾂
s16* DebugDressUpFashionSelect::getFashionPlacePointer(s32 place_index)
{
  if( !m_is_initialized ) return NULL;
  
  s16* place_pointer = NULL;
  switch(m_model_type)
  {
  case xy_system::dress_up::MODEL_TYPE_HEROINE:
    {
      xy_system::dress_up::HeroineFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroineFashion*>(m_fashion_buffer);
      place_pointer = &(fashion->id[place_index]);
      break;
    }
  case xy_system::dress_up::MODEL_TYPE_HERO:
    {
      xy_system::dress_up::HeroFashion* fashion = reinterpret_cast<xy_system::dress_up::HeroFashion*>(m_fashion_buffer);
      place_pointer = &(fashion->id[place_index]);
      break;
    }
  }
  return place_pointer;
}

#else  // #if PM_DEBUG

DebugDressUpFashionSelect::DebugDressUpFashionSelect(void) {}
DebugDressUpFashionSelect::~DebugDressUpFashionSelect() {}
void DebugDressUpFashionSelect::Initialize(void) {}
void DebugDressUpFashionSelect::Finalize(void) {}
void DebugDressUpFashionSelect::Calculate(void) {}
void DebugDressUpFashionSelect::Draw(void) {}

#endif  // #if PM_DEBUG


}  // namespace dress_up_test

