//=============================================================================
/**
 * @brief  |P̒ǂxXVǗ
 * @file   NakayoshiManager.cpp
 * @author tamada
 * @date   2012.06.10
 */
//=============================================================================
#include "poke_tool/NakayoshiManager.h"


namespace poke_tool {

  namespace nakayoshi {

    static NakayoshiType CheckNakayoshiType( const pml::pokepara::CoreParam * pp, const pml::pokepara::OwnerInfo & owner_info );
    static s32 ChangeFriendship( s32 friendship, s32 change_value );

    //-------------------------------------------------------------------------
    //  g[i[Ƃ̊֌W𒲂ׂ
    //-------------------------------------------------------------------------
    NakayoshiType CheckNakayoshiType( const pml::pokepara::CoreParam * pp, const savedata::MyStatus * myStatus )
    {
      pml::pokepara::OwnerInfo owner_info;
      myStatus->CreateOwnerInfo( owner_info );
      return CheckNakayoshiType( pp, owner_info );
    }

    //-------------------------------------------------------------------------
    /**
     * @brief   ǂ֌W𒲂ׂ
     * @param   pp        ׂ|P̃|Pp[^
     * @param   owner_info  rΏۂ̃g[i[
     * @return  NakayoshiType
     */
    //-------------------------------------------------------------------------
    NakayoshiType CheckNakayoshiType( const pml::pokepara::CoreParam * pp, const pml::pokepara::OwnerInfo & owner_info )
    {
      return NAKAYOSHI_TYPE_ORIGINAL;
#if 0
      if ( pp->CompareOwnerInfo( owner_info ) == true )
      { //@IWi̐e
        return NAKAYOSHI_TYPE_ORIGINAL;
      }
      else if ( pp->GetFriendlyTrainerID() == myStatus->GetIDLow() )
      {
        return NAKAYOSHI_TYPE_FRIENDLY; //ݕێĂg[i[ID̐l
      }
      else
      {
        return NAKAYOSHI_TYPE_OTHER;    // ǂg[i[ID
      }
#endif
    }



    //-------------------------------------------------------------------------
    /**
     * @brief ǂx팸
     * @note  Xgbp[dl̂߁APɃ}CiXĂȂ
     */
    //-------------------------------------------------------------------------
    s32 ChangeFriendship( s32 friendship, s32 change_value )
    {
      static const u32 KAWAIGARI_NUMBER_STOPPER[] = {
        0,
        25,
        50,
        75,
        100,
        150,
        200
      };
      u32 stopper_index = 0;
      for( u32 j=0; j<GFL_NELEMS(KAWAIGARI_NUMBER_STOPPER); ++j ){
        if( KAWAIGARI_NUMBER_STOPPER[j] > friendship ){
          break;
        }
        ++stopper_index;
      }
      if( change_value > 0 ) {
        friendship += change_value;
      }
      else if( friendship + change_value > KAWAIGARI_NUMBER_STOPPER[stopper_index] ){
        friendship += change_value;
      }
      if ( friendship > 255 ) friendship = 255;
      if ( friendship < 0 ) friendship = 0;

      return friendship;
    }

    //-------------------------------------------------------------------------
    //  ێĂ钇ǂg[i[̏XV
    //-------------------------------------------------------------------------
    bool UpdateTrainerInfo( pml::pokepara::CoreParam * pp, const savedata::MyStatus * myStatus )
    {
      NakayoshiType type = CheckNakayoshiType( pp, myStatus );

      if ( type == NAKAYOSHI_TYPE_OTHER )
      { // ǂg[i[ID̂ŁA
        pp->SetFriendlyTrainerID( myStatus->GetIDLow() );
        pp->SetOthersFriendship( 0 ); //Ȃ悵x
        return true;
      }
      return false;
    }

    //-------------------------------------------------------------------------
    //  Ȃ悵x@XV
    //-------------------------------------------------------------------------
    void UpdateFriendship( pml::pokepara::CoreParam * pp, const savedata::MyStatus * myStatus, s8 value )
    {
      pml::pokepara::OwnerInfo owner_info;
      myStatus->CreateOwnerInfo( owner_info );

      switch ( CheckNakayoshiType( pp, myStatus ) )
      {
      case NAKAYOSHI_TYPE_ORIGINAL:
        { //@IWi̐eȂ̂ŁÂ܂
          s32 friendship = pp->GetFriendship();
          friendship = ChangeFriendship( friendship, value );
          pp->SetFriendship( friendship );
        }
        break;

      case NAKAYOSHI_TYPE_OTHER:
        { // ǂg[i[ID̂ŁAȂ
          return;
        }

      case NAKAYOSHI_TYPE_FRIENDLY:
        { //ǂg[i[p̑
          s32 friendship = pp->GetOthersFriendship();
          friendship = ChangeFriendship( friendship, value );
          pp->SetOthersFriendship( friendship );
        }
        break;
      default:
        GFL_ASSERT( 0 );
        break;
      }
    }







  } //namespace nakayoshi
} //namespace poke_tool

