#! ruby -Ks
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		hologram_mail_script_conv.rb
#	@brief  zOb[f[^Ro[^
#	@author	Toru=Nagihashi
#	@data		2012.06.08
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
require "../../../tools/headerdata.rb"
require "hologram_mail_scr.rb"

#-------------------------------------
# `FbN
# @retval true  Ȃ
# @retval false G[
#=====================================
DEFCSVNAME   = ARGV[0]
GRPCSVNAME   = ARGV[1]
DATCSVNAME   = ARGV[2]
MSTXTNAME    = ARGV[3]
WORKNAME     = ARGV[4]
OUTPUTNAME   = ARGV[5]
def checkArgument
  if DEFCSVNAME == nil
    puts "1ɒ`csṽt@Cw肵Ă"
    return false
  end
  if GRPCSVNAME == nil
    puts "2ɃO[vcsṽt@Cw肵Ă"
    return false
  end
  if DATCSVNAME == nil
    puts "3Ƀf[^{̂csṽt@Cw肵Ă"
    return false
  end
  if MSTXTNAME == nil
    puts "3mstxt̃t@Cw肵Ă"
    return false
  end
  if OUTPUTNAME == nil
    puts "4ɏo̓t@Cw肵Ă"
    return false
  end
  unless FileTest.exists?(DEFCSVNAME)
    puts "#{DEFCSVNAME}܂"
    return false
  end
  return true
end

#=============================================================================
#
#   W[
#
#=============================================================================
#-------------------------------------
# definef[^Ro[g
#=====================================
def  convertDefine( saveCsv, watchCsv, flagCsv, tagCsv, hash, header )

  makeDefine( saveCsv, "HologramMailSaveType", "HOLOGRAM_SAVE_TYPE", hash, header )
  makeDefine( watchCsv, "HologramMailwatchType", "HOLOGRAM_WATCH_TYPE", hash, header )
  makeDefine( flagCsv, "HologramMailflagType", "HOLOGRAM_FLAG_TYPE", hash, header )
  makeDefine( tagCsv, "HologramMailTag", "HOLOGRAM_TAG", hash, header )

end

#-------------------------------------
# #start, pgname, jpname
# ̕\f[^nbVƃwb_ɏ
#=====================================
DEF_ROW_START       = 1         #sJnʒu
DEF_COL_PG_NAME     = 1         #:`
DEF_COL_JP_NAME     = 2         #:͖
def makeDefine( csv, enum_name, header_prefix, hash, header )
  
  header.write( "enum #{enum_name} {\n" )
  
  cnt = 0
  for row in DEF_ROW_START...csv.row_length-1
    
    pg_name  = csv.get( row, DEF_COL_PG_NAME )
    jp_name  = csv.get( row, DEF_COL_JP_NAME )

    header.write( "\t#{header_prefix}_#{pg_name} = #{cnt.to_i},// #{jp_name}\n" )
    hash.store( jp_name, cnt.to_i )
    
    cnt = cnt + 1
  end
  
  header.write( "\t#{header_prefix}_MAX = #{cnt.to_i},\n" )
  
  header.write( "};\n" )
end

#-------------------------------------
# groupRo[g
#=====================================
GRP_ROW_START       = 1         #sJnʒu
GRP_COL_PG_NAME     = 1         #:`
GRP_COL_JP_NAME     = 2         #:͖
GRP_COL_WATCH_TYPE  = 3         #:Ď^Cv
GRP_COL_SAVE_TYPE   = 4         #:ۑ^Cv
def convertGroup( csv, cdat, hash, header )
 
  #wb_[̃wb_
  header.write( "enum HologramMailGroup {\n" )
  header.write( "\tHOLOGRAM_MAIL_GROUP_NONE  = 0,\n" )
  
  #CDAT̃wb_
  cdat.write( "struct HologramMailGroupData{\n" )
  cdat.write( "\tint watch;\n" )
  cdat.write( "\tint save;\n" )
  cdat.write( "};\n" )
  cdat.write( "static const HologramMailGroupData hologram_mail_group_data[] = {\n" )
  
  for row in GRP_ROW_START...csv.row_length-1
    
    cnt = row - GRP_ROW_START+1 #1IW
    pg_name = csv.get( row, GRP_COL_PG_NAME )
    jp_name = csv.get( row, GRP_COL_JP_NAME )
    watch   = csv.get( row, GRP_COL_WATCH_TYPE )
    save    = csv.get( row, GRP_COL_SAVE_TYPE )

    watch_value = getHash( hash, watch )
    save_value  = getHash( hash, save )
    
    cdat.write( "\t{\n" )
    cdat.write( "\t\t#{watch_value},\n" )
    cdat.write( "\t\t#{save_value},\n" )
    cdat.write( "\t},\n" )

    header.write( "\tHOLOGRAM_MAIL_GROUP_#{pg_name} = #{cnt.to_i},// #{jp_name}\n" )
    hash.store( jp_name, cnt )
  end
  
  #CDAT̃tb^
  cdat.write( "};" )

  #wb_[̃tb^
  header.write( "};\n" )
end

def getHash( hash, key )
  if hash.key?(key) 
    return hash[key]
  end
  
  puts "#{key}݂͑܂\n"
  exit(1)
end

#-------------------------------------
# 
#=====================================
def getPersonTagMask( scr_num )
  cnt = 0
  $scr_data.each{|data|
    if data[:SCRNUMBER] == scr_num
      mask = 0
      mask |= (1<<data[:PERSON_00])
      mask |= (1<<data[:PERSON_01])
      mask |= (1<<data[:PERSON_02])
      mask |= (1<<data[:PERSON_03])
      return mask
    end
  }
  puts "vOG[#{scr_num}\n"
  exit(1)
  return 0
end

#-------------------------------------
# dataRo[g
#=====================================
DAT_ROW_START       = 1         #sJnʒu
DAT_COL_NUMBER      = 1         #:[ԍ
DAT_COL_GROUP       = 2         #:[O[v
DAT_COL_TITLE       = 3         #:^Cg
DAT_COL_SCR_NUM     = 4         #:XNvgԍ
DAT_COL_NOTICE      = 5         #:mH
DAT_COL_TERM_WORK   = 6         #:[N
DAT_COL_TERM_VAL    = 7         #:l
DAT_COL_RET_WORK    = 8         #:̓[N
DAT_COL_RET_S_VAL   = 9         #:͊Jnl
DAT_COL_RET_E_VAL   =10         #:͏Il
DAT_COL_RET_S_MIN   =11         #:͗\
DAT_COL_RET_E_MIN   =12         #:͑ҋ@
DAT_COL_TAG_ITEM    =13         #:F
DAT_COL_TAG_CITY    =14         #:FX
DAT_COL_TAG_POKE    =15         #:F|P
DAT_COL_TAG_LIFE    =16         #:F
DAT_COL_TAG_NEWS    =17         #:Fj[X
DAT_COL_TAG_EVENT   =18         #:FCxg
def convertData( csv, txt, work, data, hash, header )
 
  #wb_[̃wb_
  header.write( "enum HologramMailId {\n" )
  header.write( "\tHOLOGRAM_MAIL_ID_NONE  = 0,\n" )
  
  for row in DAT_ROW_START...csv.row_length-1
    
    cnt = row - DAT_ROW_START #0IW
    number  = csv.get( row, DAT_COL_NUMBER   )
    group   = csv.get( row, DAT_COL_GROUP    )
    title   = csv.get( row, DAT_COL_TITLE    )
    scr_num = csv.get( row, DAT_COL_SCR_NUM  )
    notice  = csv.get( row, DAT_COL_NOTICE   )
    term_wk = csv.get( row, DAT_COL_TERM_WORK)
    term_val  = csv.get( row, DAT_COL_TERM_VAL )
    ret_wk    = csv.get( row, DAT_COL_RET_WORK )
    ret_s_val = csv.get( row, DAT_COL_RET_S_VAL)
    ret_e_val = csv.get( row, DAT_COL_RET_E_VAL)
    ret_s_min = csv.get( row, DAT_COL_RET_S_MIN)
    ret_e_min = csv.get( row, DAT_COL_RET_E_MIN)

    if cnt+1 != number.to_i
      puts "[ԍяƈقȂ܂#{number} #{cnt+1}"
      exit(1)
    end
    
    data.write_u16( getHash( hash, group ) )
    
    begin
      data.write_u16( txt.search( title.to_s, "" ) )
    rescue HeaderSearchError
      puts "bZ[W݂܂ #{param}\n"
      exit(1)
    end
    data.write_u16( scr_num.to_i )
    data.write_u16( getHash( hash, notice ) )
    
    #[N
    if term_wk.to_s != "" && term_wk.to_i != 0
      begin
        data.write_u16( work.search( term_wk.to_s, "" ) )
      rescue HeaderSearchError
        puts "[N݂܂ #{term_wk}\n"
        exit(1)
      end
      
      data.write_u16( tarm_val.to_i )
    end
    

    #̓[N
    if ret_wk.to_s != "" && ret_wk.to_i != 0
      begin
        data.write_u16( work.search( ret_wk.to_s, "" ) )
      rescue HeaderSearchError
        puts "[N݂܂ #{ret_wk}\n"
        exit(1)
      end
      
      data.write_u16( ret_s_val.to_i )
      data.write_u16( ret_e_val.to_i )
      data.write_u16( ret_s_min.to_i )
      data.write_u16( ret_e_min.to_i )
    end
    
    #^O
    #l^O16bit
    tag_mask  = getPersonTagMask( number.to_i )
    data.write_u16( tag_mask )
  

    #^O
    #ތ^O16bit
    tag_mask  = 0
    for tag_num in DAT_COL_TAG_ITEM...DAT_COL_TAG_EVENT
      tag_value = csv.get( row, tag_num)
      if getHash( hash, tag_value ) == 1
        tag_mask  |= (1<<( tag_num-DAT_COL_TAG_ITEM ))
      end
    end
    data.write_u16( tag_mask )

    #ID
    header.write( "\tHOLOGRAM_MAIL_ID_#{number.to_i} = #{number.to_i},\n" )
  end

  #wb_[̃tb^
  header.write( "};\n" )
end

#=============================================================================
#
#   C
#
#=============================================================================
begin

  #`FbN
  unless checkArgument
    exit(1)
  end

  #csvǍ
  saveCsv = CsvLoader.new
  saveCsv.setPrefix( '#save_start' )
  saveCsv.setSuffix( '#save_end' )
  saveCsv.load( DEFCSVNAME )

  watchCsv = CsvLoader.new
  watchCsv.setPrefix( '#watch_start' )
  watchCsv.setSuffix( '#watch_end' )
  watchCsv.load( DEFCSVNAME )
  
  flagCsv = CsvLoader.new
  flagCsv.setPrefix( '#flag_start' )
  flagCsv.setSuffix( '#flag_end' )
  flagCsv.load( DEFCSVNAME )
  
  tagCsv = CsvLoader.new
  tagCsv.setPrefix( '#tag_start' )
  tagCsv.setSuffix( '#tag_end' )
  tagCsv.load( DEFCSVNAME )
  
  groupCsv = CsvLoader.new
  groupCsv.setPrefix( '#group_start' )
  groupCsv.setSuffix( '#group_end' )
  groupCsv.load( GRPCSVNAME )
  
  dataCsv = CsvLoader.new
  dataCsv.setPrefix( '#data_start' )
  dataCsv.setSuffix( '#data_end' )
  dataCsv.load( DATCSVNAME )

  #data쐬
  data    = BinaryBuilder.new
  
  #wb_쐬
  header    = TextBuilder.new
  header.write_header( "#{OUTPUTNAME}.h", 
                    "zOb[̒`ł",
                    "Toru=Nagihashi" ) 
  
  #cdat쐬
  cdat    = TextBuilder.new
  cdat.write_header( "#{OUTPUTNAME}.cdat", 
                    "zOb[̒`f[^ł",
                    "Toru=Nagihashi" ) 

  #nbV쐬
  hash  = Hash.new
  
  #eLXgf[^̍쐬
  txt = HeaderDataArray.new
  txt.load( MSTXTNAME )
  
  #[N`̍쐬
  work = HeaderDataArray.new
  work.load( WORKNAME )

  #Ro[g
  convertDefine( saveCsv, watchCsv, flagCsv, tagCsv, hash, header )
  convertGroup( groupCsv, cdat, hash, header )
  convertData( dataCsv, txt, work, data, hash, header )

  #cdat
  cdat.genelate( "#{OUTPUTNAME}.cdat" )
  
  #wb_
  header.genelate( "#{OUTPUTNAME}.h" )

  #date
  data.genelate( "#{OUTPUTNAME}.dat" )

end
