//=============================================================================
/**
 * @brief  |P̂ȂxXVǗ
 * @file   NatsukiManager.cpp
 * @author tamada
 * @date   2012.06.09
 */
//=============================================================================
#include "poke_tool/NatsukiManager.h"


namespace poke_tool {

    //-------------------------------------------------------------------------
    /**
     * @brief Ȃxϓe[u
     * @note  e[u3̒ĺAꂼȂx100E200E200ȏ̏ꍇƂȂĂB
     */
    //-------------------------------------------------------------------------
    static	const	s8	CalcNatsukiTable[][3]={
      {  5,  4,  3 },		//xAbv
      {  0,  0,  0 },		//ACegpiACef[^擾j
      {  5,  4,  3 },		//{XɎQiW[_[AlVA`vj
      {  2,  2,  1 },		//A
      { -1, -1, -1 },		//m
      { -5, -5,-10 },		//xROȏ̕m
    };

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    NatsukiManager::NatsukiManager()
    {
    }

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    NatsukiManager::~NatsukiManager()
    {
    }


    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    void NatsukiManager::Calc( pml::pokepara::CoreParam * pcp, NatsukiType type, u16 place_id )
    {
      CalcCore( pcp, place_id, CalcNatsukiTable[type] );
    }

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    void NatsukiManager::CalcWhenWalk( pml::pokepara::CoreParam * pcp, u16 place_id )
    {
      CalcCore( pcp, place_id, CalcNatsukiTable[NATSUKI_TYPE_TSUREARUKI] );
    }

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    void NatsukiManager::CalcWhenUseItem(pml::pokepara::CoreParam * pcp, u16 place_id, const item::ITEM_DATA * item_data )
    {
      s8 table[3];
      table[0] = item_data->GetParam( item::ITEM_DATA::PRM_ID_FRIEND1 );
      table[1] = item_data->GetParam( item::ITEM_DATA::PRM_ID_FRIEND2 );
      table[2] = item_data->GetParam( item::ITEM_DATA::PRM_ID_FRIEND3 );
      CalcCore( pcp, place_id, table );
    }

    void NatsukiManager::CalcWhenUseItem(pml::pokepara::CoreParam * pcp, u16 place_id, u16 itemno, itemman::ITEM_MANAGER * itemMan )
    {
      s8 table[3];
      table[0] = itemMan->GetParam( itemno, item::ITEM_DATA::PRM_ID_FRIEND1 );
      table[1] = itemMan->GetParam( itemno, item::ITEM_DATA::PRM_ID_FRIEND2 );
      table[2] = itemMan->GetParam( itemno, item::ITEM_DATA::PRM_ID_FRIEND3 );
      CalcCore( pcp, place_id, table );
    }

    //-------------------------------------------------------------------------
    /**
     * @brief ȂxFʊ֐
     * @param heap      Ɨpq[vw
     * @param place_id  ݂̏ꏊID
     * @param table     Ȃxωʃe[u
     * @todo            AVXgp[̔fǂɂ
     */
    //-------------------------------------------------------------------------
    void NatsukiManager::CalcCore( pml::pokepara::CoreParam * pcp, u16 place_id, const s8 * table )
    {
      if ( pcp->IsEgg( pml::pokepara::CHECK_BOTH_EGG ) ) return;
      int familiarity = pcp->GetFamiliarity();
      if ( familiarity >= 100 ) table ++;
      if ( familiarity >= 200 ) table ++;
      int updown_value = *table;
      if ( updown_value > 0 )
      {
        u16 itemno = pcp->GetItem();
        //ێACeS[WX{[1iKオ
        if ( itemno == ITEM_GOOZYASUBOORU ) updown_value ++;
        //܂ꂽꏊA߂܂ꏊ1iKオ
        if ( pcp->GetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_PLACE ) == place_id ) updown_value ++;
        //ȂxAbvǂ̏ꍇ1.5{Abv
        if ( IsNatsukiUpItem( itemno ) == true )
        {
          updown_value = updown_value * 100 / 150;
        }
        //AVXgp[̉eZiZ͉eȂj
        updown_value += GetAssistPowerValue();
      }

      familiarity += updown_value;
      if ( familiarity < 0 ) familiarity = 0;
      if ( familiarity > 255 ) familiarity = 255;

      pcp->SetFamiliarity( familiarity );
    }

    //-------------------------------------------------------------------------
    /**
     * @brief ACeȂxύX̂ǂ̔菈
     * @param itemno  肷ACeNo.
     * @todo  {̓ACẽp[^Ŕfׂc񓯊ǂݍ݂ɂ邽߂ɂ͎dg݂Kv
     */
    //-------------------------------------------------------------------------
    bool NatsukiManager::IsNatsukiUpItem( u32 itemno )
    {
      if ( itemno == ITEM_YASURAGINOSUZU ) return true;
      return false;
    }

    //-------------------------------------------------------------------------
    /**
     * @brief AVXgp[Ăꍇ̒ǉl擾
     * @todo  AVXgp[̏Ԃǂ󂯎邩̌Kv
     */
    //-------------------------------------------------------------------------
    u8 NatsukiManager::GetAssistPowerValue( void )
    {
      return 0;
    }

} //namespace poke_tool

