//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceBigFourFire.cpp
 *	@brief  lV()Fj[NV[PX
 *
 */
//============================================================================


// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"

// arc
#include "arc/arc_def.h"                   // ARCID_*
#include "arc/big_four_fire_model.gaix"
#include "big_four_fire_model.h"

#include "gimmick_mdl_setup.h"

#include "FieldUniqueSequenceBigFourFire.h"

namespace field {

#include "FieldUniqueSequenceBigFourFire.cdat"  // fݒt@C

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	*pFieldmap tB[h}bv|C^
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceBigFourFire::FieldUniqueSequenceBigFourFire(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  m_setup_seq(SETUP_LOAD_ARC),
  mp_work_buffer(NULL)
{
  mp_fieldmap = pFieldmap;
  {
    gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
    gfl::heap::HeapBase*     device_memory    = mp_fieldmap->GetDeviceHeapField();
    mp_gmk_mdl_setup = GFL_NEW( heap_memory ) gimmick::GimmickMdlSetup( heap_memory, device_memory, BIG_FOUR_RES_FIRE_NUM );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief@fXgN^
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceBigFourFire::~FieldUniqueSequenceBigFourFire()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  lV()pkff[^̎擾A
 *
 *	@param	none
 *
 *	@retval TRUEŏI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceBigFourFire::SetupLast(void)
{
  switch( m_setup_seq )
  {
  case SETUP_LOAD_ARC:
    {
      mp_gmk_mdl_setup->LoadArc( ARCID_BIG_FOUR_FIRE );
      m_setup_seq++;
    }
    break;
  case SETUP_LOAD_ARC_WAIT:
    {
      //[h҂
      if( mp_gmk_mdl_setup->LoadArcWait() )
      {
        m_setup_seq++;
      }
      else
      {
        break;
      }
    }
    // through break
  case SETUP_GMK_WORK:
    {
      /// M~bN[N̏
      gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();

      // ATC̏ԂmFď
      b32 is_assigned = GimmickWorkAccessor::IsAssigned(
          p_gdata, GIMMICK_ID_BIG_FORE_FIRE);
      // ATCs
      GimmickWorkAccessor::SecondAssign( p_gdata, GIMMICK_ID_BIG_FORE_FIRE);
      // obt@[ۑ
      mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

      // ATCĂȂԂ̏ꍇ̓f[^
      if( is_assigned == FALSE )
      {
        BIG_FOUR_FIRE_WORK gmk_work;
        gfl::std::MemClear( &gmk_work, sizeof(BIG_FOUR_FIRE_WORK) );
        BufferAccessorType<BIG_FOUR_FIRE_WORK>::SetValue(mp_work_buffer,0,gmk_work);
      }
        
      //---------------------------
      /// M~bN[N̏
      m_setup_seq = SETUP_MDL_DATA_SEQ;
    }
    return TRUE;
  }

  return FALSE;
}

void FieldUniqueSequenceBigFourFire::ReadyLastOnce(void)
{
  /// f̃ZbgAbv
  mp_gmk_mdl_setup->SetupResource( big_four_fire_model_setup_data,
                           mp_fieldmap->GetDeviceHeapFieldAllocator() );

  // Aj
  mp_gmk_mdl_setup->CreateAnime( 
      BL_IDX_BIG_FOUR_FIRE_MODEL_SF_BM_HIBASHIRA01_ANI_BCSKLA,
      &m_anim[ANMID_FIRE_01] );
  // f
  mp_gmk_mdl_setup->CreateModel(
      mp_fieldmap->GetDeviceHeapFieldAllocator(),
      mp_fieldmap->GetHeapFieldAllocator(),
      BL_IDX_BIG_FOUR_FIRE_MODEL_SF_BM_HIBASHIRA01_ANI_BCMDL,
      &mp_model[MDLID_FIRE_01],
      &m_anim[ANMID_FIRE_01]
      );

  //---------------------------
  
  //---------------------------
  /// V[ւ̓o^
  gfl::grp::g3d::Scene* p_scene = mp_fieldmap->GetGraphics()->GetScene();
 
  static const gfl::math::VEC3 DEFAULT_POS(0.0f, 0.0f, 0.0f);
  gfl::math::VEC3 pos = DEFAULT_POS;
  p_scene->AddSceneNode(mp_model[ANMID_FIRE_01]);
  /// Wݒ  
  pos.x = 0.0f;
  pos.y = 0.0f;
  pos.z = 0.0f;
  mp_model[ANMID_FIRE_01]->SetTranslate(pos);
  
  // Aj[VJn
  mp_model[ANMID_FIRE_01]->SetAnimationStepFrame(1.0f);

  // ZbgAbvV[PXɐݒ肷
  
  m_setup_seq = SETUP_END_SEQ;

}

void FieldUniqueSequenceBigFourFire::UpdateFirst(void)
{
}

//----------------------------------------------------------------------------
/**
 *  @brief   CALCULATĚɌĂ΂֐
 *
 *	@param	none
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceBigFourFire::CalculateAfter(void)
{
  
}

void FieldUniqueSequenceBigFourFire::FreeFirstOnce(void)
{
  //---------------------------
  /// eJ
  for( int i = 0; i < MDLID_MAX; i++ )
  {
    GFL_DELETE mp_model[i];
    mp_model[i] = NULL;
  }

  for( int i = 0; i < ANMID_MAX; i++ )
  {
    m_anim[i].Destroy();
  }

  GFL_DELETE mp_gmk_mdl_setup;
  mp_gmk_mdl_setup = NULL;
}

} // namespace field

