//============================================================================
/**
 *
 *	@file		gimmick_mdl_setup.cpp
 *	@brief  M~bNfZbgAbv
 *
 */
//============================================================================
#include "gimmick_mdl_setup.h"

namespace gimmick
{

GimmickMdlSetup::GimmickMdlSetup( gfl::heap::HeapBase* heap_memory, gfl::heap::HeapBase* device_memory, int resource_num )
  : m_setup_seq(SETUP_INIT_SEQ),
  m_arc_id(0),
  m_load_start(false),
  mp_arcfile(NULL),
  mp_resource_array(NULL),
  mp_compress_buf(NULL),
  mpp_resource_buf_array(NULL),
  m_bin_linker()
{
  m_resource_num = resource_num;
  m_heap_memory = heap_memory;
  m_device_memory = device_memory;
}

GimmickMdlSetup::~GimmickMdlSetup()
{
  GFL_DELETE_ARRAY mp_resource_array;
  mp_resource_array = NULL;

  GflHeapFreeMemory( mp_compress_buf );
  mp_compress_buf = NULL;

  GflHeapFreeMemory( mpp_resource_buf_array );
  mpp_resource_buf_array = NULL;
}

void GimmickMdlSetup::LoadArc( int arc_id )
{
  m_arc_id = arc_id;
  m_load_start = true;
}

bool GimmickMdlSetup::LoadArcWait( void )
{
  if ( !m_load_start ) return true;

  switch( m_setup_seq )
  {
  case SETUP_INIT_SEQ:
    {
      // A[JCut@CǍݏ
      mp_arcfile = GFL_NEW_LOW( m_heap_memory ) gfl::fs::ArcFile( m_heap_memory, m_arc_id, gfl::fs::ArcFile::OPEN );
      mp_arcfile->StartSetupForFastMode( m_heap_memory );
      m_setup_seq++;
    }
    break;
  case SETUP_ARC_INIT_SEQ:
    {
      // t@C[hύX҂
      if( mp_arcfile->WaitSetupForFastMode() )
      {
        m_setup_seq++;
      }
      else
      {
        break;
      }
    }
    // through break
  case SETUP_GET_COMPRESS_DATA_SEQ:
    {
      // kf[^擾A𓀂
      mp_resource_array = GFL_NEW_ARRAY( m_heap_memory ) gfl::grp::g3d::Resource[ m_resource_num ];
      mpp_resource_buf_array = reinterpret_cast<void**>( GflHeapAllocMemory( m_heap_memory, sizeof(void*) * m_resource_num ) );

      // kf[^ǂݍ
      u32 size = mp_arcfile->GetDataSize( 0 );
      // m
      mp_compress_buf = GflHeapAllocMemoryLow( gfl::heap::Manager::GetHeapByHeapId( HEAPID_FILEREAD ), size );

      // 񓯊Ǎ݊Jn
      bool ret;
      ret = mp_arcfile->StartAsyncRead( m_heap_memory, 0,
          mp_compress_buf, MAIN_THREAD_PRIORITY+1 );
      GFL_ASSERT(ret);

      
      // ̃V[PX
      m_setup_seq++;
    }
    // through break
  case SETUP_WAIT_COMPRESS_DATA_SEQ:
    {
      // ǂݍ݊҂
      if( (mp_arcfile->WaitAsyncRead() == true) )
      {
        // ǂݍݑ҂
        NOZOMU_PRINT("kf[^Ǎݑ҂\n");
        break;
      }

      // 𓀏
      {
        // 𓀌̃TCY擾
        u32 size = gfl::cx::GetUncompressedSize( mp_compress_buf );
        // 𓀐惁m
        void* p_buffer = GflHeapAllocMemoryAlign( m_device_memory , size, 128 );
        // 𓀏
        gfl::cx::Uncompress( mp_compress_buf, p_buffer );
        GflHeapFreeMemory( mp_compress_buf );
        mp_compress_buf = p_buffer;

        // oCiJ̏   
        m_bin_linker.Initialize( p_buffer );
      }

      NOZOMU_PRINT("W\[XǍ,[N\n");
      GFL_DELETE mp_arcfile;
      mp_arcfile = NULL;
      m_load_start = false;
      m_setup_seq = SETUP_END_SEQ;
    }
    return true;
  }
  return false;
}


void GimmickMdlSetup::SetupResource( const gimmick::MDL_SETUP_DATA * p_setup_data,
                                     gfl::heap::NwAllocator*  device_allocator )
{
  // \[XZbgAbv
  for( u32 i=0; i<m_resource_num; ++i ){

    gimmick::MDL_SETUP_TYPE  setup_type = p_setup_data[i].setup_type;
    s32  binary_id = p_setup_data[i].binary_id;

    // pbP[WĂt@C̃|C^擾
    mpp_resource_buf_array[ binary_id ] = m_bin_linker.GetData( binary_id );

    // fEAj[ṼA^b`AZbgAbv
    switch(setup_type)
    {
    case gimmick::LOAD_TYPE_MDL:
       mp_resource_array[ binary_id ].AttachBufferAndSetup( 
          device_allocator,
          mpp_resource_buf_array[ binary_id ], 
          NULL, 
          false, 
          gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT );

      break;
    case gimmick::LOAD_TYPE_ANM:
      // Aj[ṼA^b`AZbgAbv
       mp_resource_array[ binary_id ].AttachBufferAndSetup( 
          device_allocator,
          mpp_resource_buf_array[ binary_id ], 
          NULL, 
          false, 
          gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE );
      break;
    default:
      GFL_ASSERT_MSG( 0,"ZbgAbv^Cv̌\n");
      break;
    }
  }
}

void GimmickMdlSetup::CreateAnime(int res_idx,gfl::grp::g3d::ResAnim *p_anm )
{
  mp_resource_array[res_idx].GetResAnim(
      gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL,
      0,
      p_anm);
}

void GimmickMdlSetup::CreateModel(
    gfl::heap::NwAllocator*  device_allocator,
    gfl::heap::NwAllocator*  heap_allocator,
    int res_idx,
    gfl::grp::g3d::Model**    pp_model,
    gfl::grp::g3d::ResAnim*   p_anm )
{
  // f
  *pp_model = GFL_NEW(m_heap_memory) gfl::grp::g3d::Model;

  if( p_anm == NULL )
  {
    // f̂݃ZbgAbv
    (*pp_model)->Create(
        heap_allocator, device_allocator,
        &mp_resource_array[res_idx],
        0 );
  }
  else
  {
    // f̂݃ZbgAbv{Aj[V̐ݒ
    gfl::grp::g3d::Model::Description model_description;
    model_description.animation_slot_num = 1;

    // f̃ZbgAbv
    (*pp_model)->Create(
        heap_allocator, device_allocator, 
        &mp_resource_array[res_idx],
        0,
        &model_description );

    
    //---------------------------
    /// Aj[Vݒ
    (*pp_model)->ChangeAnimation(
        device_allocator,
        p_anm,
        0,
        0,
        gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERS
        );

    // Aj[Vt[
    (*pp_model)->SetAnimationStepFrame(0.0f);

  }
}


} //namespace gimmick


